/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import foundationgames.enhancedblockentities.client.render.BlockEntityRendererOverride;
import foundationgames.enhancedblockentities.util.EBEUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShulkerBoxBlockEntityRendererOverride
extends BlockEntityRendererOverride {
    private final Map<DyeColor, BakedModel> models = new HashMap<DyeColor, BakedModel>();
    private final Consumer<Map<DyeColor, BakedModel>> modelMapFiller;

    public ShulkerBoxBlockEntityRendererOverride(Consumer<Map<DyeColor, BakedModel>> modelMapFiller) {
        this.modelMapFiller = modelMapFiller;
    }

    @Override
    public void render(BlockEntity blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (this.models.isEmpty()) {
            this.modelMapFiller.accept(this.models);
        }
        if (blockEntity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity entity = (ShulkerBoxBlockEntity)blockEntity;
            Direction dir = Direction.UP;
            BlockState state = entity.m_58904_().m_8055_(entity.m_58899_());
            if (state.m_60734_() instanceof ShulkerBoxBlock) {
                dir = (Direction)state.m_61143_((Property)ShulkerBoxBlock.f_56183_);
            }
            matrices.m_85836_();
            float animation = entity.m_59657_(tickDelta);
            matrices.m_85837_(0.5, 0.5, 0.5);
            matrices.m_85845_(dir.m_122406_());
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(270.0f * animation));
            matrices.m_85837_(-0.5, -0.5, -0.5);
            matrices.m_85837_(0.0, (double)(animation * 0.5f), 0.0);
            BakedModel lidModel = this.models.get(entity.m_59701_());
            if (lidModel != null) {
                EBEUtil.renderBakedModel(vertexConsumers, blockEntity.m_58900_(), matrices, lidModel, light, overlay);
            }
            matrices.m_85849_();
        }
    }

    @Override
    public void onModelsReload() {
        this.models.clear();
    }
}

