/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.handler;

import fuzs.airhop.AirHop;
import fuzs.airhop.capability.AirHopsCapability;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.init.ModRegistry;
import java.util.Optional;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerFallHandler {
    public void onPlayerTick$start(Player player) {
        if (player.m_20096_() && player.m_20184_().m_7098_() <= 0.0) {
            ModRegistry.AIR_HOPS_CAPABILITY.maybeGet((Object)player).ifPresent(AirHopsCapability::resetAirHops);
        }
    }

    public float onLivingFall(LivingEntity entity, float distance, float damageMultiplier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.onGroundHit(player, distance);
        }
        return distance;
    }

    private float onGroundHit(Player player, float fallDistance) {
        Optional optional = ModRegistry.AIR_HOPS_CAPABILITY.maybeGet((Object)player);
        if (optional.isPresent()) {
            int airHops = ((AirHopsCapability)optional.get()).getAirHops();
            if (!((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).fallDamage && airHops > 0) {
                return Math.max(0.0f, fallDistance - (float)airHops * PlayerFallHandler.getJumpHeight(player));
            }
        }
        return fallDistance;
    }

    public static float getJumpHeight(Player player) {
        float jumpHeight = 1.25f;
        if (player.m_21023_(MobEffects.f_19603_)) {
            jumpHeight += 0.6875f * ((float)player.m_21124_(MobEffects.f_19603_).m_19564_() + 1.0f);
        }
        return jumpHeight;
    }
}

