/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.argument.ScaleEasingArgumentType;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.mixin.DataCommandInvoker;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class ScaleCommand {
    private static final Random RANDOM = new Random();
    private static final DecimalFormat SCALE_FORMAT = new DecimalFormat("#,##0");

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        if (FMLLoader.isProduction() && !((Boolean)PehkuiConfig.COMMON.enableCommands.get()).booleanValue()) {
            return;
        }
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"scale").requires(commandSource -> commandSource.m_6761_(2));
        ScaleCommand.registerOperation((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerRandomize((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerGet((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerCompute((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerReset((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerModifier((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerDelay((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerEasing((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerPersist((LiteralArgumentBuilder<CommandSourceStack>)builder);
        ScaleCommand.registerNbt((LiteralArgumentBuilder<CommandSourceStack>)builder);
        commandDispatcher.register(builder);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerOperation(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"operation", (ArgumentType)ScaleOperationArgumentType.operation()).then(Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "operation");
                data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            }
            return 1;
        }))).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "operation");
            data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            return 1;
        })))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "operation");
                data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            }
            return 1;
        }))).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleData data = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "operation");
            data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerRandomize(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"randomize").then(Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"minOperation", (ArgumentType)ScaleOperationArgumentType.operation()).then(Commands.m_82129_((String)"minValue", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"maxOperation", (ArgumentType)ScaleOperationArgumentType.operation()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"maxValue", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            float minValue = FloatArgumentType.getFloat((CommandContext)context, (String)"minValue");
            float maxValue = FloatArgumentType.getFloat((CommandContext)context, (String)"maxValue");
            ScaleOperationArgumentType.Operation minOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "minOperation");
            ScaleOperationArgumentType.Operation maxOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "maxOperation");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                double target = data.getTargetScale();
                double min = minOperation.apply(target, minValue);
                double max = maxOperation.apply(target, maxValue);
                if (max < min) {
                    double temp = min;
                    min = max;
                    max = temp;
                }
                data.setTargetScale((float)(min + (double)RANDOM.nextFloat() * (max - min)));
            }
            return 1;
        }))).executes(context -> {
            float minValue = FloatArgumentType.getFloat((CommandContext)context, (String)"minValue");
            float maxValue = FloatArgumentType.getFloat((CommandContext)context, (String)"maxValue");
            ScaleOperationArgumentType.Operation minOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "minOperation");
            ScaleOperationArgumentType.Operation maxOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSourceStack>)context, "maxOperation");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            double target = data.getTargetScale();
            double min = minOperation.apply(target, minValue);
            double max = maxOperation.apply(target, maxValue);
            if (max < min) {
                double temp = min;
                min = max;
                max = temp;
            }
            data.setTargetScale((float)(min + (double)RANDOM.nextFloat() * (max - min)));
            return 1;
        })))))));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerGet(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getBaseScale();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(Commands.m_82129_((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getBaseScale();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(Commands.m_82129_((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getBaseScale();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getBaseScale();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerCompute(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"compute").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getScale();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(Commands.m_82129_((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            float scale = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getScale();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerReset(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
                ScaleData data = type.getScaleData(e);
                Boolean persist = data.getPersistence();
                data.resetScale();
                data.setPersistence(persist);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            Boolean persist = data.getPersistence();
            data.resetScale();
            data.setPersistence(persist);
            return 1;
        }))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    Boolean persist = data.getPersistence();
                    data.resetScale();
                    data.setPersistence(persist);
                }
            }
            return 1;
        }))).executes(context -> {
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
                Boolean persist = data.getPersistence();
                data.resetScale();
                data.setPersistence(persist);
            }
            return 1;
        }));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerModifier(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modifier").then(Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity"));
            String modifierString = String.join((CharSequence)", ", data.getBaseValueModifiers().stream().map(e -> ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, e).toString()).collect(Collectors.toList()));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.modifierText(modifierString), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            String modifierString = String.join((CharSequence)", ", type.getDefaultBaseValueModifiers().stream().map(e -> ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, e).toString()).collect(Collectors.toList()));
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.modifierText(modifierString), false);
            return 1;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_modifier", (ArgumentType)ScaleModifierArgumentType.scaleModifier()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
                ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSourceStack>)context, "scale_modifier");
                ScaleData data = type.getScaleData(e);
                data.getBaseValueModifiers().add(modifier);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSourceStack>)context, "scale_modifier");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.getBaseValueModifiers().add(modifier);
            return 1;
        }))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_modifier", (ArgumentType)ScaleModifierArgumentType.scaleModifier()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
                ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSourceStack>)context, "scale_modifier");
                ScaleData data = type.getScaleData(e);
                data.getBaseValueModifiers().remove(modifier);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSourceStack>)context, "scale_modifier");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.getBaseValueModifiers().remove(modifier);
            return 1;
        }))))).then(Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
                ScaleData data = type.getScaleData(e);
                SortedSet<ScaleModifier> baseValueModifiers = data.getBaseValueModifiers();
                baseValueModifiers.clear();
                baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            SortedSet<ScaleModifier> baseValueModifiers = data.getBaseValueModifiers();
            baseValueModifiers.clear();
            baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
            return 1;
        }))));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerDelay(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"delay").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            return 1;
        }))).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setScaleTickDelay(ticks);
            return 1;
        })))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            return 1;
        }))).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleData data = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setScaleTickDelay(ticks);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            int ticks = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getScaleTickDelay();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            int ticks = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getScaleTickDelay();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            int ticks = ScaleTypes.BASE.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getScaleTickDelay();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            int ticks = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getScaleTickDelay();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            int ticks = type.getDefaultTickDelay();
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            int ticks = type.getDefaultTickDelay();
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setScaleTickDelay(ticks);
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            int ticks = ScaleTypes.BASE.getDefaultTickDelay();
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            int ticks = ScaleTypes.BASE.getDefaultTickDelay();
            ScaleData data = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setScaleTickDelay(ticks);
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerEasing(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"easing").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"easing", (ArgumentType)ScaleEasingArgumentType.scaleEasing()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            Float2FloatFunction easing = ScaleEasingArgumentType.getScaleEasingArgument((CommandContext<CommandSourceStack>)context, "easing");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setEasing(easing);
            }
            return 1;
        }))).executes(context -> {
            Float2FloatFunction easing = ScaleEasingArgumentType.getScaleEasingArgument((CommandContext<CommandSourceStack>)context, "easing");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setEasing(easing);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            Float2FloatFunction easing = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getEasing();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(easing, type), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            Float2FloatFunction easing = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getEasing();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(easing, type), false);
            return 1;
        }))).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Float2FloatFunction easing = ScaleTypes.BASE.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getEasing();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(easing, ScaleTypes.BASE), false);
            return 1;
        }))).executes(context -> {
            Float2FloatFunction easing = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getEasing();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(easing, ScaleTypes.BASE), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setEasing(null);
            }
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(null, type), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setEasing(null);
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(null, type), false);
            return 1;
        }))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                data.setEasing(null);
            }
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(null, ScaleTypes.BASE), false);
            return 1;
        }))).executes(context -> {
            ScaleData data = ScaleTypes.BASE.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setEasing(null);
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.easingText(null, ScaleTypes.BASE), false);
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerPersist(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"persist").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setPersistence(persist);
            }
            return 1;
        }))).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setPersistence(persist);
            return 1;
        })))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    data.setPersistence(persist);
                }
            }
            return 1;
        }))).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
                data.setPersistence(persist);
            }
            return 1;
        })))).then(Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            Boolean persist = type.getScaleData(EntityArgument.m_91452_((CommandContext)context, (String)"entity")).getPersistence();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.persistenceText(persist, type), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            Boolean persist = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_()).getPersistence();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> ScaleCommand.persistenceText(persist, type), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setPersistence(null);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSourceStack>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
            data.setPersistence(null);
            return 1;
        }))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            for (Entity e : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    data.setPersistence(null);
                }
            }
            return 1;
        }))).executes(context -> {
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((CommandSourceStack)context.getSource()).m_81374_());
                data.setPersistence(null);
            }
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerNbt(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"nbt").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"path", (ArgumentType)NbtPathArgument.m_99487_()).executes(context -> DataCommandInvoker.Path.callExecuteGet((CommandSourceStack)context.getSource(), (DataAccessor)new EntityScaleDataObject(EntityArgument.m_91452_((CommandContext)context, (String)"entity")), NbtPathArgument.m_99498_((CommandContext)context, (String)"path")))).then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> DataCommandInvoker.Scaled.callExecuteGet((CommandSourceStack)context.getSource(), (DataAccessor)new EntityScaleDataObject(EntityArgument.m_91452_((CommandContext)context, (String)"entity")), NbtPathArgument.m_99498_((CommandContext)context, (String)"path"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))).executes(context -> DataCommandInvoker.Get.callExecuteGet((CommandSourceStack)context.getSource(), (DataAccessor)new EntityScaleDataObject(EntityArgument.m_91452_((CommandContext)context, (String)"entity")))))).executes(context -> {
            EntityScaleDataObject obj = new EntityScaleDataObject(((CommandSourceStack)context.getSource()).m_81374_());
            CompoundTag nbt = obj.m_6184_();
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> obj.m_7624_((Tag)nbt), false);
            return nbt.m_128440_();
        })));
        return builder;
    }

    private static Component scaleText(float scale) {
        long denominator = (long)(1.0f / scale);
        if ((long)scale != 1L && Float.compare(scale, 1.0f / (float)denominator) == 0) {
            return I18nUtils.translate("commands.pehkui.scale.get.fraction.message", "Scale: %s (1/%s)", ScaleCommand.format(scale), ScaleCommand.format(denominator));
        }
        return I18nUtils.translate("commands.pehkui.scale.get.message", "Scale: %s", ScaleCommand.format(scale));
    }

    private static Component scaleText(float scale, int multiplied) {
        long denominator = (long)(1.0f / scale);
        if ((long)scale != 1L && Float.compare(scale, 1.0f / (float)denominator) == 0) {
            return I18nUtils.translate("commands.pehkui.scale.get.fraction.factor.message", "Scale: %s (1/%s) | (%s)", ScaleCommand.format(scale), ScaleCommand.format(denominator), ScaleCommand.format(multiplied));
        }
        return I18nUtils.translate("commands.pehkui.scale.get.factor.message", "Scale: %s | (%s)", ScaleCommand.format(scale), ScaleCommand.format(multiplied));
    }

    private static Component modifierText(String modifierString) {
        return I18nUtils.translate("commands.pehkui.scale.modifier.get.message", "%s", modifierString.isEmpty() ? "N/A" : modifierString);
    }

    private static Component delayText(int ticks) {
        return I18nUtils.translate("commands.pehkui.scale.delay.get.message", "Delay: %s ticks", ScaleCommand.format(ticks));
    }

    private static Component persistenceText(@Nullable Boolean persist, ScaleType type) {
        String unlocalized = "commands.pehkui.scale.persist." + (persist != null ? persist : "default." + type.getDefaultPersistence());
        String message = "Persistent: " + (persist == null ? "default (" + type.getDefaultPersistence() + ")" : persist);
        return I18nUtils.translate(unlocalized, message);
    }

    private static Component easingText(@Nullable Float2FloatFunction easing, ScaleType type) {
        String easingId = ScaleRegistries.getId(ScaleRegistries.SCALE_EASINGS, easing != null ? easing : type.getDefaultEasing()).toString();
        String unlocalized = "commands.pehkui.scale.easing" + (easing != null ? "" : ".default");
        String message = "Easing: " + (easing == null ? "default (" + easingId + ")" : easingId);
        return I18nUtils.translate(unlocalized, message, easingId);
    }

    private static String format(int scale) {
        return SCALE_FORMAT.format(scale);
    }

    private static String format(long scale) {
        return SCALE_FORMAT.format(scale);
    }

    private static String format(float scale) {
        return SCALE_FORMAT.format(scale);
    }

    static {
        SCALE_FORMAT.setMaximumFractionDigits(340);
    }

    private static class EntityScaleDataObject
    extends EntityDataAccessor {
        private final Entity entity;

        public EntityScaleDataObject(Entity entity) {
            super(entity);
            this.entity = entity;
        }

        public void m_7603_(CompoundTag nbt) throws CommandSyntaxException {
            ((PehkuiEntityExtensions)this.entity).pehkui_readScaleNbt(nbt);
        }

        public CompoundTag m_6184_() {
            return ((PehkuiEntityExtensions)this.entity).pehkui_writeScaleNbt(new CompoundTag());
        }
    }
}

