/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.mixin;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.gui.ItemScrollerIcons;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.villager.FavoriteData;
import fi.dy.masa.itemscroller.villager.IMerchantScreenHandler;
import fi.dy.masa.itemscroller.villager.VillagerData;
import fi.dy.masa.itemscroller.villager.VillagerDataStorage;
import fi.dy.masa.itemscroller.villager.VillagerUtils;
import fi.dy.masa.malilib.render.RenderUtils;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1914;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_492;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_492.class})
public abstract class MixinMerchantScreen
extends class_465<class_1728> {
    @Nullable
    private FavoriteData favoriteData;
    @Shadow
    private int field_19161;
    @Shadow
    int field_19163;
    private int indexStartOffsetLast = -1;

    @Shadow
    protected abstract boolean method_20220(int var1);

    private MixinMerchantScreen(class_1728 handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void initTradeListWidget(CallbackInfo ci) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && Configs.Generic.VILLAGER_TRADE_LIST_REMEMBER_SCROLL.getBooleanValue()) {
            VillagerData data = VillagerDataStorage.getInstance().getDataForLastInteractionTarget();
            int listSize = ((class_1728)this.field_2797).method_17438().size();
            if (data != null && this.method_20220(listSize)) {
                this.field_19163 = this.getClampedIndex(data.getTradeListPosition());
            }
        }
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="RETURN")})
    private void onMouseScrollPost(double mouseX, double mouseY, double amount, CallbackInfoReturnable<Boolean> cir) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && Configs.Generic.VILLAGER_TRADE_LIST_REMEMBER_SCROLL.getBooleanValue() && this.indexStartOffsetLast != this.field_19163) {
            int index = this.getClampedIndex(this.field_19163);
            VillagerDataStorage.getInstance().setTradeListPosition(index);
            this.indexStartOffsetLast = index;
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="RETURN")})
    private void onMouseDragPost(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && Configs.Generic.VILLAGER_TRADE_LIST_REMEMBER_SCROLL.getBooleanValue() && this.indexStartOffsetLast != this.field_19163) {
            int index = this.getClampedIndex(this.field_19163);
            VillagerDataStorage.getInstance().setTradeListPosition(index);
            this.indexStartOffsetLast = index;
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="RETURN")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        int visibleIndex;
        int realIndex;
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && (realIndex = VillagerUtils.getRealTradeIndexFor(visibleIndex = this.getHoveredTradeButtonIndex(mouseX, mouseY), (class_1728)this.field_2797)) >= 0) {
            if (button == 1) {
                InventoryUtils.villagerTradeEverythingPossibleWithTrade(visibleIndex);
                cir.setReturnValue((Object)true);
            } else if (button == 2) {
                if (Hotkeys.MODIFIER_TOGGLE_VILLAGER_GLOBAL_FAVORITE.getKeybind().isKeybindHeld()) {
                    class_1914 trade = (class_1914)((class_1728)this.field_2797).method_17438().get(visibleIndex);
                    VillagerDataStorage.getInstance().toggleGlobalFavorite(trade);
                } else {
                    VillagerDataStorage.getInstance().toggleFavorite(realIndex);
                }
                this.favoriteData = null;
                ((class_1728)this.field_2797).method_17437(((IMerchantScreenHandler)this.field_2797).getOriginalList());
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"syncRecipeIndex"}, at={@At(value="HEAD")}, cancellable=true)
    private void fixRecipeIndex(CallbackInfo ci) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && this.method_17577() instanceof IMerchantScreenHandler && VillagerUtils.switchToTradeByVisibleIndex(this.field_19161)) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screen/ingame/MerchantScreen;offers:[Lnet/minecraft/client/gui/screen/ingame/MerchantScreen$WidgetButtonPage;")})
    private void renderFavoriteMarker(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue()) {
            int numFavorites;
            FavoriteData favoriteData = this.favoriteData;
            if (favoriteData == null) {
                this.favoriteData = favoriteData = VillagerDataStorage.getInstance().getFavoritesForCurrentVillager((class_1728)this.field_2797);
            }
            if ((numFavorites = favoriteData.favorites.size()) > 0 && this.field_19163 < numFavorites) {
                int screenX = (this.field_22789 - this.field_2792) / 2;
                int screenY = (this.field_22790 - this.field_2779) / 2;
                int buttonsStartX = screenX + 5;
                int buttonsStartY = screenY + 16 + 2;
                int x = buttonsStartX + 89 - 8;
                int y = buttonsStartY + 2;
                float z = this.method_25305() + 300;
                ItemScrollerIcons icon = favoriteData.isGlobal ? ItemScrollerIcons.STAR_5_PURPLE : ItemScrollerIcons.STAR_5_YELLOW;
                for (int i = 0; i < numFavorites - this.field_19163; ++i) {
                    RenderUtils.bindTexture((class_2960)icon.getTexture());
                    icon.renderAt(x, y, z, false, false);
                    y += 20;
                }
            }
        }
    }

    private int getClampedIndex(int index) {
        int listSize = ((class_1728)this.field_2797).method_17438().size();
        return Math.max(0, Math.min(index, listSize - 7));
    }

    private int getHoveredTradeButtonIndex(double mouseX, double mouseY) {
        int screenX = (this.field_22789 - this.field_2792) / 2;
        int screenY = (this.field_22790 - this.field_2779) / 2;
        int buttonsStartX = screenX + 5;
        int buttonsStartY = screenY + 16 + 2;
        int buttonWidth = 89;
        int buttonHeight = 20;
        if (mouseX >= (double)buttonsStartX && mouseX <= (double)(buttonsStartX + buttonWidth) && mouseY >= (double)buttonsStartY && mouseY <= (double)(buttonsStartY + 7 * buttonHeight)) {
            return this.field_19163 + ((int)mouseY - buttonsStartY) / buttonHeight;
        }
        return -1;
    }
}

