/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5423;
import net.minecraft.class_5455;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.VersionUtils;

public class ReflectionUtils {
    public static final MethodHandle FOG_DENSITY;
    public static final MethodHandle FOG_START;
    public static final MethodHandle FOG_END;
    public static final MethodHandle GET_REGISTRY_MANAGER;
    public static final MethodHandle GET_DYNAMIC_REGISTRY;
    public static final MethodHandle GET_BIOME;
    public static final MethodHandle GET_IDS;
    public static final MethodHandle GET_ID;
    public static final class_5321<class_2378<class_3611>> FLUID_KEY;
    public static final class_5321<class_2378<class_1959>> BIOME_KEY;
    public static final class_5321<class_2378<class_2874>> DIMENSION_TYPE_KEY;
    public static final class_2378<class_1959> BUILTIN_BIOME_REGISTRY;

    private static <T> class_2378<T> castRegistry(Object obj) {
        return (class_2378)obj;
    }

    private static <T> class_5321<T> castRegistryKey(Object obj) {
        return (class_5321)obj;
    }

    public static <E> class_2378<E> getDynamicRegistry(class_5423 w, class_5321<? extends class_2378<? extends E>> key) throws Throwable {
        if (GET_REGISTRY_MANAGER != null && GET_DYNAMIC_REGISTRY != null) {
            class_5455 m = VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2 ? GET_REGISTRY_MANAGER.invokeExact(w) : GET_REGISTRY_MANAGER.invokeExact((class_4538)w);
            return VersionUtils.MINOR == 16 ? GET_DYNAMIC_REGISTRY.invokeExact(m, key) : GET_DYNAMIC_REGISTRY.invokeExact(m, key);
        }
        return null;
    }

    public static String getBiomeId(class_1297 entity) throws Throwable {
        if (GET_BIOME != null) {
            if (VersionUtils.MINOR > 18 || VersionUtils.MINOR == 18 && VersionUtils.PATCH >= 2) {
                return GET_BIOME.invokeExact((class_4538)entity.field_6002, new class_2338(entity.method_19538())).method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse(null);
            }
            class_1959 biome = GET_BIOME.invokeExact((class_4538)entity.field_6002, new class_2338(entity.method_19538()));
            return ReflectionUtils.getId(ReflectionUtils.getDynamicRegistry((class_5423)entity.field_6002, BIOME_KEY), biome).toString();
        }
        return null;
    }

    public static Set<class_2960> getIds(class_2378<?> registry) throws Throwable {
        return GET_IDS.invoke(registry);
    }

    public static <V> class_2960 getId(class_2378<V> registry, V entry) throws Throwable {
        return GET_ID.invoke(registry, entry);
    }

    public static void setFogDensity(float f) throws Throwable {
        if (FOG_DENSITY != null) {
            FOG_DENSITY.invokeExact(f);
        }
    }

    public static void setFogStart(float f) throws Throwable {
        if (FOG_START != null) {
            FOG_START.invokeExact(f);
        }
    }

    public static void setFogEnd(float f) throws Throwable {
        if (FOG_END != null) {
            FOG_END.invokeExact(f);
        }
    }

    public static <T> T getFieldValue(Field field, Object object, Supplier<T> defaultValue) {
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return defaultValue.get();
        }
    }

    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException e) {
                return null;
            }
        });
    }

    public static <T> T getFieldValue(Optional<Class<?>> classObj, String fieldName, Object object, T defaultValue) {
        return (T)ReflectionUtils.getField(classObj, fieldName).map(f -> {
            try {
                return f.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return defaultValue;
            }
        }).orElse(defaultValue);
    }

    public static void setField(Optional<Class<?>> classObj, String fieldName, Object object, Object value) {
        ReflectionUtils.getField(classObj, fieldName).ifPresent(f -> {
            try {
                f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectionUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectionUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private ReflectionUtils() {
    }

    static {
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        Object kF = null;
        Object rB = null;
        Object kB = null;
        Object kD = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String mapped = "unset";
        try {
            Method m;
            Class<?> clazz;
            boolean is1192Minus;
            boolean is116 = VersionUtils.MINOR == 16;
            boolean is1182Plus = VersionUtils.MINOR > 18 || VersionUtils.MINOR == 18 && VersionUtils.PATCH >= 2;
            boolean bl = is1192Minus = VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2;
            if (is116) {
                clazz = Class.forName("com.mojang.blaze3d.systems.RenderSystem");
                m = clazz.getMethod("fogDensity", Float.TYPE);
                h.put(0, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogStart", Float.TYPE);
                h.put(1, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogEnd", Float.TYPE);
                h.put(2, (Object)lookup.unreflect(m));
            }
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_" + (is1192Minus ? "5423" : "4538"), "method_30349", "()Lnet/minecraft/class_5455;");
            m = (is1192Minus ? class_5423.class : class_4538.class).getMethod(mapped, new Class[0]);
            h.put(3, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_5455", "method_30530", "(Lnet/minecraft/class_5321;)Lnet/minecraft/class_" + (is116 ? "2385;" : "2378;"));
            m = class_5455.class.getMethod(mapped, class_5321.class);
            h.put(4, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_4538", "method_23753", "(Lnet/minecraft/class_2338;)Lnet/minecraft/class_" + (is1182Plus ? "6880;" : "1959;"));
            m = class_4538.class.getMethod(mapped, class_2338.class);
            h.put(5, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2378", "method_10235", "()Ljava/util/Set;");
            m = class_2378.class.getMethod(mapped, new Class[0]);
            h.put(6, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2378", "method_10221", "(Ljava/lang/Object;)Lnet/minecraft/class_2960;");
            m = class_2378.class.getMethod(mapped, Object.class);
            h.put(7, (Object)lookup.unreflect(m));
            String registrar = is1192Minus ? "net.minecraft.class_2378" : "net.minecraft.class_7924";
            mapped = mappingResolver.mapClassName("intermediary", registrar);
            clazz = Class.forName(mapped);
            mapped = mappingResolver.mapFieldName("intermediary", registrar, "field_" + (is1192Minus ? "25103" : "41270"), "Lnet/minecraft/class_5321;");
            Field f = clazz.getField(mapped);
            kF = f.get(null);
            mapped = mappingResolver.mapFieldName("intermediary", registrar, "field_" + (is1192Minus ? "25114" : "41236"), "Lnet/minecraft/class_5321;");
            f = clazz.getField(mapped);
            kB = f.get(null);
            mapped = mappingResolver.mapFieldName("intermediary", registrar, "field_" + (is1192Minus ? "25095" : "41241"), "Lnet/minecraft/class_5321;");
            f = clazz.getField(mapped);
            kD = f.get(null);
            if (is1192Minus) {
                mapped = mappingResolver.mapClassName("intermediary", "net.minecraft.class_5458");
                clazz = Class.forName(mapped);
                mapped = mappingResolver.mapFieldName("intermediary", "net.minecraft.class_5458", "field_25933", "Lnet/minecraft/2378;");
                f = clazz.getField(mapped);
                rB = f.get(null);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException e1) {
            NoFogClient.LOGGER.error("Current name lookup: {}", (Object)mapped);
            NoFogClient.LOGGER.catching((Throwable)e1);
        }
        FOG_DENSITY = (MethodHandle)h.get(0);
        FOG_START = (MethodHandle)h.get(1);
        FOG_END = (MethodHandle)h.get(2);
        GET_REGISTRY_MANAGER = (MethodHandle)h.get(3);
        GET_DYNAMIC_REGISTRY = (MethodHandle)h.get(4);
        GET_BIOME = (MethodHandle)h.get(5);
        GET_IDS = (MethodHandle)h.get(6);
        GET_ID = (MethodHandle)h.get(7);
        FLUID_KEY = ReflectionUtils.castRegistryKey(kF);
        BIOME_KEY = ReflectionUtils.castRegistryKey(kB);
        DIMENSION_TYPE_KEY = ReflectionUtils.castRegistryKey(kD);
        BUILTIN_BIOME_REGISTRY = ReflectionUtils.castRegistry(rB);
    }
}

