/*
 * Decompiled with CFR 0.152.
 */
package kroppeb.stareval.function;

import kroppeb.stareval.expression.ConstantExpression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.TypedFunction;
import net.coderbot.iris.gl.uniform.UniformType;
import net.coderbot.iris.parsing.MatrixType;
import net.coderbot.iris.parsing.VectorType;

public abstract class Type {
    public static Boolean Boolean = new Boolean();
    public static Int Int = new Int();
    public static Float Float = new Float();
    public static TypedFunction.Parameter BooleanParameter = new TypedFunction.Parameter(Boolean);
    public static TypedFunction.Parameter IntParameter = new TypedFunction.Parameter(Int);
    public static TypedFunction.Parameter FloatParameter = new TypedFunction.Parameter(Float);
    public static Primitive[] AllPrimitives = new Primitive[]{Boolean, Int, Float};

    public abstract ConstantExpression createConstant(FunctionReturn var1);

    public abstract Object createArray(int var1);

    public abstract void setValueFromReturn(Object var1, int var2, FunctionReturn var3);

    public abstract void getValueFromArray(Object var1, int var2, FunctionReturn var3);

    public abstract String toString();

    @Deprecated
    public static UniformType convert(Type type) {
        if (type == Int || type == Boolean) {
            return UniformType.INT;
        }
        if (type == Float) {
            return UniformType.FLOAT;
        }
        if (type == VectorType.VEC2) {
            return UniformType.VEC2;
        }
        if (type == VectorType.VEC3) {
            return UniformType.VEC3;
        }
        if (type == VectorType.VEC4) {
            return UniformType.VEC4;
        }
        if (type == VectorType.I_VEC2) {
            return UniformType.VEC2I;
        }
        if (type == MatrixType.MAT4) {
            return UniformType.MAT4;
        }
        throw new IllegalArgumentException("Unsupported custom uniform type: " + type);
    }

    public static class Int
    extends Primitive {
        @Override
        public ConstantExpression createConstant(FunctionReturn functionReturn) {
            final int n = functionReturn.intReturn;
            return new ConstantExpression(this){

                @Override
                public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                    functionReturn.intReturn = n;
                }
            };
        }

        @Override
        public Object createArray(int n) {
            return new int[n];
        }

        @Override
        public void setValueFromReturn(Object object, int n, FunctionReturn functionReturn) {
            int[] nArray = (int[])object;
            nArray[n] = functionReturn.intReturn;
        }

        @Override
        public void getValueFromArray(Object object, int n, FunctionReturn functionReturn) {
            int[] nArray = (int[])object;
            functionReturn.intReturn = nArray[n];
        }

        @Override
        public String toString() {
            return "int";
        }
    }

    public static class Boolean
    extends Primitive {
        @Override
        public ConstantExpression createConstant(FunctionReturn functionReturn) {
            final boolean bl = functionReturn.booleanReturn;
            return new ConstantExpression(this){

                @Override
                public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                    functionReturn.booleanReturn = bl;
                }
            };
        }

        @Override
        public Object createArray(int n) {
            return new boolean[n];
        }

        @Override
        public void setValueFromReturn(Object object, int n, FunctionReturn functionReturn) {
            boolean[] blArray = (boolean[])object;
            blArray[n] = functionReturn.booleanReturn;
        }

        @Override
        public void getValueFromArray(Object object, int n, FunctionReturn functionReturn) {
            boolean[] blArray = (boolean[])object;
            functionReturn.booleanReturn = blArray[n];
        }

        @Override
        public String toString() {
            return "bool";
        }
    }

    public static class Float
    extends Primitive {
        @Override
        public ConstantExpression createConstant(FunctionReturn functionReturn) {
            final float f = functionReturn.floatReturn;
            return new ConstantExpression(this){

                @Override
                public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                    functionReturn.floatReturn = f;
                }
            };
        }

        @Override
        public Object createArray(int n) {
            return new float[n];
        }

        @Override
        public void setValueFromReturn(Object object, int n, FunctionReturn functionReturn) {
            float[] fArray = (float[])object;
            fArray[n] = functionReturn.floatReturn;
        }

        @Override
        public void getValueFromArray(Object object, int n, FunctionReturn functionReturn) {
            float[] fArray = (float[])object;
            functionReturn.floatReturn = fArray[n];
        }

        @Override
        public String toString() {
            return "float";
        }
    }

    public static abstract class Primitive
    extends Type {
    }

    public static class ObjectType
    extends Type {
        @Override
        public ConstantExpression createConstant(FunctionReturn functionReturn) {
            final Object object = functionReturn.objectReturn;
            return new ConstantExpression(this){

                @Override
                public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                    functionReturn.objectReturn = object;
                }
            };
        }

        @Override
        public Object createArray(int n) {
            return new Object[n];
        }

        @Override
        public void setValueFromReturn(Object object, int n, FunctionReturn functionReturn) {
            Object[] objectArray = (Object[])object;
            objectArray[n] = functionReturn.objectReturn;
        }

        @Override
        public void getValueFromArray(Object object, int n, FunctionReturn functionReturn) {
            Object[] objectArray = (Object[])object;
            functionReturn.objectReturn = objectArray[n];
        }

        @Override
        public String toString() {
            return "Object";
        }
    }
}

