/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.clouds_xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.formats.screen_quad.BasicScreenQuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.clouds_xhfp.ExtendedBasicScreenQuadVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.clouds_xhfp.QuadViewClouds;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Vector3f;

public class CloudsVertexBufferWriterNio
extends VertexBufferWriterNio
implements BasicScreenQuadVertexSink {
    private static final int STRIDE = IrisVertexFormats.CLOUDS.method_1362();
    private final QuadViewClouds.QuadViewCloudsNio quad = new QuadViewClouds.QuadViewCloudsNio();
    private final Vector3f saveNormal = new Vector3f();
    private int vertexCount;

    public CloudsVertexBufferWriterNio(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)ExtendedBasicScreenQuadVertexType.INSTANCE);
    }

    public void writeQuad(float f, float f2, float f3, int n) {
        ByteBuffer byteBuffer = this.byteBuffer;
        int n2 = this.writeOffset;
        ++this.vertexCount;
        byteBuffer.putFloat(n2, f);
        byteBuffer.putFloat(n2 + 4, f2);
        byteBuffer.putFloat(n2 + 8, f3);
        byteBuffer.putInt(n2 + 12, n);
        if (this.vertexCount == 4) {
            this.endQuad();
        }
        this.advance();
    }

    private void endQuad() {
        this.vertexCount = 0;
        int n = this.writeOffset;
        this.quad.setup(this.byteBuffer, this.writeOffset, STRIDE);
        NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
        int n2 = NormalHelper.packNormal(this.saveNormal, 0.0f);
        for (int i = 0; i < 4; ++i) {
            this.byteBuffer.putInt(n + 16 - STRIDE * i, n2);
        }
    }
}

