/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.AlphaTests;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_2960;

public class SodiumTerrainPipeline {
    Optional<String> terrainVertex;
    Optional<String> terrainGeometry;
    Optional<String> terrainFragment;
    Optional<String> terrainCutoutFragment;
    GlFramebuffer terrainFramebuffer;
    BlendModeOverride terrainBlendOverride;
    List<BufferBlendOverride> terrainBufferOverrides;
    Optional<AlphaTest> terrainCutoutAlpha;
    Optional<String> translucentVertex;
    Optional<String> translucentGeometry;
    Optional<String> translucentFragment;
    GlFramebuffer translucentFramebuffer;
    BlendModeOverride translucentBlendOverride;
    List<BufferBlendOverride> translucentBufferOverrides;
    Optional<AlphaTest> translucentAlpha;
    Optional<String> shadowVertex;
    Optional<String> shadowGeometry;
    Optional<String> shadowFragment;
    Optional<String> shadowCutoutFragment;
    GlFramebuffer shadowFramebuffer;
    BlendModeOverride shadowBlendOverride = BlendModeOverride.OFF;
    List<BufferBlendOverride> shadowBufferOverrides;
    Optional<AlphaTest> shadowAlpha;
    ProgramSet programSet;
    private final WorldRenderingPipeline parent;
    private final CustomUniforms customUniforms;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;
    private static final Supplier<Optional<AlphaTest>> terrainCutoutDefault = () -> Optional.of(AlphaTests.ONE_TENTH_ALPHA);
    private static final Supplier<Optional<AlphaTest>> translucentDefault = () -> Optional.of(AlphaTest.ALWAYS);
    private static final Supplier<Optional<AlphaTest>> shadowDefault = () -> Optional.of(AlphaTests.NON_ZERO_ALPHA);

    public SodiumTerrainPipeline(WorldRenderingPipeline worldRenderingPipeline, ProgramSet programSet, IntFunction<ProgramSamplers> intFunction, IntFunction<ProgramSamplers> intFunction2, IntFunction<ProgramImages> intFunction3, IntFunction<ProgramImages> intFunction4, RenderTargets renderTargets, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, GlFramebuffer glFramebuffer, CustomUniforms customUniforms) {
        this.parent = Objects.requireNonNull(worldRenderingPipeline);
        this.customUniforms = customUniforms;
        Optional<ProgramSource> optional = SodiumTerrainPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> optional2 = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), optional);
        this.programSet = programSet;
        this.shadowFramebuffer = glFramebuffer;
        optional.ifPresent(programSource -> {
            this.terrainFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, programSource.getDirectives().getDrawBuffers());
        });
        optional2.ifPresent(programSource -> {
            this.translucentFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet2, programSource.getDirectives().getDrawBuffers());
        });
        if (this.terrainFramebuffer == null) {
            this.terrainFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, new int[]{0});
        }
        if (this.translucentFramebuffer == null) {
            this.translucentFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet2, new int[]{0});
        }
        this.createTerrainSamplers = intFunction;
        this.createShadowSamplers = intFunction2;
        this.createTerrainImages = intFunction3;
        this.createShadowImages = intFunction4;
    }

    public void patchShaders(ChunkVertexType chunkVertexType) {
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(true, true, false, true, true);
        Optional<ProgramSource> optional = SodiumTerrainPipeline.first(this.programSet.getGbuffersTerrain(), this.programSet.getGbuffersTexturedLit(), this.programSet.getGbuffersTextured(), this.programSet.getGbuffersBasic());
        Optional<ProgramSource> optional2 = SodiumTerrainPipeline.first(this.programSet.getGbuffersWater(), optional);
        optional.ifPresentOrElse(programSource -> {
            this.terrainBlendOverride = programSource.getDirectives().getBlendModeOverride().orElse(ProgramId.Terrain.getBlendModeOverride());
            this.terrainBufferOverrides = new ArrayList<BufferBlendOverride>();
            programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
                int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
                if (n > -1) {
                    this.terrainBufferOverrides.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
                }
            });
            this.terrainCutoutAlpha = programSource.getDirectives().getAlphaTestOverride().or(terrainCutoutDefault);
            Map<PatchShaderType, String> map = TransformPatcher.patchSodium(programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), this.terrainCutoutAlpha.get(), AlphaTest.ALWAYS, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale(), this.parent.getTextureMap());
            this.terrainVertex = Optional.ofNullable(map.get((Object)PatchShaderType.VERTEX));
            this.terrainGeometry = Optional.ofNullable(map.get((Object)PatchShaderType.GEOMETRY));
            this.terrainCutoutFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT_CUTOUT));
            this.terrainFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(programSource.getName() + "_sodium", this.terrainVertex.orElse(null), this.terrainGeometry.orElse(null), this.terrainFragment.orElse(null));
            PatchedShaderPrinter.debugPatchedShaders(programSource.getName() + "_sodium_cutout", null, null, this.terrainCutoutFragment.orElse(null));
        }, () -> {
            this.terrainBlendOverride = null;
            this.terrainBufferOverrides = Collections.emptyList();
            this.terrainCutoutAlpha = terrainCutoutDefault.get();
            this.terrainVertex = Optional.empty();
            this.terrainGeometry = Optional.empty();
            this.terrainCutoutFragment = Optional.empty();
            this.terrainFragment = Optional.empty();
        });
        optional2.ifPresentOrElse(programSource -> {
            this.translucentBlendOverride = programSource.getDirectives().getBlendModeOverride().orElse(ProgramId.Water.getBlendModeOverride());
            this.translucentBufferOverrides = new ArrayList<BufferBlendOverride>();
            programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
                int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
                if (n > -1) {
                    this.translucentBufferOverrides.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
                }
            });
            this.translucentAlpha = programSource.getDirectives().getAlphaTestOverride().or(translucentDefault);
            Map<PatchShaderType, String> map = TransformPatcher.patchSodium(programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), null, this.translucentAlpha.get(), shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale(), this.parent.getTextureMap());
            this.translucentVertex = Optional.ofNullable(map.get((Object)PatchShaderType.VERTEX));
            this.translucentGeometry = Optional.ofNullable(map.get((Object)PatchShaderType.GEOMETRY));
            this.translucentFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(programSource.getName() + "_sodium", this.translucentVertex.orElse(null), this.translucentGeometry.orElse(null), this.translucentFragment.orElse(null));
        }, () -> {
            this.translucentBlendOverride = null;
            this.translucentBufferOverrides = Collections.emptyList();
            this.translucentAlpha = translucentDefault.get();
            this.translucentVertex = Optional.empty();
            this.translucentGeometry = Optional.empty();
            this.translucentFragment = Optional.empty();
        });
        this.programSet.getShadow().ifPresentOrElse(programSource -> {
            this.shadowBlendOverride = programSource.getDirectives().getBlendModeOverride().orElse(ProgramId.Shadow.getBlendModeOverride());
            this.shadowBufferOverrides = new ArrayList<BufferBlendOverride>();
            programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
                int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
                if (n > -1) {
                    this.shadowBufferOverrides.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
                }
            });
            this.shadowAlpha = programSource.getDirectives().getAlphaTestOverride().or(shadowDefault);
            Map<PatchShaderType, String> map = TransformPatcher.patchSodium(programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), this.shadowAlpha.get(), AlphaTest.ALWAYS, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale(), this.parent.getTextureMap());
            this.shadowVertex = Optional.ofNullable(map.get((Object)PatchShaderType.VERTEX));
            this.shadowGeometry = Optional.ofNullable(map.get((Object)PatchShaderType.GEOMETRY));
            this.shadowCutoutFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT_CUTOUT));
            this.shadowFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(programSource.getName() + "_sodium", this.shadowVertex.orElse(null), this.shadowGeometry.orElse(null), this.shadowFragment.orElse(null));
            PatchedShaderPrinter.debugPatchedShaders(programSource.getName() + "_sodium_cutout", null, null, this.shadowCutoutFragment.orElse(null));
        }, () -> {
            this.shadowBlendOverride = null;
            this.shadowBufferOverrides = Collections.emptyList();
            this.shadowAlpha = shadowDefault.get();
            this.shadowVertex = Optional.empty();
            this.shadowGeometry = Optional.empty();
            this.shadowCutoutFragment = Optional.empty();
            this.shadowFragment = Optional.empty();
        });
    }

    public Optional<String> getTerrainVertexShaderSource() {
        return this.terrainVertex;
    }

    public Optional<String> getTerrainGeometryShaderSource() {
        return this.terrainGeometry;
    }

    public Optional<String> getTerrainFragmentShaderSource() {
        return this.terrainFragment;
    }

    public Optional<String> getTerrainCutoutFragmentShaderSource() {
        return this.terrainCutoutFragment;
    }

    public GlFramebuffer getTerrainFramebuffer() {
        return this.terrainFramebuffer;
    }

    public BlendModeOverride getTerrainBlendOverride() {
        return this.terrainBlendOverride;
    }

    public List<BufferBlendOverride> getTerrainBufferOverrides() {
        return this.terrainBufferOverrides;
    }

    public Optional<AlphaTest> getTerrainCutoutAlpha() {
        return this.terrainCutoutAlpha;
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return this.translucentVertex;
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return this.translucentGeometry;
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return this.translucentFragment;
    }

    public GlFramebuffer getTranslucentFramebuffer() {
        return this.translucentFramebuffer;
    }

    public BlendModeOverride getTranslucentBlendOverride() {
        return this.translucentBlendOverride;
    }

    public List<BufferBlendOverride> getTranslucentBufferOverrides() {
        return this.translucentBufferOverrides;
    }

    public Optional<AlphaTest> getTranslucentAlpha() {
        return this.translucentAlpha;
    }

    public Optional<String> getShadowVertexShaderSource() {
        return this.shadowVertex;
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return this.shadowGeometry;
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return this.shadowFragment;
    }

    public Optional<String> getShadowCutoutFragmentShaderSource() {
        return this.shadowCutoutFragment;
    }

    public GlFramebuffer getShadowFramebuffer() {
        return this.shadowFramebuffer;
    }

    public BlendModeOverride getShadowBlendOverride() {
        return this.shadowBlendOverride;
    }

    public List<BufferBlendOverride> getShadowBufferOverrides() {
        return this.shadowBufferOverrides;
    }

    public Optional<AlphaTest> getShadowAlpha() {
        return this.shadowAlpha;
    }

    public ProgramUniforms.Builder initUniforms(int n) {
        ProgramUniforms.Builder builder = ProgramUniforms.builder("<sodium shaders>", n);
        CommonUniforms.addDynamicUniforms(builder, FogMode.PER_VERTEX);
        this.customUniforms.assignTo(builder);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(builder);
        return builder;
    }

    public boolean hasShadowPass() {
        return this.createShadowSamplers != null;
    }

    public ProgramSamplers initTerrainSamplers(int n) {
        return this.createTerrainSamplers.apply(n);
    }

    public ProgramSamplers initShadowSamplers(int n) {
        return this.createShadowSamplers.apply(n);
    }

    public ProgramImages initTerrainImages(int n) {
        return this.createTerrainImages.apply(n);
    }

    public ProgramImages initShadowImages(int n) {
        return this.createShadowImages.apply(n);
    }

    public CustomUniforms getCustomUniforms() {
        return this.customUniforms;
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... optionalArray) {
        for (Optional<T> optional : optionalArray) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static String parseSodiumImport(String string) {
        Pattern pattern = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed import statement (expected format: " + pattern + ")");
        }
        String string2 = matcher.group("namespace");
        String string3 = matcher.group("path");
        class_2960 class_29602 = new class_2960(string2, string3);
        return "";
    }
}

