/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.dungeons.catacombs;

import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.RoomDetection;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.Waypoints;
import io.github.quantizr.dungeonrooms.utils.MapUtils;
import io.github.quantizr.dungeonrooms.utils.Utils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DungeonManager {
    Minecraft mc = Minecraft.func_71410_x();
    public static int gameStage = 0;
    public static boolean guiToggled = true;
    public static boolean motdToggled = true;
    public static Integer[][] map;
    public static Point[] entranceMapCorners;
    public static Point entrancePhysicalNWCorner;
    public static Integer mapId;
    long bloodTime = Long.MAX_VALUE;
    boolean oddRun = true;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onChat(ClientChatReceivedEvent event) {
        if (!Utils.inCatacombs) {
            return;
        }
        String message = event.message.func_150254_d();
        if (message.startsWith("\u00a7e[NPC] \u00a7bMort\u00a7f: \u00a7rHere, I found this map when I first entered the dungeon.\u00a7r")) {
            gameStage = 2;
            DungeonRooms.logger.info("DungeonRooms: gameStage set to " + gameStage);
        } else if (message.startsWith("\u00a7r\u00a7c[BOSS] The Watcher\u00a7r\u00a7f: You have proven yourself. You may pass.\u00a7r")) {
            this.bloodTime = System.currentTimeMillis() + 5000L;
            DungeonRooms.logger.info("DungeonRooms: bloodDone has been set to True");
        } else if (System.currentTimeMillis() > this.bloodTime && (message.startsWith("\u00a7r\u00a7c[BOSS] ") && !message.contains(" The Watcher\u00a7r\u00a7f:") || message.startsWith("\u00a7r\u00a74[BOSS] "))) {
            if (gameStage != 3) {
                gameStage = 3;
                DungeonRooms.logger.info("DungeonRooms: gameStage set to " + gameStage);
                RoomDetection.resetCurrentRoom();
                RoomDetection.roomName = "Boss Room";
                RoomDetection.roomCategory = "General";
            }
        } else if (message.contains("\u00a7r\u00a7c\u2620 \u00a7r\u00a7eDefeated \u00a7r")) {
            gameStage = 4;
            DungeonRooms.logger.info("DungeonRooms: gameStage set to " + gameStage);
            RoomDetection.resetCurrentRoom();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (!Utils.inCatacombs) {
            return;
        }
        if (gameStage == 0 || gameStage == 1) {
            if (DungeonRooms.firstLogin) {
                DungeonRooms.firstLogin = false;
                this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7d\u00a7l--- Dungeon Rooms Mod ---\n\u00a7e This appears to be your first time using DRM v3.4.1.\n\u00a7e Press \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[1].func_151463_i()) + "\" to configure Secret Waypoint settings, If you do not wish to use Waypoints, you can instead press \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[0].func_151463_i()) + "\" while inside a dungeon room to view images of the secrets for that room.\n\u00a7r (If you need help, join the Discord! Run \"/room discord\" to open the Discord invite.)\n\u00a7d\u00a7l------------------------"));
            }
            if (gameStage == 0) {
                Utils.checkForConflictingHotkeys();
                gameStage = 1;
                DungeonRooms.logger.info("DungeonRooms: gameStage set to " + gameStage);
            }
            if (MapUtils.mapExists()) {
                DungeonRooms.logger.warn("DungeonRooms: Run started but gameStage is not on 2");
                gameStage = 2;
                DungeonRooms.logger.info("DungeonRooms: gameStage set to " + gameStage);
                return;
            }
            if (gameStage == 1 && entrancePhysicalNWCorner == null && !player.func_174791_d().equals(new Vec3(0.0, 0.0, 0.0))) {
                entrancePhysicalNWCorner = MapUtils.getClosestNWPhysicalCorner(player.func_174791_d());
                DungeonRooms.logger.info("DungeonRooms: entrancePhysicalNWCorner has been set to " + entrancePhysicalNWCorner);
            }
            if (DungeonRooms.textToDisplay == null && motdToggled) {
                DungeonRooms.logger.info("DungeonRooms: Updating MOTD on screen");
                if (!(!this.oddRun && guiToggled || DungeonRooms.motd == null || DungeonRooms.motd.isEmpty())) {
                    DungeonRooms.textToDisplay = DungeonRooms.motd;
                }
                if (DungeonRooms.textToDisplay == null && guiToggled) {
                    DungeonRooms.textToDisplay = new ArrayList<String>(Arrays.asList("Dungeon Rooms: " + EnumChatFormatting.GREEN + "Press the hotkey \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[1].func_151463_i()) + "\" to configure", EnumChatFormatting.GREEN + " waypoint settings. Alternatively, press \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[0].func_151463_i()) + "\" while in a room", EnumChatFormatting.GREEN + "to view images of secret locations for that room.", "(You can change the keybinds in Minecraft controls menu)"));
                }
                this.oddRun = !this.oddRun;
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        Utils.inCatacombs = false;
        gameStage = 0;
        mapId = null;
        map = null;
        entranceMapCorners = null;
        entrancePhysicalNWCorner = null;
        RoomDetection.entranceMapNullCount = 0;
        this.bloodTime = Long.MAX_VALUE;
        if (RoomDetection.stage2Executor != null) {
            RoomDetection.stage2Executor.shutdown();
        }
        Waypoints.allSecretsMap.clear();
        RoomDetection.resetCurrentRoom();
    }
}

