/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.utils;

import io.github.quantizr.dungeonrooms.dungeons.catacombs.DungeonManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec4b;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class MapUtils {
    public static boolean mapExists() {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack mapSlot = mc.field_71439_g.field_71071_by.func_70301_a(8);
        if (mapSlot == null || mapSlot.func_77973_b() != Items.field_151098_aY || !mapSlot.func_82837_s()) {
            return false;
        }
        return mapSlot.func_82833_r().contains("Magical Map");
    }

    public static Integer[][] updatedMap() {
        return MapUtils.updatedMap(DungeonManager.mapId);
    }

    public static Integer[][] updatedMap(int mapId) {
        return MapUtils.updatedMap((MapData)Minecraft.func_71410_x().field_71441_e.func_175693_T().func_75742_a(MapData.class, "map_" + mapId));
    }

    public static Integer[][] updatedMap(ItemStack mapSlot) {
        return MapUtils.updatedMap(Items.field_151098_aY.func_77873_a(mapSlot, (World)Minecraft.func_71410_x().field_71441_e));
    }

    public static Integer[][] updatedMap(MapData mapData) {
        if (mapData == null) {
            return null;
        }
        Integer[][] map = new Integer[128][128];
        for (int i = 0; i < 16384; ++i) {
            int x = i % 128;
            int y = i / 128;
            int j = mapData.field_76198_e[i] & 0xFF;
            int rgba = j / 4 == 0 ? (i + i / 128 & 1) * 8 + 16 << 24 : MapColor.field_76281_a[j / 4].func_151643_b(j & 3);
            map[x][y] = rgba & 0xFFFFFF;
        }
        return map;
    }

    public static Point[] entranceMapCorners(Integer[][] map) {
        if (map == null) {
            return null;
        }
        Point[] corners = new Point[2];
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                if (map[x][y] == null || map[x][y] != 31744 || map[x][y - 1] == null || map[x][y - 1] != 0) continue;
                if (map[x - 1][y] != null && map[x - 1][y] == 0) {
                    corners[0] = new Point(x, y);
                    continue;
                }
                if (map[x + 1][y] == null || map[x + 1][y] != 0) continue;
                corners[1] = new Point(x, y);
            }
            if (corners[0] != null && corners[1] != null) break;
        }
        return corners;
    }

    public static Point getClosestNWMapCorner(Point mapPos, Point leftCorner, Point rightCorner) {
        int roomWidthAndGap = rightCorner.x - leftCorner.x + 1 + 4;
        Point origin = new Point(leftCorner.x % roomWidthAndGap, leftCorner.y % roomWidthAndGap);
        mapPos.x += 2;
        mapPos.y += 2;
        int x = mapPos.x - mapPos.x % roomWidthAndGap + origin.x;
        int y = mapPos.y - mapPos.y % roomWidthAndGap + origin.y;
        if (x > mapPos.x) {
            x -= roomWidthAndGap;
        }
        if (y > mapPos.y) {
            y -= roomWidthAndGap;
        }
        return new Point(x, y);
    }

    public static Point getClosestNWPhysicalCorner(Vec3 vectorPos) {
        Vec3 shiftedPos = vectorPos.func_72441_c(0.5, 0.0, 0.5);
        shiftedPos = shiftedPos.func_72441_c(8.0, 0.0, 8.0);
        int x = (int)(shiftedPos.field_72450_a - (double)Math.floorMod((int)shiftedPos.field_72450_a, 32));
        int z = (int)(shiftedPos.field_72449_c - (double)Math.floorMod((int)shiftedPos.field_72449_c, 32));
        return new Point(x - 8, z - 8);
    }

    public static Point getClosestNWPhysicalCorner(BlockPos blockPos) {
        return MapUtils.getClosestNWPhysicalCorner(new Vec3((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()));
    }

    public static Point physicalToMapCorner(Point physicalClosestCorner, Point physicalLeftCorner, Point leftCorner, Point rightCorner) {
        int roomWidthAndGap = rightCorner.x - leftCorner.x + 1 + 4;
        int xShift = (physicalClosestCorner.x - physicalLeftCorner.x) / 32;
        int yShift = (physicalClosestCorner.y - physicalLeftCorner.y) / 32;
        int x = leftCorner.x + roomWidthAndGap * xShift;
        int y = leftCorner.y + roomWidthAndGap * yShift;
        return new Point(x, y);
    }

    public static Point mapToPhysicalCorner(Point mapCorner, Point physicalLeftCorner, Point leftCorner, Point rightCorner) {
        int roomWidthAndGap = rightCorner.x - leftCorner.x + 1 + 4;
        int xShift = (mapCorner.x - leftCorner.x) / roomWidthAndGap;
        int yShift = (mapCorner.y - leftCorner.y) / roomWidthAndGap;
        int x = physicalLeftCorner.x + 32 * xShift;
        int y = physicalLeftCorner.y + 32 * yShift;
        return new Point(x, y);
    }

    public static String getMapColor(Point point, Integer[][] map) {
        int x = point.x;
        int y = point.y;
        if (x < 0 || y < 0 || x > 127 || y > 127) {
            return "undefined";
        }
        if (map != null) {
            switch (map[x][y]) {
                case 7488283: {
                    return "brown";
                }
                case 11685080: {
                    return "purple";
                }
                case 0xE5E533: {
                    return "yellow";
                }
                case 31744: {
                    return "green";
                }
                case 15892389: {
                    return "pink";
                }
                case 14188339: {
                    return "orange";
                }
                case 0xFF0000: {
                    return "red";
                }
            }
            return "undefined";
        }
        return "undefined";
    }

    public static List<Point> neighboringSegments(Point originCorner, Integer[][] map, Point leftCorner, Point rightCorner, List<Point> list) {
        if (!list.contains(originCorner)) {
            list.add(originCorner);
        }
        if (!MapUtils.getMapColor(originCorner, map).equals("brown")) {
            return list;
        }
        int roomWidth = rightCorner.x - leftCorner.x + 1;
        ArrayList<Point> pointsToCheck = new ArrayList<Point>();
        pointsToCheck.add(new Point(originCorner.x, originCorner.y - 1));
        pointsToCheck.add(new Point(originCorner.x, originCorner.y + roomWidth));
        pointsToCheck.add(new Point(originCorner.x - 1, originCorner.y));
        pointsToCheck.add(new Point(originCorner.x + roomWidth, originCorner.y));
        ArrayList<Point> pointsToTransform = new ArrayList<Point>();
        pointsToTransform.add(new Point(originCorner.x, originCorner.y - 1 - 4));
        pointsToTransform.add(new Point(originCorner.x, originCorner.y + roomWidth + 4));
        pointsToTransform.add(new Point(originCorner.x - 1 - 4, originCorner.y));
        pointsToTransform.add(new Point(originCorner.x + roomWidth + 4, originCorner.y));
        for (int i = 0; i < 4; ++i) {
            Point newCorner;
            if (!MapUtils.getMapColor((Point)pointsToCheck.get(i), map).equals("brown") || list.contains(newCorner = MapUtils.getClosestNWMapCorner((Point)pointsToTransform.get(i), leftCorner, rightCorner))) continue;
            list.add(newCorner);
            list = MapUtils.neighboringSegments(newCorner, map, leftCorner, rightCorner, list);
        }
        return list;
    }

    public static String roomSize(List<Point> segments) {
        if (segments.size() == 1) {
            return "1x1";
        }
        if (segments.size() == 2) {
            return "1x2";
        }
        HashSet<Integer> x = new HashSet<Integer>();
        HashSet<Integer> y = new HashSet<Integer>();
        for (Point segment : segments) {
            x.add(segment.x);
            y.add(segment.y);
        }
        if (segments.size() == 3) {
            if (x.size() == 2 && y.size() == 2) {
                return "L-shape";
            }
            return "1x3";
        }
        if (segments.size() == 4) {
            if (x.size() == 2 && y.size() == 2) {
                return "2x2";
            }
            return "1x4";
        }
        return "undefined";
    }

    public static String roomCategory(String roomSize, String roomColor) {
        if (roomSize.equals("1x1")) {
            switch (roomColor) {
                case "brown": {
                    return "1x1";
                }
                case "purple": {
                    return "Puzzle";
                }
                case "orange": {
                    return "Trap";
                }
                case "green": 
                case "red": 
                case "pink": 
                case "yellow": {
                    return "General";
                }
            }
            return "undefined";
        }
        return roomSize;
    }

    public static Point playerMarkerPos() {
        MapData mapData = (MapData)Minecraft.func_71410_x().field_71441_e.func_175693_T().func_75742_a(MapData.class, "map_" + DungeonManager.mapId);
        if (mapData == null) {
            return null;
        }
        if (mapData.field_76203_h != null) {
            for (Map.Entry entry : mapData.field_76203_h.entrySet()) {
                if (((Vec4b)entry.getValue()).func_176110_a() != 1) continue;
                int x = ((Vec4b)entry.getValue()).func_176112_b() / 2 + 64;
                int y = ((Vec4b)entry.getValue()).func_176113_c() / 2 + 64;
                return new Point(x, y);
            }
        }
        return null;
    }

    public static Point getPhysicalCornerPos(String direction, List<Point> currentPhysicalSegments) {
        TreeSet<Integer> xSet = new TreeSet<Integer>();
        TreeSet<Integer> ySet = new TreeSet<Integer>();
        for (Point segment : currentPhysicalSegments) {
            xSet.add(segment.x);
            ySet.add(segment.y);
        }
        switch (direction) {
            case "NW": {
                return new Point((Integer)xSet.first(), (Integer)ySet.first());
            }
            case "NE": {
                return new Point((Integer)xSet.last() + 30, (Integer)ySet.first());
            }
            case "SE": {
                return new Point((Integer)xSet.last() + 30, (Integer)ySet.last() + 30);
            }
            case "SW": {
                return new Point((Integer)xSet.first(), (Integer)ySet.last() + 30);
            }
        }
        return null;
    }

    public static List<String> possibleDirections(String roomSize, List<Point> currentRoomSegments) {
        ArrayList<String> directions = new ArrayList<String>();
        if (roomSize.equals("1x1") || roomSize.equals("2x2")) {
            directions.add("NW");
            directions.add("NE");
            directions.add("SE");
            directions.add("SW");
        } else {
            TreeSet<Integer> xSet = new TreeSet<Integer>();
            TreeSet<Integer> ySet = new TreeSet<Integer>();
            for (Point segment : currentRoomSegments) {
                xSet.add(segment.x);
                ySet.add(segment.y);
            }
            if (roomSize.equals("L-shape")) {
                ArrayList x = new ArrayList(xSet);
                ArrayList y = new ArrayList(ySet);
                if (!currentRoomSegments.contains(new Point((Integer)x.get(0), (Integer)y.get(0)))) {
                    directions.add("SW");
                } else if (!currentRoomSegments.contains(new Point((Integer)x.get(0), (Integer)y.get(1)))) {
                    directions.add("SE");
                } else if (!currentRoomSegments.contains(new Point((Integer)x.get(1), (Integer)y.get(0)))) {
                    directions.add("NW");
                } else if (!currentRoomSegments.contains(new Point((Integer)x.get(1), (Integer)y.get(1)))) {
                    directions.add("NE");
                }
            } else if (roomSize.startsWith("1x")) {
                if (xSet.size() >= 2 && ySet.size() == 1) {
                    directions.add("NW");
                    directions.add("SE");
                } else if (xSet.size() == 1 && ySet.size() >= 2) {
                    directions.add("NE");
                    directions.add("SW");
                }
            }
        }
        return directions;
    }

    public static BlockPos actualToRelative(BlockPos actual, String cornerDirection, Point locationOfCorner) {
        double x = 0.0;
        double z = 0.0;
        switch (cornerDirection) {
            case "NW": {
                x = (double)actual.func_177958_n() - locationOfCorner.getX();
                z = (double)actual.func_177952_p() - locationOfCorner.getY();
                break;
            }
            case "NE": {
                x = (double)actual.func_177952_p() - locationOfCorner.getY();
                z = -((double)actual.func_177958_n() - locationOfCorner.getX());
                break;
            }
            case "SE": {
                x = -((double)actual.func_177958_n() - locationOfCorner.getX());
                z = -((double)actual.func_177952_p() - locationOfCorner.getY());
                break;
            }
            case "SW": {
                x = -((double)actual.func_177952_p() - locationOfCorner.getY());
                z = (double)actual.func_177958_n() - locationOfCorner.getX();
            }
        }
        return new BlockPos(x, (double)actual.func_177956_o(), z);
    }

    public static BlockPos relativeToActual(BlockPos relative, String cornerDirection, Point locationOfCorner) {
        double x = 0.0;
        double z = 0.0;
        switch (cornerDirection) {
            case "NW": {
                x = (double)relative.func_177958_n() + locationOfCorner.getX();
                z = (double)relative.func_177952_p() + locationOfCorner.getY();
                break;
            }
            case "NE": {
                x = -((double)relative.func_177952_p() - locationOfCorner.getX());
                z = (double)relative.func_177958_n() + locationOfCorner.getY();
                break;
            }
            case "SE": {
                x = -((double)relative.func_177958_n() - locationOfCorner.getX());
                z = -((double)relative.func_177952_p() - locationOfCorner.getY());
                break;
            }
            case "SW": {
                x = (double)relative.func_177952_p() + locationOfCorner.getX();
                z = -((double)relative.func_177958_n() - locationOfCorner.getY());
            }
        }
        return new BlockPos(x, (double)relative.func_177956_o(), z);
    }
}

