/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.utils;

import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.handlers.ScoreboardHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.InflaterInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.BaseConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Utils {
    public static boolean inSkyblock = false;
    public static boolean inCatacombs = false;
    public static boolean dungeonOverride = false;

    public static void checkForSkyblock() {
        String scObjName;
        ScoreObjective scoreboardObj;
        if (dungeonOverride) {
            inSkyblock = true;
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71441_e != null && !mc.func_71356_B() && (scoreboardObj = mc.field_71441_e.func_96441_U().func_96539_a(1)) != null && (scObjName = ScoreboardHandler.cleanSB(scoreboardObj.func_96678_d())).contains("SKYBLOCK")) {
            inSkyblock = true;
            return;
        }
        inSkyblock = false;
    }

    public static void checkForCatacombs() {
        if (dungeonOverride) {
            inCatacombs = true;
            return;
        }
        if (inSkyblock) {
            List<String> scoreboard = ScoreboardHandler.getSidebarLines();
            for (String s : scoreboard) {
                String sCleaned = ScoreboardHandler.cleanSB(s);
                if (!sCleaned.contains("The Catacombs")) continue;
                inCatacombs = true;
                return;
            }
        }
        inCatacombs = false;
    }

    public static void checkForConflictingHotkeys() {
        Minecraft mc = Minecraft.func_71410_x();
        for (KeyBinding drmKeybind : DungeonRooms.keyBindings) {
            for (KeyBinding keybinding : mc.field_71474_y.field_74324_K) {
                if (drmKeybind.func_151463_i() == 0 || drmKeybind == keybinding || drmKeybind.func_151463_i() != keybinding.func_151463_i()) continue;
                mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7d\u00a7l--- Dungeon Rooms Mod ---\n \u00a7r\u00a7cThe hotkey \"" + GameSettings.func_74298_c((int)drmKeybind.func_151463_i()) + "\", which is used to " + drmKeybind.func_151464_g() + ", has a conflict with a keybinding from \"" + keybinding.func_151466_e() + "\".\n \u00a7c\u00a7lPlease go into the Minecraft Controls menu and change one of the keybindings.\n\u00a7d\u00a7l------------------------"));
            }
        }
    }

    public static List<Path> getAllPaths(String folderName) {
        ArrayList<Path> paths = new ArrayList<Path>();
        try {
            Path Path2;
            URI uri = DungeonRooms.class.getResource("/assets/dungeonrooms/" + folderName).toURI();
            FileSystem fileSystem = null;
            if (uri.getScheme().equals("jar")) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                Path2 = fileSystem.getPath("/assets/dungeonrooms/" + folderName, new String[0]);
            } else {
                Path2 = Paths.get(uri);
            }
            Stream<Path> walk = Files.walk(Path2, 3, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                String name = path.getFileName().toString();
                if (!name.endsWith(".skeleton")) continue;
                paths.add(path);
            }
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return paths;
    }

    public static HashMap<String, long[]> pathsToRoomData(String parentFolder, List<Path> allPaths) {
        HashMap<String, long[]> allRoomData = new HashMap<String, long[]>();
        try {
            for (Path path : allPaths) {
                if (!path.getParent().getFileName().toString().equals(parentFolder)) continue;
                String name = path.getFileName().toString();
                InputStream input = DungeonRooms.class.getResourceAsStream(path.toString());
                ObjectInputStream data = new ObjectInputStream(new InflaterInputStream(input));
                long[] roomData = (long[])data.readObject();
                allRoomData.put(name.substring(0, name.length() - 9), roomData);
                DungeonRooms.logger.debug("DungeonRooms: Loaded " + name);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        DungeonRooms.logger.info("DungeonRooms: Loaded " + allRoomData.size() + " " + parentFolder + " rooms");
        return allRoomData;
    }

    public static void setLogLevel(Logger logger, Level level) {
        LoggerConfig loggerConfig;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        BaseConfiguration config = (BaseConfiguration)ctx.getConfiguration();
        LoggerConfig specificConfig = loggerConfig = config.getLoggerConfig(logger.getName());
        if (!loggerConfig.getName().equals(logger.getName())) {
            specificConfig = new LoggerConfig(logger.getName(), level, true);
            specificConfig.setParent(loggerConfig);
            config.addLogger(logger.getName(), specificConfig);
        }
        specificConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static long shortToLong(short a, short b, short c, short d) {
        return (long)(a << 16 | b & 0xFFFF) << 32 | (long)(c << 16 | d & 0xFFFF) & 0xFFFFFFFFL;
    }

    public static short[] longToShort(long l) {
        return new short[]{(short)(l >> 48), (short)(l >> 32), (short)(l >> 16), (short)l};
    }
}

