/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class WikiTextReader {
    public static final char[] NO_CHAR = new char[0];
    private static final int DEFAULT_READING_SIZE = 8192;
    private final String fTemplateBaseFilename;

    public WikiTextReader(String templateBaseFileName) {
        this.fTemplateBaseFilename = templateBaseFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlainContent(String wikiTitle) {
        String filename = this.fTemplateBaseFilename.replace("${title}", wikiTitle);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            String string = new String(WikiTextReader.getInputStreamAsCharArray(fis, -1, StandardCharsets.UTF_8));
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, Charset charset) throws IOException {
        char[] contents;
        InputStreamReader reader;
        InputStreamReader inputStreamReader = reader = charset == null ? new InputStreamReader(stream) : new InputStreamReader(stream, charset);
        if (length == -1) {
            contents = NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len2 = 0;
            int readSize = 0;
            while (readSize != -1 && len2 != length) {
                readSize = reader.read(contents, len2 += readSize, length - len2);
            }
            if (len2 != length) {
                char[] cArray = contents;
                contents = new char[len2];
                System.arraycopy(cArray, 0, contents, 0, len2);
            }
        }
        return contents;
    }
}

