/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.util.render;

import io.github.moulberry.notenoughupdates.core.BackgroundBlur;
import io.github.moulberry.notenoughupdates.miscfeatures.CustomItemEffects;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Slot;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

public class RenderUtils {
    private static final ResourceLocation beaconBeam = new ResourceLocation("textures/entity/beacon_beam.png");

    public static void drawFloatingRectDark(int x, int y, int width, int height) {
        RenderUtils.drawFloatingRectDark(x, y, width, height, true);
    }

    public static void drawFloatingRectDark(int x, int y, int width, int height, boolean shadow) {
        int alpha = -268435456;
        if (OpenGlHelper.func_148822_b()) {
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            BackgroundBlur.renderBlurredBackground(15.0f, scaledResolution.func_78326_a(), scaledResolution.func_78328_b(), x, y, width, height, true);
        } else {
            alpha = -16777216;
        }
        int main = alpha | 0x202026;
        int light = -13619146;
        int dark = -15724522;
        Gui.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + height), (int)light);
        Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + width), (int)(y + 1), (int)light);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)main);
        if (shadow) {
            Gui.func_73734_a((int)(x + width), (int)(y + 2), (int)(x + width + 2), (int)(y + height + 2), (int)0x70000000);
            Gui.func_73734_a((int)(x + 2), (int)(y + height), (int)(x + width), (int)(y + height + 2), (int)0x70000000);
        }
    }

    public static void drawFloatingRect(int x, int y, int width, int height) {
        RenderUtils.drawFloatingRectWithAlpha(x, y, width, height, 255, true);
    }

    public static void drawFloatingRectWithAlpha(int x, int y, int width, int height, int alpha, boolean shadow) {
        int main = alpha << 24 | 0xC0C0C0;
        int light = alpha << 24 | 0xF0F0F0;
        int dark = alpha << 24 | 0x909090;
        Gui.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + height), (int)light);
        Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + width), (int)(y + 1), (int)light);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)main);
        if (shadow) {
            Gui.func_73734_a((int)(x + width), (int)(y + 2), (int)(x + width + 2), (int)(y + height + 2), (int)(alpha * 3 / 5 << 24));
            Gui.func_73734_a((int)(x + 2), (int)(y + height), (int)(x + width), (int)(y + height + 2), (int)(alpha * 3 / 5 << 24));
        }
    }

    public static void drawTexturedRect(float x, float y, float width, float height) {
        RenderUtils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, int filter) {
        RenderUtils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, filter);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax) {
        RenderUtils.drawTexturedRect(x, y, width, height, uMin, uMax, vMin, vMax, 9728);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax, int filter) {
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        RenderUtils.drawTexturedRectNoBlend(x, y, width, height, uMin, uMax, vMin, vMax, filter);
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRectNoBlend(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax, int filter) {
        GlStateManager.func_179098_w();
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)uMin, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)uMax, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)uMax, (double)vMin).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public static void drawGradientRect(int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private static void renderBeaconBeam(double x, double y, double z, int rgb, float alphaMult, float partialTicks, Boolean disableDepth) {
        int height = 300;
        int bottomOffset = 0;
        int topOffset = bottomOffset + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        if (disableDepth.booleanValue()) {
            GlStateManager.func_179097_i();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(beaconBeam);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        double time = (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() + (double)partialTicks;
        double d1 = MathHelper.func_181162_h((double)(-time * 0.2 - (double)MathHelper.func_76128_c((double)(-time * 0.1))));
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        double d2 = time * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d2 + 2.356194490192345) * 0.2;
        double d5 = 0.5 + Math.sin(d2 + 2.356194490192345) * 0.2;
        double d6 = 0.5 + Math.cos(d2 + 0.7853981633974483) * 0.2;
        double d7 = 0.5 + Math.sin(d2 + 0.7853981633974483) * 0.2;
        double d8 = 0.5 + Math.cos(d2 + 3.9269908169872414) * 0.2;
        double d9 = 0.5 + Math.sin(d2 + 3.9269908169872414) * 0.2;
        double d10 = 0.5 + Math.cos(d2 + 5.497787143782138) * 0.2;
        double d11 = 0.5 + Math.sin(d2 + 5.497787143782138) * 0.2;
        double d14 = -1.0 + d1;
        double d15 = (double)height * 2.5 + d14;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179129_p();
        double d12 = -1.0 + d1;
        double d13 = (double)height + d12;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        if (disableDepth.booleanValue()) {
            GlStateManager.func_179126_j();
        }
    }

    public static void renderBoundingBox(BlockPos worldPos, int rgb, float partialTicks, boolean disableDepth) {
        Vector3f interpolatedPlayerPosition = RenderUtils.getInterpolatedPlayerPosition(partialTicks);
        RenderUtils.renderBoundingBoxInViewSpace((float)worldPos.func_177958_n() - interpolatedPlayerPosition.x, (float)worldPos.func_177956_o() - interpolatedPlayerPosition.y, (float)worldPos.func_177952_p() - interpolatedPlayerPosition.z, rgb, disableDepth);
    }

    private static void renderBoundingBoxInViewSpace(double x, double y, double z, int rgb, boolean disableDepth) {
        AxisAlignedBB bb = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
        if (disableDepth) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        CustomItemEffects.drawFilledBoundingBox(bb, 1.0f, SpecialColour.special(0, rgb >> 24 & 0xFF, rgb));
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        if (disableDepth) {
            GlStateManager.func_179126_j();
        }
    }

    public static void renderBeaconBeam(BlockPos block, int rgb, float alphaMult, float partialTicks) {
        double viewerZ;
        double viewerY;
        double viewerX;
        Vector3f aoteInterpPos = CustomItemEffects.INSTANCE.getCurrentPosition();
        if (aoteInterpPos != null) {
            viewerX = aoteInterpPos.x;
            viewerY = aoteInterpPos.y;
            viewerZ = aoteInterpPos.z;
        } else {
            Entity viewer = Minecraft.func_71410_x().func_175606_aa();
            viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
            viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
            viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        }
        double x = (double)block.func_177958_n() - viewerX;
        double y = (double)block.func_177956_o() - viewerY;
        double z = (double)block.func_177952_p() - viewerZ;
        double distSq = x * x + y * y + z * z;
        RenderUtils.renderBeaconBeam(x, y, z, rgb, 1.0f, partialTicks, distSq > 100.0);
    }

    public static Vector3f getInterpolatedPlayerPosition(float partialTicks) {
        Vector3f aoteInterpPos = CustomItemEffects.INSTANCE.getCurrentPosition();
        if (aoteInterpPos != null) {
            return new Vector3f((ReadableVector3f)aoteInterpPos);
        }
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        Vector3f lastPos = new Vector3f((float)viewer.field_70142_S, (float)viewer.field_70137_T, (float)viewer.field_70136_U);
        Vector3f currentPos = new Vector3f((float)viewer.field_70165_t, (float)viewer.field_70163_u, (float)viewer.field_70161_v);
        Vector3f movement = Vector3f.sub((Vector3f)currentPos, (Vector3f)lastPos, (Vector3f)currentPos);
        movement.scale(partialTicks);
        return Vector3f.add((Vector3f)lastPos, (Vector3f)movement, (Vector3f)lastPos);
    }

    public static void renderBeaconBeamOrBoundingBox(BlockPos block, int rgb, float alphaMult, float partialTicks) {
        double z;
        double y;
        Vector3f interpolatedPlayerPosition = RenderUtils.getInterpolatedPlayerPosition(partialTicks);
        double x = (float)block.func_177958_n() - interpolatedPlayerPosition.x;
        double distSq = x * x + (y = (double)((float)block.func_177956_o() - interpolatedPlayerPosition.y)) * y + (z = (double)((float)block.func_177952_p() - interpolatedPlayerPosition.z)) * z;
        if (distSq > 100.0) {
            RenderUtils.renderBeaconBeam(x, y, z, rgb, 1.0f, partialTicks, true);
        } else {
            RenderUtils.renderBoundingBoxInViewSpace(x, y, z, rgb, true);
        }
    }

    public static void renderWayPoint(String str, Vec3i loc, float partialTicks) {
        RenderUtils.renderWayPoint(str, new Vector3f((float)loc.func_177958_n(), (float)loc.func_177956_o(), (float)loc.func_177952_p()), partialTicks);
    }

    public static void renderWayPoint(List<String> str, Vec3i loc, float partialTicks) {
        RenderUtils.renderWayPoint(str, new Vector3f((float)loc.func_177958_n(), (float)loc.func_177956_o(), (float)loc.func_177952_p()), partialTicks, false);
    }

    public static void renderWayPoint(String str, Vector3f loc, float partialTicks) {
        RenderUtils.renderWayPoint(Arrays.asList(str), loc, partialTicks, false);
    }

    public static void renderWayPoint(Vec3i loc, float partialTicks) {
        RenderUtils.renderWayPoint(Arrays.asList(""), new Vector3f((float)loc.func_177958_n(), (float)loc.func_177956_o(), (float)loc.func_177952_p()), partialTicks, true);
    }

    public static void drawFilledQuadWithTexture(Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, float alpha, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        Entity v = Minecraft.func_71410_x().func_175606_aa();
        double vX = v.field_70142_S + (v.field_70165_t - v.field_70142_S);
        double vY = v.field_70137_T + (v.field_70163_u - v.field_70137_T);
        double vZ = v.field_70136_U + (v.field_70161_v - v.field_70136_U);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b(p1.field_72450_a - vX, p1.field_72448_b - vY, p1.field_72449_c - vZ).func_181673_a(0.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b(p2.field_72450_a - vX, p2.field_72448_b - vY, p2.field_72449_c - vZ).func_181673_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b(p3.field_72450_a - vX, p3.field_72448_b - vY, p3.field_72449_c - vZ).func_181673_a(1.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b(p4.field_72450_a - vX, p4.field_72448_b - vY, p4.field_72449_c - vZ).func_181673_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public static void renderWayPoint(List<String> lines, Vector3f loc, float partialTicks, boolean onlyShowDistance) {
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        double x = (double)loc.x - viewerX + 0.5;
        double y = (double)loc.y - viewerY - (double)viewer.func_70047_e();
        double z = (double)loc.z - viewerZ + 0.5;
        double distSq = x * x + y * y + z * z;
        double dist = Math.sqrt(distSq);
        if (distSq > 144.0) {
            x *= 12.0 / dist;
            y *= 12.0 / dist;
            z *= 12.0 / dist;
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)0.0f, (float)viewer.func_70047_e(), (float)0.0f);
        lines = onlyShowDistance ? new ArrayList<String>() : new ArrayList<String>(lines);
        lines.add(EnumChatFormatting.YELLOW.toString() + Math.round(dist) + "m");
        RenderUtils.renderNametag(lines);
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
    }

    public static void renderNametag(String str) {
        RenderUtils.renderNametag(Arrays.asList(str));
    }

    public static void renderNametag(List<String> lines) {
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        int i = 0;
        for (String str : lines) {
            int j = fontrenderer.func_78256_a(str) / 2;
            GlStateManager.func_179090_x();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            worldrenderer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, 0x20FFFFFF);
            GlStateManager.func_179132_a((boolean)true);
            fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, -1);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void highlightSlot(Slot slot, Color color) {
        boolean lightingState = GL11.glIsEnabled((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(110.0f + Minecraft.func_71410_x().func_175599_af().field_77023_b));
        Gui.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)color.getRGB());
        GlStateManager.func_179121_F();
        if (lightingState) {
            GlStateManager.func_179145_e();
        }
    }

    public static void renderLineToBlock(BlockPos block, int rgb, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderViewEntity = mc.func_175606_aa();
        double cameraX = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S);
        double cameraY = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T);
        double cameraZ = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U);
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glLineWidth((float)3.0f);
        GlStateManager.func_179131_c((float)((float)(rgb >> 16 & 0xFF) / 255.0f), (float)((float)(rgb >> 8 & 0xFF) / 255.0f), (float)((float)(rgb & 0xFF) / 255.0f), (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(0.0, (double)renderViewEntity.func_70047_e(), 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)block.func_177958_n() + 0.5 - cameraX, (double)block.func_177956_o() - cameraY, (double)block.func_177952_p() + 0.5 - cameraZ).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }
}

