/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate;

import io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate.UpdateAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ExitHookInvoker {
    private static boolean isExitHookRegistered = false;
    private static List<UpdateAction> actions;
    private static File updaterJar;
    private static boolean cancelled;
    private static String identifer;
    private static UUID uuid;

    public static synchronized void setExitHook(String identifier, UUID uuid, File updaterJar, List<UpdateAction> actions) {
        if (!isExitHookRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(ExitHookInvoker::runExitHook));
            isExitHookRegistered = true;
        }
        identifer = identifier;
        ExitHookInvoker.uuid = uuid;
        cancelled = false;
        ExitHookInvoker.actions = actions;
        ExitHookInvoker.updaterJar = updaterJar;
    }

    public static synchronized void cancelExitHook() {
        cancelled = true;
    }

    private static synchronized String[] buildInvocation() {
        boolean isWindows = System.getProperty("os.name", "").startsWith("Windows");
        File javaBinary = new File(System.getProperty("java.home"), "bin/java" + (isWindows ? ".exe" : ""));
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(javaBinary.getAbsolutePath());
        arguments.add("-jar");
        arguments.add(updaterJar.getAbsolutePath());
        arguments.add(identifer);
        arguments.add(String.valueOf(uuid));
        for (UpdateAction action : actions) {
            action.encode(arguments);
        }
        return arguments.toArray(new String[0]);
    }

    private static void runExitHook() {
        try {
            if (cancelled) {
                System.out.println("Skipping cancelled update");
                return;
            }
            CharSequence[] invocation = ExitHookInvoker.buildInvocation();
            System.out.println("Running post updater using: " + String.join((CharSequence)" ", invocation));
            Runtime.getRuntime().exec((String[])invocation);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        cancelled = false;
    }
}

