/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.ItemCooldowns;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class CustomItemEffects {
    public static final CustomItemEffects INSTANCE = new CustomItemEffects();
    private static final int MAX_BUILDERS_BLOCKS = 241;
    private final HashSet<BlockPos> zapperBlocks = new HashSet();
    private boolean zapperDirty = false;
    public long aoteUseMillis = 0L;
    public long lastUsedHyperion = 0L;
    private final Pattern etherwarpDistancePattern = Pattern.compile("(?:up )?to (?<distance>\\d{2}) blocks away\\.");
    private final List<String> aoteNames = Arrays.asList("ASPECT_OF_THE_END", "ASPECT_OF_THE_VOID", "ASPECT_OF_THE_LEECH_1", "ASPECT_OF_THE_LEECH_2", "ASPECT_OF_THE_LEECH_3");
    public int aoteTeleportationMillis = 0;
    public Vector3f aoteTeleportationCurr = null;
    public int tpTime;
    private int tick;
    public long lastMillis;
    private float lastPartialTicks;
    private float currentFOVMult;
    private float targetFOVMult;
    private float lastPartialDelta;
    private float currentSensMult;
    private float targetSensMult;
    private boolean wasUsingEtherwarp;
    private boolean usingEtherwarp;
    private RaycastResult etherwarpRaycast;
    private int lastEtherwarpUse;
    private String denyTpReason;
    private static final List<BlockPos> zapperOffsets = new ArrayList<BlockPos>(){
        {
            this.add(new BlockPos(0, 0, -1));
            this.add(new BlockPos(0, 0, 1));
            this.add(new BlockPos(-1, 0, 0));
            this.add(new BlockPos(1, 0, 0));
            this.add(new BlockPos(0, 1, 0));
            this.add(new BlockPos(0, -1, 0));
        }
    };
    private static final HashSet<Block> cropBlocksZapper = new HashSet<Block>(){
        {
            this.add(Blocks.field_150464_aj);
            this.add(Blocks.field_150459_bM);
            this.add(Blocks.field_150469_bN);
            this.add(Blocks.field_150423_aK);
            this.add(Blocks.field_150393_bb);
            this.add(Blocks.field_150440_ba);
            this.add(Blocks.field_150394_bc);
            this.add(Blocks.field_150434_aF);
            this.add(Blocks.field_150436_aH);
            this.add(Blocks.field_150388_bm);
            this.add(Blocks.field_150329_H);
            this.add(Blocks.field_150398_cm);
        }
    };
    private static final HashSet<Block> otherBannedBlocksZapper = new HashSet<Block>(){
        {
            this.add(Blocks.field_150458_ak);
        }
    };
    List<Block> scytheBlocks;

    public CustomItemEffects() {
        this.tpTime = NotEnoughUpdates.INSTANCE.config.itemOverlays.smoothTpMillis;
        this.lastMillis = 0L;
        this.lastPartialTicks = 0.0f;
        this.currentFOVMult = 1.0f;
        this.targetFOVMult = 1.0f;
        this.lastPartialDelta = 0.0f;
        this.currentSensMult = 1.0f;
        this.targetSensMult = 1.0f;
        this.wasUsingEtherwarp = false;
        this.usingEtherwarp = false;
        this.etherwarpRaycast = null;
        this.lastEtherwarpUse = 0;
        this.denyTpReason = null;
        this.scytheBlocks = Arrays.asList(Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150329_H, Blocks.field_150398_cm);
    }

    public Vector3f getCurrentPosition() {
        if (this.aoteTeleportationMillis <= 0) {
            return null;
        }
        return this.aoteTeleportationCurr;
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        this.zapperDirty = true;
        long currentTime = System.currentTimeMillis();
        int delta = (int)(currentTime - this.lastMillis);
        this.lastMillis = currentTime;
        if (delta <= 0) {
            return;
        }
        if (this.aoteTeleportationMillis > this.tpTime * 2) {
            this.aoteTeleportationMillis = this.tpTime * 2;
        }
        if (this.aoteTeleportationMillis < 0) {
            this.aoteTeleportationMillis = 0;
        }
        if (currentTime - this.aoteUseMillis > 1000L && this.aoteTeleportationMillis <= 0) {
            this.aoteTeleportationCurr = null;
        }
        if (this.aoteTeleportationCurr != null) {
            if (this.aoteTeleportationMillis > 0) {
                int deltaMin = Math.min(delta, this.aoteTeleportationMillis);
                float factor = (float)deltaMin / (float)this.aoteTeleportationMillis;
                float dX = this.aoteTeleportationCurr.x - (float)Minecraft.func_71410_x().field_71439_g.field_70165_t;
                float dY = this.aoteTeleportationCurr.y - (float)Minecraft.func_71410_x().field_71439_g.field_70163_u;
                float dZ = this.aoteTeleportationCurr.z - (float)Minecraft.func_71410_x().field_71439_g.field_70161_v;
                this.aoteTeleportationCurr.x -= dX * factor;
                this.aoteTeleportationCurr.y -= dY * factor;
                this.aoteTeleportationCurr.z -= dZ * factor;
                if (Minecraft.func_71410_x().field_71441_e.func_180495_p(new BlockPos((double)this.aoteTeleportationCurr.x, (double)this.aoteTeleportationCurr.y, (double)this.aoteTeleportationCurr.z)).func_177230_c().func_149688_o() != Material.field_151579_a) {
                    this.aoteTeleportationCurr.y = (float)Math.ceil(this.aoteTeleportationCurr.y);
                }
                this.aoteTeleportationMillis -= deltaMin;
            } else {
                this.aoteTeleportationCurr.x = (float)Minecraft.func_71410_x().field_71439_g.field_70165_t;
                this.aoteTeleportationCurr.y = (float)Minecraft.func_71410_x().field_71439_g.field_70163_u;
                this.aoteTeleportationCurr.z = (float)Minecraft.func_71410_x().field_71439_g.field_70161_v;
            }
        } else {
            this.aoteUseMillis = 0L;
            this.aoteTeleportationMillis = 0;
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack held;
        String internal;
        if ((event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && (internal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held = Minecraft.func_71410_x().field_71439_g.func_70694_bm())) != null) {
            NBTTagCompound ea;
            NBTTagCompound tag;
            boolean shadowWarp = false;
            if ((internal.equals("HYPERION") || internal.equals("VALKYRIE") || internal.equals("SCYLLA") || internal.equals("ASTRAEA")) && (tag = held.func_77978_p()) != null && tag.func_150297_b("ExtraAttributes", 10) && (ea = tag.func_74775_l("ExtraAttributes")) != null && ea.func_150297_b("ability_scroll", 9)) {
                NBTTagList list = ea.func_150295_c("ability_scroll", 8);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    if (list.func_150307_f(i).equals("IMPLOSION_SCROLL")) {
                        this.lastUsedHyperion = System.currentTimeMillis();
                        continue;
                    }
                    if (!list.func_150307_f(i).equals("SHADOW_WARP_SCROLL")) continue;
                    shadowWarp = true;
                }
            }
            if (this.usingEtherwarp) {
                this.lastEtherwarpUse = this.tick;
            }
            if (this.tpTime <= 0 || Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
                return;
            }
            boolean aote = NotEnoughUpdates.INSTANCE.config.itemOverlays.enableSmoothAOTE && this.aoteNames.contains(internal);
            boolean hyp = NotEnoughUpdates.INSTANCE.config.itemOverlays.enableSmoothHyperion && shadowWarp;
            this.tpTime = this.usingEtherwarp ? NotEnoughUpdates.INSTANCE.config.itemOverlays.smoothTpMillisEtherwarp : NotEnoughUpdates.INSTANCE.config.itemOverlays.smoothTpMillis;
            if (this.usingEtherwarp || aote || hyp) {
                this.aoteUseMillis = System.currentTimeMillis();
                if (this.aoteTeleportationCurr == null) {
                    this.aoteTeleportationCurr = new Vector3f();
                    this.aoteTeleportationCurr.x = (float)Minecraft.func_71410_x().field_71439_g.field_70165_t;
                    this.aoteTeleportationCurr.y = (float)Minecraft.func_71410_x().field_71439_g.field_70163_u;
                    this.aoteTeleportationCurr.z = (float)Minecraft.func_71410_x().field_71439_g.field_70161_v;
                }
            }
        }
    }

    @SubscribeEvent
    public void onGameTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!this.usingEtherwarp && this.wasUsingEtherwarp) {
            player.field_70177_z = player.field_70177_z > 0.0f ? (float)((double)player.field_70177_z - 1.0E-6) : (float)((double)player.field_70177_z + 1.0E-6);
        }
        this.wasUsingEtherwarp = this.usingEtherwarp;
        ++this.tick;
        if (this.tick > 0x3FFFFFFF) {
            this.tick = 0;
        }
    }

    public float getSensMultiplier() {
        if (this.targetSensMult < 0.0f) {
            this.currentSensMult = 1.0f;
        } else {
            float deltaSens = this.targetSensMult - this.currentSensMult;
            this.currentSensMult = (float)((double)this.currentSensMult + (double)(deltaSens * this.lastPartialDelta) * 0.1);
            if (this.currentSensMult < 0.25f) {
                this.currentSensMult = 0.25f;
            }
            if (this.currentSensMult > 1.0f) {
                this.currentSensMult = 1.0f;
            }
        }
        return this.currentSensMult;
    }

    public float getFovMultiplier(float partialTicks) {
        float partialDelta = partialTicks + (float)this.tick - this.lastPartialTicks;
        if (partialDelta < 0.0f) {
            partialDelta += 1.0f;
        }
        if (partialDelta > 0.0f) {
            this.lastPartialDelta = partialDelta;
        }
        if (this.targetFOVMult < 0.0f) {
            this.currentFOVMult = 1.0f;
        } else {
            float deltaFOV = this.targetFOVMult - this.currentFOVMult;
            this.currentFOVMult = (float)((double)this.currentFOVMult + (double)(deltaFOV * this.lastPartialDelta) * 0.2);
            if (this.currentFOVMult < 0.15f) {
                this.currentFOVMult = 0.15f;
            }
            if (this.currentFOVMult > 1.0f) {
                this.currentFOVMult = 1.0f;
            }
        }
        this.lastPartialTicks = partialTicks + (float)this.tick;
        return this.currentFOVMult;
    }

    @SubscribeEvent
    public void onOverlayDrawn(RenderGameOverlayEvent.Post event) {
        if (event.type == null && Loader.isModLoaded((String)"labymod") || event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            IBlockState hover;
            ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
            String heldInternal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held);
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.usingEtherwarp) {
                this.denyTpReason = null;
                if (this.etherwarpRaycast == null) {
                    this.denyTpReason = "Too far!";
                } else {
                    BlockPos pos = this.etherwarpRaycast.pos;
                    Block block = this.etherwarpRaycast.state.func_177230_c();
                    if (!block.func_149703_v() || block == Blocks.field_150404_cg || block == Blocks.field_150384_bq || block == Blocks.field_150465_bP || block == Blocks.field_150431_aC || block == Blocks.field_150392_bi || block.func_180640_a((World)world, this.etherwarpRaycast.pos, this.etherwarpRaycast.state) == null && block != Blocks.field_150444_as && block != Blocks.field_150472_an) {
                        this.denyTpReason = "Not solid!";
                    } else {
                        BlockPos blockPosAbove = pos.func_177982_a(0, 1, 0);
                        Block blockAbove = world.func_180495_p(blockPosAbove).func_177230_c();
                        Block twoBlockAbove = world.func_180495_p(pos.func_177982_a(0, 2, 0)).func_177230_c();
                        if (blockAbove != Blocks.field_150350_a && blockAbove != Blocks.field_150404_cg && blockAbove != Blocks.field_150465_bP && blockAbove.func_149703_v() && blockAbove.func_180640_a((World)world, blockPosAbove, world.func_180495_p(blockPosAbove)) != null || blockAbove == Blocks.field_150444_as || block == Blocks.field_150472_an || twoBlockAbove != Blocks.field_150350_a && twoBlockAbove != Blocks.field_150398_cm && twoBlockAbove != Blocks.field_150404_cg && blockAbove != Blocks.field_150465_bP) {
                            this.denyTpReason = "No air above!";
                        }
                    }
                }
                if (NotEnoughUpdates.INSTANCE.config.itemOverlays.enableEtherwarpHelperOverlay && this.denyTpReason != null && !NotEnoughUpdates.INSTANCE.config.itemOverlays.hideEtherwarpFailText) {
                    ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
                    Utils.drawStringCentered(EnumChatFormatting.RED + "Can't TP: " + this.denyTpReason, Minecraft.func_71410_x().field_71466_p, (float)scaledResolution.func_78326_a() / 2.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f, true, 0);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            boolean onPrivateIsland = Arrays.asList("dynamic", "garden").contains(SBInfo.getInstance().getLocation());
            if (NotEnoughUpdates.INSTANCE.config.itemOverlays.enableWandOverlay && Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && onPrivateIsland && (hover = world.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a().func_177967_a(Minecraft.func_71410_x().field_71476_x.field_178784_b, 1))).func_177230_c() == Blocks.field_150350_a) {
                if (heldInternal != null && heldInternal.equals("BUILDERS_WAND")) {
                    this.buildersWandText(event, world);
                } else if (heldInternal != null && heldInternal.equals("BUILDERS_RULER")) {
                    this.buildersRulerText(event, world);
                }
            }
        }
    }

    public void buildersWandText(RenderGameOverlayEvent.Post event, WorldClient world) {
        int itemCount;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        HashSet<BlockPos> candidatesOld = new HashSet<BlockPos>();
        TreeMap<Float, Set<BlockPos>> candidatesOldSorted = new TreeMap<Float, Set<BlockPos>>();
        IBlockState match2 = world.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a());
        Item matchItem = Item.func_150898_a((Block)match2.func_177230_c());
        if (matchItem == null) {
            return;
        }
        ItemStack matchStack = new ItemStack(matchItem, 1, match2.func_177230_c().func_176222_j((World)world, Minecraft.func_71410_x().field_71476_x.func_178782_a()));
        this.getBuildersWandCandidates((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71476_x, event.partialTicks, candidatesOld, candidatesOldSorted, 758);
        boolean usingDirtWand = false;
        if (match2.func_177230_c() == Blocks.field_150346_d && matchStack.func_77952_i() == 0 && this.hasDirtWand()) {
            itemCount = candidatesOld.size();
            usingDirtWand = true;
        } else {
            itemCount = this.countItemsInInventoryAndStorage(matchStack);
        }
        if (candidatesOld.size() == 0) {
            return;
        }
        if (candidatesOld.size() > 241) {
            Utils.drawStringCentered(EnumChatFormatting.RED.toString() + candidatesOld.size() + "/" + 241, Minecraft.func_71410_x().field_71466_p, (float)scaledResolution.func_78326_a() / 2.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f, true, 0);
        } else {
            String pre = EnumChatFormatting.GREEN.toString();
            if (itemCount < candidatesOld.size()) {
                pre = EnumChatFormatting.RED.toString();
            }
            Utils.drawStringCentered(pre + Math.min(candidatesOld.size(), itemCount) + "/" + Math.min(candidatesOld.size(), 241), Minecraft.func_71410_x().field_71466_p, (float)scaledResolution.func_78326_a() / 2.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f, true, 0);
        }
        String itemCountS = EnumChatFormatting.DARK_GRAY + "x" + EnumChatFormatting.RESET + itemCount;
        int itemCountLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(itemCountS);
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.wandBlockCount) {
            if (usingDirtWand) {
                Utils.drawItemStack(new ItemStack(Items.field_151074_bl), scaledResolution.func_78326_a() / 2 - (itemCountLen + 16) / 2, scaledResolution.func_78328_b() / 2 + 10 + 4);
                Minecraft.func_71410_x().field_71466_p.func_175065_a(itemCountS, (float)scaledResolution.func_78326_a() / 2.0f - (float)(itemCountLen + 16) / 2.0f + 11.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f + 8.0f, -1, true);
            } else {
                Utils.drawItemStack(matchStack, scaledResolution.func_78326_a() / 2 - (itemCountLen + 16) / 2, scaledResolution.func_78328_b() / 2 + 10 + 4);
                Minecraft.func_71410_x().field_71466_p.func_175065_a(itemCountS, (float)scaledResolution.func_78326_a() / 2.0f - (float)(itemCountLen + 16) / 2.0f + 16.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f + 8.0f, -1, true);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void buildersRulerText(RenderGameOverlayEvent.Post event, WorldClient world) {
        int itemCount;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        HashSet<BlockPos> candidatesOld = new HashSet<BlockPos>();
        TreeMap<Float, Set<BlockPos>> candidatesOldSorted = new TreeMap<Float, Set<BlockPos>>();
        IBlockState match2 = world.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a());
        Item matchItem = Item.func_150898_a((Block)match2.func_177230_c());
        if (matchItem == null) {
            return;
        }
        ItemStack matchStack = new ItemStack(matchItem, 1, match2.func_177230_c().func_176222_j((World)world, Minecraft.func_71410_x().field_71476_x.func_178782_a()));
        if (!Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            matchStack = this.getFirstItemInRuler();
        }
        match2 = Blocks.field_150346_d.func_176223_P();
        if (matchStack == null) {
            return;
        }
        if (matchStack.func_77973_b() == null) {
            return;
        }
        this.getBuildersRulerCandidates((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71476_x, event.partialTicks, candidatesOld, candidatesOldSorted, 258);
        boolean usingDirtWand = false;
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            itemCount = candidatesOld.size();
        } else if (match2.func_177230_c() == Blocks.field_150346_d && matchStack.func_77952_i() == 0 && this.hasDirtWand()) {
            itemCount = candidatesOld.size();
            usingDirtWand = true;
        } else {
            itemCount = this.countItemsInInventoryAndStorage(matchStack);
        }
        if (candidatesOld.size() == 0) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            if (candidatesOld.size() > 241) {
                Utils.drawStringCentered(EnumChatFormatting.RED.toString() + candidatesOld.size() + "/" + 241, Minecraft.func_71410_x().field_71466_p, (float)scaledResolution.func_78326_a() / 2.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f, true, 0);
            } else {
                String pre = EnumChatFormatting.GREEN.toString();
                Utils.drawStringCentered(pre + Math.min(candidatesOld.size(), itemCount) + "/" + Math.min(candidatesOld.size(), 241), Minecraft.func_71410_x().field_71466_p, (float)scaledResolution.func_78326_a() / 2.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f, true, 0);
            }
        }
        String itemCountS = EnumChatFormatting.DARK_GRAY + "x" + EnumChatFormatting.RESET + itemCount;
        int itemCountLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(itemCountS);
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.wandBlockCount) {
            if (usingDirtWand) {
                Utils.drawItemStack(new ItemStack(Items.field_151074_bl), scaledResolution.func_78326_a() / 2 - (itemCountLen + 16) / 2, scaledResolution.func_78328_b() / 2 + 10 + 4);
                Minecraft.func_71410_x().field_71466_p.func_175065_a(itemCountS, (float)scaledResolution.func_78326_a() / 2.0f - (float)(itemCountLen + 16) / 2.0f + 11.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f + 8.0f, -1, true);
            } else {
                Utils.drawItemStack(matchStack, scaledResolution.func_78326_a() / 2 - (itemCountLen + 16) / 2, scaledResolution.func_78328_b() / 2 + 10 + 4);
                Minecraft.func_71410_x().field_71466_p.func_175065_a(itemCountS, (float)scaledResolution.func_78326_a() / 2.0f - (float)(itemCountLen + 16) / 2.0f + 16.0f, (float)scaledResolution.func_78328_b() / 2.0f + 10.0f + 8.0f, -1, true);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private RaycastResult raycast(EntityPlayerSP player, float partialTicks, float dist, float step) {
        Vector3f pos = new Vector3f((float)player.field_70165_t, (float)player.field_70163_u + player.func_70047_e(), (float)player.field_70161_v);
        Vec3 lookVec3 = player.func_70676_i(partialTicks);
        Vector3f look = new Vector3f((float)lookVec3.field_72450_a, (float)lookVec3.field_72448_b, (float)lookVec3.field_72449_c);
        look.scale(step / look.length());
        int stepCount = (int)Math.ceil(dist / step);
        for (int i = 0; i < stepCount; ++i) {
            Vector3f.add((Vector3f)pos, (Vector3f)look, (Vector3f)pos);
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BlockPos position = new BlockPos((double)pos.x, (double)pos.y, (double)pos.z);
            IBlockState state = world.func_180495_p(position);
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            Vector3f.sub((Vector3f)pos, (Vector3f)look, (Vector3f)pos);
            look.scale(0.1f);
            for (int j = 0; j < 10; ++j) {
                Vector3f.add((Vector3f)pos, (Vector3f)look, (Vector3f)pos);
                BlockPos position2 = new BlockPos((double)pos.x, (double)pos.y, (double)pos.z);
                IBlockState state2 = world.func_180495_p(position2);
                if (state2.func_177230_c() == Blocks.field_150350_a) continue;
                return new RaycastResult(state2, position2);
            }
            return new RaycastResult(state, position);
        }
        return null;
    }

    public NBTTagCompound getBuildersNbt(boolean isWand) {
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (held == null) {
            return null;
        }
        if (held.func_77942_o() && held.func_77978_p().func_150297_b("ExtraAttributes", 10) && held.func_77978_p().func_74775_l("ExtraAttributes").func_150297_b(isWand ? "builder's_wand_data" : "builder's_ruler_data", 7)) {
            byte[] bytes = held.func_77978_p().func_74775_l("ExtraAttributes").func_74770_j(isWand ? "builder's_wand_data" : "builder's_ruler_data");
            try {
                return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (Exception e2) {
                return null;
            }
        }
        return null;
    }

    public int countItemsInInventoryAndStorage(ItemStack match2) {
        boolean isWand;
        if (match2 == null) {
            return 0;
        }
        int count = 0;
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
            if (!match2.func_77969_a(stack)) continue;
            count += stack.field_77994_a;
        }
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        String heldInternal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held);
        boolean bl = isWand = heldInternal != null && heldInternal.equals("BUILDERS_WAND");
        if (heldInternal == null || !heldInternal.equals(isWand ? "BUILDERS_WAND" : "BUILDERS_RULER")) {
            return count;
        }
        NBTTagCompound contents_nbt = this.getBuildersNbt(isWand);
        if (contents_nbt == null) {
            return count;
        }
        NBTTagList items2 = contents_nbt.func_150295_c("i", 10);
        for (int j = 0; j < items2.func_74745_c(); ++j) {
            NBTTagCompound buildersItem = items2.func_150305_b(j);
            if (buildersItem.func_150296_c().size() <= 0 || buildersItem.func_74762_e("id") != Item.func_150891_b((Item)match2.func_77973_b()) || buildersItem.func_74762_e("Damage") != match2.func_77952_i()) continue;
            count += items2.func_150305_b(j).func_74771_c("Count");
        }
        return count;
    }

    public ItemStack getFirstItemInRuler() {
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        String heldInternal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held);
        if (heldInternal == null || !heldInternal.equals("BUILDERS_RULER")) {
            return null;
        }
        NBTTagCompound contents_nbt = this.getBuildersNbt(false);
        if (contents_nbt == null) {
            return null;
        }
        NBTTagList items2 = contents_nbt.func_150295_c("i", 10);
        for (int j = 0; j < items2.func_74745_c(); ++j) {
            NBTTagCompound buildersItem = items2.func_150305_b(j);
            if (buildersItem.func_150296_c().size() <= 0) continue;
            ItemStack newStack = new ItemStack(Item.func_150899_d((int)buildersItem.func_74762_e("id")), 1, buildersItem.func_74762_e("Damage"));
            return newStack;
        }
        return null;
    }

    public boolean hasDirtWand() {
        boolean isWand;
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
            String internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack);
            if (internalname == null || !internalname.equals("INFINIDIRT_WAND")) continue;
            return true;
        }
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        String heldInternal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held);
        boolean bl = isWand = heldInternal != null && heldInternal.equals("BUILDERS_WAND");
        if (heldInternal != null && heldInternal.equals(isWand ? "BUILDERS_WAND" : "BUILDERS_RULER") && held.func_77942_o() && held.func_77978_p().func_150297_b("ExtraAttributes", 10) && held.func_77978_p().func_74775_l("ExtraAttributes").func_150297_b(isWand ? "builder's_wand_data" : "builder's_ruler_data", 7)) {
            byte[] bytes = held.func_77978_p().func_74775_l("ExtraAttributes").func_74770_j(isWand ? "builder's_wand_data" : "builder's_ruler_data");
            try {
                NBTTagCompound contents_nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
                NBTTagList items2 = contents_nbt.func_150295_c("i", 10);
                for (int j = 0; j < items2.func_74745_c(); ++j) {
                    String internalname;
                    NBTTagCompound buildersItem = items2.func_150305_b(j);
                    if (buildersItem.func_150296_c().size() <= 0 || (internalname = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemNBT(buildersItem.func_74775_l("tag")).resolveInternalName()) == null || !internalname.equals("INFINIDIRT_WAND")) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @SubscribeEvent
    public void renderBlockOverlay(DrawBlockHighlightEvent event) {
        if (this.aoteTeleportationCurr != null && this.aoteTeleportationMillis > 0) {
            event.setCanceled(true);
        }
        this.usingEtherwarp = false;
        this.etherwarpRaycast = null;
        float lastFOVMult = this.targetFOVMult;
        this.targetFOVMult = 1.0f;
        this.targetSensMult = 1.0f;
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        String heldInternal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held);
        if (heldInternal == null) {
            return;
        }
        boolean onPrivateIsland = Arrays.asList("dynamic", "garden").contains(SBInfo.getInstance().getLocation());
        EntityPlayer player = event.player;
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks;
        if ((this.tick - this.lastEtherwarpUse > 10 || !NotEnoughUpdates.INSTANCE.config.itemOverlays.etherwarpZoom) && this.onRenderBlockEtherwarp(heldInternal, held, d0, d1, d2, lastFOVMult)) {
            return;
        }
        if (heldInternal.equals("BLOCK_ZAPPER")) {
            this.onRenderBlockBlockZapper(event, onPrivateIsland, d0, d1, d2);
        } else if (NotEnoughUpdates.INSTANCE.config.itemOverlays.enableTreecapOverlay && (heldInternal.equals("JUNGLE_AXE") || heldInternal.equals("TREECAPITATOR_AXE")) && ItemCooldowns.getDurabilityOverride(held) < 0.0f) {
            CustomItemEffects.onRenderBlockTreecap(event, heldInternal, d0, d1, d2);
        } else if (NotEnoughUpdates.INSTANCE.config.itemOverlays.enableWandOverlay) {
            this.onRenderBlockWandOverlay(event, heldInternal, onPrivateIsland, d0, d1, d2, player);
        }
    }

    private boolean onRenderBlockEtherwarp(String heldInternal, ItemStack held, double d0, double d1, double d2, float lastFOVMult) {
        NBTTagCompound tag;
        boolean aotv;
        boolean bl = aotv = Minecraft.func_71410_x().field_71439_g.func_70093_af() && (heldInternal.equals("ASPECT_OF_THE_VOID") || heldInternal.equals("ASPECT_OF_THE_END"));
        if (!aotv && !heldInternal.equals("ETHERWARP_CONDUIT")) {
            return false;
        }
        boolean bl2 = this.usingEtherwarp = !aotv;
        if (aotv && (tag = held.func_77978_p()) != null && tag.func_150297_b("ExtraAttributes", 10)) {
            NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
            this.usingEtherwarp = ea.func_74764_b("ethermerge");
        }
        if (!this.usingEtherwarp) {
            return false;
        }
        int dist = 0;
        for (NBTTagCompound line : NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(held.func_77978_p())) {
            String cleaned = Utils.cleanColour((String)line);
            Matcher matcher = this.etherwarpDistancePattern.matcher(cleaned);
            if (!matcher.matches()) continue;
            dist = Integer.parseInt(matcher.group("distance"));
            break;
        }
        if (dist == 0) {
            return false;
        }
        this.etherwarpRaycast = this.raycast(Minecraft.func_71410_x().field_71439_g, 1.0f, dist, 0.1f);
        if (this.etherwarpRaycast != null && NotEnoughUpdates.INSTANCE.config.itemOverlays.enableEtherwarpBlockOverlay) {
            if (this.denyTpReason == null || !NotEnoughUpdates.INSTANCE.config.itemOverlays.disableOverlayWhenFailed) {
                AxisAlignedBB box = this.etherwarpRaycast.state.func_177230_c().func_180646_a((World)Minecraft.func_71410_x().field_71441_e, this.etherwarpRaycast.pos);
                String colour = this.denyTpReason != null && NotEnoughUpdates.INSTANCE.config.itemOverlays.changeEtherwarpColourWhenFailed ? NotEnoughUpdates.INSTANCE.config.itemOverlays.etherwarpFailHighlightColour : NotEnoughUpdates.INSTANCE.config.itemOverlays.etherwarpHighlightColour;
                AxisAlignedBB bb = box.func_72314_b(0.01, 0.01, 0.01).func_72317_d(-d0, -d1, -d2);
                CustomItemEffects.drawFilledBoundingBox(bb, 1.0f, colour);
                GlStateManager.func_179097_i();
                CustomItemEffects.drawOutlineBoundingBox(bb, 2.0f, colour);
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
            if (NotEnoughUpdates.INSTANCE.config.itemOverlays.etherwarpZoom) {
                float distFactor = 1.0f - (float)Math.sqrt(this.etherwarpRaycast.pos.func_177951_i((Vec3i)Minecraft.func_71410_x().field_71439_g.func_180425_c())) / 60.0f;
                this.targetFOVMult = distFactor * distFactor * distFactor * 0.75f + 0.25f;
                if (this.targetFOVMult < 0.25f) {
                    this.targetFOVMult = 0.25f;
                }
                this.targetSensMult = distFactor * 0.76f + 0.25f;
            }
        } else if (NotEnoughUpdates.INSTANCE.config.itemOverlays.etherwarpZoom) {
            this.targetFOVMult = lastFOVMult;
        }
        return true;
    }

    private void onRenderBlockWandOverlay(DrawBlockHighlightEvent event, String heldInternal, boolean onPrivateIsland, double d0, double d1, double d2, EntityPlayer player) {
        if (heldInternal.equals("BUILDERS_WAND") && onPrivateIsland) {
            this.buildersWandOverlay(event, d0, d1, d2);
        } else if (heldInternal.equals("BUILDERS_RULER") && onPrivateIsland) {
            this.buildersRulerOverlay(event, d0, d1, d2);
        } else if (heldInternal.equals("INFINIDIRT_WAND") && event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && NotEnoughUpdates.INSTANCE.config.itemOverlays.enableDirtWandOverlay) {
            BlockPos hover = event.target.func_178782_a().func_177967_a(event.target.field_178784_b, 1);
            if ("garden".equals(SBInfo.getInstance().getLocation()) && (hover.func_177958_n() > 239 || hover.func_177958_n() < -240 || hover.func_177952_p() > 239 || hover.func_177952_p() < -240 || hover.func_177956_o() <= 66 || hover.func_177956_o() > 76)) {
                return;
            }
            IBlockState hoverState = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a().func_177967_a(event.target.field_178784_b, 1));
            if (hoverState.func_177230_c() == Blocks.field_150350_a) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                String special = NotEnoughUpdates.INSTANCE.config.itemOverlays.wandOverlayColour;
                AxisAlignedBB bb = Blocks.field_150346_d.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, hover);
                CustomItemEffects.drawBlock((int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c + 1, Blocks.field_150346_d.func_176223_P(), event.partialTicks, 0.75f);
                AxisAlignedBB bbExpanded = Blocks.field_150346_d.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, hover).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2);
                CustomItemEffects.drawOutlineBoundingBox(bbExpanded, 1.0f, special);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
        } else if ((heldInternal.equals("WATER_BUCKET") || heldInternal.equals("MAGICAL_WATER_BUCKET") && NotEnoughUpdates.INSTANCE.config.itemOverlays.enablePrismapumpOverlay && onPrivateIsland) && event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockPos hover = event.target.func_178782_a().func_177967_a(event.target.field_178784_b, 1);
            HashSet<BlockPos> verticalSources = new HashSet<BlockPos>();
            TreeMap<Float, HashMap> watersSorted = new TreeMap<Float, HashMap>();
            for (int xOff = -1; xOff <= 1; ++xOff) {
                for (int yOff = 0; yOff <= 1; ++yOff) {
                    block2: for (int zOff = -1; zOff <= 1; ++zOff) {
                        IBlockState renderState;
                        BlockPos renderPos;
                        BlockPos checkPos;
                        IBlockState check;
                        if (!(xOff == 0 && yOff == 0 || xOff == 0 && zOff == 0) && (zOff != 0 || yOff != 0) || (check = Minecraft.func_71410_x().field_71441_e.func_180495_p(checkPos = hover.func_177982_a(-xOff, -yOff, -zOff))).func_177230_c() != Blocks.field_180397_cI || check.func_177230_c().func_176201_c(check) != 2) continue;
                        for (int i = 0; i < 300 && Math.abs((renderPos = hover.func_177982_a(xOff * i, yOff * i, zOff * i)).func_177958_n()) <= 128 && Math.abs(renderPos.func_177956_o()) <= 255 && Math.abs(renderPos.func_177952_p()) <= 128 && ((renderState = Minecraft.func_71410_x().field_71441_e.func_180495_p(renderPos)).func_177230_c() == Blocks.field_150350_a || renderState.func_177230_c() == Blocks.field_150355_j || renderState.func_177230_c() == Blocks.field_150358_i); ++i) {
                            if (yOff != 0) {
                                verticalSources.add(renderPos);
                            } else {
                                IBlockState belowState = Minecraft.func_71410_x().field_71441_e.func_180495_p(renderPos.func_177982_a(0, -1, 0));
                                if (belowState.func_177230_c() == Blocks.field_150350_a) continue block2;
                            }
                            for (IBlockState facing : EnumFacing.values()) {
                                float xDist = (float)((double)((float)renderPos.func_177958_n() + 0.5f + 0.5f * (float)facing.func_82601_c()) - d0);
                                float yDist = (float)((double)((float)renderPos.func_177956_o() + 0.5f + 0.5f * (float)facing.func_96559_d()) - d1 - (double)player.func_70047_e());
                                float zDist = (float)((double)((float)renderPos.func_177952_p() + 0.5f + 0.5f * (float)facing.func_82599_e()) - d2);
                                float distSq = xDist * xDist + yDist * yDist + zDist * zDist;
                                watersSorted.computeIfAbsent(Float.valueOf(distSq), k -> new HashMap()).put(renderPos, facing);
                            }
                        }
                    }
                }
            }
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)true);
            for (HashMap blockPoses : watersSorted.values()) {
                for (Map.Entry entry : blockPoses.entrySet()) {
                    boolean vertical = verticalSources.contains(entry.getKey());
                    AxisAlignedBB bbExpanded = Blocks.field_150355_j.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, (BlockPos)entry.getKey()).func_72314_b(-0.001, -0.001 - (vertical ? 0.0 : 0.0625), -0.001).func_72317_d(-d0, -d1 - (vertical ? 0.0 : 0.0625), -d2);
                    CustomItemEffects.drawFilledBoundingBoxSide(bbExpanded, (EnumFacing)entry.getValue(), 1.0f, "0:100:20:50:160");
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        } else if ((heldInternal.equals("HOE_OF_GREAT_TILLING") || heldInternal.equals("HOE_OF_GREATER_TILLING") && NotEnoughUpdates.INSTANCE.config.itemOverlays.enableHoeOverlay && onPrivateIsland) && event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int radius;
            BlockPos target = event.target.func_178782_a();
            IBlockState targetState = Minecraft.func_71410_x().field_71441_e.func_180495_p(target);
            int n = radius = heldInternal.equals("HOE_OF_GREAT_TILLING") ? 1 : 2;
            if (targetState.func_177230_c() == Blocks.field_150346_d || targetState.func_177230_c() == Blocks.field_150349_c) {
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)true);
                for (int xOff = -radius; xOff <= radius; ++xOff) {
                    for (int zOff = -radius; zOff <= radius; ++zOff) {
                        BlockPos renderPos = target.func_177982_a(xOff, 0, zOff);
                        BlockPos airPos = renderPos.func_177982_a(0, 1, 0);
                        IBlockState renderState = Minecraft.func_71410_x().field_71441_e.func_180495_p(renderPos);
                        IBlockState airState = Minecraft.func_71410_x().field_71441_e.func_180495_p(airPos);
                        if (renderState.func_177230_c() != Blocks.field_150346_d && (renderState.func_177230_c() != Blocks.field_150349_c || airState.func_177230_c() != Blocks.field_150350_a)) continue;
                        AxisAlignedBB bbExpanded = Blocks.field_150346_d.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, renderPos).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2);
                        CustomItemEffects.drawFilledBoundingBox(bbExpanded, 1.0f, "0:100:178:34:34");
                    }
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
        } else if (heldInternal.equals("HOE_OF_GREATEST_TILLING") && NotEnoughUpdates.INSTANCE.config.itemOverlays.enableHoeOverlay && onPrivateIsland && event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockPos target = event.target.func_178782_a();
            IBlockState targetState = Minecraft.func_71410_x().field_71441_e.func_180495_p(target);
            if (targetState.func_177230_c() == Blocks.field_150346_d || targetState.func_177230_c() == Blocks.field_150349_c) {
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)true);
                LinkedList candidates = new LinkedList();
                LinkedList<BlockPos> candidatesOld = new LinkedList<BlockPos>();
                LinkedList<BlockPos> candidatesNew = new LinkedList<BlockPos>();
                candidatesNew.add(target);
                while (candidatesOld.size() <= 100 && !candidatesNew.isEmpty()) {
                    candidates.addAll(candidatesNew);
                    candidatesNew.clear();
                    while (!candidates.isEmpty()) {
                        int xOff;
                        BlockPos candidate = (BlockPos)candidates.pop();
                        candidatesOld.add(candidate);
                        float yaw = Minecraft.func_71410_x().field_71439_g.func_70079_am();
                        Facing facing = Facing.forDirection(yaw);
                        int n = facing == Facing.WEST ? -1 : (xOff = facing == Facing.EAST ? 1 : 0);
                        int zOff = facing == Facing.NORTH ? -1 : (facing == Facing.SOUTH ? 1 : 0);
                        BlockPos renderPos = candidate.func_177982_a(xOff, 0, zOff);
                        BlockPos airPos = renderPos.func_177982_a(0, 1, 0);
                        IBlockState renderState = Minecraft.func_71410_x().field_71441_e.func_180495_p(renderPos);
                        IBlockState airState = Minecraft.func_71410_x().field_71441_e.func_180495_p(airPos);
                        if (candidatesOld.contains(renderPos) || candidates.contains(renderPos) || candidatesNew.contains(renderPos)) continue;
                        if (renderState.func_177230_c() != Blocks.field_150346_d && (renderState.func_177230_c() != Blocks.field_150349_c || airState.func_177230_c() != Blocks.field_150350_a)) break;
                        candidatesNew.add(renderPos);
                    }
                    for (BlockPos renderPos : candidatesNew) {
                        AxisAlignedBB bbExpanded = Blocks.field_150346_d.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, renderPos).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2);
                        CustomItemEffects.drawFilledBoundingBox(bbExpanded, 1.0f, "0:100:178:34:34");
                    }
                }
                AxisAlignedBB bbExpanded = Blocks.field_150346_d.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, target).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2);
                CustomItemEffects.drawFilledBoundingBox(bbExpanded, 1.0f, "0:100:178:34:34");
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
        } else if ((heldInternal.equals("SAM_SCYTHE") || heldInternal.equals("GARDEN_SCYTHE") && NotEnoughUpdates.INSTANCE.config.itemOverlays.enableScytheOverlay && onPrivateIsland) && event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int radius;
            BlockPos target = event.target.func_178782_a();
            IBlockState targetState = Minecraft.func_71410_x().field_71441_e.func_180495_p(target);
            int n = radius = heldInternal.equals("SAM_SCYTHE") ? 1 : 2;
            if (this.scytheBlocks.contains(targetState.func_177230_c())) {
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)true);
                for (int xOff = -radius; xOff <= radius; ++xOff) {
                    for (int yOff = -radius; yOff <= radius; ++yOff) {
                        for (int zOff = -radius; zOff <= radius; ++zOff) {
                            BlockPos renderPos = target.func_177982_a(xOff, yOff, zOff);
                            IBlockState renderState = Minecraft.func_71410_x().field_71441_e.func_180495_p(renderPos);
                            if (!this.scytheBlocks.contains(renderState.func_177230_c())) continue;
                            AxisAlignedBB bbExpanded = renderState.func_177230_c().func_180646_a((World)Minecraft.func_71410_x().field_71441_e, renderPos).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2);
                            CustomItemEffects.drawFilledBoundingBox(bbExpanded, 1.0f, "0:100:178:34:34");
                        }
                    }
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
        }
    }

    private static void onRenderBlockTreecap(DrawBlockHighlightEvent event, String heldInternal, double d0, double d1, double d2) {
        int maxWood = 10;
        if (heldInternal.equals("TREECAPITATOR_AXE")) {
            maxWood = 35;
        }
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            if (Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a()).func_177230_c() == Blocks.field_150364_r || Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a()).func_177230_c() == Blocks.field_150363_s) {
                int woods = 0;
                HashSet<BlockPos> candidatesOld = new HashSet<BlockPos>();
                LinkedList candidates = new LinkedList();
                LinkedList<BlockPos> candidatesNew = new LinkedList<BlockPos>();
                candidatesNew.add(event.target.func_178782_a());
                while (woods < maxWood && !candidatesNew.isEmpty()) {
                    boolean random2;
                    candidates.addAll(candidatesNew);
                    candidatesNew.clear();
                    boolean bl = random2 = (woods += candidates.size()) > maxWood;
                    while (!candidates.isEmpty()) {
                        BlockPos candidate = (BlockPos)candidates.pop();
                        Block block = Minecraft.func_71410_x().field_71441_e.func_180495_p(candidate).func_177230_c();
                        candidatesOld.add(candidate);
                        for (int x = -1; x <= 1; ++x) {
                            for (int y = -1; y <= 1; ++y) {
                                for (int z = -1; z <= 1; ++z) {
                                    Block blockNew;
                                    BlockPos posNew;
                                    if (x == 0 && y == 0 && z == 0 || candidatesOld.contains(posNew = candidate.func_177982_a(x, y, z)) || candidates.contains(posNew) || candidatesNew.contains(posNew) || (blockNew = Minecraft.func_71410_x().field_71441_e.func_180495_p(posNew).func_177230_c()) != Blocks.field_150364_r && blockNew != Blocks.field_150363_s) continue;
                                    candidatesNew.add(posNew);
                                }
                            }
                        }
                        block.func_180654_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, candidate);
                        CustomItemEffects.drawFilledBoundingBox(block.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, candidate).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2), random2 ? 0.5f : 1.0f, NotEnoughUpdates.INSTANCE.config.itemOverlays.treecapOverlayColour);
                    }
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    private void onRenderBlockBlockZapper(DrawBlockHighlightEvent event, boolean onPrivateIsland, double d0, double d1, double d2) {
        if (!onPrivateIsland || !NotEnoughUpdates.INSTANCE.config.itemOverlays.enableZapperOverlay || event.target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            this.zapperBlocks.clear();
            return;
        }
        if (this.zapperDirty) {
            this.zapperDirty = false;
            this.zapperBlocks.clear();
            LinkedList<BlockPos> returnablePositions = new LinkedList<BlockPos>();
            BlockPos pos = event.target.func_178782_a();
            IBlockState firstBlockState = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
            Block block = firstBlockState.func_177230_c();
            BlockPos above = pos.func_177982_a(0, 1, 0);
            Block aboveBlock = Minecraft.func_71410_x().field_71441_e.func_180495_p(above).func_177230_c();
            if (!(cropBlocksZapper.contains(aboveBlock) || cropBlocksZapper.contains(block) || otherBannedBlocksZapper.contains(block) || block.hasTileEntity(firstBlockState) || !(block.func_176195_g((World)Minecraft.func_71410_x().field_71441_e, pos) >= 0.0f))) {
                for (int i = 0; i < 164; ++i) {
                    this.zapperBlocks.add(pos);
                    returnablePositions.remove(pos);
                    ArrayList<BlockPos> availableNeighbors = new ArrayList<BlockPos>();
                    for (BlockPos offset : zapperOffsets) {
                        IBlockState state;
                        BlockPos newPos = pos.func_177971_a((Vec3i)offset);
                        if (this.zapperBlocks.contains(newPos) || (state = Minecraft.func_71410_x().field_71441_e.func_180495_p(newPos)) == null || state.func_177230_c() != block || cropBlocksZapper.contains(aboveBlock = Minecraft.func_71410_x().field_71441_e.func_180495_p(above = newPos.func_177982_a(0, 1, 0)).func_177230_c())) continue;
                        availableNeighbors.add(newPos);
                    }
                    if (availableNeighbors.size() >= 2) {
                        returnablePositions.add(pos);
                        pos = (BlockPos)availableNeighbors.get(0);
                        continue;
                    }
                    if (availableNeighbors.size() == 1) {
                        pos = (BlockPos)availableNeighbors.get(0);
                        continue;
                    }
                    if (returnablePositions.isEmpty()) break;
                    --i;
                    pos = (BlockPos)returnablePositions.getLast();
                }
            }
        }
        for (BlockPos pos : this.zapperBlocks) {
            Block block = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c();
            CustomItemEffects.drawFilledBoundingBox(block.func_180646_a((World)Minecraft.func_71410_x().field_71441_e, pos).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2), 1.0f, NotEnoughUpdates.INSTANCE.config.itemOverlays.zapperOverlayColour);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void buildersWandOverlay(DrawBlockHighlightEvent event, double d0, double d1, double d2) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            String special;
            IBlockState hover = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a().func_177967_a(event.target.field_178784_b, 1));
            if (hover.func_177230_c() != Blocks.field_150350_a) {
                return;
            }
            IBlockState match2 = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a());
            Item matchItem = Item.func_150898_a((Block)match2.func_177230_c());
            if (matchItem == null) {
                return;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            HashSet<BlockPos> candidatesOld = new HashSet<BlockPos>();
            TreeMap<Float, Set<BlockPos>> candidatesOldSorted = new TreeMap<Float, Set<BlockPos>>();
            this.getBuildersWandCandidates((EntityPlayer)Minecraft.func_71410_x().field_71439_g, event.target, event.partialTicks, candidatesOld, candidatesOldSorted, 10);
            ItemStack matchStack = new ItemStack(matchItem, 1, match2.func_177230_c().func_176222_j((World)Minecraft.func_71410_x().field_71441_e, event.target.func_178782_a()));
            int itemCount = match2.func_177230_c() == Blocks.field_150346_d && matchStack.func_77952_i() == 0 && this.hasDirtWand() ? candidatesOld.size() : this.countItemsInInventoryAndStorage(matchStack);
            String string = special = candidatesOld.size() <= itemCount ? NotEnoughUpdates.INSTANCE.config.itemOverlays.wandOverlayColour : "0:255:255:0:0";
            if (candidatesOld.size() <= 241) {
                for (Set<BlockPos> candidatesSorted : candidatesOldSorted.values()) {
                    for (BlockPos candidate : candidatesSorted) {
                        match2.func_177230_c().func_180654_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, candidate);
                        Minecraft.func_71410_x().field_71439_g.func_70093_af();
                        AxisAlignedBB bb = match2.func_177230_c().func_180646_a((World)Minecraft.func_71410_x().field_71441_e, candidate.func_177982_a(0, 0, 0)).func_72317_d((double)event.target.field_178784_b.func_82601_c(), (double)event.target.field_178784_b.func_96559_d(), (double)event.target.field_178784_b.func_82599_e());
                        CustomItemEffects.drawBlock((int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c + 1, match2, event.partialTicks, 0.75f);
                    }
                }
                for (BlockPos candidate : candidatesOld) {
                    match2.func_177230_c().func_180654_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, candidate);
                    Minecraft.func_71410_x().field_71439_g.func_70093_af();
                    AxisAlignedBB bb = match2.func_177230_c().func_180646_a((World)Minecraft.func_71410_x().field_71441_e, candidate.func_177982_a(0, 0, 0)).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2).func_72317_d((double)event.target.field_178784_b.func_82601_c(), (double)event.target.field_178784_b.func_96559_d(), (double)event.target.field_178784_b.func_82599_e());
                    CustomItemEffects.drawOutlineBoundingBox(bb, 1.0f, special);
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    public void buildersRulerOverlay(DrawBlockHighlightEvent event, double d0, double d1, double d2) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int itemCount;
            ItemStack matchStack;
            IBlockState hover = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a().func_177967_a(event.target.field_178784_b, 1));
            if (hover.func_177230_c() != Blocks.field_150350_a) {
                return;
            }
            IBlockState match2 = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a());
            Item matchItem = Item.func_150898_a((Block)match2.func_177230_c());
            if (matchItem == null) {
                return;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            HashSet<BlockPos> candidatesOld = new HashSet<BlockPos>();
            TreeMap<Float, Set<BlockPos>> candidatesOldSorted = new TreeMap<Float, Set<BlockPos>>();
            this.getBuildersRulerCandidates((EntityPlayer)Minecraft.func_71410_x().field_71439_g, event.target, event.partialTicks, candidatesOld, candidatesOldSorted, 10);
            ItemStack firstItemInRuler = this.getFirstItemInRuler();
            if (!Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                Item item;
                Item item2 = item = firstItemInRuler == null ? null : firstItemInRuler.func_77973_b();
                if (item != null) {
                    match2 = item instanceof ItemBlock ? ((ItemBlock)item).func_179223_d().func_176203_a(firstItemInRuler.func_77952_i()) : Blocks.field_150346_d.func_176223_P();
                }
            }
            if ((matchStack = Minecraft.func_71410_x().field_71439_g.func_70093_af() ? new ItemStack(Minecraft.func_71410_x().field_71441_e.func_180495_p(event.target.func_178782_a()).func_177230_c()) : firstItemInRuler) != null && matchStack.func_77973_b() != null) {
                itemCount = match2.func_177230_c() == Blocks.field_150346_d && matchStack.func_77952_i() == 0 && this.hasDirtWand() ? candidatesOld.size() : this.countItemsInInventoryAndStorage(matchStack);
            } else {
                return;
            }
            String special = candidatesOld.size() <= itemCount ? NotEnoughUpdates.INSTANCE.config.itemOverlays.wandOverlayColour : "0:255:255:0:0";
            for (Set<BlockPos> candidatesSorted : candidatesOldSorted.values()) {
                for (BlockPos candidate : candidatesSorted) {
                    AxisAlignedBB bb = match2.func_177230_c().func_180646_a((World)Minecraft.func_71410_x().field_71441_e, candidate.func_177982_a(0, Minecraft.func_71410_x().field_71439_g.func_70093_af() ? -1 : 0, 0)).func_72317_d((double)event.target.field_178784_b.func_82601_c(), (double)event.target.field_178784_b.func_96559_d(), (double)event.target.field_178784_b.func_82599_e());
                    CustomItemEffects.drawBlock((int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c + 1, match2, event.partialTicks, 0.75f);
                }
            }
            for (BlockPos candidate : candidatesOld) {
                AxisAlignedBB bb = match2.func_177230_c().func_180646_a((World)Minecraft.func_71410_x().field_71441_e, candidate.func_177982_a(0, Minecraft.func_71410_x().field_71439_g.func_70093_af() ? -1 : 0, 0)).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2).func_72317_d((double)event.target.field_178784_b.func_82601_c(), (double)event.target.field_178784_b.func_96559_d(), (double)event.target.field_178784_b.func_82599_e());
                CustomItemEffects.drawOutlineBoundingBox(bb, 1.0f, Minecraft.func_71410_x().field_71439_g.func_70093_af() ? NotEnoughUpdates.INSTANCE.config.itemOverlays.wandOverlayColour : special);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    public void getBuildersWandCandidates(EntityPlayer player, MovingObjectPosition target, float partialTicks, HashSet<BlockPos> candidatesOld, TreeMap<Float, Set<BlockPos>> candidatesOldSorted, int extraMax) {
        IBlockState match2 = Minecraft.func_71410_x().field_71441_e.func_180495_p(target.func_178782_a());
        candidatesOld.clear();
        candidatesOldSorted.clear();
        LinkedList candidates = new LinkedList();
        LinkedList<BlockPos> candidatesNew = new LinkedList<BlockPos>();
        candidatesNew.add(target.func_178782_a());
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        while (candidatesOld.size() <= 241 + extraMax && !candidatesNew.isEmpty()) {
            candidates.addAll(candidatesNew);
            candidatesNew.clear();
            while (!candidates.isEmpty() && candidatesOld.size() <= 241 + extraMax) {
                BlockPos candidate = (BlockPos)candidates.pop();
                float distSq = (float)(((double)((float)candidate.func_177958_n() + 0.5f) - d0) * ((double)((float)candidate.func_177958_n() + 0.5f) - d0) + ((double)((float)candidate.func_177956_o() + 0.5f) - d1 - (double)player.func_70047_e()) * ((double)((float)candidate.func_177956_o() + 0.5f) - d1 - (double)player.func_70047_e()) + ((double)((float)candidate.func_177952_p() + 0.5f) - d2) * ((double)((float)candidate.func_177952_p() + 0.5f) - d2));
                candidatesOldSorted.computeIfAbsent(Float.valueOf(distSq), k -> new HashSet()).add(candidate);
                candidatesOld.add(candidate);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            IBlockState blockNew;
                            BlockPos posNew;
                            if (x * x + y * y + z * z != 1 || !(x == 0 && target.field_178784_b.func_176740_k() == EnumFacing.Axis.X || y == 0 && target.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) && (z != 0 || target.field_178784_b.func_176740_k() != EnumFacing.Axis.Z) || Minecraft.func_71410_x().field_71441_e.func_180495_p(candidate.func_177982_a(x + target.field_178784_b.func_82601_c(), y + target.field_178784_b.func_96559_d(), z + target.field_178784_b.func_82599_e())).func_177230_c() != Blocks.field_150350_a || candidatesOld.contains(posNew = candidate.func_177982_a(x, y, z)) || candidates.contains(posNew) || candidatesNew.contains(posNew) || (blockNew = Minecraft.func_71410_x().field_71441_e.func_180495_p(posNew)) != match2) continue;
                            candidatesNew.add(posNew);
                        }
                    }
                }
            }
        }
    }

    public void getBuildersRulerCandidates(EntityPlayer player, MovingObjectPosition target, float partialTicks, HashSet<BlockPos> candidatesOld, TreeMap<Float, Set<BlockPos>> candidatesOldSorted, int extraMax) {
        if (target.field_178784_b != EnumFacing.UP) {
            return;
        }
        boolean sneaking = Minecraft.func_71410_x().field_71439_g.func_70093_af();
        candidatesOld.clear();
        candidatesOldSorted.clear();
        LinkedList candidates = new LinkedList();
        LinkedList<BlockPos> candidatesNew = new LinkedList<BlockPos>();
        candidatesNew.add(target.func_178782_a());
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        block0: while (candidatesOld.size() <= 241 + extraMax && !candidatesNew.isEmpty()) {
            candidates.addAll(candidatesNew);
            candidatesNew.clear();
            while (!candidates.isEmpty() && candidatesOld.size() <= 241 + extraMax) {
                IBlockState blockNew;
                int xOff;
                BlockPos candidate = (BlockPos)candidates.pop();
                float distSq = (float)(((double)((float)candidate.func_177958_n() + 0.5f) - d0) * ((double)((float)candidate.func_177958_n() + 0.5f) - d0) + ((double)((float)candidate.func_177956_o() + 0.5f) - d1 - (double)player.func_70047_e()) * ((double)((float)candidate.func_177956_o() + 0.5f) - d1 - (double)player.func_70047_e()) + ((double)((float)candidate.func_177952_p() + 0.5f) - d2) * ((double)((float)candidate.func_177952_p() + 0.5f) - d2));
                if ("garden".equals(SBInfo.getInstance().getLocation()) && (candidate.func_177956_o() < 66 || candidate.func_177956_o() >= 76)) continue;
                candidatesOldSorted.computeIfAbsent(Float.valueOf(distSq), k -> new HashSet()).add(candidate);
                candidatesOld.add(candidate);
                float yaw = Minecraft.func_71410_x().field_71439_g.func_70079_am();
                Facing facing = Facing.forDirection(yaw);
                int n = facing == Facing.WEST ? -1 : (xOff = facing == Facing.EAST ? 1 : 0);
                int zOff = facing == Facing.NORTH ? -1 : (facing == Facing.SOUTH ? 1 : 0);
                BlockPos posNew = candidate.func_177982_a(xOff, 0, zOff);
                if ("garden".equals(SBInfo.getInstance().getLocation())) {
                    int plotX = MathHelper.func_76141_d((float)((float)(candidate.func_177958_n() + 48) / 96.0f));
                    int plotXNew = MathHelper.func_76141_d((float)((float)(posNew.func_177958_n() + 48) / 96.0f));
                    int plotZ = MathHelper.func_76141_d((float)((float)(candidate.func_177952_p() + 48) / 96.0f));
                    int plotZNew = MathHelper.func_76141_d((float)((float)(posNew.func_177952_p() + 48) / 96.0f));
                    if (plotX != plotXNew || plotZ != plotZNew || 2 < plotXNew || plotXNew < -2 || 2 < plotZNew || plotZNew < -2) continue;
                }
                if (!sneaking) {
                    IBlockState blockNew2;
                    if (Minecraft.func_71410_x().field_71441_e.func_180495_p(candidate.func_177982_a(xOff, 1, zOff)).func_177230_c() != Blocks.field_150350_a) continue block0;
                    if (candidatesOld.contains(posNew) || candidates.contains(posNew) || candidatesNew.contains(posNew) || (blockNew2 = Minecraft.func_71410_x().field_71441_e.func_180495_p(posNew.func_177982_a(0, 1, 0))).func_177230_c() != Blocks.field_150350_a) continue;
                    candidatesNew.add(posNew);
                    continue;
                }
                if (Minecraft.func_71410_x().field_71441_e.func_180495_p(candidate.func_177982_a(xOff, 0, zOff)).func_177230_c() != Minecraft.func_71410_x().field_71441_e.func_180495_p(target.func_178782_a()).func_177230_c()) continue block0;
                if (candidatesOld.contains(posNew) || candidates.contains(posNew) || candidatesNew.contains(posNew) || (blockNew = Minecraft.func_71410_x().field_71441_e.func_180495_p(posNew.func_177982_a(0, 0, 0))).func_177230_c() != Minecraft.func_71410_x().field_71441_e.func_180495_p(target.func_178782_a()).func_177230_c()) continue;
                candidatesNew.add(posNew);
            }
        }
    }

    public static void drawBlock(int x, int y, int z, IBlockState state, float partialTicks, float brightness) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179107_e((int)1029);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)x - d0), (double)((double)y - d1), (double)((double)z - d2));
        int i = state.func_177230_c().func_149645_b();
        if (i == 3) {
            IBakedModel ibakedmodel = blockrendererdispatcher.func_175022_a(state, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, null);
            Block block = state.func_177230_c();
            block.func_149683_g();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int colour = block.func_180644_h(block.func_176217_b(state));
            if (EntityRenderer.field_78517_a) {
                colour = TextureUtil.func_177054_c((int)i);
            }
            colour = colour & 0xFFFFFF | 0x64000000;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                CustomItemEffects.renderModelBrightnessColorQuads(colour, ibakedmodel.func_177551_a(enumfacing));
            }
            CustomItemEffects.renderModelBrightnessColorQuads(colour, ibakedmodel.func_177550_a());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)((double)(-x) + d0), (double)((double)(-y) + d1), (double)((double)(-z) + d2));
        GlStateManager.func_179121_F();
    }

    private static void renderModelBrightnessColorQuads(int c, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        for (BakedQuad bakedquad : listQuads) {
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            worldrenderer.func_178981_a(bakedquad.func_178209_a());
            worldrenderer.func_178968_d(c);
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            worldrenderer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static void drawFilledBoundingBox(AxisAlignedBB p_181561_0_, float alpha, String special) {
        Color c = new Color(SpecialColour.specialToChromaRGB(special), true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)((float)c.getAlpha() / 255.0f * alpha));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.8f), (float)((float)c.getGreen() / 255.0f * 0.8f), (float)((float)c.getBlue() / 255.0f * 0.8f), (float)((float)c.getAlpha() / 255.0f * alpha));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.9f), (float)((float)c.getGreen() / 255.0f * 0.9f), (float)((float)c.getBlue() / 255.0f * 0.9f), (float)((float)c.getAlpha() / 255.0f * alpha));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawFilledBoundingBoxSide(AxisAlignedBB p_181561_0_, EnumFacing facing, float alpha, String special) {
        Color c = new Color(SpecialColour.specialToChromaRGB(special), true);
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)((float)c.getAlpha() / 255.0f * alpha));
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        switch (facing) {
            case UP: {
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
                break;
            }
            case DOWN: {
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
                break;
            }
            case EAST: {
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
                break;
            }
            case WEST: {
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
                break;
            }
            case SOUTH: {
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
                break;
            }
            case NORTH: {
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
                worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    public static void drawOutlineBoundingBox(AxisAlignedBB p_181561_0_, float alpha, String special) {
        Color c = new Color(SpecialColour.specialToChromaRGB(special), true);
        float newAlpha = (float)c.getAlpha() / 255.0f * alpha;
        if (newAlpha > 1.0f) {
            newAlpha = 1.0f;
        }
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)newAlpha);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GL11.glLineWidth((float)3.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glLineWidth((float)1.0f);
    }

    public static enum Facing {
        NORTH,
        EAST,
        SOUTH,
        WEST;


        public static Facing forDirection(float direction) {
            double rotation = (direction - 90.0f) % 360.0f;
            if (rotation < 0.0) {
                rotation += 360.0;
            }
            if (0.0 <= rotation && rotation < 45.0) {
                return WEST;
            }
            if (45.0 <= rotation && rotation < 135.0) {
                return NORTH;
            }
            if (135.0 <= rotation && rotation < 225.0) {
                return EAST;
            }
            if (225.0 <= rotation && rotation < 315.0) {
                return SOUTH;
            }
            if (315.0 <= rotation && rotation < 360.0) {
                return WEST;
            }
            return NORTH;
        }
    }

    private static class RaycastResult {
        IBlockState state;
        BlockPos pos;

        public RaycastResult(IBlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

