/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.IIconCreator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ITransformation;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class CustomSkulls
implements IResourceManagerReloadListener {
    private static final CustomSkulls INSTANCE = new CustomSkulls();
    private final ResourceLocation atlas = new ResourceLocation("notenoughupdates", "custom_skull_textures_atlas");
    private final ResourceLocation configuration = new ResourceLocation("notenoughupdates", "custom_skull_textures/customskull.json");
    private final ResourceLocation configuration2 = new ResourceLocation("notenoughupdates", "custom_skull_textures/customskull2.json");
    protected final TextureMap textureMap = new TextureMap("custom_skull_textures");
    public static ItemCameraTransforms.TransformType mostRecentTransformType = ItemCameraTransforms.TransformType.NONE;
    protected final Map<ResourceLocation, TextureAtlasSprite> sprites = Maps.newHashMap();
    private final FaceBakery faceBakery = new FaceBakery();
    private final ModelSkeletonHead humanoidHead = new ModelHumanoidHead();
    private final HashMap<String, CustomSkull> customSkulls = new HashMap();
    private final HashMap<String, CustomSkull> customSkulls2 = new HashMap();
    private final Gson gson = new GsonBuilder().create();

    public static CustomSkulls getInstance() {
        return INSTANCE;
    }

    private void processConfig(ResourceLocation config, Map<String, CustomSkull> map2, Map<String, CustomSkull> cache) {
        map2.clear();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(config).func_110527_b(), StandardCharsets.UTF_8));){
            JsonObject json = this.gson.fromJson((Reader)reader, JsonObject.class);
            if (json == null) {
                return;
            }
            for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                CustomSkull skull;
                if (!entry.getValue().isJsonObject()) continue;
                JsonObject obj = entry.getValue().getAsJsonObject();
                if (obj.has("model")) {
                    ResourceLocation loc = new ResourceLocation("notenoughupdates", "custom_skull_textures/" + obj.get("model").getAsString() + ".json");
                    skull = cache.get(loc.toString());
                    if (skull == null) {
                        skull = new CustomSkull();
                        skull.model = ModelBlock.func_178307_a((Reader)new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b()));
                        cache.put(loc.toString(), skull);
                    }
                    map2.put(entry.getKey(), skull);
                    continue;
                }
                if (!obj.has("texture")) continue;
                String location = obj.get("texture").getAsString();
                ResourceLocation loc = new ResourceLocation("notenoughupdates", "custom_skull_textures/" + location + ".png");
                skull = cache.get(loc.toString());
                if (skull == null) {
                    skull = new CustomSkull();
                    skull.texture = loc;
                    Minecraft.func_71410_x().func_110434_K().func_147645_c(skull.texture);
                    cache.put(loc.toString(), skull);
                }
                map2.put(entry.getKey(), skull);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        HashMap<String, CustomSkull> skullCache = new HashMap<String, CustomSkull>();
        this.processConfig(this.configuration, this.customSkulls, skullCache);
        this.processConfig(this.configuration2, this.customSkulls2, skullCache);
        if (this.customSkulls.isEmpty() && this.customSkulls2.isEmpty()) {
            return;
        }
        try {
            this.loadSprites(skullCache.values());
            skullCache.values().forEach(skull -> {
                if (((CustomSkull)skull).model != null) {
                    ((CustomSkull)skull).modelBaked = this.bakeModel(((CustomSkull)skull).model, (ITransformation)ModelRotation.X0_Y0, false);
                }
            });
            Minecraft.func_71410_x().func_110434_K().func_110579_a(this.atlas, (ITextureObject)this.textureMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadSprites(Collection<CustomSkull> models) {
        Set<ResourceLocation> set = this.getAllTextureLocations(models);
        set.remove(TextureMap.field_174945_f);
        IIconCreator iiconcreator = iconRegistry -> {
            for (ResourceLocation resourcelocation : set) {
                TextureAtlasSprite textureatlassprite = iconRegistry.func_174942_a(resourcelocation);
                this.sprites.put(resourcelocation, textureatlassprite);
            }
        };
        this.textureMap.func_174943_a(Minecraft.func_71410_x().func_110442_L(), iiconcreator);
        this.sprites.put(new ResourceLocation("missingno"), this.textureMap.func_174944_f());
    }

    protected Set<ResourceLocation> getAllTextureLocations(Collection<CustomSkull> models) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (CustomSkull skull : models) {
            if (skull.model == null) continue;
            set.addAll(this.getTextureLocations(skull.model));
        }
        return set;
    }

    protected Set<ResourceLocation> getTextureLocations(ModelBlock modelBlock) {
        HashSet set = Sets.newHashSet();
        for (BlockPart blockpart : modelBlock.func_178298_a()) {
            for (BlockPartFace blockpartface : blockpart.field_178240_c.values()) {
                ResourceLocation resourcelocation = new ResourceLocation("notenoughupdates", modelBlock.func_178308_c(blockpartface.field_178242_d));
                set.add(resourcelocation);
            }
        }
        set.add(new ResourceLocation("notenoughupdates", modelBlock.func_178308_c("particle")));
        return set;
    }

    protected IBakedModel bakeModel(ModelBlock modelBlockIn, ITransformation modelRotationIn, boolean uvLocked) {
        TextureAtlasSprite textureatlassprite = this.sprites.get(new ResourceLocation("notenoughupdates", modelBlockIn.func_178308_c("particle")));
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(modelBlockIn).func_177646_a(textureatlassprite);
        for (BlockPart blockpart : modelBlockIn.func_178298_a()) {
            for (EnumFacing enumfacing : blockpart.field_178240_c.keySet()) {
                BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(enumfacing);
                TextureAtlasSprite textureatlassprite1 = this.sprites.get(new ResourceLocation("notenoughupdates", modelBlockIn.func_178308_c(blockpartface.field_178242_d)));
                if (blockpartface.field_178244_b == null || !TRSRTransformation.isInteger((Matrix4f)modelRotationIn.getMatrix())) {
                    simplebakedmodel$builder.func_177648_a(this.makeBakedQuad(blockpart, blockpartface, textureatlassprite1, enumfacing, modelRotationIn, uvLocked));
                    continue;
                }
                simplebakedmodel$builder.func_177650_a(modelRotationIn.rotate(blockpartface.field_178244_b), this.makeBakedQuad(blockpart, blockpartface, textureatlassprite1, enumfacing, modelRotationIn, uvLocked));
            }
        }
        return simplebakedmodel$builder.func_177645_b();
    }

    private BakedQuad makeBakedQuad(BlockPart p_177589_1_, BlockPartFace p_177589_2_, TextureAtlasSprite p_177589_3_, EnumFacing p_177589_4_, ModelRotation p_177589_5_, boolean p_177589_6_) {
        return this.makeBakedQuad(p_177589_1_, p_177589_2_, p_177589_3_, p_177589_4_, (ITransformation)p_177589_5_, p_177589_6_);
    }

    protected BakedQuad makeBakedQuad(BlockPart p_177589_1_, BlockPartFace p_177589_2_, TextureAtlasSprite p_177589_3_, EnumFacing p_177589_4_, ITransformation p_177589_5_, boolean p_177589_6_) {
        return this.faceBakery.makeBakedQuad(p_177589_1_.field_178241_a, p_177589_1_.field_178239_b, p_177589_2_, p_177589_3_, p_177589_4_, p_177589_5_, p_177589_1_.field_178237_d, p_177589_6_, p_177589_1_.field_178238_e);
    }

    private void renderModel(IBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(worldrenderer, model.func_177551_a(enumfacing), color);
        }
        this.renderQuads(worldrenderer, model.func_177550_a(), color);
        tessellator.func_78381_a();
    }

    private void renderQuads(WorldRenderer renderer, List<BakedQuad> quads, int color) {
        for (BakedQuad quad : quads) {
            LightUtil.renderQuadColor((WorldRenderer)renderer, (BakedQuad)quad, (int)color);
        }
    }

    public boolean renderSkull(float xOffset, float yOffset, float zOffset, EnumFacing placedDirection, float rotationDeg, int skullType, GameProfile skullOwner, int damage) {
        if (NotEnoughUpdates.INSTANCE.config.misc.disableSkullRetexturing) {
            return false;
        }
        if (skullType != 3) {
            return false;
        }
        if (skullOwner == null || skullOwner.getId() == null) {
            return false;
        }
        CustomSkull skull = this.customSkulls.get(skullOwner.getId().toString());
        if (skull == null) {
            try {
                skull = this.customSkulls2.get(((Property)skullOwner.getProperties().get((Object)"textures").iterator().next()).getValue());
                if (skull == null) {
                    return false;
                }
            }
            catch (NoSuchElementException e2) {
                return false;
            }
        }
        if (skull.modelBaked != null && skull.model != null) {
            float rot;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.atlas);
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179145_e();
            switch (placedDirection) {
                case NORTH: {
                    GlStateManager.func_179109_b((float)(xOffset + 0.5f), (float)(yOffset + 0.25f), (float)(zOffset + 0.74f));
                    rot = 0.0f;
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179109_b((float)(xOffset + 0.5f), (float)(yOffset + 0.25f), (float)(zOffset + 0.26f));
                    rot = 180.0f;
                    break;
                }
                case WEST: {
                    GlStateManager.func_179109_b((float)(xOffset + 0.74f), (float)(yOffset + 0.25f), (float)(zOffset + 0.5f));
                    rot = 270.0f;
                    break;
                }
                case EAST: {
                    GlStateManager.func_179109_b((float)(xOffset + 0.26f), (float)(yOffset + 0.25f), (float)(zOffset + 0.5f));
                    rot = 90.0f;
                    break;
                }
                default: {
                    GlStateManager.func_179109_b((float)(xOffset + 0.5f), (float)yOffset, (float)(zOffset + 0.5f));
                    rot = rotationDeg;
                }
            }
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.0f);
            if (placedDirection == EnumFacing.UP && (double)xOffset == -0.5 && yOffset == 0.0f && (double)zOffset == -0.5 && rotationDeg == 180.0f) {
                skull.model.func_181682_g().func_181689_a(ItemCameraTransforms.TransformType.HEAD);
            } else {
                skull.model.func_181682_g().func_181689_a(mostRecentTransformType);
            }
            GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
            this.renderModel(skull.modelBaked, -1);
            GlStateManager.func_179121_F();
        } else if (skull.texture != null) {
            if (Minecraft.func_71410_x().func_110434_K().func_110581_b(skull.texture) == null) {
                try {
                    final BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(skull.texture).func_110527_b());
                    final int size = Math.max(image.getHeight(), image.getWidth());
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(skull.texture, (ITextureObject)new AbstractTexture(){

                        public void func_110551_a(IResourceManager resourceManager) {
                            TextureUtil.func_110991_a((int)this.func_110552_b(), (int)size, (int)size);
                            int[] rgb = new int[size * size];
                            image.getRGB(0, 0, image.getWidth(), image.getHeight(), rgb, 0, image.getWidth());
                            TextureUtil.func_110988_a((int)this.func_110552_b(), (int[])rgb, (int)size, (int)size);
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(skull.texture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179109_b((float)(xOffset + 0.5f), (float)yOffset, (float)(zOffset + 0.5f));
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            this.humanoidHead.func_78088_a(null, 0.0f, 0.0f, 0.0f, rotationDeg, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        } else {
            return false;
        }
        return true;
    }

    private static class CustomSkull {
        private ModelBlock model;
        private IBakedModel modelBaked;
        private ResourceLocation texture;

        private CustomSkull() {
        }
    }
}

