/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamerMode {
    private static final Pattern lobbyPattern = Pattern.compile("(mini|mega|m|M)([0-9]{1,3}[A-Z])");

    public static String filterLobbyNames(String line) {
        Matcher matcher = lobbyPattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 2) {
            String lobbyType = matcher.group(1);
            String lobbyId = matcher.group(2);
            long lobbyNum = Long.parseLong(lobbyId.substring(0, lobbyId.length() - 1));
            long obfLobbyNum = (lobbyNum * 9182739L + 11L) % 500L;
            char obfLobbyLetter = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt((int)(obfLobbyNum % 26L));
            line = line.replaceAll("(mini|mega|m|M)([0-9]{1,3}[A-Z])", lobbyType + obfLobbyNum + obfLobbyLetter);
        }
        return line;
    }

    public static String filterScoreboard(String line) {
        line = StreamerMode.filterLobbyNames(Utils.cleanDuplicateColourCodes(line));
        return line;
    }

    public static String filterChat(String line) {
        line = StreamerMode.filterLobbyNames(line);
        return line;
    }
}

