/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.dev;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.ClipboardUtils;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AnimatedSkullExporter {
    static RecordingType recordingState = RecordingType.NOT_RECORDING;
    static ArrayList<NBTTagCompound> skullsList = new ArrayList();
    public static ArrayList<String> lastSkullsList = new ArrayList();
    public static String trackedPlayer = "";

    @SubscribeEvent
    public void onTick(TickEvent event) {
        block9: {
            block8: {
                if (!AnimatedSkullExporter.isRecording()) {
                    return;
                }
                if (Minecraft.func_71410_x().field_71441_e == null) {
                    AnimatedSkullExporter.finishRecording(true, true);
                    return;
                }
                if (recordingState != RecordingType.HEAD) break block8;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                ItemStack currentArmor = player.func_82169_q(3);
                NBTTagCompound skullOwner = AnimatedSkullExporter.getSkullOwner(currentArmor);
                if (skullOwner == null) break block9;
                skullsList.add(skullOwner);
                break block9;
            }
            if (recordingState == RecordingType.PET) {
                for (Entity entity : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
                    ItemStack[] currentArmorS;
                    if (!(entity instanceof EntityArmorStand)) continue;
                    EntityArmorStand armorStand = (EntityArmorStand)entity;
                    for (ItemStack currentArmor : currentArmorS = armorStand.func_70035_c()) {
                        NBTTagCompound skullOwner;
                        String displayName;
                        if (currentArmor == null || !(displayName = currentArmor.func_82833_r()).contains("Head") && !displayName.contains("Lvl") || (skullOwner = AnimatedSkullExporter.getSkullOwner(currentArmor)) == null) continue;
                        skullsList.add(skullOwner);
                    }
                }
            } else if (recordingState == RecordingType.PLAYER) {
                for (Entity entity : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
                    ItemStack currentArmor;
                    NBTTagCompound skullOwner;
                    EntityOtherPlayerMP otherPlayer;
                    if (!(entity instanceof EntityOtherPlayerMP) || !(otherPlayer = (EntityOtherPlayerMP)entity).func_70005_c_().toLowerCase(Locale.ROOT).contains(trackedPlayer.toLowerCase(Locale.ROOT)) || (skullOwner = AnimatedSkullExporter.getSkullOwner(currentArmor = otherPlayer.func_82169_q(3))) == null) continue;
                    skullsList.add(skullOwner);
                }
            }
        }
    }

    public static void startRecordingPlayer(String name) {
        trackedPlayer = name;
        AnimatedSkullExporter.startRecording(RecordingType.PLAYER);
    }

    public static void startRecording(RecordingType recordingType) {
        if (AnimatedSkullExporter.isRecording()) {
            AnimatedSkullExporter.restartRecording(recordingType);
            return;
        }
        if (recordingType == RecordingType.HEAD) {
            recordingState = RecordingType.HEAD;
            Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] Started recording skull frames"));
        } else if (recordingType == RecordingType.PET) {
            recordingState = RecordingType.PET;
            Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] Started recording pet skull frames"));
            Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] Make sure you are near NO OTHER armour stands"));
            Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] The corner of my island /visit throwpo works"));
        } else if (recordingType == RecordingType.PLAYER) {
            recordingState = RecordingType.PLAYER;
            Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] Started recording " + trackedPlayer + "'s skull frames"));
        }
        Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] Wait for the animation to play out"));
        Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] Use /neuskull stop to stop recording"));
    }

    public static void restartRecording(RecordingType recordingType) {
        Utils.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] Restarting..."));
        AnimatedSkullExporter.finishRecording(false, true);
        AnimatedSkullExporter.startRecording(recordingType);
    }

    public static void finishRecording(boolean save, boolean recordExisting) {
        trackedPlayer = "";
        recordingState = RecordingType.NOT_RECORDING;
        ArrayList<NBTTagCompound> noDuplicates = AnimatedSkullExporter.removeDuplicates(skullsList);
        if (save) {
            JsonArray jsonArray = new JsonArray();
            for (NBTTagCompound noDuplicate : noDuplicates) {
                String id = noDuplicate.func_74779_i("Id");
                String value = noDuplicate.func_74775_l("Properties").func_150295_c("textures", 10).func_150305_b(0).func_74779_i("Value");
                if (!recordExisting && AnimatedSkullExporter.checkIfAlreadyInConstant(id, value)) continue;
                jsonArray.add(new JsonPrimitive(id + ":" + value));
            }
            if (jsonArray.size() == 0) {
                Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] No skull frames recorded.");
                skullsList.clear();
                return;
            }
            Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] " + jsonArray.size() + " skull frame" + (jsonArray.size() == 1 ? "" : "s") + " copied to clipboard.");
            ClipboardUtils.copyToClipboard(jsonArray.toString());
            lastSkullsList.clear();
            for (int i = 0; i < jsonArray.size(); ++i) {
                lastSkullsList.add(jsonArray.get(i).getAsString());
            }
        }
        skullsList.clear();
    }

    static boolean checkIfAlreadyInConstant(String id, String value) {
        JsonObject animatedskulls = Constants.ANIMATEDSKULLS;
        if (animatedskulls == null) {
            return false;
        }
        if (!animatedskulls.has("skins")) {
            return false;
        }
        JsonObject skins = animatedskulls.get("skins").getAsJsonObject();
        for (Map.Entry<String, JsonElement> stringJsonElementEntry : skins.entrySet()) {
            JsonArray textures = skins.get(stringJsonElementEntry.getKey()).getAsJsonObject().get("textures").getAsJsonArray();
            for (JsonElement texture : textures) {
                String textureStr = texture.getAsString();
                String[] split = textureStr.split(":");
                if (split.length == 1 || !value.equals(split[1])) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList<NBTTagCompound> removeDuplicates(ArrayList<NBTTagCompound> list) {
        LinkedHashSet<NBTTagCompound> set = new LinkedHashSet<NBTTagCompound>();
        set.addAll(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public static NBTTagCompound getSkullOwner(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151144_bL && stack.func_77942_o() && stack.func_77978_p().func_74764_b("SkullOwner")) {
            return stack.func_77978_p().func_74775_l("SkullOwner");
        }
        return null;
    }

    public static boolean isRecording() {
        return recordingState != RecordingType.NOT_RECORDING;
    }

    public static enum RecordingType {
        NOT_RECORDING,
        HEAD,
        PET,
        PLAYER;

    }
}

