/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.inventory;

import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.GuiContainerBackgroundDrawnEvent;
import io.github.moulberry.notenoughupdates.events.ReplaceItemEvent;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.options.separatesections.Museum;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.LRUCache;
import io.github.moulberry.notenoughupdates.util.MuseumUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020%H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tRr\u0010\n\u001af\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r \u0007*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e \u0007*2\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r \u0007*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\n \u0007*\u0004\u0018\u00010\u00100\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumItemHighlighter;", "", "()V", "MUSEUM_HYDRATED_ITEM_TAG", "", "config", "Lio/github/moulberry/notenoughupdates/options/separatesections/Museum;", "kotlin.jvm.PlatformType", "getConfig", "()Lio/github/moulberry/notenoughupdates/options/separatesections/Museum;", "findRawItemForName", "Lio/github/moulberry/notenoughupdates/util/LRUCache;", "Lkotlin/Pair;", "", "Lnet/minecraft/item/ItemStack;", "manager", "Lio/github/moulberry/notenoughupdates/NEUManager;", "getManager", "()Lio/github/moulberry/notenoughupdates/NEUManager;", "findRawItemForName0", "arg", "getHighlightColor", "", "hydrateMuseumItem", "rawItem", "original", "isCompletedRetrievedItem", "itemStack", "isHydratedMuseumItem", "stack", "onBackgroundDrawn", "", "event", "Lio/github/moulberry/notenoughupdates/events/GuiContainerBackgroundDrawnEvent;", "onItemOverride", "Lio/github/moulberry/notenoughupdates/events/ReplaceItemEvent;", "onRepositoryReload", "Lio/github/moulberry/notenoughupdates/events/RepositoryReloadEvent;", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nMuseumItemHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MuseumItemHighlighter.kt\nio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumItemHighlighter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class MuseumItemHighlighter {
    @NotNull
    public static final MuseumItemHighlighter INSTANCE = new MuseumItemHighlighter();
    private static final LRUCache<Pair<String, Boolean>, ItemStack> findRawItemForName = LRUCache.memoize(INSTANCE::findRawItemForName0, 56);
    @NotNull
    public static final String MUSEUM_HYDRATED_ITEM_TAG = "NEU_HYDRATED_MUSEUM_ITEM";

    private MuseumItemHighlighter() {
    }

    private final NEUManager getManager() {
        return NotEnoughUpdates.INSTANCE.manager;
    }

    private final Museum getConfig() {
        return NotEnoughUpdates.INSTANCE.config.museum;
    }

    private final int getHighlightColor() {
        return ChromaColour.specialToChromaRGB(this.getConfig().museumItemColor);
    }

    @SubscribeEvent
    public final void onRepositoryReload(@NotNull RepositoryReloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        findRawItemForName.clearCache();
    }

    private final ItemStack findRawItemForName0(Pair<String, Boolean> arg) {
        ItemStack itemStack;
        String name = (String)arg.component1();
        boolean armor = (Boolean)arg.component2();
        String string = (String)CollectionsKt.firstOrNull(MuseumUtil.INSTANCE.findItemsByName(name, armor));
        if (string != null) {
            String it = string;
            boolean bl = false;
            itemStack = INSTANCE.getManager().createItem(it);
        } else {
            itemStack = null;
        }
        return itemStack;
    }

    @SubscribeEvent
    public final void onItemOverride(@NotNull ReplaceItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        if (!this.getConfig().museumItemShow) {
            return;
        }
        IInventory iInventory = event.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)iInventory, (String)"event.inventory");
        if (!MuseumUtil.INSTANCE.isMuseumInventory(iInventory)) {
            return;
        }
        ItemStack itemStack = event.getOriginal();
        if (itemStack == null) {
            return;
        }
        ItemStack original = itemStack;
        if (!this.isCompletedRetrievedItem(original)) {
            return;
        }
        String string = StringUtils.cleanColour(event.getInventory().func_145748_c_().func_150260_c());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanColour(event.invent\u2026playName.unformattedText)");
        boolean armor = StringsKt.endsWith$default((String)string, (String)"Armor Sets", (boolean)false, (int)2, null);
        ItemStack itemStack2 = (ItemStack)findRawItemForName.apply(TuplesKt.to((Object)original.func_82833_r(), (Object)armor));
        if (itemStack2 == null) {
            return;
        }
        ItemStack rawItem = itemStack2;
        ItemStack hydratedItem = this.hydrateMuseumItem(rawItem, original);
        event.replaceWith(hydratedItem);
    }

    public final boolean isCompletedRetrievedItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return itemStack.func_82837_s() && Intrinsics.areEqual((Object)itemStack.func_77973_b(), (Object)Items.field_151100_aR) && EnumDyeColor.func_176766_a((int)itemStack.func_77952_i()) == EnumDyeColor.LIME;
    }

    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerBackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        GuiContainer guiContainer = event.container;
        if (guiContainer == null) {
            return;
        }
        GuiContainer egui = guiContainer;
        Container container = egui.field_147002_h;
        ContainerChest containerChest = container instanceof ContainerChest ? (ContainerChest)container : null;
        if (containerChest == null) {
            return;
        }
        ContainerChest chest = containerChest;
        if (!this.getConfig().museumItemShow) {
            return;
        }
        IInventory iInventory = chest.func_85151_d();
        Intrinsics.checkNotNullExpressionValue((Object)iInventory, (String)"chest.lowerChestInventory");
        if (!MuseumUtil.INSTANCE.isMuseumInventory(iInventory)) {
            return;
        }
        int fixedHighlightColor = this.getHighlightColor();
        for (Slot slot : chest.field_75151_b) {
            if (slot == null || slot.func_75211_c() == null) continue;
            ItemStack itemStack = slot.func_75211_c();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"slot.stack");
            if (!this.isHydratedMuseumItem(itemStack)) {
                ItemStack itemStack2 = slot.func_75211_c();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"slot.stack");
                if (!this.isCompletedRetrievedItem(itemStack2)) continue;
            }
            int left = slot.field_75223_e;
            int top = slot.field_75221_f;
            Gui.func_73734_a((int)left, (int)top, (int)(left + 16), (int)(top + 16), (int)fixedHighlightColor);
        }
    }

    public final ItemStack hydrateMuseumItem(@NotNull ItemStack rawItem, @NotNull ItemStack original) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)rawItem, (String)"rawItem");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        ItemStack $this$hydrateMuseumItem_u24lambda_u241 = itemStack = rawItem.func_77946_l();
        boolean bl = false;
        $this$hydrateMuseumItem_u24lambda_u241.func_151001_c(original.func_82833_r());
        List<String> list = ItemUtils.getLore(original);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLore(original)");
        List originalLore = CollectionsKt.toMutableList((Collection)list);
        ItemUtils.setLore($this$hydrateMuseumItem_u24lambda_u241, originalLore);
        NBTTagCompound data = ItemUtils.getOrCreateTag($this$hydrateMuseumItem_u24lambda_u241);
        NBTTagCompound extraAttributes = data.func_74775_l("ExtraAttributes");
        extraAttributes.func_74774_a("donated_museum", (byte)1);
        data.func_74782_a("ExtraAttributes", (NBTBase)extraAttributes);
        data.func_74757_a(MUSEUM_HYDRATED_ITEM_TAG, true);
        return itemStack;
    }

    public final boolean isHydratedMuseumItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return ItemUtils.getOrCreateTag(stack).func_74767_n(MUSEUM_HYDRATED_ITEM_TAG);
    }
}

