/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.hex;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GlScissorStack;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingFloat;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingInteger;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.HexPriceWarning;
import io.github.moulberry.notenoughupdates.miscfeatures.SlotLocking;
import io.github.moulberry.notenoughupdates.miscgui.hex.EnchantState;
import io.github.moulberry.notenoughupdates.miscgui.hex.HexItem;
import io.github.moulberry.notenoughupdates.miscgui.hex.ItemType;
import io.github.moulberry.notenoughupdates.miscgui.util.OrbDisplay;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C0EPacketClickWindow;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.glu.Project;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class GuiCustomHex
extends Gui {
    private static final GuiCustomHex INSTANCE = new GuiCustomHex();
    private static final ResourceLocation TEXTURE = new ResourceLocation("notenoughupdates:custom_enchant_gui.png");
    private static final ResourceLocation ENCHANTMENT_TABLE_BOOK_TEXTURE = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private static final ModelBook MODEL_BOOK = new ModelBook();
    private static final Pattern XP_COST_PATTERN = Pattern.compile("\\u00a73(\\d+) Exp Levels");
    private static final Pattern DISCOUNT_COST_PATTERN = Pattern.compile("\\u00a78\\u00a7m(\\d+)\\u00a73 (\\d+) Exp Levels");
    private static final Pattern ENCHANT_LEVEL_PATTERN = Pattern.compile("(.*)_(.*)");
    private static final Pattern ENCHANT_NAME_PATTERN = Pattern.compile("([^IVX]*) ([IVX]*)");
    public OrbDisplay orbDisplay = new OrbDisplay();
    private int guiLeft;
    private int guiTop;
    private boolean shouldOverrideFast = false;
    private boolean shouldOverrideET = false;
    private boolean shouldOverrideGemstones = false;
    private boolean shouldOverrideXp = false;
    public float pageOpen;
    public float pageOpenLast;
    public float pageOpenRandom;
    public float pageOpenVelocity;
    public float bookOpen;
    public float bookOpenLast;
    private int currentPage;
    private int expectedMaxPage;
    private boolean isScrollingLeft = true;
    private ItemStack enchantingItem = null;
    private int removingEnchantPlayerLevel = -1;
    private final GuiElementTextField searchField = new GuiElementTextField("", 128);
    private final HashMap<String, Integer> playerEnchantIds = new HashMap();
    private boolean searchRemovedFromApplicable = false;
    private boolean searchRemovedFromRemovable = false;
    private final List<Enchantment> applicable = new ArrayList<Enchantment>();
    private final List<Enchantment> removable = new ArrayList<Enchantment>();
    private final List<HexItem> applicableItem = new ArrayList<HexItem>();
    private final List<HexItem> removableItem = new ArrayList<HexItem>();
    private final HashMap<Integer, Enchantment> enchanterEnchLevels = new HashMap();
    private final HashMap<Integer, HexItem> enchanterItemLevels = new HashMap();
    private Enchantment enchanterCurrentEnch = null;
    private HexItem enchanterCurrentItem = null;
    public Random random = new Random();
    private EnchantState currentState = EnchantState.NO_ITEM;
    private EnchantState lastState = EnchantState.NO_ITEM;
    private final LerpingInteger leftScroll = new LerpingInteger(0, 150);
    private final LerpingInteger rightScroll = new LerpingInteger(0, 150);
    private final LerpingFloat arrowAmount = new LerpingFloat(0.0f, 100);
    private static final int X_SIZE = 364;
    private static final int Y_SIZE = 215;
    private int clickedScrollOffset = -1;
    private boolean isClickedScrollLeft = true;
    private boolean isChangingEnchLevel = false;
    private long cancelButtonAnimTime = 0L;
    private long confirmButtonAnimTime = 0L;
    private int tickCounter = 0;

    public static GuiCustomHex getInstance() {
        return INSTANCE;
    }

    public boolean shouldOverride(String containerName) {
        if (containerName == null) {
            this.shouldOverrideET = false;
            this.shouldOverrideFast = false;
            this.shouldOverrideGemstones = false;
            this.shouldOverrideXp = false;
            this.searchField.setText("");
            return false;
        }
        boolean config = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableHexGUI;
        ArrayList<String> gemList = new ArrayList<String>(Arrays.asList("\u2764", "\u2748", "\u270e", "\u2618", "\u2e15", "\u2727", "\u2741", "\u2742"));
        this.shouldOverrideFast = config && containerName.length() >= 7 && Objects.equals("The Hex", containerName.substring(0, "The Hex".length())) && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard();
        this.shouldOverrideET = config && containerName.length() >= 12 && Objects.equals("Enchant Item", containerName.substring(0, "Enchant Item".length())) && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard();
        boolean bl = this.shouldOverrideGemstones = config && containerName.length() >= 12 && Objects.equals("Gemstones \u279c", containerName.substring(0, "Gemstones \u279c".length())) && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard();
        if (this.shouldOverrideGemstones) {
            for (String string : gemList) {
                if (!containerName.contains(string)) continue;
                this.shouldOverrideGemstones = false;
                break;
            }
        }
        this.shouldOverrideXp = config && containerName.length() >= 21 && Objects.equals("Bottles of Enchanting", containerName.substring(0, "Bottles of Enchanting".length())) && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard();
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        ItemStack hexStack = cc.func_85151_d().func_70301_a(50);
        ItemStack bookStack = cc.func_85151_d().func_70301_a(32);
        if (bookStack != null && bookStack.func_77973_b() == Items.field_151122_aG) {
            this.shouldOverrideGemstones = false;
        }
        if (hexStack != null && hexStack.func_77973_b() == Items.field_151062_by) {
            return this.shouldOverrideET || this.shouldOverrideFast;
        }
        if (!(this.shouldOverrideFast || this.shouldOverrideET || this.shouldOverrideGemstones || this.shouldOverrideXp)) {
            this.currentState = EnchantState.NO_ITEM;
            this.applicable.clear();
            this.removable.clear();
            this.applicableItem.clear();
            this.removableItem.clear();
            this.expectedMaxPage = 1;
            this.enchanterCurrentItem = null;
            this.searchField.setText("");
        }
        return this.shouldOverrideFast || this.shouldOverrideGemstones || this.shouldOverrideXp;
    }

    public void tick(String containerName) {
        if (containerName.equals("The Hex")) {
            this.currentState = EnchantState.HAS_ITEM_IN_HEX;
            this.tickHex();
        } else if (containerName.contains("Enchant Item")) {
            this.tickEnchants();
        } else if (containerName.contains("Books") || containerName.contains("Modifiers") || containerName.contains("Reforges") || containerName.contains("Item Upgrades") || containerName.equals("Bottles of Enchanting")) {
            this.tickBooks();
        } else if (containerName.contains("Gemstones")) {
            this.tickGemstones();
        } else {
            this.tickBooks();
        }
    }

    private void tickEnchants() {
        boolean updateItems;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        ItemStack enchantingItemStack = cc.func_85151_d().func_70301_a(19);
        ItemStack hopperStack = cc.func_85151_d().func_70301_a(51);
        int lastPage = this.currentPage;
        this.lastState = this.currentState;
        if (hopperStack != null && hopperStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150438_bZ) && this.enchantingItem != null) {
            this.currentState = EnchantState.ADDING_ENCHANT;
        } else if (enchantingItemStack == null) {
            this.currentState = this.currentState == EnchantState.SWITCHING_DONT_UPDATE || this.currentState == EnchantState.NO_ITEM ? EnchantState.NO_ITEM : EnchantState.SWITCHING_DONT_UPDATE;
        } else {
            ItemStack sanityCheckStack = cc.func_85151_d().func_70301_a(12);
            if (sanityCheckStack == null || sanityCheckStack.func_77973_b() == Items.field_151134_bR) {
                this.currentState = EnchantState.HAS_ITEM;
                this.enchantingItem = enchantingItemStack;
            } else {
                this.currentState = EnchantState.SWITCHING_DONT_UPDATE;
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM) {
            ItemStack pageUpStack = cc.func_85151_d().func_70301_a(17);
            ItemStack pageDownStack = cc.func_85151_d().func_70301_a(35);
            if (pageUpStack != null && pageDownStack != null) {
                this.currentPage = 0;
                boolean upIsGlass = pageUpStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                boolean downIsGlass = pageDownStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                int page = -1;
                this.expectedMaxPage = 1;
                if (!downIsGlass) {
                    try {
                        page = Integer.parseInt(Utils.getRawTooltip(pageDownStack).get(1).substring(11)) - 1;
                        this.expectedMaxPage = page + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (page == -1 && !upIsGlass) {
                    try {
                        this.expectedMaxPage = page = Integer.parseInt(Utils.getRawTooltip(pageUpStack).get(1).substring(11)) + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentPage = page == -1 ? 1 : page;
            }
        }
        this.orbDisplay.physicsTickOrbs();
        if (++this.tickCounter >= 20) {
            this.tickCounter = 0;
        }
        boolean bl = updateItems = this.tickCounter == 0;
        if (this.currentState == EnchantState.ADDING_ENCHANT) {
            if (this.arrowAmount.getTarget() != 1.0f) {
                this.arrowAmount.setTarget(1.0f);
                this.arrowAmount.resetTimer();
            }
        } else if (this.arrowAmount.getTarget() != 0.0f) {
            this.arrowAmount.setTarget(0.0f);
            this.arrowAmount.resetTimer();
        }
        if (this.lastState != this.currentState || lastPage != this.currentPage) {
            this.leftScroll.setValue(0);
            this.rightScroll.setValue(0);
            updateItems = true;
        }
        if (updateItems && this.currentState != EnchantState.SWITCHING_DONT_UPDATE) {
            this.enchanterEnchLevels.clear();
            if (this.enchantingItem != null) {
                NBTTagCompound enchantments;
                NBTTagCompound ea;
                this.playerEnchantIds.clear();
                NBTTagCompound tag = this.enchantingItem.func_77978_p();
                if (tag != null && (ea = tag.func_74775_l("ExtraAttributes")) != null && (enchantments = ea.func_74775_l("enchantments")) != null) {
                    for (String enchId : enchantments.func_150296_c()) {
                        this.playerEnchantIds.put(enchId, enchantments.func_74762_e(enchId));
                    }
                }
            }
            if (this.currentState == EnchantState.ADDING_ENCHANT) {
                this.removingEnchantPlayerLevel = -1;
                boolean updateLevel = this.enchanterCurrentEnch == null;
                boolean hasXpBottle = false;
                for (int i = 0; i < 27; ++i) {
                    NBTTagCompound enchantments;
                    NBTTagCompound ea;
                    NBTTagCompound tagBook;
                    int slotIndex = 9 + i;
                    ItemStack book = cc.func_85151_d().func_70301_a(slotIndex);
                    ItemStack xpBottle = cc.func_85151_d().func_70301_a(50);
                    if (!hasXpBottle && xpBottle != null && xpBottle.func_77973_b() == Items.field_151062_by) {
                        String name = "Buy Xp Bottles";
                        String id = "XP_BOTTLE";
                        Enchantment xpBottleEnch = new Enchantment(50, name, id, Utils.getRawTooltip(xpBottle), 1, true, false);
                        boolean hasHasXpBottle = false;
                        for (Enchantment ench : this.applicable) {
                            if (!ench.enchId.equals("XP_BOTTLE")) continue;
                            hasHasXpBottle = true;
                            break;
                        }
                        if (!hasHasXpBottle) {
                            this.applicable.add(xpBottleEnch);
                        }
                        hasXpBottle = true;
                    }
                    if (book == null || book.func_77973_b() != Items.field_151134_bR || (tagBook = book.func_77978_p()) == null || (ea = tagBook.func_74775_l("ExtraAttributes")) == null || (enchantments = ea.func_74775_l("enchantments")) == null) continue;
                    String enchId = Utils.cleanColour(book.func_82833_r()).toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_").replaceAll("[^a-z_]", "");
                    String name = Utils.cleanColour(book.func_82833_r());
                    int enchLevel = -1;
                    if (name.equalsIgnoreCase("Bane of Arthropods")) {
                        name = "Bane of Arth.";
                    } else if (name.equalsIgnoreCase("Projectile Protection")) {
                        name = "Projectile Prot";
                    } else if (name.equalsIgnoreCase("Blast Protection")) {
                        name = "Blast Prot";
                    } else if (name.equalsIgnoreCase("Turbo-Mushrooms")) {
                        name = "Turbo-Mush";
                    }
                    Matcher levelMatcher = ENCHANT_LEVEL_PATTERN.matcher(enchId);
                    if (levelMatcher.matches()) {
                        enchLevel = Utils.parseRomanNumeral(levelMatcher.group(2).toUpperCase(Locale.ROOT));
                        enchId = levelMatcher.group(1);
                    }
                    Enchantment enchantment = new Enchantment(slotIndex, name, enchId, Utils.getRawTooltip(book), enchLevel, false, true);
                    int index = 0;
                    for (String lore : enchantment.displayLore) {
                        if (lore.contains("N/A") && enchantment.price > 0) {
                            String price = StringUtils.formatNumber(enchantment.price);
                            enchantment.displayLore.set(index, "\u00a76" + price + ".0 Coins");
                        }
                        if (lore.contains("Loading...")) {
                            if (enchantment.price > 0) {
                                enchantment.displayLore.set(index, "\u00a7eClick to buy on the Bazaar!");
                            } else {
                                enchantment.displayLore.set(index, "\u00a7cNot enough supply on the Bazaar!");
                            }
                        }
                        ++index;
                    }
                    enchantment.displayLore.remove(0);
                    if (this.removingEnchantPlayerLevel == -1 && this.playerEnchantIds.containsKey(enchId)) {
                        this.removingEnchantPlayerLevel = this.playerEnchantIds.get(enchId);
                    }
                    if (this.removingEnchantPlayerLevel >= 0 && enchantment.level < this.removingEnchantPlayerLevel) continue;
                    boolean aboveMaxLevelFromEt = false;
                    if (NotEnoughUpdates.INSTANCE.config.enchantingSolvers.maxEnchLevel && Constants.ENCHANTS != null) {
                        JsonObject maxLevel = null;
                        if (Constants.ENCHANTS.has("max_xp_table_levels")) {
                            maxLevel = Constants.ENCHANTS.getAsJsonObject("max_xp_table_levels");
                        }
                        if (maxLevel != null && maxLevel.has(enchId) && enchantment.level > maxLevel.get(enchId).getAsInt()) {
                            aboveMaxLevelFromEt = true;
                        }
                    }
                    if (this.enchanterCurrentEnch == null) {
                        this.enchanterCurrentEnch = enchantment;
                    } else if (updateLevel) {
                        if (this.removingEnchantPlayerLevel < 0 && enchantment.level > this.enchanterCurrentEnch.level && !aboveMaxLevelFromEt) {
                            this.enchanterCurrentEnch = enchantment;
                        } else if (this.removingEnchantPlayerLevel >= 0 && enchantment.level < this.enchanterCurrentEnch.level) {
                            this.enchanterCurrentEnch = enchantment;
                        }
                    }
                    this.enchanterEnchLevels.put(enchantment.level, enchantment);
                }
                if (this.enchanterCurrentEnch != null && this.removingEnchantPlayerLevel >= 0) {
                    for (String line : this.enchanterCurrentEnch.displayLore) {
                        Matcher matcher = XP_COST_PATTERN.matcher(line);
                        Matcher discount_matcher = DISCOUNT_COST_PATTERN.matcher(line);
                        if (matcher.find()) {
                            this.enchanterCurrentEnch.xpCost = Integer.parseInt(matcher.group(1));
                            continue;
                        }
                        if (!discount_matcher.find()) continue;
                        this.enchanterCurrentEnch.xpCost = Integer.parseInt(discount_matcher.group(2));
                    }
                }
            } else {
                this.isChangingEnchLevel = false;
                this.enchanterCurrentEnch = null;
                this.searchRemovedFromRemovable = false;
                this.searchRemovedFromApplicable = false;
                this.applicable.clear();
                this.removable.clear();
                boolean hasXpBottle = false;
                if (this.currentState == EnchantState.HAS_ITEM) {
                    for (int i = 0; i < 15; ++i) {
                        String enchId;
                        NBTTagCompound enchantments;
                        NBTTagCompound ea;
                        NBTTagCompound tagBook;
                        int slotIndex = 12 + i % 5 + i / 5 * 9;
                        ItemStack book = cc.func_85151_d().func_70301_a(slotIndex);
                        ItemStack xpBottle = cc.func_85151_d().func_70301_a(50);
                        if (!hasXpBottle && xpBottle != null && xpBottle.func_77973_b() == Items.field_151062_by) {
                            String name = "Buy Xp Bottles";
                            String id = "XP_BOTTLE";
                            Enchantment xpBottleEnch = new Enchantment(50, name, id, Utils.getRawTooltip(xpBottle), 1, true, false);
                            this.applicable.add(xpBottleEnch);
                            hasXpBottle = true;
                        }
                        if (book == null || (tagBook = book.func_77978_p()) == null || (ea = tagBook.func_74775_l("ExtraAttributes")) == null || (enchantments = ea.func_74775_l("enchantments")) == null || (enchId = Utils.cleanColour(book.func_82833_r()).toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_").replaceAll("[^a-z_]", "")).equalsIgnoreCase("_")) continue;
                        enchId = ItemUtils.fixEnchantId(enchId, true);
                        String name = Utils.cleanColour(book.func_82833_r());
                        if (this.searchField.getText().trim().isEmpty() || name.toLowerCase(Locale.ROOT).contains(this.searchField.getText().trim().toLowerCase(Locale.ROOT))) {
                            Enchantment enchantment;
                            if (name.equalsIgnoreCase("Bane of Arthropods")) {
                                name = "Bane of Arth.";
                            } else if (name.equalsIgnoreCase("Projectile Protection")) {
                                name = "Projectile Prot";
                            } else if (name.equalsIgnoreCase("Blast Protection")) {
                                name = "Blast Prot";
                            } else if (name.equalsIgnoreCase("Turbo-Mushrooms")) {
                                name = "Turbo-Mush";
                            }
                            Matcher nameMatcher = ENCHANT_NAME_PATTERN.matcher(name);
                            if (nameMatcher.matches()) {
                                name = nameMatcher.group(1);
                            }
                            if (this.playerEnchantIds.containsKey(enchId)) {
                                enchantment = new Enchantment(slotIndex, name, enchId, Utils.getRawTooltip(book), this.playerEnchantIds.get(enchId), false, false);
                                if (enchantment.overMaxLevel) continue;
                                this.removable.add(enchantment);
                                continue;
                            }
                            enchantment = new Enchantment(slotIndex, name, enchId, Utils.getRawTooltip(book), 1, true, true);
                            this.applicable.add(enchantment);
                            continue;
                        }
                        if (this.playerEnchantIds.containsKey(enchId)) {
                            this.searchRemovedFromRemovable = true;
                            continue;
                        }
                        this.searchRemovedFromApplicable = true;
                    }
                    NEUConfig cfg = NotEnoughUpdates.INSTANCE.config;
                    int mult = cfg.enchantingSolvers.enchantOrdering == 0 ? 1 : -1;
                    Comparator<Enchantment> comparator = cfg.enchantingSolvers.enchantSorting == 0 ? Comparator.comparingInt(e2 -> mult * e2.xpCost) : (c1, c2) -> mult * c1.enchId.toLowerCase(Locale.ROOT).compareTo(c2.enchId.toLowerCase(Locale.ROOT));
                    this.removable.sort(comparator);
                    this.applicable.sort(comparator);
                }
            }
        }
        if (this.lastState != this.currentState) {
            do {
                this.pageOpenRandom += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (!(this.pageOpen > this.pageOpenRandom + 1.0f) && !(this.pageOpen < this.pageOpenRandom - 1.0f));
        }
        this.pageOpenLast = this.pageOpen;
        this.bookOpenLast = this.bookOpen;
        this.bookOpen = this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT ? (this.bookOpen += 0.2f) : (this.bookOpen -= 0.2f);
        this.bookOpen = MathHelper.func_76131_a((float)this.bookOpen, (float)0.0f, (float)1.0f);
        float f1 = (this.pageOpenRandom - this.pageOpen) * 0.4f;
        f1 = MathHelper.func_76131_a((float)f1, (float)-0.2f, (float)0.2f);
        this.pageOpenVelocity += (f1 - this.pageOpenVelocity) * 0.9f;
        this.pageOpen += this.pageOpenVelocity;
    }

    private void tickBooks() {
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        ItemStack enchantingItemStack = cc.func_85151_d().func_70301_a(19);
        ItemStack anvilStack = cc.func_85151_d().func_70301_a(28);
        this.lastState = this.currentState;
        if (anvilStack != null && anvilStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150467_bQ) && this.currentState != EnchantState.ADDING_BOOK) {
            this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
            this.enchantingItem = enchantingItemStack;
        } else if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS && this.enchantingItem == null && enchantingItemStack != null) {
            this.enchantingItem = enchantingItemStack;
        } else if (anvilStack != null && anvilStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150381_bn) && this.currentState != EnchantState.ADDING_BOOK) {
            this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
            this.enchantingItem = enchantingItemStack;
        }
        this.orbDisplay.physicsTickOrbs();
        if (++this.tickCounter >= 20) {
            this.tickCounter = 0;
        }
        if (this.currentState == EnchantState.ADDING_BOOK) {
            if (this.arrowAmount.getTarget() != 1.0f) {
                this.arrowAmount.setTarget(1.0f);
                this.arrowAmount.resetTimer();
            }
        } else if (this.arrowAmount.getTarget() != 0.0f) {
            this.arrowAmount.setTarget(0.0f);
            this.arrowAmount.resetTimer();
        }
        if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS) {
            ItemStack pageUpStack = cc.func_85151_d().func_70301_a(17);
            ItemStack pageDownStack = cc.func_85151_d().func_70301_a(35);
            if (pageUpStack != null && pageDownStack != null) {
                this.currentPage = 0;
                boolean upIsGlass = pageUpStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                boolean downIsGlass = pageDownStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                int page = -1;
                this.expectedMaxPage = 1;
                if (!downIsGlass) {
                    try {
                        page = Integer.parseInt(Utils.getRawTooltip(pageDownStack).get(1).substring(11)) - 1;
                        this.expectedMaxPage = page + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (page == -1 && !upIsGlass) {
                    try {
                        this.expectedMaxPage = page = Integer.parseInt(Utils.getRawTooltip(pageUpStack).get(1).substring(11)) + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentPage = page == -1 ? 1 : page;
            }
        }
        this.isChangingEnchLevel = false;
        this.searchRemovedFromRemovable = false;
        this.searchRemovedFromApplicable = false;
        if (this.applicableItem.size() < 6) {
            this.leftScroll.setValue(0);
        }
        this.applicableItem.clear();
        this.removableItem.clear();
        if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS || this.currentState == EnchantState.ADDING_BOOK) {
            boolean hasRandomReforge = false;
            for (int i = 0; i < 15; ++i) {
                NBTTagCompound enchantments;
                NBTTagCompound ea;
                NBTTagCompound tagBook;
                int slotIndex = 12 + i % 5 + i / 5 * 9;
                ItemStack book = cc.func_85151_d().func_70301_a(slotIndex);
                ItemStack randomReforge = cc.func_85151_d().func_70301_a(48);
                if (!hasRandomReforge && randomReforge != null && randomReforge.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150467_bQ)) {
                    String name = Utils.cleanColour(randomReforge.func_82833_r());
                    String id = Utils.cleanColour(randomReforge.func_82833_r());
                    if (name.equals("Convert to Dungeon Item")) {
                        name = "Dungeonize Item";
                        id = "CONVERT_TO_DUNGEON";
                    } else if (name.equals("Random Basic Reforge")) {
                        name = "Basic Reforge";
                        id = "RANDOM_REFORGE";
                    }
                    HexItem reforgeItem = new HexItem(48, name, id, Utils.getRawTooltip(randomReforge), true, true);
                    boolean hasAdded = false;
                    for (String lore : reforgeItem.displayLore) {
                        if (!lore.contains("This item is already a Dungeon")) continue;
                        this.removableItem.add(reforgeItem);
                        hasAdded = true;
                        break;
                    }
                    if (!hasAdded) {
                        this.applicableItem.add(reforgeItem);
                    }
                    hasRandomReforge = true;
                }
                if (book == null || (tagBook = book.func_77978_p()) == null || (ea = tagBook.func_74775_l("ExtraAttributes")) == null || (enchantments = ea.func_74775_l("enchantments")) == null) continue;
                String itemId = Utils.cleanColour(book.func_82833_r()).toUpperCase(Locale.ROOT).replace(" ", "_").replace("-", "_");
                String name = Utils.cleanColour(book.func_82833_r());
                if (itemId.equalsIgnoreCase("_") || itemId.equalsIgnoreCase("Item_Maxed_Out")) continue;
                if (this.searchField.getText().trim().isEmpty() || name.toLowerCase(Locale.ROOT).contains(this.searchField.getText().trim().toLowerCase(Locale.ROOT))) {
                    name = this.fixName(name);
                    HexItem item = new HexItem(slotIndex, name, itemId, Utils.getRawTooltip(book), true, true);
                    this.enchanterItemLevels.put(item.level, item);
                    if (item.itemType != ItemType.UNKNOWN) {
                        NBTTagCompound extra;
                        NBTTagCompound tagItem;
                        int potatoCount = 0;
                        int killCount = 0;
                        int warCount = 0;
                        int ffdCount = 0;
                        int recombCount = 0;
                        int effLevel = 0;
                        int starCount = 0;
                        int singularityCount = 0;
                        int tunerCount = 0;
                        int peaceCount = 0;
                        int manaDisintegratorCount = 0;
                        boolean shadowWarp = false;
                        boolean witherShield = false;
                        boolean implosion = false;
                        String reforge = "";
                        if (this.enchantingItem != null && (tagItem = this.enchantingItem.func_77978_p()) != null && (extra = tagItem.func_74775_l("ExtraAttributes")) != null) {
                            potatoCount = extra.func_74762_e("hot_potato_count");
                            killCount = extra.func_74762_e("stats_book");
                            warCount = extra.func_74762_e("art_of_war_count");
                            ffdCount = extra.func_74762_e("farming_for_dummies_count");
                            recombCount = extra.func_74762_e("rarity_upgrades");
                            starCount = extra.func_74762_e("upgrade_level");
                            singularityCount = extra.func_74762_e("wood_singularity_count");
                            tunerCount = extra.func_74762_e("tuned_transmission");
                            peaceCount = extra.func_74762_e("art_of_peace_count");
                            manaDisintegratorCount = extra.func_74762_e("mana_disintegrator_count");
                            reforge = extra.func_74779_i("modifier");
                            NBTTagCompound enchs = extra.func_74775_l("enchantments");
                            NBTTagList scrolls = extra.func_150295_c("ability_scroll", 8);
                            if (enchs != null) {
                                effLevel = enchs.func_74762_e("efficiency");
                            }
                            if (scrolls != null) {
                                for (int index = 0; index < scrolls.func_74745_c(); ++index) {
                                    if (scrolls.func_150307_f(index).equals("IMPLOSION_SCROLL")) {
                                        implosion = true;
                                        continue;
                                    }
                                    if (scrolls.func_150307_f(index).equals("SHADOW_WARP_SCROLL")) {
                                        shadowWarp = true;
                                        continue;
                                    }
                                    if (!scrolls.func_150307_f(index).equals("WITHER_SHIELD_SCROLL")) continue;
                                    witherShield = true;
                                }
                            }
                        }
                        if (item.itemName.length() > 14) {
                            item.itemName = item.itemName.substring(0, 14);
                        }
                        if (item.itemType == ItemType.HOT_POTATO) {
                            if (potatoCount < 10) {
                                this.applicableItem.add(item);
                                continue;
                            }
                            this.removableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.FUMING_POTATO) {
                            if (potatoCount >= 10 && potatoCount < 15) {
                                this.applicableItem.add(item);
                                continue;
                            }
                            if (potatoCount < 15) continue;
                            this.removableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.BOOK_OF_STATS) {
                            if (killCount > 0) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.ART_OF_WAR) {
                            if (warCount > 0) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.FARMING_DUMMY) {
                            if (ffdCount < 5) {
                                this.applicableItem.add(item);
                                continue;
                            }
                            this.removableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.RECOMB) {
                            if (recombCount > 0) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.SILEX) {
                            if (effLevel >= 5 && effLevel < 10) {
                                this.applicableItem.add(item);
                                continue;
                            }
                            if (effLevel != 10) continue;
                            this.removableItem.add(item);
                            continue;
                        }
                        if (item.isPowerScroll()) {
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.isMasterStar()) {
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.isDungeonStar()) {
                            if (starCount >= item.itemType.getStarLevel()) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.WOOD_SINGULARITY) {
                            if (singularityCount > 0) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.isHypeScroll()) {
                            if (shadowWarp) {
                                this.removableItem.add(item);
                                continue;
                            }
                            if (implosion) {
                                this.removableItem.add(item);
                                continue;
                            }
                            if (witherShield) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.TUNER) {
                            if (tunerCount >= 4) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.REFORGE) {
                            if (item.getReforge().equalsIgnoreCase(reforge) && !reforge.equals("")) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.ART_OF_PEACE) {
                            if (peaceCount > 0) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.itemType == ItemType.MANA_DISINTEGRATOR) {
                            if (manaDisintegratorCount >= 10) {
                                this.removableItem.add(item);
                                continue;
                            }
                            this.applicableItem.add(item);
                            continue;
                        }
                        if (item.isEnrichment()) {
                            this.applicableItem.add(item);
                            continue;
                        }
                        this.applicableItem.add(item);
                        continue;
                    }
                    this.applicableItem.add(item);
                    continue;
                }
                if (this.playerEnchantIds.containsKey(itemId)) {
                    this.searchRemovedFromRemovable = true;
                    continue;
                }
                this.searchRemovedFromApplicable = true;
            }
            NEUConfig cfg = NotEnoughUpdates.INSTANCE.config;
            int mult = cfg.enchantingSolvers.enchantOrdering == 0 ? 1 : -1;
            Comparator<HexItem> comparator = cfg.enchantingSolvers.enchantSorting == 0 ? Comparator.comparingInt(e2 -> mult * e2.price) : (c1, c2) -> mult * c1.itemId.toLowerCase(Locale.ROOT).compareTo(c2.itemId.toLowerCase(Locale.ROOT));
            this.removableItem.sort(comparator);
            this.applicableItem.sort(comparator);
        }
    }

    private void tickHex() {
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        ItemStack enchantingItemStack = cc.func_85151_d().func_70301_a(22);
        ItemStack glassStack = cc.func_85151_d().func_70301_a(12);
        this.lastState = this.currentState;
        if (enchantingItemStack != null) {
            if (glassStack.func_77973_b() != null && glassStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
                this.currentState = glassStack.func_77952_i() == 14 ? EnchantState.INVALID_ITEM_HEX : (glassStack.func_77952_i() == 10 ? EnchantState.HAS_ITEM_IN_HEX : EnchantState.NO_ITEM_IN_HEX);
                this.enchantingItem = enchantingItemStack;
            }
        } else {
            this.currentState = EnchantState.NO_ITEM_IN_HEX;
        }
        this.orbDisplay.physicsTickOrbs();
        if (++this.tickCounter >= 20) {
            this.tickCounter = 0;
        }
        if (this.currentState == EnchantState.ADDING_BOOK) {
            if (this.arrowAmount.getTarget() != 1.0f) {
                this.arrowAmount.setTarget(1.0f);
                this.arrowAmount.resetTimer();
            }
        } else if (this.arrowAmount.getTarget() != 0.0f) {
            this.arrowAmount.setTarget(0.0f);
            this.arrowAmount.resetTimer();
        }
        this.isChangingEnchLevel = false;
        this.searchRemovedFromRemovable = false;
        this.searchRemovedFromApplicable = false;
        this.applicableItem.clear();
        this.removableItem.clear();
        boolean hasHexItem = false;
        if (this.currentState == EnchantState.HAS_ITEM_IN_HEX) {
            for (int i = 0; i < 9; ++i) {
                NBTTagCompound enchantments;
                NBTTagCompound ea;
                NBTTagCompound tagBook;
                int slotIndex = 15 + i % 3 + i / 3 * 9;
                ItemStack book = cc.func_85151_d().func_70301_a(slotIndex);
                if (!hasHexItem && glassStack != null) {
                    HexItem item = new HexItem(slotIndex, "Total Upgrades", "TOTAL_UPGRADES", Utils.getRawTooltip(glassStack), true, true);
                    this.removableItem.add(item);
                    hasHexItem = true;
                }
                if (book == null || (tagBook = book.func_77978_p()) == null || (ea = tagBook.func_74775_l("ExtraAttributes")) == null || (enchantments = ea.func_74775_l("enchantments")) == null) continue;
                String itemId = Utils.cleanColour(book.func_82833_r()).toUpperCase(Locale.ROOT).replace(" ", "_").replace("-", "_");
                String name = Utils.cleanColour(book.func_82833_r());
                if (itemId.equalsIgnoreCase("_") || itemId.equalsIgnoreCase("Item_Maxed_Out")) continue;
                if (this.searchField.getText().trim().isEmpty() || name.toLowerCase(Locale.ROOT).contains(this.searchField.getText().trim().toLowerCase(Locale.ROOT))) {
                    if (name.equalsIgnoreCase("Ultimate Enchantments")) {
                        name = "Ult Enchants";
                    }
                    HexItem item = new HexItem(slotIndex, name, "HEX_ITEM" + i, Utils.getRawTooltip(book), true, true);
                    this.enchanterItemLevels.put(item.level, item);
                    this.applicableItem.add(item);
                    continue;
                }
                if (this.playerEnchantIds.containsKey(itemId)) {
                    this.searchRemovedFromRemovable = true;
                    continue;
                }
                this.searchRemovedFromApplicable = true;
            }
            NEUConfig cfg = NotEnoughUpdates.INSTANCE.config;
            int mult = cfg.enchantingSolvers.enchantOrdering == 0 ? 1 : -1;
            Comparator<HexItem> comparator = cfg.enchantingSolvers.enchantSorting == 0 ? Comparator.comparingInt(e2 -> mult * e2.price) : (c1, c2) -> mult * c1.itemId.toLowerCase(Locale.ROOT).compareTo(c2.itemId.toLowerCase(Locale.ROOT));
            this.removableItem.sort(comparator);
            this.applicableItem.sort(comparator);
        }
    }

    private void tickGemstones() {
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        ItemStack enchantingItemStack = cc.func_85151_d().func_70301_a(19);
        ItemStack portalStack = cc.func_85151_d().func_70301_a(28);
        int lastPage = this.currentPage;
        this.lastState = this.currentState;
        if (portalStack != null && portalStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150378_br) && this.currentState != EnchantState.ADDING_GEMSTONE && !this.shouldOverrideGemstones && this.currentState != EnchantState.APPLYING_GEMSTONE) {
            this.currentState = EnchantState.HAS_ITEM_IN_GEMSTONE;
            this.enchantingItem = enchantingItemStack;
        } else if (portalStack != null && portalStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150378_br) && this.shouldOverrideGemstones && this.currentState != EnchantState.APPLYING_GEMSTONE) {
            this.currentState = EnchantState.ADDING_GEMSTONE;
        } else if (this.currentState == EnchantState.HAS_ITEM_IN_GEMSTONE && this.enchantingItem == null && enchantingItemStack != null) {
            this.enchantingItem = enchantingItemStack;
        } else if (this.currentState != EnchantState.APPLYING_GEMSTONE) {
            this.currentState = EnchantState.HAS_ITEM_IN_GEMSTONE;
        }
        if (this.currentState == EnchantState.APPLYING_GEMSTONE || this.currentState == EnchantState.ADDING_GEMSTONE) {
            ItemStack pageUpStack = cc.func_85151_d().func_70301_a(17);
            ItemStack pageDownStack = cc.func_85151_d().func_70301_a(35);
            if (pageUpStack != null && pageDownStack != null) {
                this.currentPage = 0;
                boolean upIsGlass = pageUpStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                boolean downIsGlass = pageDownStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                int page = -1;
                this.expectedMaxPage = 1;
                if (!downIsGlass) {
                    try {
                        page = Integer.parseInt(Utils.getRawTooltip(pageDownStack).get(1).substring(11)) - 1;
                        this.expectedMaxPage = page + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (page == -1 && !upIsGlass) {
                    try {
                        this.expectedMaxPage = page = Integer.parseInt(Utils.getRawTooltip(pageUpStack).get(1).substring(11)) + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentPage = page == -1 ? 1 : page;
            }
        }
        this.orbDisplay.physicsTickOrbs();
        if (++this.tickCounter >= 20) {
            this.tickCounter = 0;
        }
        if (this.lastState != this.currentState || lastPage != this.currentPage) {
            this.leftScroll.setValue(0);
            this.rightScroll.setValue(0);
        }
        if (this.currentState == EnchantState.APPLYING_GEMSTONE) {
            if (this.arrowAmount.getTarget() != 1.0f) {
                this.arrowAmount.setTarget(1.0f);
                this.arrowAmount.resetTimer();
            }
        } else if (this.arrowAmount.getTarget() != 0.0f) {
            this.arrowAmount.setTarget(0.0f);
            this.arrowAmount.resetTimer();
        }
        this.isChangingEnchLevel = false;
        this.searchRemovedFromRemovable = false;
        this.searchRemovedFromApplicable = false;
        this.applicableItem.clear();
        this.removableItem.clear();
        if (this.isInGemstones()) {
            for (int i = 0; i < 15; ++i) {
                NBTTagCompound enchantments;
                NBTTagCompound ea;
                NBTTagCompound tagBook;
                int slotIndex = 12 + i % 5 + i / 5 * 9;
                ItemStack book = cc.func_85151_d().func_70301_a(slotIndex);
                if (book == null || (tagBook = book.func_77978_p()) == null || (ea = tagBook.func_74775_l("ExtraAttributes")) == null || (enchantments = ea.func_74775_l("enchantments")) == null) continue;
                String itemId = Utils.cleanColour(book.func_82833_r()).toUpperCase(Locale.ROOT).replace(" ", "_").replace("-", "_");
                String name = Utils.cleanColour(book.func_82833_r());
                if (itemId.equalsIgnoreCase("_") || itemId.equalsIgnoreCase("Item_Maxed_Out")) continue;
                if (this.searchField.getText().trim().isEmpty() || name.toLowerCase(Locale.ROOT).contains(this.searchField.getText().trim().toLowerCase(Locale.ROOT))) {
                    HexItem item = new HexItem(slotIndex, name, itemId, Utils.getRawTooltip(book), true, true);
                    this.enchanterItemLevels.put(item.level, item);
                    if (item.isGemstone()) {
                        if (book.func_77973_b() == Items.field_151100_aR) {
                            item.conflicts = true;
                        }
                        boolean removed = false;
                        for (String lore : item.displayLore) {
                            if (!lore.contains("Click to remove!")) continue;
                            this.removableItem.add(item);
                            removed = true;
                            break;
                        }
                        if (!removed) {
                            this.applicableItem.add(item);
                        }
                        if (item.itemName.length() <= 14) continue;
                        item.itemName = item.itemName.substring(0, 14);
                        continue;
                    }
                    this.applicableItem.add(item);
                    continue;
                }
                if (this.playerEnchantIds.containsKey(itemId)) {
                    this.searchRemovedFromRemovable = true;
                    continue;
                }
                this.searchRemovedFromApplicable = true;
            }
            NEUConfig cfg = NotEnoughUpdates.INSTANCE.config;
            int mult = cfg.enchantingSolvers.enchantOrdering == 0 ? 1 : -1;
            Comparator<HexItem> comparator = cfg.enchantingSolvers.enchantSorting == 0 ? Comparator.comparingInt(e2 -> mult * e2.price) : (c1, c2) -> mult * c1.itemId.toLowerCase(Locale.ROOT).compareTo(c2.itemId.toLowerCase(Locale.ROOT));
            this.removableItem.sort(comparator);
            this.applicableItem.sort(comparator);
        }
        this.pageOpenLast = this.pageOpen;
    }

    private List<String> createTooltip(String title, int selectedOption, String ... options) {
        String selPrefix = EnumChatFormatting.DARK_AQUA + " \u25b6 ";
        String unselPrefix = EnumChatFormatting.GRAY.toString();
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == selectedOption ? selPrefix + options[i] : unselPrefix + options[i];
        }
        ArrayList list = Lists.newArrayList((Object[])options);
        list.add(0, "");
        list.add(0, EnumChatFormatting.GREEN + title);
        return list;
    }

    public void render(float partialTicks, String containerName) {
        if (containerName == null) {
            return;
        }
        if (containerName.equals("The Hex")) {
            this.renderHex(partialTicks);
        } else if (containerName.contains("Enchant Item")) {
            this.renderEnchantment(partialTicks);
        } else if (containerName.contains("Books") || containerName.contains("Modifiers") || containerName.contains("Bottles of Enchanting")) {
            this.renderBooks(partialTicks);
        } else if (containerName.contains("Gemstones")) {
            this.renderGemstones(partialTicks);
        } else {
            this.renderBooks(partialTicks);
        }
    }

    private void renderEnchantment(float partialTicks) {
        ItemStack itemEnchantInput;
        int itemY;
        int vOffset;
        int top;
        Enchantment ench;
        int index;
        int i;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        int playerXpLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        this.leftScroll.tick();
        this.rightScroll.tick();
        this.arrowAmount.tick();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        this.guiLeft = (width - 364) / 2;
        this.guiTop = (height - 215) / 2;
        ArrayList tooltipToDisplay = null;
        boolean disallowClick = false;
        ItemStack stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        int itemHoverX = -1;
        int itemHoverY = -1;
        boolean hoverLocked = false;
        this.func_73733_a(0, 0, width, height, -1072689136, -804253680);
        this.renderBaseTexture();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a("Applicable", (float)(this.guiLeft + 7), (float)(this.guiTop + 7), 0x404040, false);
        fr.func_175065_a("Removable", (float)(this.guiLeft + 247), (float)(this.guiTop + 7), 0x404040, false);
        if (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT) {
            String pageStr = "Page: " + this.currentPage + "/" + this.expectedMaxPage;
            int pageStrLen = fr.func_78256_a(pageStr);
            Utils.drawStringCentered(pageStr, this.guiLeft + 182, this.guiTop + 14, false, 0x404040);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 - pageStrLen / 2 - 2 - 15, this.guiTop + 6, 15.0f, 15.0f, 0.0f, 0.029296875f, 0.7265625f, 0.7558594f, 9728);
            Utils.drawTexturedRect(this.guiLeft + 182 + pageStrLen / 2 + 2, this.guiTop + 6, 15.0f, 15.0f, 0.029296875f, 0.05859375f, 0.7265625f, 0.7558594f, 9728);
        }
        tooltipToDisplay = this.renderSettings(mouseX, mouseY, tooltipToDisplay);
        this.renderScrollBars(this.applicable, this.removable, mouseY);
        this.renderEnchantBook(scaledResolution, partialTicks);
        if (this.currentState == EnchantState.INVALID_ITEM) {
            GlStateManager.func_179097_i();
            Utils.drawStringCentered("This item can't", this.guiLeft + 182, this.guiTop + 88, true, -43691);
            Utils.drawStringCentered("be enchanted", this.guiLeft + 182, this.guiTop + 98, true, -43691);
            GlStateManager.func_179126_j();
        }
        this.renderArrow();
        if (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT) {
            if (this.applicable.isEmpty() && this.removable.isEmpty() && this.searchRemovedFromApplicable) {
                Utils.drawStringCentered("Can't find that", this.guiLeft + 8 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchant, perhaps", this.guiLeft + 8 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("it is on", this.guiLeft + 8 + 48, this.guiTop + 48, true, -43691);
                Utils.drawStringCentered("another page?", this.guiLeft + 8 + 48, this.guiTop + 58, true, -43691);
            } else if (this.applicable.isEmpty() && !this.searchRemovedFromApplicable) {
                Utils.drawStringCentered("No applicable", this.guiLeft + 8 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchants on", this.guiLeft + 8 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("this page...", this.guiLeft + 8 + 48, this.guiTop + 48, true, -43691);
            }
            if (this.applicable.isEmpty() && this.removable.isEmpty() && this.searchRemovedFromRemovable) {
                Utils.drawStringCentered("Can't find that", this.guiLeft + 248 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchant, perhaps", this.guiLeft + 248 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("it is on", this.guiLeft + 248 + 48, this.guiTop + 48, true, -43691);
                Utils.drawStringCentered("another page?", this.guiLeft + 248 + 48, this.guiTop + 58, true, -43691);
            } else if (this.removable.isEmpty() && !this.searchRemovedFromRemovable) {
                Utils.drawStringCentered("No removable", this.guiLeft + 248 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchants on", this.guiLeft + 248 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("this page...", this.guiLeft + 248 + 48, this.guiTop + 48, true, -43691);
            }
        }
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.leftScroll.getValue() / 16;
            if (this.applicable.size() <= index) break;
            ench = this.applicable.get(index);
            top = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentEnch != null && this.enchanterCurrentEnch.enchId.equals(ench.enchId) ? 16 : 0;
            int uOffset = ench.conflicts ? 112 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 8, top, 96.0f, 16.0f, (float)uOffset / 512.0f, (float)(96 + uOffset) / 512.0f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 8 && mouseX <= this.guiLeft + 8 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (ench.displayLore != null) {
                    tooltipToDisplay = ench.displayLore;
                }
            }
            String levelStr = "" + ench.xpCost;
            int colour = 0xC8FF8F;
            if (ench.xpCost > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(ench.enchantName, (float)(this.guiLeft + 8 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.rightScroll.getValue() / 16;
            if (this.removable.size() <= index) break;
            ench = this.removable.get(index);
            top = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentEnch != null && this.enchanterCurrentEnch.enchId.equals(ench.enchId) ? 16 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 248, top, 96.0f, 16.0f, 0.0f, 0.1875f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 248 && mouseX <= this.guiLeft + 248 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (ench.displayLore != null) {
                    tooltipToDisplay = ench.displayLore;
                }
            }
            String levelStr = "" + ench.xpCost;
            if (ench.xpCost < 0) {
                levelStr = "?";
            }
            int colour = 0xC8FF8F;
            if (ench.xpCost > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(ench.enchantName, (float)(this.guiLeft + 248 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        fr.func_78276_b(Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150260_c(), this.guiLeft + 102, this.guiTop + 215 - 96 + 2, 0x404040);
        int inventoryStartIndex = cc.func_85151_d().func_70302_i_();
        GlStateManager.func_179126_j();
        for (int i2 = 0; i2 < 36; ++i2) {
            int itemX = this.guiLeft + 102 + 18 * (i2 % 9);
            itemY = this.guiTop + 133 + 18 * (i2 / 9);
            if (i2 >= 27) {
                itemY += 4;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 102 - 8), (float)(this.guiTop + 191 - (inventoryStartIndex / 9 * 18 + 89)), (float)0.0f);
            Slot slot = cc.func_75139_a(inventoryStartIndex + i2);
            ((AccessorGuiContainer)chest).doDrawSlot(slot);
            GlStateManager.func_179121_F();
            if (mouseX < itemX || mouseX >= itemX + 18 || mouseY < itemY || mouseY >= itemY + 18) continue;
            itemHoverX = itemX;
            itemHoverY = itemY;
            hoverLocked = SlotLocking.getInstance().isSlotLocked(slot);
            if (!slot.func_75216_d()) continue;
            tooltipToDisplay = slot.func_75211_c().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (this.currentState == EnchantState.HAS_ITEM) {
            if (this.searchField.getText().isEmpty() && !this.searchField.getFocus()) {
                this.searchField.setSize(90, 14);
                this.searchField.setPrependText("\u00a77Search...");
            } else {
                if (this.searchField.getFocus()) {
                    int len2 = fr.func_78256_a(this.searchField.getTextDisplay()) + 10;
                    this.searchField.setSize(Math.max(90, len2), 14);
                } else {
                    this.searchField.setSize(90, 14);
                }
                this.searchField.setPrependText("");
            }
            this.searchField.render(this.guiLeft + 182 - this.searchField.getWidth() / 2, this.guiTop + 83);
        } else if (this.currentState == EnchantState.ADDING_ENCHANT && this.enchanterCurrentEnch != null && !this.enchanterEnchLevels.isEmpty()) {
            int left = this.guiLeft + 182 - 56;
            int top2 = this.guiTop + 83;
            int uOffset = this.enchanterCurrentEnch.conflicts ? 112 : 0;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(left, top2, 112.0f, 16.0f, (float)uOffset / 512.0f, (float)(112 + uOffset) / 512.0f, 0.48632812f, 0.5175781f, 9728);
            if (mouseX > left + 16 && mouseX <= left + 96 && mouseY > top2 && mouseY <= top2 + 16) {
                disallowClick = true;
                if (this.enchanterCurrentEnch.displayLore != null) {
                    tooltipToDisplay = this.enchanterCurrentEnch.displayLore;
                }
            }
            String levelStr = "" + this.enchanterCurrentEnch.xpCost;
            if (this.enchanterCurrentEnch.xpCost < 0) {
                levelStr = "?";
            }
            int colour = 0xC8FF8F;
            if (this.enchanterCurrentEnch.xpCost > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2 - 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2 + 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top2 + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top2 + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top2 + 4), colour, false);
            String priceStr = StringUtils.formatNumber(this.enchanterCurrentEnch.price) + " Coins";
            if (this.enchanterCurrentEnch.price < 0) {
                priceStr = "";
            }
            int priceWidth = fr.func_78256_a(priceStr);
            int priceTop = this.guiTop + 16;
            int x = 180;
            int color = 2957570;
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2 - 1), (float)(priceTop + 4), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2 + 1), (float)(priceTop + 4), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2), (float)(priceTop + 4 - 1), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2), (float)(priceTop + 4 + 1), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2), (float)(priceTop + 4), 16562691, false);
            String name = WordUtils.capitalizeFully((String)ItemUtils.fixEnchantId(this.enchanterCurrentEnch.enchId, false).replace("_", " "));
            if (name.equalsIgnoreCase("Bane of Arthropods")) {
                name = "Bane of Arth.";
            } else if (name.equalsIgnoreCase("Projectile Protection")) {
                name = "Projectile Prot";
            } else if (name.equalsIgnoreCase("Blast Protection")) {
                name = "Blast Prot";
            } else if (name.equalsIgnoreCase("Luck of the Sea")) {
                name = "Luck of Sea";
            } else if (name.equalsIgnoreCase("Turbo Mushrooms")) {
                name = "Turbo-Mush";
            }
            Utils.drawStringCentered(name, this.guiLeft + 182, top2 + 8, true, -35);
            if (this.isChangingEnchLevel) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(left + 96, top2, 16.0f, 16.0f, 0.1875f, 0.21875f, 0.5175781f, 0.5488281f, 9728);
            }
            levelStr = "" + this.enchanterCurrentEnch.level;
            if (this.enchanterCurrentEnch.xpCost < 0) {
                levelStr = "?";
            }
            levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 - 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 + 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 4), 15368959, false);
            String confirmText = "Apply";
            if (this.removingEnchantPlayerLevel >= 0) {
                confirmText = this.removingEnchantPlayerLevel == this.enchanterCurrentEnch.level ? "Remove" : (this.enchanterCurrentEnch.level > this.removingEnchantPlayerLevel ? "Upgrade" : "Bad Level");
            }
            if (System.currentTimeMillis() - this.confirmButtonAnimTime < 500L && playerXpLevel >= this.enchanterCurrentEnch.xpCost) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 23, top2 + 18 + 9, false, 0x408040);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 24, top2 + 18 + 8, false, 0x408040);
                if (playerXpLevel < this.enchanterCurrentEnch.xpCost) {
                    Gui.func_73734_a((int)(this.guiLeft + 182 - 1 - 48), (int)(top2 + 18), (int)(this.guiLeft + 182 - 1), (int)(top2 + 18 + 14), (int)Integer.MIN_VALUE);
                }
            }
            if (System.currentTimeMillis() - this.cancelButtonAnimTime < 500L) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
                Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 25, top2 + 18 + 9, false, 0xA04040);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 24, top2 + 18 + 8, false, 0xA04040);
            }
            if (mouseY > top2 + 18 && mouseY <= top2 + 18 + 16) {
                if (mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1) {
                    disallowClick = true;
                    if (this.enchanterCurrentEnch.displayLore != null) {
                        tooltipToDisplay = this.enchanterCurrentEnch.displayLore;
                    }
                } else if (mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48) {
                    disallowClick = true;
                    tooltipToDisplay = Lists.newArrayList((Object[])new String[]{"\u00a7cCancel"});
                }
            }
            if (this.isChangingEnchLevel) {
                tooltipToDisplay = null;
                ArrayList<Enchantment> before = new ArrayList<Enchantment>();
                ArrayList<Enchantment> after = new ArrayList<Enchantment>();
                for (Enchantment ench2 : this.enchanterEnchLevels.values()) {
                    if (ench2.level < this.enchanterCurrentEnch.level) {
                        before.add(ench2);
                        continue;
                    }
                    if (ench2.level <= this.enchanterCurrentEnch.level) continue;
                    after.add(ench2);
                }
                before.sort(Comparator.comparingInt(o -> -o.level));
                after.sort(Comparator.comparingInt(o -> o.level));
                int bSize = before.size();
                int aSize = after.size();
                GlStateManager.func_179097_i();
                for (int i3 = 0; i3 < bSize + aSize; ++i3) {
                    int yIndex;
                    Enchantment ench3;
                    if (i3 < bSize) {
                        ench3 = (Enchantment)before.get(i3);
                        yIndex = -i3 - 1;
                    } else {
                        ench3 = (Enchantment)after.get(i3 - bSize);
                        yIndex = i3 - bSize + 1;
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int type2 = 0;
                    if (i3 == bSize) {
                        type2 = 2;
                    } else if (i3 == 0) {
                        type2 = 1;
                    }
                    if (mouseX > left + 96 && mouseX <= left + 96 + 16 && mouseY > top2 + 16 * yIndex && mouseY <= top2 + 16 * yIndex + 16) {
                        tooltipToDisplay = new ArrayList(ench3.displayLore);
                        if (tooltipToDisplay.size() > 2) {
                            tooltipToDisplay.remove(tooltipToDisplay.size() - 1);
                            tooltipToDisplay.remove(tooltipToDisplay.size() - 1);
                        }
                        itemHoverX = -1;
                        itemHoverY = -1;
                    }
                    Utils.drawTexturedRect(left + 96, top2 + 16 * yIndex, 16.0f, 16.0f, (float)(16 * type2) / 512.0f, (float)(16 + 16 * type2) / 512.0f, 0.6953125f, 0.7265625f, 9728);
                    levelStr = "" + ench3.level;
                    levelWidth = fr.func_78256_a(levelStr);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 - 1), (float)(top2 + 16 * yIndex + 4), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 + 1), (float)(top2 + 16 * yIndex + 4), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 16 * yIndex + 4 - 1), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 16 * yIndex + 4 + 1), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 16 * yIndex + 4), 15368959, false);
                }
                GlStateManager.func_179126_j();
            }
            if (mouseX > left + 96 && mouseX <= left + 96 + 16 && mouseY > top2 && mouseY <= top2 + 16) {
                tooltipToDisplay = this.isChangingEnchLevel ? Lists.newArrayList((Object[])new String[]{"\u00a7cCancel level change"}) : Lists.newArrayList((Object[])new String[]{"\u00a7aChange enchant level"});
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM) {
            this.renderCancel();
        }
        if ((itemEnchantInput = this.currentState == EnchantState.HAS_ITEM_IN_HEX ? cc.func_75139_a(22).func_75211_c() : cc.func_75139_a(19).func_75211_c()) != null && itemEnchantInput.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
            itemEnchantInput = this.enchantingItem;
        }
        int itemX = this.guiLeft + 174;
        itemY = this.guiTop + 58;
        if (itemEnchantInput == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(itemX, itemY, 16.0f, 16.0f, 0.0f, 0.03125f, 0.5488281f, 0.5800781f, 9728);
        } else {
            Utils.drawItemStack(itemEnchantInput, itemX, itemY);
        }
        if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
            itemHoverX = itemX;
            itemHoverY = itemY;
            if (itemEnchantInput != null) {
                tooltipToDisplay = itemEnchantInput.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
        }
        if (!this.isChangingEnchLevel && itemHoverX >= 0 && itemHoverY >= 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)itemHoverX, (int)itemHoverY, (int)(itemHoverX + 16), (int)(itemHoverY + 16), (int)(hoverLocked ? -2130739072 : -2130706433));
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        this.renderOrbAnim(partialTicks);
        this.renderMouseStack(stackOnMouse, disallowClick, mouseX, mouseY, width, height, tooltipToDisplay);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    private void renderBooks(float partialTicks) {
        ItemStack itemEnchantInput;
        int itemY;
        int vOffset;
        int top;
        HexItem item;
        int index;
        int i;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        int playerXpLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        this.leftScroll.tick();
        this.rightScroll.tick();
        this.arrowAmount.tick();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        this.guiLeft = (width - 364) / 2;
        this.guiTop = (height - 215) / 2;
        ArrayList tooltipToDisplay = null;
        boolean disallowClick = false;
        ItemStack stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        int itemHoverX = -1;
        int itemHoverY = -1;
        boolean hoverLocked = false;
        this.func_73733_a(0, 0, width, height, -1072689136, -804253680);
        this.renderBaseTexture();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a("Applicable", (float)(this.guiLeft + 7), (float)(this.guiTop + 7), 0x404040, false);
        fr.func_175065_a("Applied", (float)(this.guiLeft + 247), (float)(this.guiTop + 7), 0x404040, false);
        if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS) {
            String pageStr = "Page: " + this.currentPage + "/" + this.expectedMaxPage;
            int pageStrLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(pageStr);
            Utils.drawStringCentered(pageStr, this.guiLeft + 182, this.guiTop + 14, false, 0x404040);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 - pageStrLen / 2 - 2 - 15, this.guiTop + 6, 15.0f, 15.0f, 0.0f, 0.029296875f, 0.7265625f, 0.7558594f, 9728);
            Utils.drawTexturedRect(this.guiLeft + 182 + pageStrLen / 2 + 2, this.guiTop + 6, 15.0f, 15.0f, 0.029296875f, 0.05859375f, 0.7265625f, 0.7558594f, 9728);
        }
        tooltipToDisplay = this.renderSettings(mouseX, mouseY, tooltipToDisplay);
        this.renderScrollBars(this.applicableItem, this.applicableItem, mouseY);
        this.renderEnchantBook(scaledResolution, partialTicks);
        this.renderArrow();
        if (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT || this.currentState == EnchantState.HAS_ITEM_IN_BOOKS || this.currentState == EnchantState.ADDING_BOOK) {
            if (this.applicableItem.isEmpty() && this.removableItem.isEmpty() && this.searchRemovedFromApplicable) {
                Utils.drawStringCentered("Can't find that", this.guiLeft + 8 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchant, perhaps", this.guiLeft + 8 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("it is on", this.guiLeft + 8 + 48, this.guiTop + 48, true, -43691);
                Utils.drawStringCentered("another page?", this.guiLeft + 8 + 48, this.guiTop + 58, true, -43691);
            } else if (this.applicableItem.isEmpty() && !this.searchRemovedFromApplicable) {
                Utils.drawStringCentered("No applicable", this.guiLeft + 8 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchants on", this.guiLeft + 8 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("this page...", this.guiLeft + 8 + 48, this.guiTop + 48, true, -43691);
            }
            if (this.applicableItem.isEmpty() && this.removableItem.isEmpty() && this.searchRemovedFromRemovable) {
                Utils.drawStringCentered("Can't find that", this.guiLeft + 248 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchant, perhaps", this.guiLeft + 248 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("it is on", this.guiLeft + 248 + 48, this.guiTop + 48, true, -43691);
                Utils.drawStringCentered("another page?", this.guiLeft + 248 + 48, this.guiTop + 58, true, -43691);
            } else if (this.removableItem.isEmpty() && !this.searchRemovedFromRemovable) {
                Utils.drawStringCentered("No removable", this.guiLeft + 248 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchants on", this.guiLeft + 248 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("this page...", this.guiLeft + 248 + 48, this.guiTop + 48, true, -43691);
            }
        }
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.leftScroll.getValue() / 16;
            if (this.applicableItem.size() <= index) break;
            item = this.applicableItem.get(index);
            top = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentItem != null && this.enchanterCurrentItem.itemId.equals(item.itemId) ? 16 : 0;
            int uOffset = item.conflicts ? 112 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 8, top, 96.0f, 16.0f, (float)uOffset / 512.0f, (float)(96 + uOffset) / 512.0f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 8 && mouseX <= this.guiLeft + 8 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (item.displayLore != null) {
                    tooltipToDisplay = item.displayLore;
                }
            }
            String levelStr = this.getIconStr(item);
            int colour = 0xC8FF8F;
            if (item.price > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(item.itemName, (float)(this.guiLeft + 8 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.rightScroll.getValue() / 16;
            if (this.removableItem.size() <= index) break;
            item = this.removableItem.get(index);
            top = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentItem != null && this.enchanterCurrentItem.itemId.equals(item.itemId) ? 16 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 248, top, 96.0f, 16.0f, 0.0f, 0.1875f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 248 && mouseX <= this.guiLeft + 248 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (item.displayLore != null) {
                    tooltipToDisplay = item.displayLore;
                }
            }
            String levelStr = this.getIconStr(item);
            int colour = 0xC8FF8F;
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(item.itemName, (float)(this.guiLeft + 248 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        fr.func_78276_b(Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150260_c(), this.guiLeft + 102, this.guiTop + 215 - 96 + 2, 0x404040);
        int inventoryStartIndex = cc.func_85151_d().func_70302_i_();
        GlStateManager.func_179126_j();
        for (int i2 = 0; i2 < 36; ++i2) {
            int itemX = this.guiLeft + 102 + 18 * (i2 % 9);
            itemY = this.guiTop + 133 + 18 * (i2 / 9);
            if (i2 >= 27) {
                itemY += 4;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 102 - 8), (float)(this.guiTop + 191 - (inventoryStartIndex / 9 * 18 + 89)), (float)0.0f);
            Slot slot = cc.func_75139_a(inventoryStartIndex + i2);
            ((AccessorGuiContainer)chest).doDrawSlot(slot);
            GlStateManager.func_179121_F();
            if (mouseX < itemX || mouseX >= itemX + 18 || mouseY < itemY || mouseY >= itemY + 18) continue;
            itemHoverX = itemX;
            itemHoverY = itemY;
            hoverLocked = SlotLocking.getInstance().isSlotLocked(slot);
            if (!slot.func_75216_d()) continue;
            tooltipToDisplay = slot.func_75211_c().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (this.currentState == EnchantState.HAS_ITEM) {
            if (this.searchField.getText().isEmpty() && !this.searchField.getFocus()) {
                this.searchField.setSize(90, 14);
                this.searchField.setPrependText("\u00a77Search...");
            } else {
                if (this.searchField.getFocus()) {
                    int len2 = fr.func_78256_a(this.searchField.getTextDisplay()) + 10;
                    this.searchField.setSize(Math.max(90, len2), 14);
                } else {
                    this.searchField.setSize(90, 14);
                }
                this.searchField.setPrependText("");
            }
            this.searchField.render(this.guiLeft + 182 - this.searchField.getWidth() / 2, this.guiTop + 83);
        } else if (this.currentState == EnchantState.ADDING_BOOK && this.enchanterCurrentItem != null) {
            int left = this.guiLeft + 182 - 56;
            int top2 = this.guiTop + 83;
            int uOffset = this.enchanterCurrentItem.conflicts ? 112 : 0;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(left, top2, 112.0f, 16.0f, (float)uOffset / 512.0f, (float)(112 + uOffset) / 512.0f, 0.48632812f, 0.5175781f, 9728);
            if (mouseX > left + 16 && mouseX <= left + 96 && mouseY > top2 && mouseY <= top2 + 16) {
                disallowClick = true;
                if (this.enchanterCurrentItem.displayLore != null) {
                    tooltipToDisplay = this.enchanterCurrentItem.displayLore;
                }
            }
            String priceStr = StringUtils.formatNumber(this.enchanterCurrentItem.getPrice()) + " Coins";
            if (this.enchanterCurrentItem.price < 0) {
                priceStr = "";
            }
            int priceWidth = fr.func_78256_a(priceStr);
            int priceTop = this.guiTop + 10;
            int x = 180;
            int color = 2957570;
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2 - 1), (float)(priceTop + 4), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2 + 1), (float)(priceTop + 4), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2), (float)(priceTop + 4 - 1), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2), (float)(priceTop + 4 + 1), color, false);
            fr.func_175065_a(priceStr, (float)(this.guiLeft + x - priceWidth / 2), (float)(priceTop + 4), 16562691, false);
            String name = WordUtils.capitalizeFully((String)this.enchanterCurrentItem.itemId.replace("_", " "));
            name = this.fixName(name);
            Utils.drawStringCentered(name, this.guiLeft + 182, top2 + 8, true, -35);
            String confirmText = "Apply";
            if (this.removingEnchantPlayerLevel >= 0) {
                confirmText = this.removingEnchantPlayerLevel == this.enchanterCurrentItem.level ? "Remove" : (this.enchanterCurrentItem.level > this.removingEnchantPlayerLevel ? "Upgrade" : "Bad Level");
            }
            if (System.currentTimeMillis() - this.confirmButtonAnimTime < 500L && playerXpLevel >= this.enchanterCurrentItem.price) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 23, top2 + 18 + 9, false, 0x408040);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 24, top2 + 18 + 8, false, 0x408040);
            }
            if (System.currentTimeMillis() - this.cancelButtonAnimTime < 500L) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
                Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 25, top2 + 18 + 9, false, 0xA04040);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 24, top2 + 18 + 8, false, 0xA04040);
            }
            if (mouseY > top2 + 18 && mouseY <= top2 + 18 + 16) {
                if (mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1) {
                    disallowClick = true;
                    if (this.enchanterCurrentItem.displayLore != null) {
                        tooltipToDisplay = this.enchanterCurrentItem.displayLore;
                    }
                } else if (mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48) {
                    disallowClick = true;
                    tooltipToDisplay = Lists.newArrayList((Object[])new String[]{"\u00a7cCancel"});
                }
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS || this.currentState == EnchantState.ADDING_BOOK) {
            this.renderCancel();
        }
        if ((itemEnchantInput = this.currentState == EnchantState.HAS_ITEM_IN_HEX ? cc.func_75139_a(22).func_75211_c() : cc.func_75139_a(19).func_75211_c()) != null && itemEnchantInput.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
            itemEnchantInput = this.enchantingItem;
        }
        int itemX = this.guiLeft + 174;
        itemY = this.guiTop + 58;
        if (itemEnchantInput == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(itemX, itemY, 16.0f, 16.0f, 0.0f, 0.03125f, 0.5488281f, 0.5800781f, 9728);
        } else {
            Utils.drawItemStack(itemEnchantInput, itemX, itemY);
        }
        if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
            itemHoverX = itemX;
            itemHoverY = itemY;
            if (itemEnchantInput != null) {
                tooltipToDisplay = itemEnchantInput.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
        }
        if (!this.isChangingEnchLevel && itemHoverX >= 0 && itemHoverY >= 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)itemHoverX, (int)itemHoverY, (int)(itemHoverX + 16), (int)(itemHoverY + 16), (int)(hoverLocked ? -2130739072 : -2130706433));
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        this.renderOrbAnim(partialTicks);
        this.renderMouseStack(stackOnMouse, disallowClick, mouseX, mouseY, width, height, tooltipToDisplay);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    private void renderHex(float partialTicks) {
        ItemStack itemEnchantInput;
        int itemY;
        int vOffset;
        int top;
        HexItem item;
        int index;
        int i;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        int playerXpLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        this.leftScroll.tick();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        this.guiLeft = (width - 364) / 2;
        this.guiTop = (height - 215) / 2;
        ArrayList tooltipToDisplay = null;
        boolean disallowClick = false;
        ItemStack stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        int itemHoverX = -1;
        int itemHoverY = -1;
        boolean hoverLocked = false;
        this.func_73733_a(0, 0, width, height, -1072689136, -804253680);
        this.renderBaseTexture();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a("The Hex", (float)(this.guiLeft + 7), (float)(this.guiTop + 7), 0x404040, false);
        tooltipToDisplay = this.renderSettings(mouseX, mouseY, tooltipToDisplay);
        this.renderScrollBars(this.applicableItem, this.applicableItem, mouseY);
        this.renderEnchantBook(scaledResolution, partialTicks);
        if (this.currentState == EnchantState.INVALID_ITEM_HEX) {
            GlStateManager.func_179097_i();
            Utils.drawStringCentered("This item can't", this.guiLeft + 182, this.guiTop + 88, true, -43691);
            Utils.drawStringCentered("be enchanted", this.guiLeft + 182, this.guiTop + 98, true, -43691);
            GlStateManager.func_179126_j();
        }
        this.renderArrow();
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.leftScroll.getValue() / 16;
            if (this.applicableItem.size() <= index) break;
            item = this.applicableItem.get(index);
            top = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentItem != null && this.enchanterCurrentItem.itemId.equals(item.itemId) ? 16 : 0;
            int uOffset = item.conflicts ? 112 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 8, top, 96.0f, 16.0f, (float)uOffset / 512.0f, (float)(96 + uOffset) / 512.0f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 8 && mouseX <= this.guiLeft + 8 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (item.displayLore != null) {
                    tooltipToDisplay = item.displayLore;
                }
            }
            String levelStr = this.getIconStr(item);
            int colour = 0xC8FF8F;
            if (item.price > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(item.itemName, (float)(this.guiLeft + 8 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.rightScroll.getValue() / 16;
            if (this.removableItem.size() <= index) break;
            item = this.removableItem.get(index);
            top = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentItem != null && this.enchanterCurrentItem.itemId.equals(item.itemId) ? 16 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 248, top, 96.0f, 16.0f, 0.0f, 0.1875f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 248 && mouseX <= this.guiLeft + 248 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (item.displayLore != null) {
                    tooltipToDisplay = item.displayLore;
                }
            }
            String levelStr = this.getIconStr(item);
            int colour = 0xC8FF8F;
            if (item.price > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(item.itemName, (float)(this.guiLeft + 248 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        fr.func_78276_b(Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150260_c(), this.guiLeft + 102, this.guiTop + 215 - 96 + 2, 0x404040);
        int inventoryStartIndex = cc.func_85151_d().func_70302_i_();
        GlStateManager.func_179126_j();
        for (int i2 = 0; i2 < 36; ++i2) {
            int itemX = this.guiLeft + 102 + 18 * (i2 % 9);
            itemY = this.guiTop + 133 + 18 * (i2 / 9);
            if (i2 >= 27) {
                itemY += 4;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 102 - 8), (float)(this.guiTop + 191 - (inventoryStartIndex / 9 * 18 + 89)), (float)0.0f);
            Slot slot = cc.func_75139_a(inventoryStartIndex + i2);
            ((AccessorGuiContainer)chest).doDrawSlot(slot);
            GlStateManager.func_179121_F();
            if (mouseX < itemX || mouseX >= itemX + 18 || mouseY < itemY || mouseY >= itemY + 18) continue;
            itemHoverX = itemX;
            itemHoverY = itemY;
            hoverLocked = SlotLocking.getInstance().isSlotLocked(slot);
            if (!slot.func_75216_d()) continue;
            tooltipToDisplay = slot.func_75211_c().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (this.currentState == EnchantState.ADDING_BOOK && this.enchanterCurrentItem != null) {
            int left = this.guiLeft + 182 - 56;
            int top2 = this.guiTop + 83;
            int uOffset = this.enchanterCurrentItem.conflicts ? 112 : 0;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(left, top2, 112.0f, 16.0f, (float)uOffset / 512.0f, (float)(112 + uOffset) / 512.0f, 0.48632812f, 0.5175781f, 9728);
            if (mouseX > left + 16 && mouseX <= left + 96 && mouseY > top2 && mouseY <= top2 + 16) {
                disallowClick = true;
                if (this.enchanterCurrentItem.displayLore != null) {
                    tooltipToDisplay = this.enchanterCurrentItem.displayLore;
                }
            }
            if (mouseY > top2 + 18 && mouseY <= top2 + 18 + 16) {
                if (mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1) {
                    disallowClick = true;
                    if (this.enchanterCurrentItem.displayLore != null) {
                        tooltipToDisplay = this.enchanterCurrentItem.displayLore;
                    }
                } else if (mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48) {
                    disallowClick = true;
                    tooltipToDisplay = Lists.newArrayList((Object[])new String[]{"\u00a7cCancel"});
                }
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS || this.currentState == EnchantState.ADDING_BOOK) {
            this.renderCancel();
        }
        if ((itemEnchantInput = this.isInHex() ? cc.func_75139_a(22).func_75211_c() : cc.func_75139_a(19).func_75211_c()) != null && itemEnchantInput.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
            itemEnchantInput = this.enchantingItem;
        }
        int itemX = this.guiLeft + 174;
        itemY = this.guiTop + 58;
        if (itemEnchantInput == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(itemX, itemY, 16.0f, 16.0f, 0.0f, 0.03125f, 0.5488281f, 0.5800781f, 9728);
        } else {
            Utils.drawItemStack(itemEnchantInput, itemX, itemY);
        }
        if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
            itemHoverX = itemX;
            itemHoverY = itemY;
            if (itemEnchantInput != null) {
                tooltipToDisplay = itemEnchantInput.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
        }
        if (!this.isChangingEnchLevel && itemHoverX >= 0 && itemHoverY >= 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)itemHoverX, (int)itemHoverY, (int)(itemHoverX + 16), (int)(itemHoverY + 16), (int)(hoverLocked ? -2130739072 : -2130706433));
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        this.renderOrbAnim(partialTicks);
        this.renderMouseStack(stackOnMouse, disallowClick, mouseX, mouseY, width, height, tooltipToDisplay);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    private void renderGemstones(float partialTicks) {
        ItemStack itemEnchantInput;
        int itemY;
        int vOffset;
        int top;
        HexItem item;
        int index;
        int i;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        int playerXpLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        this.leftScroll.tick();
        this.rightScroll.tick();
        this.arrowAmount.tick();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        this.guiLeft = (width - 364) / 2;
        this.guiTop = (height - 215) / 2;
        ArrayList tooltipToDisplay = null;
        boolean disallowClick = false;
        ItemStack stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        int itemHoverX = -1;
        int itemHoverY = -1;
        boolean hoverLocked = false;
        this.func_73733_a(0, 0, width, height, -1072689136, -804253680);
        this.renderBaseTexture();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a("Applicable", (float)(this.guiLeft + 7), (float)(this.guiTop + 7), 0x404040, false);
        fr.func_175065_a("Applied", (float)(this.guiLeft + 247), (float)(this.guiTop + 7), 0x404040, false);
        if (this.currentState == EnchantState.ADDING_GEMSTONE || this.currentState == EnchantState.APPLYING_GEMSTONE) {
            String pageStr = "Page: " + this.currentPage + "/" + this.expectedMaxPage;
            int pageStrLen = fr.func_78256_a(pageStr);
            Utils.drawStringCentered(pageStr, this.guiLeft + 182, this.guiTop + 14, false, 0x404040);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 - pageStrLen / 2 - 2 - 15, this.guiTop + 6, 15.0f, 15.0f, 0.0f, 0.029296875f, 0.7265625f, 0.7558594f, 9728);
            Utils.drawTexturedRect(this.guiLeft + 182 + pageStrLen / 2 + 2, this.guiTop + 6, 15.0f, 15.0f, 0.029296875f, 0.05859375f, 0.7265625f, 0.7558594f, 9728);
        }
        int top2 = this.guiTop + 83;
        if (this.currentState == EnchantState.APPLYING_GEMSTONE) {
            String confirmText = "Apply";
            if (this.removingEnchantPlayerLevel >= 0) {
                confirmText = this.removingEnchantPlayerLevel == this.enchanterCurrentItem.level ? "Remove" : (this.enchanterCurrentItem.level > this.removingEnchantPlayerLevel ? "Upgrade" : "Bad Level");
            }
            if (System.currentTimeMillis() - this.confirmButtonAnimTime < 500L) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 23, top2 + 18 + 9, false, 0x408040);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 24, top2 + 18 + 8, false, 0x408040);
            }
        }
        if (System.currentTimeMillis() - this.cancelButtonAnimTime < 500L) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
            Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 25, top2 + 18 + 9, false, 0xA04040);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
            Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 24, top2 + 18 + 8, false, 0xA04040);
        }
        tooltipToDisplay = this.renderSettings(mouseX, mouseY, tooltipToDisplay);
        this.renderScrollBars(this.applicableItem, this.applicableItem, mouseY);
        this.renderEnchantBook(scaledResolution, partialTicks);
        this.renderArrow();
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.leftScroll.getValue() / 16;
            if (this.applicableItem.size() <= index) break;
            item = this.applicableItem.get(index);
            top = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentItem != null && this.enchanterCurrentItem.itemId.equals(item.itemId) ? 16 : 0;
            int uOffset = item.conflicts ? 112 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 8, top, 96.0f, 16.0f, (float)uOffset / 512.0f, (float)(96 + uOffset) / 512.0f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 8 && mouseX <= this.guiLeft + 8 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (item.displayLore != null) {
                    tooltipToDisplay = item.displayLore;
                }
            }
            String levelStr = this.getIconStr(item);
            int colour = 0xC8FF8F;
            if (item.price > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(item.itemName, (float)(this.guiLeft + 8 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.rightScroll.getValue() / 16;
            if (this.removableItem.size() <= index) break;
            item = this.removableItem.get(index);
            top = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentItem != null && this.enchanterCurrentItem.itemId.equals(item.itemId) ? 16 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 248, top, 96.0f, 16.0f, 0.0f, 0.1875f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 248 && mouseX <= this.guiLeft + 248 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (item.displayLore != null) {
                    tooltipToDisplay = item.displayLore;
                }
            }
            String levelStr = this.getIconStr(item);
            int colour = 0xC8FF8F;
            if (item.price > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(item.itemName, (float)(this.guiLeft + 248 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        fr.func_78276_b(Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150260_c(), this.guiLeft + 102, this.guiTop + 215 - 96 + 2, 0x404040);
        int inventoryStartIndex = cc.func_85151_d().func_70302_i_();
        GlStateManager.func_179126_j();
        for (int i2 = 0; i2 < 36; ++i2) {
            int itemX = this.guiLeft + 102 + 18 * (i2 % 9);
            itemY = this.guiTop + 133 + 18 * (i2 / 9);
            if (i2 >= 27) {
                itemY += 4;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 102 - 8), (float)(this.guiTop + 191 - (inventoryStartIndex / 9 * 18 + 89)), (float)0.0f);
            Slot slot = cc.func_75139_a(inventoryStartIndex + i2);
            ((AccessorGuiContainer)chest).doDrawSlot(slot);
            GlStateManager.func_179121_F();
            if (mouseX < itemX || mouseX >= itemX + 18 || mouseY < itemY || mouseY >= itemY + 18) continue;
            itemHoverX = itemX;
            itemHoverY = itemY;
            hoverLocked = SlotLocking.getInstance().isSlotLocked(slot);
            if (!slot.func_75216_d()) continue;
            tooltipToDisplay = slot.func_75211_c().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (this.currentState == EnchantState.APPLYING_GEMSTONE && this.enchanterCurrentItem != null) {
            int left = this.guiLeft + 182 - 56;
            int top3 = this.guiTop + 83;
            int uOffset = this.enchanterCurrentItem.conflicts ? 112 : 0;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(left, top3, 112.0f, 16.0f, (float)uOffset / 512.0f, (float)(112 + uOffset) / 512.0f, 0.48632812f, 0.5175781f, 9728);
            if (mouseX > left + 16 && mouseX <= left + 96 && mouseY > top3 && mouseY <= top3 + 16) {
                disallowClick = true;
                if (this.enchanterCurrentItem.displayLore != null) {
                    tooltipToDisplay = this.enchanterCurrentItem.displayLore;
                }
            }
            if (mouseY > top3 + 18 && mouseY <= top3 + 18 + 16) {
                if (mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1) {
                    disallowClick = true;
                    if (this.enchanterCurrentItem.displayLore != null) {
                        tooltipToDisplay = this.enchanterCurrentItem.displayLore;
                    }
                } else if (mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48) {
                    disallowClick = true;
                    tooltipToDisplay = Lists.newArrayList((Object[])new String[]{"\u00a7cCancel"});
                }
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS || this.currentState == EnchantState.ADDING_BOOK) {
            this.renderCancel();
        }
        if ((itemEnchantInput = this.isInHex() ? cc.func_75139_a(22).func_75211_c() : cc.func_75139_a(19).func_75211_c()) != null && itemEnchantInput.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
            itemEnchantInput = this.enchantingItem;
        }
        int itemX = this.guiLeft + 174;
        itemY = this.guiTop + 58;
        if (itemEnchantInput == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(itemX, itemY, 16.0f, 16.0f, 0.0f, 0.03125f, 0.5488281f, 0.5800781f, 9728);
        } else {
            Utils.drawItemStack(itemEnchantInput, itemX, itemY);
        }
        if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
            itemHoverX = itemX;
            itemHoverY = itemY;
            if (itemEnchantInput != null) {
                tooltipToDisplay = itemEnchantInput.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
        }
        if (this.currentState == EnchantState.APPLYING_GEMSTONE) {
            int left = this.guiLeft + 182 - 56;
            top = this.guiTop + 83;
            String levelStr = this.getIconStr(this.enchanterCurrentItem);
            int colour = 0xC8FF8F;
            if (this.enchanterCurrentItem.price > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top + 4), colour, false);
            String name = WordUtils.capitalizeFully((String)this.enchanterCurrentItem.itemName);
            if (name.equalsIgnoreCase("Bane of Arthropods")) {
                name = "Bane of Arth.";
            } else if (name.equalsIgnoreCase("Projectile Protection")) {
                name = "Projectile Prot";
            } else if (name.equalsIgnoreCase("Blast Protection")) {
                name = "Blast Prot";
            } else if (name.equalsIgnoreCase("Luck of the Sea")) {
                name = "Luck of Sea";
            } else if (name.equalsIgnoreCase("Turbo Mushrooms")) {
                name = "Turbo-Mush";
            }
            Utils.drawStringCentered(name, this.guiLeft + 182, top + 8, true, -35);
            if (this.isChangingEnchLevel) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(left + 96, top, 16.0f, 16.0f, 0.1875f, 0.21875f, 0.5175781f, 0.5488281f, 9728);
            }
            levelStr = "";
            levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top + 4), 15368959, false);
        }
        if (!this.isChangingEnchLevel && itemHoverX >= 0 && itemHoverY >= 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)itemHoverX, (int)itemHoverY, (int)(itemHoverX + 16), (int)(itemHoverY + 16), (int)(hoverLocked ? -2130739072 : -2130706433));
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        this.renderOrbAnim(partialTicks);
        this.renderMouseStack(stackOnMouse, disallowClick, mouseX, mouseY, width, height, tooltipToDisplay);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    private String getIconStr(HexItem item) {
        String levelStr = "";
        if (item.itemType != ItemType.UNKNOWN) {
            NBTTagCompound ea;
            NBTTagCompound tagItem;
            int potatoCount = 0;
            int killCount = 0;
            int warCount = 0;
            int ffdCount = 0;
            int recombCount = 0;
            int effLevel = 0;
            int starCount = 0;
            int singularityCount = 0;
            int tunerCount = 0;
            int manaDisintegratorCount = 0;
            int peaceCount = 0;
            int dungeonItem = 0;
            boolean shadowWarp = false;
            boolean witherShield = false;
            boolean implosion = false;
            String reforge = "";
            if (this.enchantingItem != null && (tagItem = this.enchantingItem.func_77978_p()) != null && (ea = tagItem.func_74775_l("ExtraAttributes")) != null) {
                potatoCount = ea.func_74762_e("hot_potato_count");
                killCount = ea.func_74762_e("stats_book");
                warCount = ea.func_74762_e("art_of_war_count");
                ffdCount = ea.func_74762_e("farming_for_dummies_count");
                recombCount = ea.func_74762_e("rarity_upgrades");
                starCount = ea.func_74762_e("upgrade_level");
                singularityCount = ea.func_74762_e("wood_singularity_count");
                tunerCount = ea.func_74762_e("tuned_transmission");
                peaceCount = ea.func_74762_e("art_of_peace_count");
                manaDisintegratorCount = ea.func_74762_e("mana_disintegrator_count");
                dungeonItem = ea.func_74762_e("dungeon_item");
                reforge = ea.func_74779_i("modifier");
                NBTTagCompound enchs = ea.func_74775_l("enchantments");
                NBTTagList scrolls = ea.func_150295_c("ability_scroll", 8);
                if (enchs != null) {
                    effLevel = enchs.func_74762_e("efficiency");
                }
                if (scrolls != null) {
                    for (int index = 0; index < scrolls.func_74745_c(); ++index) {
                        if (scrolls.func_150307_f(index).equals("IMPLOSION_SCROLL")) {
                            implosion = true;
                            continue;
                        }
                        if (scrolls.func_150307_f(index).equals("SHADOW_WARP_SCROLL")) {
                            shadowWarp = true;
                            continue;
                        }
                        if (!scrolls.func_150307_f(index).equals("WITHER_SHIELD_SCROLL")) continue;
                        witherShield = true;
                    }
                }
            }
            if (item.itemType == ItemType.HOT_POTATO) {
                levelStr = potatoCount < 10 ? "" + potatoCount : "\u2714";
            } else if (item.itemType == ItemType.FUMING_POTATO) {
                levelStr = potatoCount <= 10 ? "0" : (potatoCount < 15 ? "" + (potatoCount - 10) : "\u2714");
            } else if (item.itemType == ItemType.BOOK_OF_STATS) {
                levelStr = killCount > 0 ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.ART_OF_WAR) {
                levelStr = warCount > 0 ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.FARMING_DUMMY) {
                levelStr = ffdCount < 5 ? "" + ffdCount : "\u2714";
            } else if (item.itemType == ItemType.RECOMB) {
                levelStr = recombCount > 0 ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.SILEX) {
                levelStr = effLevel < 10 ? "\u2716" : "\u2714";
            } else if (item.isPowerScroll()) {
                levelStr = "\u2716";
            } else if (item.isMasterStar()) {
                levelStr = "\u2716";
            } else if (item.isDungeonStar()) {
                levelStr = starCount >= item.itemType.getStarLevel() ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.WOOD_SINGULARITY) {
                levelStr = singularityCount > 0 ? "\u2714" : "\u2716";
            } else if (item.isHypeScroll()) {
                levelStr = shadowWarp ? "\u2714" : (implosion ? "\u2714" : (witherShield ? "\u2714" : "\u2716"));
            } else if (item.itemType == ItemType.TUNER) {
                levelStr = tunerCount >= 4 ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.REFORGE) {
                levelStr = item.getReforge().equalsIgnoreCase(reforge) ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.RANDOM_REFORGE) {
                levelStr = "?";
            } else if (item.itemType == ItemType.ART_OF_PEACE) {
                levelStr = peaceCount > 0 ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.MANA_DISINTEGRATOR) {
                levelStr = manaDisintegratorCount >= 10 ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.CONVERT_TO_DUNGEON) {
                levelStr = dungeonItem > 0 ? "\u2714" : "\u2716";
            } else if (item.itemType == ItemType.RUBY_GEMSTONE) {
                levelStr = "\u2764";
            } else if (item.itemType == ItemType.AMETHYST_GEMSTONE) {
                levelStr = "\u2748";
            } else if (item.itemType == ItemType.SAPPHIRE_GEMSTONE) {
                levelStr = "\u270e";
            } else if (item.itemType == ItemType.JADE_GEMSTONE) {
                levelStr = "\u2618";
            } else if (item.itemType == ItemType.AMBER_GEMSTONE) {
                levelStr = "\u2e15";
            } else if (item.itemType == ItemType.TOPAZ_GEMSTONE) {
                levelStr = "\u2727";
            } else if (item.itemType == ItemType.JASPER_GEMSTONE) {
                levelStr = "\u2741";
            } else if (item.itemType == ItemType.OPAL_GEMSTONE) {
                levelStr = "\u2742";
            } else if (item.itemType == ItemType.ONYX_GEMSTONE) {
                levelStr = "\u2620";
            } else if (item.itemType == ItemType.AQUAMARINE_GEMSTONE) {
                levelStr = "\u03b1";
            } else if (item.itemType == ItemType.CITRINE_GEMSTONE) {
                levelStr = "\u2618";
            } else if (item.itemType == ItemType.PERIDOT_GEMSTONE) {
                levelStr = "\u2618";
            }
        } else {
            levelStr = "?";
        }
        return levelStr;
    }

    private void renderBaseTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, 364.0f, 215.0f, 0.0f, 0.7109375f, 0.0f, 0.41992188f, 9728);
    }

    private List<String> renderSettings(int mouseX, int mouseY, List<String> tooltipToDisplay) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft + 295, this.guiTop + 147, 16.0f, 16.0f, 0.0f, 0.03125f, 0.7558594f, 0.7871094f, 9728);
        float sortingMinU = (float)(NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting * 16) / 512.0f;
        Utils.drawTexturedRect(this.guiLeft + 295, this.guiTop + 147 + 18, 16.0f, 16.0f, sortingMinU, sortingMinU + 0.03125f, 0.8183594f, 0.8496094f, 9728);
        float orderingMinU = (float)(NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering * 16) / 512.0f;
        Utils.drawTexturedRect(this.guiLeft + 295 + 18, this.guiTop + 147 + 18, 16.0f, 16.0f, orderingMinU, orderingMinU + 0.03125f, 0.8496094f, 0.8808594f, 9728);
        if (mouseX >= this.guiLeft + 294 && mouseX < this.guiLeft + 294 + 36 && mouseY >= this.guiTop + 146 && mouseY < this.guiTop + 146 + 36) {
            int index = (mouseX - (this.guiLeft + 295)) / 18 + (mouseY - (this.guiTop + 147)) / 18 * 2;
            switch (index) {
                case 0: {
                    Gui.func_73734_a((int)(this.guiLeft + 295), (int)(this.guiTop + 147), (int)(this.guiLeft + 295 + 16), (int)(this.guiTop + 147 + 16), (int)-2130706433);
                    tooltipToDisplay = this.createTooltip("Enable GUI", 0, "On", "Off");
                    break;
                }
                case 1: {
                    Gui.func_73734_a((int)(this.guiLeft + 295 + 18), (int)(this.guiTop + 147), (int)(this.guiLeft + 295 + 16 + 18), (int)(this.guiTop + 147 + 16), (int)-2130706433);
                    tooltipToDisplay = this.createTooltip("Max Level", NotEnoughUpdates.INSTANCE.config.enchantingSolvers.maxEnchLevel ? 0 : 1, "Enabled", "Disabled");
                    tooltipToDisplay.add(1, EnumChatFormatting.GRAY + "Show max level of enchant");
                    tooltipToDisplay.add(2, EnumChatFormatting.GRAY + "from either hex or enchantment table");
                    tooltipToDisplay.add(3, EnumChatFormatting.GRAY + "max level");
                    break;
                }
                case 2: {
                    Gui.func_73734_a((int)(this.guiLeft + 295), (int)(this.guiTop + 147 + 18), (int)(this.guiLeft + 295 + 16), (int)(this.guiTop + 147 + 16 + 18), (int)-2130706433);
                    tooltipToDisplay = this.createTooltip("Sort enchants...", NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting, "By Cost", "Alphabetically");
                    break;
                }
                case 3: {
                    Gui.func_73734_a((int)(this.guiLeft + 295 + 18), (int)(this.guiTop + 147 + 18), (int)(this.guiLeft + 295 + 16 + 18), (int)(this.guiTop + 147 + 16 + 18), (int)-2130706433);
                    tooltipToDisplay = this.createTooltip("Order enchants...", NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering, "Ascending", "Descending");
                }
            }
        }
        return tooltipToDisplay;
    }

    private void renderScrollBars(List applicable, List removable, int mouseY) {
        int offset;
        if (applicable.size() <= 6) {
            offset = 0;
        } else if (this.isScrollingLeft && this.clickedScrollOffset >= 0) {
            offset = mouseY - this.clickedScrollOffset;
            if (offset < 0) {
                offset = 0;
            }
            if (offset > 81) {
                offset = 81;
            }
        } else {
            offset = Math.round(81.0f * ((float)this.leftScroll.getValue() / (float)((applicable.size() - 6) * 16)));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft + 104, this.guiTop + 18 + offset, 12.0f, 15.0f, 0.0f, 0.0234375f, 0.6113281f, 0.640625f, 9728);
        if (removable.size() <= 6) {
            offset = 0;
        } else if (!this.isScrollingLeft && this.clickedScrollOffset >= 0) {
            offset = mouseY - this.clickedScrollOffset;
            if (offset < 0) {
                offset = 0;
            }
            if (offset > 81) {
                offset = 81;
            }
        } else {
            offset = Math.round(81.0f * ((float)this.rightScroll.getValue() / (float)((removable.size() - 6) * 16)));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft + 344, this.guiTop + 18 + offset, 12.0f, 15.0f, 0.0f, 0.0234375f, 0.6113281f, 0.640625f, 9728);
    }

    private void renderArrow() {
        if (this.arrowAmount.getValue() > 0.0f) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float w = 22.0f * this.arrowAmount.getValue();
            if (this.removingEnchantPlayerLevel < 0) {
                Utils.drawTexturedRect(this.guiLeft + 134, this.guiTop + 58, w, 16.0f, 0.0f, w / 512.0f, 0.5800781f, 0.6113281f, 9728);
            } else {
                Utils.drawTexturedRect((float)(this.guiLeft + 230) - w, this.guiTop + 58, w, 16.0f, (44.0f - w) / 512.0f, 0.0859375f, 0.5800781f, 0.6113281f, 9728);
            }
        }
    }

    private void renderCancel() {
        int top = this.guiTop + 83;
        if (System.currentTimeMillis() - this.cancelButtonAnimTime < 500L) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 + 1, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
            Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 25, top + 18 + 9, false, 0xA04040);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 + 1, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
            Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 24, top + 18 + 8, false, 0xA04040);
        }
    }

    private void renderOrbAnim(float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.orbDisplay.renderOrbs(partialTicks);
        GlStateManager.func_179121_F();
    }

    private void renderMouseStack(ItemStack stackOnMouse, boolean disallowClick, int mouseX, int mouseY, int width, int height, List<String> tooltipToDisplay) {
        if (stackOnMouse != null) {
            if (disallowClick) {
                Utils.drawItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_180401_cv)), mouseX - 8, mouseY - 8);
            } else {
                Utils.drawItemStack(stackOnMouse, mouseX - 8, mouseY - 8);
            }
        } else if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1);
        }
    }

    private void renderEnchantBook(ScaledResolution scaledresolution, float partialTicks) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179083_b((int)((scaledresolution.func_78326_a() - 320) / 2 * scaledresolution.func_78325_e()), (int)((scaledresolution.func_78328_b() - 240) / 2 * scaledresolution.func_78325_e()), (int)(320 * scaledresolution.func_78325_e()), (int)(240 * scaledresolution.func_78325_e()));
        GlStateManager.func_179109_b((float)0.0f, (float)0.33f, (float)0.0f);
        Project.gluPerspective((float)90.0f, (float)1.3333334f, (float)9.0f, (float)80.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        RenderHelper.func_74519_b();
        GlStateManager.func_179109_b((float)0.0f, (float)3.3f, (float)-16.0f);
        GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)5.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ENCHANTMENT_TABLE_BOOK_TEXTURE);
        GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float bookOpenAngle = this.bookOpenLast + (this.bookOpen - this.bookOpenLast) * partialTicks;
        GlStateManager.func_179109_b((float)((1.0f - bookOpenAngle) * 0.2f), (float)((1.0f - bookOpenAngle) * 0.1f), (float)((1.0f - bookOpenAngle) * 0.25f));
        GlStateManager.func_179114_b((float)(-(1.0f - bookOpenAngle) * 90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float pageAngle1 = this.pageOpenLast + (this.pageOpen - this.pageOpenLast) * partialTicks + 0.25f;
        float pageAngle2 = this.pageOpenLast + (this.pageOpen - this.pageOpenLast) * partialTicks + 0.75f;
        pageAngle1 = (pageAngle1 - (float)MathHelper.func_76140_b((double)pageAngle1)) * 1.6f - 0.3f;
        pageAngle2 = (pageAngle2 - (float)MathHelper.func_76140_b((double)pageAngle2)) * 1.6f - 0.3f;
        if (pageAngle1 < 0.0f) {
            pageAngle1 = 0.0f;
        }
        if (pageAngle1 > 1.0f) {
            pageAngle1 = 1.0f;
        }
        if (pageAngle2 < 0.0f) {
            pageAngle2 = 0.0f;
        }
        if (pageAngle2 > 1.0f) {
            pageAngle2 = 1.0f;
        }
        GlStateManager.func_179091_B();
        MODEL_BOOK.func_78088_a(null, 0.0f, pageAngle1, pageAngle2, bookOpenAngle, 0.0f, 0.0625f);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
    }

    private boolean isInEnchanting() {
        return this.currentState == EnchantState.ADDING_ENCHANT || this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.SWITCHING_DONT_UPDATE;
    }

    private boolean isInHex() {
        return this.currentState == EnchantState.HAS_ITEM_IN_HEX || this.currentState == EnchantState.INVALID_ITEM_HEX || this.currentState == EnchantState.NO_ITEM_IN_HEX;
    }

    private boolean isInGemstones() {
        return this.currentState == EnchantState.HAS_ITEM_IN_GEMSTONE || this.currentState == EnchantState.ADDING_GEMSTONE || this.currentState == EnchantState.APPLYING_GEMSTONE;
    }

    public void overrideIsMouseOverSlot(Slot slot, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if ((this.shouldOverrideFast || this.shouldOverrideGemstones || this.shouldOverrideXp) && this.currentState != EnchantState.ADDING_ENCHANT) {
            boolean playerInv = slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by;
            int slotId = slot.getSlotIndex();
            if (playerInv && slotId < 36) {
                if ((slotId -= 9) < 0) {
                    slotId += 36;
                }
                int itemX = this.guiLeft + 102 + 18 * (slotId % 9);
                int itemY = this.guiTop + 133 + 18 * (slotId / 9);
                if (slotId >= 27) {
                    itemY += 4;
                }
                if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
            } else if (slotId == 19 && !this.isInHex() || slotId == 22 && this.isInHex()) {
                cir.setReturnValue((Object)(mouseX >= this.guiLeft + 173 && mouseX < this.guiLeft + 173 + 18 && mouseY >= this.guiTop + 57 && mouseY < this.guiTop + 57 + 18 ? 1 : 0));
            }
        }
    }

    public boolean mouseInput(int mouseX, int mouseY) {
        HexItem item;
        int yIndex;
        int i;
        int top;
        if (Mouse.getEventButtonState() && (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT || this.currentState == EnchantState.HAS_ITEM_IN_HEX || this.currentState == EnchantState.ADDING_BOOK || this.currentState == EnchantState.ADDING_GEMSTONE || this.currentState == EnchantState.APPLYING_GEMSTONE || this.currentState == EnchantState.HAS_ITEM_IN_BOOKS) && mouseY > this.guiTop + 6 && mouseY < this.guiTop + 6 + 15) {
            String pageStr = "Page: " + this.currentPage + "/" + this.expectedMaxPage;
            int pageStrLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(pageStr);
            int click = -1;
            if (mouseX > this.guiLeft + 182 - pageStrLen / 2 - 2 - 15 && mouseX <= this.guiLeft + 182 - pageStrLen / 2 - 2) {
                click = 17;
            } else if (mouseX > this.guiLeft + 182 + pageStrLen / 2 + 2 && mouseX <= this.guiLeft + 182 + pageStrLen / 2 + 2 + 15) {
                click = 35;
            }
            if (click >= 0) {
                if (this.currentState == EnchantState.ADDING_ENCHANT || this.currentState == EnchantState.ADDING_BOOK) {
                    if (Mouse.getEventButtonState()) {
                        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                            return true;
                        }
                        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                        EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                        short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                        ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                        this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                        this.cancelButtonAnimTime = System.currentTimeMillis();
                    }
                } else {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                    short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(click);
                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, click, 0, 0, stack, transactionID));
                }
                return true;
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.HAS_ITEM_IN_BOOKS || this.currentState == EnchantState.HAS_ITEM_IN_GEMSTONE) {
            if (Mouse.getEventButtonState()) {
                int top2 = this.guiTop + 83;
                if (!this.isChangingEnchLevel && mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48 && mouseY > top2 + 18 && mouseY <= top2 + 18 + 14) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    this.leftScroll.setValue(0);
                    this.rightScroll.setValue(0);
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    if (this.currentState != EnchantState.ADDING_BOOK) {
                        EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                        short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                        ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                        this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                        if (this.isInGemstones()) {
                            this.currentState = EnchantState.HAS_ITEM_IN_GEMSTONE;
                        }
                    } else {
                        this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                    }
                    this.searchField.setText("");
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                    this.enchanterCurrentItem = null;
                }
                if (mouseX > this.guiLeft + 182 - this.searchField.getWidth() / 2 && mouseX < this.guiLeft + 182 + this.searchField.getWidth() / 2 && mouseY > this.guiTop + 80 && mouseY < this.guiTop + 96) {
                    this.searchField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                } else {
                    this.searchField.setFocus(false);
                }
            } else if (Mouse.getEventButton() < 0 && this.searchField.getFocus() && Mouse.isButtonDown((int)0)) {
                this.searchField.mouseClickMove(mouseX, mouseY, 0, 0L);
            }
        } else if (this.currentState == EnchantState.ADDING_ENCHANT && !this.enchanterEnchLevels.isEmpty()) {
            if (Mouse.getEventButtonState()) {
                short transactionID;
                EntityPlayerSP playerIn;
                int left = this.guiLeft + 182 - 56;
                top = this.guiTop + 83;
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                if (!this.isChangingEnchLevel && mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    playerIn = Minecraft.func_71410_x().field_71439_g;
                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                } else if (!this.isChangingEnchLevel && this.enchanterCurrentEnch != null && mouseX > left + 16 && mouseX <= left + 96 && mouseY > top && mouseY <= top + 16 || mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    playerIn = Minecraft.func_71410_x().field_71439_g;
                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(this.enchanterCurrentEnch.slotIndex);
                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, this.enchanterCurrentEnch.slotIndex, 0, 0, stack, transactionID));
                    int playerXpLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
                    if (playerXpLevel >= this.enchanterCurrentEnch.xpCost) {
                        if (this.removingEnchantPlayerLevel >= 0 && this.enchanterCurrentEnch.level == this.removingEnchantPlayerLevel) {
                            this.orbDisplay.spawnExperienceOrbs(182, 66, 182, 36, 3);
                        } else {
                            this.orbDisplay.spawnExperienceOrbs(mouseX - this.guiLeft, mouseY - this.guiTop, 182, 66, 0);
                        }
                    }
                    this.confirmButtonAnimTime = System.currentTimeMillis();
                } else if (mouseX > left + 96 && mouseX <= left + 96 + 16) {
                    if (!this.isChangingEnchLevel) {
                        if (mouseY > top && mouseY < top + 16) {
                            this.isChangingEnchLevel = true;
                            return true;
                        }
                    } else {
                        ArrayList<Enchantment> before = new ArrayList<Enchantment>();
                        ArrayList<Enchantment> after = new ArrayList<Enchantment>();
                        for (Enchantment ench : this.enchanterEnchLevels.values()) {
                            if (ench.level < this.enchanterCurrentEnch.level) {
                                before.add(ench);
                                continue;
                            }
                            if (ench.level <= this.enchanterCurrentEnch.level) continue;
                            after.add(ench);
                        }
                        before.sort(Comparator.comparingInt(o -> -o.level));
                        after.sort(Comparator.comparingInt(o -> o.level));
                        int bSize = before.size();
                        int aSize = after.size();
                        for (i = 0; i < bSize + aSize; ++i) {
                            Enchantment ench;
                            if (i < bSize) {
                                yIndex = -i - 1;
                                ench = (Enchantment)before.get(i);
                            } else {
                                yIndex = i - bSize + 1;
                                ench = (Enchantment)after.get(i - bSize);
                            }
                            if (mouseY <= top + 16 * yIndex || mouseY > top + 16 * yIndex + 16) continue;
                            this.enchanterCurrentEnch = ench;
                            this.isChangingEnchLevel = false;
                            return true;
                        }
                    }
                }
                if (this.isChangingEnchLevel) {
                    this.isChangingEnchLevel = false;
                    return true;
                }
            }
        } else if (this.currentState == EnchantState.ADDING_BOOK) {
            if (Mouse.getEventButtonState()) {
                int left = this.guiLeft + 182 - 56;
                top = this.guiTop + 83;
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                if (!this.isChangingEnchLevel && mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                    this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                    this.enchanterCurrentItem = null;
                } else if (!this.isChangingEnchLevel && this.enchanterCurrentItem != null && mouseX > left + 16 && mouseX <= left + 96 && mouseY > top && mouseY <= top + 16 || mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                    short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(this.enchanterCurrentItem.slotIndex);
                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, this.enchanterCurrentItem.slotIndex, 0, 0, stack, transactionID));
                    if (this.removingEnchantPlayerLevel >= 0 && this.enchanterCurrentItem.level == this.removingEnchantPlayerLevel) {
                        this.orbDisplay.spawnExperienceOrbs(182, 66, 182, 36, 3);
                    } else {
                        this.orbDisplay.spawnExperienceOrbs(mouseX - this.guiLeft, mouseY - this.guiTop, 182, 66, 0);
                    }
                    this.confirmButtonAnimTime = System.currentTimeMillis();
                    this.enchanterCurrentItem = null;
                    this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                } else if (mouseX > left + 96 && mouseX <= left + 96 + 16) {
                    if (!this.isChangingEnchLevel) {
                        if (mouseY > top && mouseY < top + 16) {
                            this.isChangingEnchLevel = true;
                            return true;
                        }
                    } else {
                        ArrayList<HexItem> before = new ArrayList<HexItem>();
                        ArrayList<HexItem> after = new ArrayList<HexItem>();
                        for (HexItem item2 : this.enchanterItemLevels.values()) {
                            if (item2.level < this.enchanterCurrentItem.level) {
                                before.add(item2);
                                continue;
                            }
                            if (item2.level <= this.enchanterCurrentItem.level) continue;
                            after.add(item2);
                        }
                        before.sort(Comparator.comparingInt(o -> -o.level));
                        after.sort(Comparator.comparingInt(o -> o.level));
                        int bSize = before.size();
                        int aSize = after.size();
                        for (i = 0; i < bSize + aSize; ++i) {
                            if (i < bSize) {
                                yIndex = -i - 1;
                                item = (HexItem)before.get(i);
                            } else {
                                yIndex = i - bSize + 1;
                                item = (HexItem)after.get(i - bSize);
                            }
                            if (mouseY <= top + 16 * yIndex || mouseY > top + 16 * yIndex + 16) continue;
                            this.enchanterCurrentItem = item;
                            this.isChangingEnchLevel = false;
                            return true;
                        }
                    }
                }
                if (this.isChangingEnchLevel) {
                    this.isChangingEnchLevel = false;
                    return true;
                }
            }
        } else if (this.currentState == EnchantState.HAS_ITEM_IN_HEX) {
            if (Mouse.getEventButtonState()) {
                int left = this.guiLeft + 182 - 56;
                top = this.guiTop + 83;
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                if (this.isChangingEnchLevel || mouseX <= this.guiLeft + 182 + 1 || mouseX > this.guiLeft + 182 + 1 + 48 || mouseY <= top + 18 || mouseY > top + 18 + 14) {
                    if (!this.isChangingEnchLevel && this.enchanterCurrentItem != null && mouseX > left + 16 && mouseX <= left + 96 && mouseY > top && mouseY <= top + 16 || mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                            return true;
                        }
                        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                        EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                        short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                        ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(this.enchanterCurrentItem.slotIndex);
                        this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, this.enchanterCurrentItem.slotIndex, 0, 0, stack, transactionID));
                        this.enchantingItem = null;
                        if (this.removingEnchantPlayerLevel >= 0 && this.enchanterCurrentItem.level == this.removingEnchantPlayerLevel) {
                            this.orbDisplay.spawnExperienceOrbs(182, 66, 182, 36, 3);
                        } else {
                            this.orbDisplay.spawnExperienceOrbs(mouseX - this.guiLeft, mouseY - this.guiTop, 182, 66, 0);
                        }
                        this.confirmButtonAnimTime = System.currentTimeMillis();
                    } else if (mouseX > left + 96 && mouseX <= left + 96 + 16) {
                        if (!this.isChangingEnchLevel) {
                            if (mouseY > top && mouseY < top + 16) {
                                this.isChangingEnchLevel = true;
                                return true;
                            }
                        } else {
                            ArrayList<HexItem> before = new ArrayList<HexItem>();
                            ArrayList<HexItem> after = new ArrayList<HexItem>();
                            for (HexItem item3 : this.enchanterItemLevels.values()) {
                                if (item3.level < this.enchanterCurrentItem.level) {
                                    before.add(item3);
                                    continue;
                                }
                                if (item3.level <= this.enchanterCurrentItem.level) continue;
                                after.add(item3);
                            }
                            before.sort(Comparator.comparingInt(o -> -o.level));
                            after.sort(Comparator.comparingInt(o -> o.level));
                            int bSize = before.size();
                            int aSize = after.size();
                            for (i = 0; i < bSize + aSize; ++i) {
                                if (i < bSize) {
                                    yIndex = -i - 1;
                                    item = (HexItem)before.get(i);
                                } else {
                                    yIndex = i - bSize + 1;
                                    item = (HexItem)after.get(i - bSize);
                                }
                                if (mouseY <= top + 16 * yIndex || mouseY > top + 16 * yIndex + 16) continue;
                                this.enchanterCurrentItem = item;
                                this.isChangingEnchLevel = false;
                                return true;
                            }
                        }
                    }
                }
                if (this.isChangingEnchLevel) {
                    this.isChangingEnchLevel = false;
                    return true;
                }
            }
        } else if ((this.currentState == EnchantState.ADDING_GEMSTONE || this.currentState == EnchantState.APPLYING_GEMSTONE) && Mouse.getEventButtonState()) {
            short transactionID;
            EntityPlayerSP playerIn;
            int left = this.guiLeft + 182 - 56;
            top = this.guiTop + 83;
            Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
            Utils.drawTexturedRect(this.guiLeft + 182 + 1, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
            if (!this.isChangingEnchLevel && mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                    return true;
                }
                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                if (this.currentState != EnchantState.APPLYING_GEMSTONE) {
                    playerIn = Minecraft.func_71410_x().field_71439_g;
                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                    this.currentState = EnchantState.HAS_ITEM_IN_GEMSTONE;
                    this.enchanterCurrentItem = null;
                } else {
                    this.currentState = EnchantState.ADDING_ENCHANT;
                    this.enchanterCurrentItem = null;
                }
            } else if (!this.isChangingEnchLevel && this.enchanterCurrentItem != null && mouseX > left + 16 && mouseX <= left + 96 && mouseY > top && mouseY <= top + 16 || mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1 && mouseY > top + 18 && mouseY <= top + 18 + 14 && this.currentState == EnchantState.APPLYING_GEMSTONE) {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                    return true;
                }
                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                playerIn = Minecraft.func_71410_x().field_71439_g;
                transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(this.enchanterCurrentItem.slotIndex);
                this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, this.enchanterCurrentItem.slotIndex, 0, 0, stack, transactionID));
                this.enchantingItem = null;
                if (this.removingEnchantPlayerLevel >= 0 && this.enchanterCurrentItem.level == this.removingEnchantPlayerLevel) {
                    this.orbDisplay.spawnExperienceOrbs(182, 66, 182, 36, 3);
                } else {
                    this.orbDisplay.spawnExperienceOrbs(mouseX - this.guiLeft, mouseY - this.guiTop, 182, 66, 0);
                }
                this.confirmButtonAnimTime = System.currentTimeMillis();
                this.enchanterCurrentItem = null;
                this.currentState = EnchantState.ADDING_GEMSTONE;
            } else if (mouseX > left + 96 && mouseX <= left + 96 + 16) {
                if (!this.isChangingEnchLevel) {
                    if (mouseY > top && mouseY < top + 16) {
                        this.isChangingEnchLevel = true;
                        return true;
                    }
                } else {
                    ArrayList<HexItem> before = new ArrayList<HexItem>();
                    ArrayList<HexItem> after = new ArrayList<HexItem>();
                    for (HexItem item4 : this.enchanterItemLevels.values()) {
                        if (item4.level < this.enchanterCurrentItem.level) {
                            before.add(item4);
                            continue;
                        }
                        if (item4.level <= this.enchanterCurrentItem.level) continue;
                        after.add(item4);
                    }
                    before.sort(Comparator.comparingInt(o -> -o.level));
                    after.sort(Comparator.comparingInt(o -> o.level));
                    int bSize = before.size();
                    int aSize = after.size();
                    for (i = 0; i < bSize + aSize; ++i) {
                        if (i < bSize) {
                            yIndex = -i - 1;
                            item = (HexItem)before.get(i);
                        } else {
                            yIndex = i - bSize + 1;
                            item = (HexItem)after.get(i - bSize);
                        }
                        if (mouseY <= top + 16 * yIndex || mouseY > top + 16 * yIndex + 16) continue;
                        this.enchanterCurrentItem = item;
                        this.isChangingEnchLevel = false;
                        return true;
                    }
                }
            }
            if (this.isChangingEnchLevel) {
                this.isChangingEnchLevel = false;
                return true;
            }
        }
        if (!Mouse.getEventButtonState() && Mouse.getEventButton() < 0 && this.clickedScrollOffset != -1) {
            if (this.isInEnchanting()) {
                List<Enchantment> enchantsList;
                LerpingInteger lerpingInteger = this.isClickedScrollLeft ? this.leftScroll : this.rightScroll;
                List<Enchantment> list = enchantsList = this.isClickedScrollLeft ? this.applicable : this.removable;
                if (enchantsList.size() > 6) {
                    int max2;
                    int newOffset = mouseY - this.clickedScrollOffset;
                    int newScroll = Math.round((float)newOffset * (float)((enchantsList.size() - 6) * 16) / 81.0f);
                    if (newScroll > (max2 = (enchantsList.size() - 6) * 16)) {
                        newScroll = max2;
                    }
                    if (newScroll < 0) {
                        newScroll = 0;
                    }
                    lerpingInteger.setValue(newScroll);
                }
            } else {
                List<HexItem> itemsList;
                LerpingInteger lerpingInteger = this.isClickedScrollLeft ? this.leftScroll : this.rightScroll;
                List<HexItem> list = itemsList = this.isClickedScrollLeft ? this.applicableItem : this.removableItem;
                if (itemsList.size() > 6) {
                    int max3;
                    int newOffset = mouseY - this.clickedScrollOffset;
                    int newScroll = Math.round((float)newOffset * (float)((itemsList.size() - 6) * 16) / 81.0f);
                    if (newScroll > (max3 = (itemsList.size() - 6) * 16)) {
                        newScroll = max3;
                    }
                    if (newScroll < 0) {
                        newScroll = 0;
                    }
                    lerpingInteger.setValue(newScroll);
                }
            }
        }
        if (Mouse.getEventButtonState() && mouseX >= this.guiLeft + 294 && mouseX < this.guiLeft + 294 + 36 && mouseY >= this.guiTop + 146 && mouseY < this.guiTop + 146 + 36) {
            int index = (mouseX - (this.guiLeft + 295)) / 18 + (mouseY - (this.guiTop + 147)) / 18 * 2;
            int direction = Mouse.getEventButton() == 0 ? 1 : -1;
            switch (index) {
                case 0: {
                    NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableHexGUI = false;
                    break;
                }
                case 1: {
                    NotEnoughUpdates.INSTANCE.config.enchantingSolvers.maxEnchLevel = !NotEnoughUpdates.INSTANCE.config.enchantingSolvers.maxEnchLevel;
                    break;
                }
                case 2: {
                    int val = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting;
                    if ((val += direction) < 0) {
                        val = 1;
                    }
                    if (val > 1) {
                        val = 0;
                    }
                    NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting = val;
                    break;
                }
                case 3: {
                    int val = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering;
                    if ((val += direction) < 0) {
                        val = 1;
                    }
                    if (val > 1) {
                        val = 0;
                    }
                    NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering = val;
                    break;
                }
            }
        }
        if (Mouse.getEventButton() == 0) {
            if (Mouse.getEventButtonState()) {
                int offset;
                if (this.isInEnchanting()) {
                    int offset2;
                    if (mouseX > this.guiLeft + 104 && mouseX < this.guiLeft + 104 + 12) {
                        int offset3 = this.applicable.size() <= 6 ? 0 : Math.round(81.0f * ((float)this.leftScroll.getValue() / (float)((this.applicable.size() - 6) * 16)));
                        if (mouseY >= this.guiTop + 18 + offset3 && mouseY < this.guiTop + 18 + offset3 + 15) {
                            this.isClickedScrollLeft = true;
                            this.clickedScrollOffset = mouseY - offset3;
                        }
                    } else if (mouseX > this.guiLeft + 344 && mouseX < this.guiLeft + 344 + 12 && mouseY >= this.guiTop + 18 + (offset2 = this.removable.size() <= 6 ? 0 : Math.round(81.0f * ((float)this.rightScroll.getValue() / (float)((this.removable.size() - 6) * 16)))) && mouseY < this.guiTop + 18 + offset2 + 15) {
                        this.isClickedScrollLeft = false;
                        this.clickedScrollOffset = mouseY - offset2;
                    }
                } else if (mouseX > this.guiLeft + 104 && mouseX < this.guiLeft + 104 + 12) {
                    int offset4 = this.applicableItem.size() <= 6 ? 0 : Math.round(81.0f * ((float)this.leftScroll.getValue() / (float)((this.applicableItem.size() - 6) * 16)));
                    if (mouseY >= this.guiTop + 18 + offset4 && mouseY < this.guiTop + 18 + offset4 + 15) {
                        this.isClickedScrollLeft = true;
                        this.clickedScrollOffset = mouseY - offset4;
                    }
                } else if (mouseX > this.guiLeft + 344 && mouseX < this.guiLeft + 344 + 12 && mouseY >= this.guiTop + 18 + (offset = this.removableItem.size() <= 6 ? 0 : Math.round(81.0f * ((float)this.rightScroll.getValue() / (float)((this.removableItem.size() - 6) * 16)))) && mouseY < this.guiTop + 18 + offset + 15) {
                    this.isClickedScrollLeft = false;
                    this.clickedScrollOffset = mouseY - offset;
                }
            } else {
                this.clickedScrollOffset = -1;
            }
        }
        if (mouseY > this.guiTop + 18 && mouseY < this.guiTop + 18 + 96) {
            ItemStack stack;
            short transactionID;
            if (mouseX > this.guiLeft + 8 && mouseX < this.guiLeft + 8 + 96) {
                if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null) {
                    if (this.isInEnchanting()) {
                        for (int i2 = 0; i2 < 7; ++i2) {
                            int index = i2 + this.leftScroll.getValue() / 16;
                            if (this.applicable.size() > index) {
                                int top3 = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i2;
                                if (mouseX <= this.guiLeft + 8 || mouseX > this.guiLeft + 8 + 96 || mouseY <= top3 || mouseY > top3 + 16) continue;
                                Enchantment ench = this.applicable.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                if (this.currentState == EnchantState.HAS_ITEM) {
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(ench.slotIndex);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, ench.slotIndex, 0, 0, stack, transactionID));
                                } else if (this.currentState == EnchantState.ADDING_ENCHANT) {
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                                    this.cancelButtonAnimTime = System.currentTimeMillis();
                                }
                                return true;
                            }
                            break;
                        }
                    } else if (!this.isInHex() && !this.isInGemstones()) {
                        for (int i3 = 0; i3 < 7; ++i3) {
                            int index = i3 + this.leftScroll.getValue() / 16;
                            if (this.applicableItem.size() > index) {
                                int top4 = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i3;
                                if (mouseX <= this.guiLeft + 8 || mouseX > this.guiLeft + 8 + 96 || mouseY <= top4 || mouseY > top4 + 16) continue;
                                HexItem item5 = this.applicableItem.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS) {
                                    this.currentState = EnchantState.ADDING_BOOK;
                                    this.enchanterCurrentItem = item5;
                                } else if (this.currentState == EnchantState.ADDING_BOOK && this.enchanterCurrentItem == item5) {
                                    this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(item5.slotIndex);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, item5.slotIndex, 0, 0, stack, transactionID));
                                    this.cancelButtonAnimTime = System.currentTimeMillis();
                                } else {
                                    this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                                    this.enchanterCurrentItem = null;
                                }
                                return true;
                            }
                            break;
                        }
                    } else if (this.isInHex() && !this.isInGemstones()) {
                        for (int i4 = 0; i4 < 7; ++i4) {
                            int index = i4 + this.leftScroll.getValue() / 16;
                            if (this.applicableItem.size() > index) {
                                int top5 = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i4;
                                if (mouseX <= this.guiLeft + 8 || mouseX > this.guiLeft + 8 + 96 || mouseY <= top5 || mouseY > top5 + 16) continue;
                                HexItem item6 = this.applicableItem.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                                EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(item6.slotIndex);
                                this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, item6.slotIndex, 0, 0, stack, transactionID));
                                return true;
                            }
                            break;
                        }
                    } else if (this.currentState == EnchantState.ADDING_GEMSTONE || this.currentState == EnchantState.APPLYING_GEMSTONE) {
                        for (int i5 = 0; i5 < 7; ++i5) {
                            int index = i5 + this.leftScroll.getValue() / 16;
                            if (this.applicableItem.size() > index) {
                                int top6 = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i5;
                                if (mouseX <= this.guiLeft + 8 || mouseX > this.guiLeft + 8 + 96 || mouseY <= top6 || mouseY > top6 + 16) continue;
                                HexItem item7 = this.applicableItem.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                if (this.currentState == EnchantState.ADDING_GEMSTONE) {
                                    this.currentState = EnchantState.APPLYING_GEMSTONE;
                                    this.enchanterCurrentItem = item7;
                                } else if (this.currentState == EnchantState.APPLYING_GEMSTONE && this.enchanterCurrentItem == item7) {
                                    this.currentState = EnchantState.ADDING_GEMSTONE;
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(item7.slotIndex);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, item7.slotIndex, 0, 0, stack, transactionID));
                                    this.cancelButtonAnimTime = System.currentTimeMillis();
                                } else {
                                    this.currentState = EnchantState.ADDING_GEMSTONE;
                                    this.enchanterCurrentItem = null;
                                }
                                return true;
                            }
                            break;
                        }
                    } else if (this.currentState == EnchantState.HAS_ITEM_IN_GEMSTONE) {
                        for (int i6 = 0; i6 < 7; ++i6) {
                            int index = i6 + this.leftScroll.getValue() / 16;
                            if (this.applicableItem.size() > index) {
                                int top7 = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i6;
                                if (mouseX <= this.guiLeft + 8 || mouseX > this.guiLeft + 8 + 96 || mouseY <= top7 || mouseY > top7 + 16) continue;
                                HexItem item8 = this.applicableItem.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(item8.slotIndex);
                                this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, item8.slotIndex, 0, 0, stack, transactionID));
                                this.cancelButtonAnimTime = System.currentTimeMillis();
                                return true;
                            }
                            break;
                        }
                    }
                }
                this.isScrollingLeft = true;
            } else if (mouseX > this.guiLeft + 248 && mouseX < this.guiLeft + 248 + 96) {
                if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null) {
                    if (this.isInEnchanting()) {
                        for (int i7 = 0; i7 < 7; ++i7) {
                            int index = i7 + this.rightScroll.getValue() / 16;
                            if (this.removable.size() > index) {
                                int top8 = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i7;
                                if (mouseX <= this.guiLeft + 248 || mouseX > this.guiLeft + 248 + 96 || mouseY <= top8 || mouseY > top8 + 16) continue;
                                Enchantment ench = this.removable.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                if (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.HAS_ITEM_IN_HEX) {
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(ench.slotIndex);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, ench.slotIndex, 0, 0, stack, transactionID));
                                } else if (this.currentState == EnchantState.ADDING_ENCHANT) {
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                                    this.cancelButtonAnimTime = System.currentTimeMillis();
                                }
                                return true;
                            }
                            break;
                        }
                    } else if (this.currentState == EnchantState.ADDING_GEMSTONE) {
                        for (int i8 = 0; i8 < 7; ++i8) {
                            int index = i8 + this.rightScroll.getValue() / 16;
                            if (this.removableItem.size() > index) {
                                int top9 = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i8;
                                if (mouseX <= this.guiLeft + 248 || mouseX > this.guiLeft + 248 + 96 || mouseY <= top9 || mouseY > top9 + 16) continue;
                                HexItem item9 = this.removableItem.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                if (this.currentState == EnchantState.ADDING_GEMSTONE) {
                                    this.currentState = EnchantState.APPLYING_GEMSTONE;
                                    this.enchanterCurrentItem = item9;
                                } else if (this.currentState == EnchantState.APPLYING_GEMSTONE && this.enchanterCurrentItem == item9) {
                                    this.currentState = EnchantState.ADDING_GEMSTONE;
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(item9.slotIndex);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, item9.slotIndex, 0, 0, stack, transactionID));
                                    this.cancelButtonAnimTime = System.currentTimeMillis();
                                } else {
                                    this.currentState = EnchantState.ADDING_GEMSTONE;
                                    this.enchanterCurrentItem = null;
                                }
                                return true;
                            }
                            break;
                        }
                    } else {
                        for (int i9 = 0; i9 < 7; ++i9) {
                            int index = i9 + this.rightScroll.getValue() / 16;
                            if (this.removableItem.size() > index) {
                                int top10 = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i9;
                                if (mouseX <= this.guiLeft + 248 || mouseX > this.guiLeft + 248 + 96 || mouseY <= top10 || mouseY > top10 + 16) continue;
                                HexItem item10 = this.removableItem.get(index);
                                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                                    return true;
                                }
                                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                                if (this.currentState == EnchantState.HAS_ITEM_IN_BOOKS) {
                                    this.currentState = EnchantState.ADDING_BOOK;
                                    this.enchanterCurrentItem = item10;
                                } else if (this.currentState == EnchantState.ADDING_BOOK && this.enchanterCurrentItem == item10) {
                                    this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                                    transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                                    stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(item10.slotIndex);
                                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, item10.slotIndex, 0, 0, stack, transactionID));
                                    this.cancelButtonAnimTime = System.currentTimeMillis();
                                } else {
                                    this.currentState = EnchantState.HAS_ITEM_IN_BOOKS;
                                    this.enchanterCurrentItem = null;
                                }
                                return true;
                            }
                            break;
                        }
                    }
                }
                this.isScrollingLeft = false;
            }
        }
        if (Mouse.getEventDWheel() != 0) {
            LerpingInteger lerpingInteger;
            int scroll = Mouse.getEventDWheel();
            scroll = scroll > 0 ? -16 : 16;
            LerpingInteger lerpingInteger2 = lerpingInteger = this.isScrollingLeft ? this.leftScroll : this.rightScroll;
            int elementsCount = this.isInEnchanting() ? (this.isScrollingLeft ? this.applicable.size() : this.removable.size()) : (this.isScrollingLeft ? this.applicableItem.size() : this.removableItem.size());
            int max4 = (elementsCount - 6) * 16;
            int newTarget = lerpingInteger.getTarget() + scroll;
            if (newTarget > max4) {
                newTarget = max4;
            }
            if (newTarget < 0) {
                newTarget = 0;
            }
            if (newTarget != lerpingInteger.getTarget()) {
                lerpingInteger.resetTimer();
                lerpingInteger.setTarget(newTarget);
            }
        }
        if (mouseX > this.guiLeft + 102 && mouseX < this.guiLeft + 102 + 160 && (mouseY > this.guiTop + 133 && mouseY < this.guiTop + 133 + 54 || mouseY > this.guiTop + 133 + 54 + 4 && mouseY < this.guiTop + 133 + 54 + 4 + 18)) {
            if (this.currentState == EnchantState.ADDING_ENCHANT) {
                if (Mouse.getEventButtonState()) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                    short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                }
                return true;
            }
            return false;
        }
        if (mouseX >= this.guiLeft + 173 && mouseX < this.guiLeft + 173 + 18 && mouseY >= this.guiTop + 57 && mouseY < this.guiTop + 57 + 18) {
            if (this.currentState == EnchantState.ADDING_ENCHANT) {
                if (Mouse.getEventButtonState()) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                    short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                    this.onClick(new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void onClick(C0EPacketClickWindow packet) {
        Container cont = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        SlotClickEvent clickEvent = new SlotClickEvent((GuiContainer)Minecraft.func_71410_x().field_71462_r, cont.func_75139_a(packet.func_149544_d()), packet.func_149544_d(), packet.func_149543_e(), packet.func_149542_h());
        HexPriceWarning.INSTANCE.onClick(clickEvent);
        if (!clickEvent.isCanceled()) {
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)packet);
        }
    }

    public boolean keyboardInput() {
        if (this.currentState == EnchantState.HAS_ITEM && this.searchField.getFocus()) {
            if (Keyboard.getEventKeyState()) {
                this.searchField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            }
            return true;
        }
        if (Keyboard.getEventKey() == Minecraft.func_71410_x().field_71474_y.field_151447_Z.func_151463_i()) {
            return false;
        }
        return Keyboard.getEventKey() != 1 && Keyboard.getEventKey() != Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i() && (!NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking || Keyboard.getEventKey() != NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockKey);
    }

    private String fixName(String name) {
        if ((name = name.replace("Enrichment", "Enrich")).equalsIgnoreCase("Hot Potato Book")) {
            name = "Hot Potato";
        } else if (name.equalsIgnoreCase("Fuming Potato Book")) {
            name = "Fuming Potato";
        } else if (name.equalsIgnoreCase("Recombobulator 3000")) {
            name = "Recombobulator";
        } else if (name.contains("Power Scroll")) {
            name = name.replace("Power ", "");
        } else if (name.contains("\u272a")) {
            name = name.replaceAll("[^\u272a]*", "");
        } else if (name.equalsIgnoreCase("First Master Star")) {
            name = "Master Star \u00a7c\u278a";
        } else if (name.equalsIgnoreCase("Second Master Star")) {
            name = "Master Star \u00a7c\u278b";
        } else if (name.equalsIgnoreCase("Third Master Star")) {
            name = "Master Star \u00a7c\u278c";
        } else if (name.equalsIgnoreCase("Fourth Master Star")) {
            name = "Master Star \u00a7c\u278d";
        } else if (name.equalsIgnoreCase("Fifth Master Star")) {
            name = "Master Star \u00a7c\u278e";
        } else if (name.equalsIgnoreCase("The Art Of Peace")) {
            name = "Art Of Peace";
        } else if (name.equalsIgnoreCase("Mana Disintegrator")) {
            name = "M Disintegrator";
        } else if (name.equalsIgnoreCase("Intelligence Enrich")) {
            name = "Int Enrich";
        } else if (name.equalsIgnoreCase("Critical Damage Enrich")) {
            name = "Cd Enrich";
        } else if (name.equalsIgnoreCase("Strength Enrich")) {
            name = "Str Enrich";
        } else if (name.equalsIgnoreCase("Magic Find Enrich")) {
            name = "Mf Enrich";
        } else if (name.equalsIgnoreCase("Ferocity Enrich")) {
            name = "Fero Enrich";
        } else if (name.equalsIgnoreCase("Sea Creature Chance Enrich")) {
            name = "SCC Enrich";
        } else if (name.equalsIgnoreCase("Attack Speed Enrich")) {
            name = "Atk Spd Enrich";
        }
        return name;
    }

    public class Enchantment {
        public int slotIndex;
        public String enchantName;
        public String enchId;
        public List<String> displayLore;
        public int level;
        public int xpCost = -1;
        public boolean overMaxLevel = false;
        public boolean conflicts = false;
        public int price = -1;

        public Enchantment(int slotIndex, String enchantName, String enchId, List<String> displayLore, int level, boolean useMaxLevelForCost, boolean checkConflicts) {
            JsonObject bazaarInfo;
            this.slotIndex = slotIndex;
            this.enchantName = enchantName;
            this.enchId = enchId;
            this.displayLore = displayLore;
            this.level = level;
            boolean isUlt = false;
            for (String lore : displayLore) {
                if (!lore.contains("\u00a7l")) continue;
                isUlt = true;
                break;
            }
            if ((bazaarInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo((isUlt ? "ULTIMATE_" : "") + enchId.toUpperCase(Locale.ROOT) + ";" + level)) != null && bazaarInfo.get("curr_buy") != null) {
                this.price = bazaarInfo.get("curr_buy").getAsInt();
            }
            this.enchId = ItemUtils.fixEnchantId(this.enchId, true);
            if (Constants.ENCHANTS != null) {
                if (checkConflicts && Constants.ENCHANTS.has("enchant_pools")) {
                    JsonArray pools = Constants.ENCHANTS.getAsJsonArray("enchant_pools");
                    block1: for (int i = 0; i < pools.size(); ++i) {
                        JsonArray pool = pools.get(i).getAsJsonArray();
                        boolean hasThis = false;
                        boolean hasApplied = false;
                        for (int j = 0; j < pool.size(); ++j) {
                            String enchIdPoolElement = pool.get(j).getAsString();
                            if (this.enchId.equalsIgnoreCase(enchIdPoolElement)) {
                                hasThis = true;
                            } else if (GuiCustomHex.this.playerEnchantIds.containsKey(enchIdPoolElement)) {
                                hasApplied = true;
                            }
                            if (!hasThis || !hasApplied) continue;
                            this.conflicts = true;
                            break block1;
                        }
                    }
                }
                if (level >= 1 && Constants.ENCHANTS.has("enchants_xp_cost")) {
                    JsonArray costs;
                    JsonObject allCosts = Constants.ENCHANTS.getAsJsonObject("enchants_xp_cost");
                    JsonObject maxLevel = null;
                    if (NotEnoughUpdates.INSTANCE.config.enchantingSolvers.maxEnchLevel && Constants.ENCHANTS.has("max_xp_table_levels")) {
                        maxLevel = Constants.ENCHANTS.getAsJsonObject("max_xp_table_levels");
                    }
                    if (allCosts.has(this.enchId) && (costs = allCosts.getAsJsonArray(this.enchId)).size() >= 1) {
                        if (useMaxLevelForCost) {
                            int cost = maxLevel != null && maxLevel.has(this.enchId) ? maxLevel.get(this.enchId).getAsInt() : costs.size();
                            this.xpCost = costs.get(cost - 1).getAsInt();
                        } else if (level - 1 < costs.size()) {
                            this.xpCost = costs.get(level - 1).getAsInt();
                        } else {
                            this.overMaxLevel = true;
                        }
                    }
                }
            }
            for (String line : this.displayLore) {
                Matcher matcher = XP_COST_PATTERN.matcher(line);
                Matcher discount_matcher = DISCOUNT_COST_PATTERN.matcher(line);
                if (matcher.find()) {
                    this.xpCost = Integer.parseInt(matcher.group(1));
                    continue;
                }
                if (!discount_matcher.find()) continue;
                this.xpCost = Integer.parseInt(discount_matcher.group(2));
            }
        }
    }
}

