/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MinionHelperInventoryLoader {
    private final MinionHelperManager manager;
    private final List<String> pagesSeenAlready = new ArrayList<String>();
    private boolean dirty = true;
    private int ticks = 0;
    private final Pattern PATTERN_MINIONS_NEEDED = Pattern.compile("^\u00a77Craft \u00a7b(\\d+) \u00a77more \u00a7aunique \u00a77minions to unlock$");
    private final Pattern PATTERN_PELTS = Pattern.compile("\u00a7r \u00a7r\u00a7fPelts: \u00a7r\u00a75(\\d+)\u00a7r");

    public MinionHelperInventoryLoader(MinionHelperManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.manager.setLocalPelts(-1);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            return;
        }
        if (this.manager.notReady()) {
            return;
        }
        ++this.ticks;
        if (this.ticks % 5 != 0) {
            return;
        }
        if (this.manager.inCraftedMinionsInventory()) {
            this.checkInventory();
        } else {
            this.pagesSeenAlready.clear();
            this.dirty = true;
        }
    }

    private void checkInventory() {
        Container openContainer = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (openContainer instanceof ContainerChest) {
            if (this.dirty) {
                this.dirty = false;
                this.checkNextSlot(openContainer);
                this.checkLocalPelts();
            }
            if (this.manager.getDebugPlayerUuid() == null) {
                this.loadMinionData(openContainer);
            }
        }
    }

    private void checkLocalPelts() {
        int pelts = -1;
        for (String line : TablistAPI.getOptionalWidgetLines(TablistAPI.WidgetNames.TRAPPER)) {
            Matcher matcher = this.PATTERN_PELTS.matcher(line);
            if (!matcher.matches()) continue;
            pelts = Integer.parseInt(matcher.group(1));
            break;
        }
        this.manager.setLocalPelts(pelts);
    }

    private void checkNextSlot(Container openContainer) {
        Slot informationSlot = (Slot)openContainer.field_75151_b.get(50);
        if (informationSlot.func_75216_d()) {
            ItemStack informationStack = informationSlot.func_75211_c();
            for (String line : ItemUtils.getLore(informationStack)) {
                Matcher matcher = this.PATTERN_MINIONS_NEEDED.matcher(line);
                if (!matcher.matches()) continue;
                int debugNeedForNextSlot = this.manager.getDebugNeedForNextSlot();
                int needForNextSlot = debugNeedForNextSlot != -1 ? debugNeedForNextSlot : Integer.parseInt(matcher.group(1));
                this.manager.setNeedForNextSlot(needForNextSlot);
                return;
            }
        }
    }

    private void loadMinionData(Container openContainer) {
        ItemStack stack;
        String displayName;
        Slot firstSlot = (Slot)openContainer.field_75151_b.get(10);
        boolean shouldLoad = false;
        if (firstSlot != null && firstSlot.func_75216_d() && !this.pagesSeenAlready.contains(displayName = (stack = firstSlot.func_75211_c()).func_82833_r())) {
            this.pagesSeenAlready.add(displayName);
            shouldLoad = true;
        }
        if (!shouldLoad) {
            return;
        }
        int crafted = 0;
        for (Slot slot : openContainer.field_75151_b) {
            String displayName2;
            ItemStack stack2;
            if (!slot.func_75216_d() || (stack2 = slot.func_75211_c()) == null || slot.field_75222_d != slot.getSlotIndex() || !(displayName2 = stack2.func_82833_r()).contains(" Minion")) continue;
            displayName2 = StringUtils.cleanColour(displayName2);
            int index = 0;
            for (String line : ItemUtils.getLore(stack2)) {
                Minion minion;
                if (!line.contains("Tier") || !line.contains("\u00a7a") || (minion = this.manager.getMinionByName(displayName2, ++index)).isCrafted()) continue;
                minion.setCrafted(true);
                ++crafted;
            }
        }
        if (crafted > 0) {
            this.manager.getOverlay().resetCache();
        }
    }

    public void onProfileSwitch() {
        this.dirty = true;
    }
}

