/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.CookieWarning;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiEditSign;
import io.github.moulberry.notenoughupdates.overlays.SearchOverlayScreen;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AuctionSearchOverlay
extends SearchOverlayScreen {
    private static final Comparator<String> salesComparator = (o1, o2) -> {
        int sales2;
        boolean auc2Invalid;
        JsonObject auctionInfo1 = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfo((String)o1);
        JsonObject auctionInfo2 = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfo((String)o2);
        boolean auc1Invalid = auctionInfo1 == null || !auctionInfo1.has("sales");
        boolean bl = auc2Invalid = auctionInfo2 == null || !auctionInfo2.has("sales");
        if (auc1Invalid && auc2Invalid) {
            return o1.compareTo((String)o2);
        }
        if (auc1Invalid) {
            return 1;
        }
        if (auc2Invalid) {
            return -1;
        }
        int sales1 = auctionInfo1.get("sales").getAsInt();
        if (sales1 == (sales2 = auctionInfo2.get("sales").getAsInt())) {
            return o1.compareTo((String)o2);
        }
        if (sales1 > sales2) {
            return -1;
        }
        return 1;
    };

    public AuctionSearchOverlay() {
        super(new TileEntitySign());
    }

    public AuctionSearchOverlay(TileEntitySign sign) {
        super(sign);
        this.tileSign = sign;
        this.guiType = SearchOverlayScreen.GuiType.AUCTION_HOUSE;
    }

    public static boolean shouldReplace() {
        return Minecraft.func_71410_x().field_71462_r instanceof AuctionSearchOverlay;
    }

    public static boolean isinAhSign() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.config.ahTweaks.enableSearchOverlay) {
            return false;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiEditSign)) {
            if (!NotEnoughUpdates.INSTANCE.config.ahTweaks.keepPreviousSearch) {
                searchString = "";
            }
            return false;
        }
        String lastContainer = Utils.getLastOpenChestName();
        if (!lastContainer.equals("Auctions Browser") && !lastContainer.startsWith("Auctions: ")) {
            return false;
        }
        TileEntitySign tes = ((AccessorGuiEditSign)Minecraft.func_71410_x().field_71462_r).getTileSign();
        if (tes == null) {
            return false;
        }
        if (tes.func_174877_v().func_177956_o() != 0) {
            return false;
        }
        if (!tes.field_145915_a[2].func_150260_c().equals("^^^^^^^^^^^^^^^")) {
            return false;
        }
        return tes.field_145915_a[3].func_150260_c().equals("Enter query");
    }

    @SubscribeEvent
    public void onSlotClick(SlotClickEvent event) {
        if (!this.enableSearchOverlay()) {
            return;
        }
        if (this.disableClientSideGUI()) {
            return;
        }
        if (event.clickedButton == 1 && event.clickType == 0) {
            return;
        }
        if (!CookieWarning.hasActiveBoosterCookie()) {
            return;
        }
        if (!Utils.getOpenChestName().startsWith("Auctions")) {
            return;
        }
        ItemStack stack = event.slot.func_75211_c();
        if (event.slot.field_75222_d == 48 && stack != null && stack.func_82837_s() && stack.func_77973_b() == Items.field_151155_ap && stack.func_82833_r().equals("\u00a7aSearch")) {
            event.setCanceled(true);
            Minecraft.func_71410_x().field_71462_r = null;
            NotEnoughUpdates.INSTANCE.openGui = new AuctionSearchOverlay();
        }
    }

    @SubscribeEvent
    public void onSignDrawn(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!AuctionSearchOverlay.isinAhSign() || !(event.gui instanceof GuiEditSign) || event.gui instanceof SearchOverlayScreen) {
            return;
        }
        GuiEditSign guiEditSign = (GuiEditSign)event.gui;
        TileEntitySign tileSign = ((AccessorGuiEditSign)guiEditSign).getTileSign();
        if (tileSign != null) {
            event.setCanceled(true);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new AuctionSearchOverlay(tileSign));
        }
    }

    @Override
    public Comparator<String> getSearchComparator() {
        return salesComparator;
    }

    @Override
    public boolean enableSearchOverlay() {
        return NotEnoughUpdates.INSTANCE.config.ahTweaks.enableSearchOverlay;
    }

    @Override
    public ArrayList<String> previousSearches() {
        return NotEnoughUpdates.INSTANCE.config.hidden.previousAuctionSearches;
    }

    @Override
    public int searchHistorySize() {
        return NotEnoughUpdates.INSTANCE.config.ahTweaks.ahSearchHistorySize;
    }

    @Override
    public boolean showPastSearches() {
        return NotEnoughUpdates.INSTANCE.config.ahTweaks.showPastSearches;
    }

    @Override
    public boolean escFullClose() {
        return NotEnoughUpdates.INSTANCE.config.ahTweaks.escFullClose;
    }

    @Override
    public boolean keepPreviousSearch() {
        return NotEnoughUpdates.INSTANCE.config.ahTweaks.keepPreviousSearch;
    }

    @Override
    public SearchOverlayScreen.GuiType currentGuiType() {
        return SearchOverlayScreen.GuiType.AUCTION_HOUSE;
    }
}

