/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import org.lwjgl.util.vector.Vector3f;

public class BonemerangOverlay
extends TextOverlay {
    public static BonemerangOverlay INSTANCE;
    public final Set<EntityLivingBase> bonemeragedEntities = new HashSet<EntityLivingBase>();

    public BonemerangOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
        INSTANCE = this;
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.itemOverlays.enableBonemerangOverlay;
    }

    @Override
    public void updateFrequent() {
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.bonemerangFastUpdate) {
            this.updateOverlay();
        }
    }

    @Override
    public void update() {
        if (!NotEnoughUpdates.INSTANCE.config.itemOverlays.bonemerangFastUpdate) {
            this.updateOverlay();
        }
    }

    private void updateOverlay() {
        if (!this.isEnabled() && NotEnoughUpdates.INSTANCE.config.itemOverlays.highlightTargeted) {
            this.overlayStrings = null;
            return;
        }
        this.overlayStrings = new ArrayList();
        this.bonemeragedEntities.clear();
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        String internal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held);
        if (internal != null && (internal.equals("BONE_BOOMERANG") || internal.equals("STARRED_BONE_BOOMERANG"))) {
            HashMap<Integer, String> map2 = new HashMap<Integer, String>();
            EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
            float stepSize = 0.15f;
            float bonemerangDistance = 15.0f;
            Vector3f position = new Vector3f((float)p.field_70165_t, (float)p.field_70163_u + p.func_70047_e(), (float)p.field_70161_v);
            Vec3 look = p.func_70676_i(0.0f);
            Vector3f step = new Vector3f((float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c);
            step.scale(stepSize / step.length());
            int i = 0;
            while ((double)i < Math.floor(bonemerangDistance / stepSize) - 2.0) {
                AxisAlignedBB bb = new AxisAlignedBB((double)(position.x - 0.75f), (double)position.y - 0.1, (double)(position.z - 0.75f), (double)(position.x + 0.75f), (double)position.y + 0.25, (double)position.z + 0.75);
                BlockPos blockPos = new BlockPos((double)position.x, (double)position.y, (double)position.z);
                if (!Minecraft.func_71410_x().field_71441_e.func_175623_d(blockPos) && Minecraft.func_71410_x().field_71441_e.func_180495_p(blockPos).func_177230_c().func_149686_d()) {
                    map2.put(0, EnumChatFormatting.RED + "Bonemerang will break!");
                    break;
                }
                List entities = Minecraft.func_71410_x().field_71441_e.func_72839_b((Entity)Minecraft.func_71410_x().field_71439_g, bb);
                for (Entity entity : entities) {
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityArmorStand || entity.func_82150_aj() || this.bonemeragedEntities.contains(entity)) continue;
                    this.bonemeragedEntities.add((EntityLivingBase)entity);
                }
                position.translate(step.x, step.y, step.z);
                ++i;
            }
            if (NotEnoughUpdates.INSTANCE.config.itemOverlays.enableBonemerangOverlay) {
                map2.put(1, EnumChatFormatting.GRAY + "Targets: " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + this.bonemeragedEntities.size());
                for (int index : NotEnoughUpdates.INSTANCE.config.itemOverlays.bonemerangOverlayText) {
                    if (!map2.containsKey(index)) continue;
                    this.overlayStrings.add(map2.get(index));
                }
            }
        }
        if (this.overlayStrings.isEmpty()) {
            this.overlayStrings = null;
        }
    }
}

