/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.ReplaceItemEvent;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.BetterContainers;
import io.github.moulberry.notenoughupdates.overlays.SearchOverlayScreen;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RecipeSearchOverlay
extends SearchOverlayScreen {
    private static final ItemStack recipeSearchStack = Utils.createItemStack(Items.field_151005_D, EnumChatFormatting.GREEN + "Recipe Search", EnumChatFormatting.YELLOW + "Click to open Recipe Search!");

    public RecipeSearchOverlay() {
        super(new TileEntitySign());
        this.guiType = SearchOverlayScreen.GuiType.RECIPE;
    }

    public static boolean shouldReplace() {
        return Minecraft.func_71410_x().field_71462_r instanceof RecipeSearchOverlay;
    }

    @SubscribeEvent
    public void onSlotClick(SlotClickEvent event) {
        ItemStack stack = event.slot.func_75211_c();
        if (this.enableSearchOverlay() && (event.slot.field_75222_d == 50 || event.slot.field_75222_d == 51) && stack != null && stack.func_82837_s() && stack.func_77973_b() == Items.field_151155_ap && stack.func_82833_r().equals("\u00a7aSearch Recipes")) {
            event.setCanceled(true);
            NotEnoughUpdates.INSTANCE.openGui = new RecipeSearchOverlay();
        }
        if (this.shouldAddPickaxe() && event.slot.field_75222_d == 32 && Utils.getOpenChestName().equals("Craft Item")) {
            event.setCanceled(true);
            NotEnoughUpdates.INSTANCE.openGui = new RecipeSearchOverlay();
        }
    }

    @SubscribeEvent
    public void slotReplace(ReplaceItemEvent event) {
        if (event.getInventory() instanceof InventoryPlayer) {
            return;
        }
        if (!this.shouldAddPickaxe()) {
            return;
        }
        if (event.getSlotNumber() != 32 || !Utils.getOpenChestName().equals("Craft Item")) {
            return;
        }
        if (event.getOriginal() == null || !BetterContainers.isBlankStack(-1, event.getOriginal())) {
            return;
        }
        event.replaceWith(recipeSearchStack);
    }

    @Override
    public boolean enableSearchOverlay() {
        return NotEnoughUpdates.INSTANCE.config.recipeTweaks.enableSearchOverlay;
    }

    public boolean shouldAddPickaxe() {
        return NotEnoughUpdates.INSTANCE.config.recipeTweaks.addPickaxeStack;
    }

    @Override
    public ArrayList<String> previousSearches() {
        return NotEnoughUpdates.INSTANCE.config.hidden.previousRecipeSearches;
    }

    @Override
    public int searchHistorySize() {
        return NotEnoughUpdates.INSTANCE.config.recipeTweaks.recipeSearchHistorySize;
    }

    @Override
    public boolean showPastSearches() {
        return NotEnoughUpdates.INSTANCE.config.recipeTweaks.showPastSearches;
    }

    @Override
    public boolean escFullClose() {
        return NotEnoughUpdates.INSTANCE.config.recipeTweaks.escFullClose;
    }

    @Override
    public boolean keepPreviousSearch() {
        return NotEnoughUpdates.INSTANCE.config.recipeTweaks.keepPreviousSearch;
    }

    @Override
    public SearchOverlayScreen.GuiType currentGuiType() {
        return SearchOverlayScreen.GuiType.RECIPE;
    }
}

