/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.level.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.profileviewer.level.LevelPage;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.GuiTaskLevel;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;

public class EssenceTaskLevel
extends GuiTaskLevel {
    public EssenceTaskLevel(LevelPage levelPage) {
        super(levelPage);
    }

    @Override
    public void drawTask(JsonObject object, int mouseX, int mouseY, int guiLeft, int guiTop) {
        ArrayList<String> lore = new ArrayList<String>();
        JsonObject categoryXp = this.levelPage.getConstant().get("category_xp").getAsJsonObject();
        JsonObject essenceShopTask = this.levelPage.getConstant().get("essence_shop_task").getAsJsonObject();
        JsonArray essenceSteps = essenceShopTask.get("essence_shop_xp").getAsJsonArray();
        JsonObject essencePerks = object.has("perks") ? object.get("perks").getAsJsonObject() : new JsonObject();
        HashMap<String, EssenceShop> loreMap = new HashMap<String, EssenceShop>();
        for (Map.Entry<String, JsonElement> stringJsonElementEntry : Constants.ESSENCESHOPS.entrySet()) {
            String name = stringJsonElementEntry.getKey();
            JsonObject individualObjects = stringJsonElementEntry.getValue().getAsJsonObject();
            for (Map.Entry<String, JsonElement> jsonElementEntry : individualObjects.entrySet()) {
                int essenceAmount = Utils.getElementAsInt(Utils.getElement(object, "player_data.perks." + jsonElementEntry.getKey()), 0);
                int amountReceivedForEach = 0;
                for (int i = essenceAmount - 1; i >= 0; --i) {
                    amountReceivedForEach += essenceSteps.get(i).getAsInt();
                }
                if (!loreMap.containsKey(name)) {
                    EssenceShop value = new EssenceShop();
                    value.current += (double)amountReceivedForEach;
                    value.name = name;
                    loreMap.put(name, value);
                    continue;
                }
                EssenceShop essenceShop = (EssenceShop)loreMap.get(name);
                essenceShop.current += (double)amountReceivedForEach;
            }
        }
        for (Map.Entry<String, JsonElement> stringJsonElementEntry : essenceShopTask.entrySet()) {
            String name;
            String key = stringJsonElementEntry.getKey();
            if (!key.endsWith("_shop") || loreMap.containsKey(name = key.split("_shop")[0].toUpperCase(Locale.ROOT))) continue;
            loreMap.put(name, new EssenceShop().setName(name).setCurrent(0.0));
        }
        int total = 0;
        for (Map.Entry stringEssenceShopEntry : loreMap.entrySet()) {
            String key = (String)stringEssenceShopEntry.getKey();
            EssenceShop value = (EssenceShop)stringEssenceShopEntry.getValue();
            JsonObject jsonObject = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(key).resolveToItemListJson();
            if (jsonObject == null) {
                Utils.showOutdatedRepoNotification(key);
                continue;
            }
            value.name = jsonObject.get("displayname").getAsString();
            String name = key.toLowerCase(Locale.ROOT) + "_shop";
            if (!essenceShopTask.has(name)) continue;
            value.max = essenceShopTask.get(name).getAsInt();
            lore.add(this.levelPage.buildLore(EnumChatFormatting.func_110646_a((String)value.name), value.current, value.max, false));
            total = (int)((double)total + value.current);
        }
        this.levelPage.renderLevelBar("Essence", NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName("ESSENCE_WITHER").resolveToItemStack(), guiLeft + 299, guiTop + 25, 110, total, total, categoryXp.get("essence_shop_task").getAsInt(), mouseX, mouseY, true, lore);
    }

    class EssenceShop {
        String name;
        double max;
        double current;

        EssenceShop() {
        }

        public EssenceShop setCurrent(double current) {
            this.current = current;
            return this;
        }

        public EssenceShop setName(String name) {
            this.name = name;
            return this;
        }
    }
}

