/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.weight.senither;

import com.google.gson.JsonArray;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.SlayerWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.WeightStruct;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Map;

public class SenitherSlayerWeight
extends SlayerWeight {
    public SenitherSlayerWeight(Map<String, ProfileViewer.Level> player) {
        super(player);
    }

    @Override
    public void getSlayerWeight(String slayerName) {
        double left;
        if (slayerName.equals("blaze") || slayerName.equals("vampire")) {
            return;
        }
        JsonArray curWeights = Utils.getElement(Constants.WEIGHT, "senither.slayer." + slayerName).getAsJsonArray();
        double divider = curWeights.get(0).getAsDouble();
        double modifier = curWeights.get(1).getAsDouble();
        int currentSlayerXp = (int)((ProfileViewer.Level)this.player.get((Object)slayerName)).totalXp;
        if (currentSlayerXp <= 1000000) {
            this.weightStruct.add(new WeightStruct(currentSlayerXp == 0 ? 0.0 : (double)currentSlayerXp / divider));
            return;
        }
        double base = 1000000.0 / divider;
        double overflow = 0.0;
        double initialModifier = modifier;
        for (double remaining = (double)(currentSlayerXp - 1000000); remaining > 0.0; remaining -= left) {
            left = Math.min(remaining, 1000000.0);
            overflow += Math.pow(left / (divider * (1.5 + modifier)), 0.942);
            modifier += initialModifier;
        }
        this.weightStruct.add(new WeightStruct(base, overflow));
    }
}

