/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.IteratorUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemResolutionQuery {
    private static final Pattern ENCHANTED_BOOK_NAME_PATTERN = Pattern.compile("^((?:\u00a7.)*)([^\u00a7]+) ([IVXL]+)$");
    private static final Pattern PET_PATTERN = Pattern.compile(".*(\\[Lvl .*\\] )\u00a7(.).*");
    private static final String EXTRA_ATTRIBUTES = "ExtraAttributes";
    private static final List<String> PET_RARITIES = Arrays.asList("COMMON", "UNCOMMON", "RARE", "EPIC", "LEGENDARY", "MYTHIC");
    private final NEUManager manager;
    private NBTTagCompound compound;
    private Item itemType;
    private int stackSize = -1;
    private Gui guiContext;
    private String knownInternalName;

    public ItemResolutionQuery(NEUManager manager) {
        this.manager = manager;
    }

    public ItemResolutionQuery withItemNBT(NBTTagCompound compound) {
        this.compound = compound;
        return this;
    }

    public ItemResolutionQuery withItemStack(ItemStack stack) {
        if (stack == null) {
            return this;
        }
        this.itemType = stack.func_77973_b();
        this.compound = stack.func_77978_p();
        this.stackSize = stack.field_77994_a;
        return this;
    }

    public ItemResolutionQuery withGuiContext(Gui gui) {
        this.guiContext = gui;
        return this;
    }

    public ItemResolutionQuery withCurrentGuiContext() {
        this.guiContext = Minecraft.func_71410_x().field_71462_r;
        return this;
    }

    public ItemResolutionQuery withKnownInternalName(String knownInternalName) {
        this.knownInternalName = knownInternalName;
        return this;
    }

    @Nullable
    public String resolveInternalName() {
        if (this.knownInternalName != null) {
            return this.knownInternalName;
        }
        String resolvedName = this.resolveFromSkyblock();
        if (resolvedName == null) {
            resolvedName = this.resolveContextualName();
        } else {
            switch (resolvedName.intern()) {
                case "PET": {
                    resolvedName = this.resolvePetName();
                    break;
                }
                case "RUNE": 
                case "UNIQUE_RUNE": {
                    resolvedName = this.resolveRuneName();
                    break;
                }
                case "ENCHANTED_BOOK": {
                    resolvedName = this.resolveEnchantedBookNameFromNBT();
                    break;
                }
                case "PARTY_HAT_CRAB": 
                case "PARTY_HAT_CRAB_ANIMATED": {
                    resolvedName = this.resolveCrabHatName();
                    break;
                }
                case "ABICASE": {
                    resolvedName = this.resolvePhoneCase();
                    break;
                }
                case "PARTY_HAT_SLOTH": {
                    resolvedName = this.resolveSlothHatName();
                    break;
                }
                case "POTION": {
                    resolvedName = this.resolvePotionName();
                    break;
                }
                case "BALLOON_HAT_2024": 
                case "BALLOON_HAT_2025": {
                    resolvedName = this.resolveBalloonHatName();
                    break;
                }
                case "ATTRIBUTE_SHARD": {
                    resolvedName = this.resolveAttributeShardName();
                }
            }
        }
        return resolvedName;
    }

    @Nullable
    public JsonObject resolveToItemListJson() {
        String internalName = this.resolveInternalName();
        if (internalName == null) {
            return null;
        }
        return this.manager.getItemInformation().get(internalName);
    }

    @Nullable
    public ItemStack resolveToItemStack() {
        JsonObject jsonObject = this.resolveToItemListJson();
        if (jsonObject == null) {
            return null;
        }
        return this.manager.jsonToStack(jsonObject);
    }

    @Nullable
    public ItemStack resolveToItemStack(boolean useReplacements) {
        JsonObject jsonObject = this.resolveToItemListJson();
        if (jsonObject == null) {
            return null;
        }
        return this.manager.jsonToStack(jsonObject, false, useReplacements);
    }

    private boolean isBazaar(IInventory chest) {
        if (chest.func_145748_c_().func_150254_d().startsWith("Bazaar \u279c ")) {
            return true;
        }
        int bazaarSlot = chest.func_70302_i_() - 5;
        if (bazaarSlot < 0) {
            return false;
        }
        ItemStack stackInSlot = chest.func_70301_a(bazaarSlot);
        if (stackInSlot == null || stackInSlot.field_77994_a == 0) {
            return false;
        }
        List<String> lore = ItemUtils.getLore(stackInSlot);
        return lore.contains("\u00a77To Bazaar");
    }

    private String resolveContextualName() {
        if (!(this.guiContext instanceof GuiChest)) {
            return null;
        }
        GuiChest chest = (GuiChest)this.guiContext;
        ContainerChest inventorySlots = (ContainerChest)chest.field_147002_h;
        String guiName = inventorySlots.func_85151_d().func_145748_c_().func_150260_c();
        boolean isOnBazaar = this.isBazaar(inventorySlots.func_85151_d());
        String displayName = ItemUtils.getDisplayName(this.compound);
        if (displayName == null) {
            return null;
        }
        displayName = displayName.replaceFirst("^\u00a76\u00a7lSELL ", "").replaceFirst("^\u00a7a\u00a7lBUY ", "");
        if (this.itemType == Items.field_151134_bR && isOnBazaar && this.compound != null) {
            return ItemResolutionQuery.resolveEnchantmentByName(displayName);
        }
        if (this.itemType == Items.field_151144_bL && displayName.contains("Essence")) {
            return ItemResolutionQuery.findInternalNameByDisplayName(displayName, false);
        }
        if (displayName.endsWith("Enchanted Book") && guiName.startsWith("Superpairs")) {
            for (String loreLine : ItemUtils.getLore(this.compound)) {
                String enchantmentIdCandidate = ItemResolutionQuery.resolveEnchantmentByName(loreLine);
                if (enchantmentIdCandidate == null) continue;
                return enchantmentIdCandidate;
            }
            return null;
        }
        if (guiName.equals("Catacombs RNG Meter")) {
            return this.resolveItemInCatacombsRngMeter();
        }
        if (guiName.startsWith("Choose Pet")) {
            return ItemResolutionQuery.findInternalNameByDisplayName(displayName, false);
        }
        if (guiName.contains("Experimentation Table RNG")) {
            return ItemResolutionQuery.resolveEnchantmentByName(displayName);
        }
        return null;
    }

    public static String findInternalNameByDisplayName(String displayName, boolean mayBeMangled) {
        return ItemResolutionQuery.filterInternalNameCandidates(ItemResolutionQuery.findInternalNameCandidatesForDisplayName(displayName), displayName, mayBeMangled);
    }

    public static String filterInternalNameCandidates(Collection<String> candidateInternalNames, String displayName, boolean mayBeMangled) {
        Matcher matcher;
        boolean isPet = displayName.contains("[Lvl ");
        String petRarity = null;
        if (isPet && (matcher = PET_PATTERN.matcher(displayName)).matches()) {
            displayName = displayName.replace(matcher.group(1), "").replace("\u2726", "").trim();
            petRarity = matcher.group(2);
        }
        String cleanDisplayName = StringUtils.cleanColour(displayName);
        NEUManager manager = NotEnoughUpdates.INSTANCE.manager;
        String bestMatch = null;
        int bestMatchLength = -1;
        for (String internalName : candidateInternalNames) {
            String unCleanItemDisplayName = manager.getDisplayName(internalName);
            String cleanItemDisplayName = StringUtils.cleanColour(unCleanItemDisplayName);
            if (cleanItemDisplayName.length() == 0) continue;
            if (isPet) {
                if (!cleanItemDisplayName.contains("[Lvl {LVL}] ")) continue;
                cleanItemDisplayName = cleanItemDisplayName.replace("[Lvl {LVL}] ", "");
                Matcher matcher2 = PET_PATTERN.matcher(unCleanItemDisplayName);
                if (matcher2.matches() && !matcher2.group(2).equals(petRarity)) continue;
            }
            if ((!mayBeMangled ? !cleanItemDisplayName.equals(cleanDisplayName) : !cleanDisplayName.contains(cleanItemDisplayName)) || cleanItemDisplayName.length() <= bestMatchLength) continue;
            bestMatchLength = cleanItemDisplayName.length();
            bestMatch = internalName;
        }
        return bestMatch;
    }

    public static Set<String> findInternalNameCandidatesForDisplayName(String displayName) {
        boolean isPet = displayName.contains("[Lvl ");
        String cleanDisplayName = NEUManager.cleanForTitleMapSearch(displayName);
        TreeMap<String, HashMap<String, List<Integer>>> titleWordMap = NotEnoughUpdates.INSTANCE.manager.titleWordMap;
        HashSet<String> candidates = new HashSet<String>();
        for (String partialDisplayName : cleanDisplayName.split(" ")) {
            if ("".equals(partialDisplayName) || !titleWordMap.containsKey(partialDisplayName)) continue;
            Set<String> c = titleWordMap.get(partialDisplayName).keySet();
            for (String s : c) {
                if (isPet && !s.contains(";")) continue;
                candidates.add(s);
            }
        }
        return candidates;
    }

    private String resolveItemInCatacombsRngMeter() {
        String s;
        List<String> lore = ItemUtils.getLore(this.compound);
        if (lore.size() > 16 && (s = lore.get(15)).equals("\u00a77Selected Drop")) {
            String displayName = lore.get(16);
            return ItemResolutionQuery.findInternalNameByDisplayName(displayName, false);
        }
        return null;
    }

    public static String resolveEnchantmentByName(String name) {
        Matcher matcher = ENCHANTED_BOOK_NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            return null;
        }
        String format2 = matcher.group(1).toLowerCase(Locale.ROOT);
        String enchantmentName = matcher.group(2).trim().replace("'", "");
        String romanLevel = matcher.group(3);
        boolean ultimate = format2.contains("\u00a7l");
        return (ultimate && !enchantmentName.equals("Ultimate Wise") && !enchantmentName.equals("Ultimate Jerry") ? "ULTIMATE_" : "") + ItemResolutionQuery.turboCheck(enchantmentName).replace(" ", "_").replace("-", "_").toUpperCase(Locale.ROOT) + ";" + Utils.parseRomanNumeral(romanLevel);
    }

    private static String turboCheck(String text) {
        if (text.equals("Turbo-Cocoa")) {
            return "Turbo-Coco";
        }
        if (text.equals("Turbo-Cacti")) {
            return "Turbo-Cactus";
        }
        if (text.equals("Prismatic")) {
            return "Pristine";
        }
        if (text.equals("Dragon Tracer")) {
            return "Aiming";
        }
        return text;
    }

    private String resolveCrabHatName() {
        int crabHatYear = this.getExtraAttributes().func_74762_e("party_hat_year");
        String color = this.getExtraAttributes().func_74779_i("party_hat_color");
        return "PARTY_HAT_CRAB_" + color.toUpperCase(Locale.ROOT) + (crabHatYear == 2022 ? "_ANIMATED" : "");
    }

    private String resolveSlothHatName() {
        String emoji = this.getExtraAttributes().func_74779_i("party_hat_emoji");
        return "PARTY_HAT_SLOTH_" + emoji.toUpperCase(Locale.ROOT);
    }

    private String resolvePhoneCase() {
        String model = this.getExtraAttributes().func_74779_i("model");
        return "ABICASE_" + model.toUpperCase(Locale.ROOT);
    }

    private String resolveEnchantedBookNameFromNBT() {
        NBTTagCompound enchantments = this.getExtraAttributes().func_74775_l("enchantments");
        String enchantName = IteratorUtils.getOnlyElement(enchantments.func_150296_c(), null);
        if (enchantName == null || enchantName.isEmpty()) {
            return null;
        }
        return enchantName.toUpperCase(Locale.ROOT) + ";" + enchantments.func_74762_e(enchantName);
    }

    private String resolveRuneName() {
        NBTTagCompound runes = this.getExtraAttributes().func_74775_l("runes");
        String runeName = IteratorUtils.getOnlyElement(runes.func_150296_c(), null);
        if (runeName == null || runeName.isEmpty()) {
            return null;
        }
        return runeName.toUpperCase(Locale.ROOT) + "_RUNE;" + runes.func_74762_e(runeName);
    }

    private String resolvePetName() {
        String petInfo = this.getExtraAttributes().func_74779_i("petInfo");
        if (petInfo == null || petInfo.isEmpty()) {
            return null;
        }
        try {
            JsonObject petInfoObject = this.manager.gson.fromJson(petInfo, JsonObject.class);
            String petId = petInfoObject.get("type").getAsString();
            String petTier = petInfoObject.get("tier").getAsString();
            int rarityIndex = PET_RARITIES.indexOf(petTier);
            return petId.toUpperCase(Locale.ROOT) + ";" + rarityIndex;
        }
        catch (JsonParseException | ClassCastException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String resolvePotionName() {
        String potion = this.getExtraAttributes().func_74779_i("potion");
        int potionLvl = this.getExtraAttributes().func_74762_e("potion_level");
        String potionName = this.getExtraAttributes().func_74779_i("potion_name").replace(" ", "_");
        String potionType = this.getExtraAttributes().func_74779_i("potion_type");
        if (potionName != null && !potionName.isEmpty()) {
            return "POTION_" + potionName.toUpperCase(Locale.ROOT) + ";" + potionLvl;
        }
        if (potion != null && !potion.isEmpty()) {
            return "POTION_" + potion.toUpperCase(Locale.ROOT) + ";" + potionLvl;
        }
        if (potionType != null && !potionType.isEmpty()) {
            return "POTION_" + potionType.toUpperCase(Locale.ROOT);
        }
        return "WATER_BOTTLE";
    }

    private String resolveBalloonHatName() {
        String color = this.getExtraAttributes().func_74779_i("party_hat_color");
        int balloonHatYear = this.getExtraAttributes().func_74762_e("party_hat_year");
        return "BALLOON_HAT_" + balloonHatYear + "_" + color.toUpperCase(Locale.ROOT);
    }

    private String resolveAttributeShardName() {
        NBTTagCompound attributes = this.getExtraAttributes().func_74775_l("attributes");
        String attributeName = IteratorUtils.getOnlyElement(attributes.func_150296_c(), null);
        if (attributeName == null || attributeName.isEmpty()) {
            return null;
        }
        return "ATTRIBUTE_SHARD_" + attributeName.toUpperCase(Locale.ROOT) + ";" + attributes.func_74762_e(attributeName);
    }

    private NBTTagCompound getExtraAttributes() {
        if (this.compound == null) {
            return new NBTTagCompound();
        }
        return this.compound.func_74775_l(EXTRA_ATTRIBUTES);
    }

    private String resolveFromSkyblock() {
        String internalName = this.getExtraAttributes().func_74779_i("id");
        if (internalName == null || internalName.isEmpty()) {
            return null;
        }
        return internalName.toUpperCase(Locale.ROOT).replace(':', '-');
    }
}

