/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SidebarChangeEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.CookieWarning;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.LocationChangeEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.overlays.OverlayManager;
import io.github.moulberry.notenoughupdates.overlays.SlayerOverlay;
import io.github.moulberry.notenoughupdates.util.SidebarUtil;
import io.github.moulberry.notenoughupdates.util.TabListUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SBInfo {
    private static final SBInfo INSTANCE = new SBInfo();
    private static final Pattern timePattern = Pattern.compile(".+(am|pm)");
    public IChatComponent footer;
    public IChatComponent header;
    @NotNull
    private String location = "";
    @NotNull
    private String lastLocation = "";
    public String date = "";
    public String time = "";
    public String objective = "";
    public String slayer = "";
    public boolean stranded = false;
    public boolean bingo = false;
    @Nullable
    public String mode = null;
    public Date currentTimeDate = null;
    private JsonObject mayorJson = new JsonObject();
    @Deprecated
    public String currentlyOpenChestName = "";
    public String lastOpenChestName = "";
    private long lastManualLocRaw = -1L;
    private long lastLocRaw = -1L;
    public long joinedWorld = -1L;
    private long lastMayorUpdate;
    public long unloadedWorld = -1L;
    private JsonObject locraw = null;
    public boolean isInDungeon = false;
    private Map<String, Gamemode> gamemodes = new HashMap<String, Gamemode>();
    private boolean areGamemodesLoaded = false;
    private int tickCount = 0;
    public String currentProfile = null;
    private static final Pattern PROFILE_PATTERN = Pattern.compile("(?<type>(\u2672 Ironman)|(\u2600 Stranded)|()) *Profile: (?<name>[^ ]+)");
    private static final Pattern JSON_BRACKET_PATTERN = Pattern.compile("^\\{.+}");
    private static final String skillsPrefix = "\u00a7r\u00a7e\u00a7lSkills: \u00a7r\u00a7a";
    private static final String completedFactionQuests = "\u00a7r \u00a7r\u00a7a(?!(Paul|Finnegan|Aatrox|Cole|Diana|Diaz|Foxy|Marina)).*";
    public ArrayList<String> completedQuests = new ArrayList();
    private static final Pattern SKILL_LEVEL_PATTERN = Pattern.compile("([^0-9:]+) (\\d{1,2})");
    private static List<String> lastLines = new ArrayList<String>();

    public static SBInfo getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (event.gui instanceof GuiChest) {
            GuiChest chest = (GuiChest)event.gui;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            this.lastOpenChestName = this.currentlyOpenChestName = container.func_85151_d().func_145748_c_().func_150260_c();
        } else {
            this.currentlyOpenChestName = "";
        }
    }

    @SubscribeEvent
    public void onGuiTick(TickEvent event) {
        if (this.tickCount++ % 10 != 0) {
            return;
        }
        if (Utils.getOpenChestName().equals("Profile Management")) {
            ContainerChest container = (ContainerChest)((GuiChest)Minecraft.func_71410_x().field_71462_r).field_147002_h;
            this.updateProfileInformation(container);
        }
    }

    public boolean checkForSkyblockLocation() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || this.getLocation() == null) {
            Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] This command is not available outside SkyBlock");
            return false;
        }
        return true;
    }

    private void updateProfileInformation(ContainerChest container) {
        int i = 11;
        while (i < 16) {
            String displayName;
            Matcher matcher;
            ItemStack item;
            Slot slot = container.func_75139_a(i);
            if (slot != null && slot.func_75216_d() && (item = slot.func_75211_c()) != null && item.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150357_h) && (matcher = PROFILE_PATTERN.matcher(displayName = Utils.cleanColour(item.func_82833_r()))).matches()) {
                String type2 = matcher.group("type");
                String name = matcher.group("name");
                Gamemode gamemode = Gamemode.find(type2);
                this.gamemodes.put(name, gamemode);
            }
            i = -(~i);
        }
        this.areGamemodesLoaded = true;
        this.saveGameModes();
    }

    private Path getProfilesFile() {
        return new File(NotEnoughUpdates.INSTANCE.manager.configLocation, "profiles.json").toPath();
    }

    public Map<String, Gamemode> getAllGamemodes() {
        if (!this.areGamemodesLoaded) {
            this.loadGameModes();
        }
        return this.gamemodes;
    }

    public void saveGameModes() {
        try {
            Files.write(this.getProfilesFile(), NotEnoughUpdates.INSTANCE.manager.gson.toJson(this.gamemodes).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public Gamemode getGamemodeForProfile(String profiles) {
        return this.getAllGamemodes().get(profiles);
    }

    public Gamemode getCurrentMode() {
        return this.getGamemodeForProfile(this.currentProfile);
    }

    public void loadGameModes() {
        try {
            this.gamemodes = (Map)NotEnoughUpdates.INSTANCE.manager.gson.fromJson((Reader)Files.newBufferedReader(this.getProfilesFile()), new TypeToken<Map<String, Gamemode>>(){}.getType());
            this.areGamemodesLoaded = true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (JsonSyntaxException e3) {
            e3.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.lastLocRaw = -1L;
        this.locraw = null;
        this.setLocation(null);
        this.joinedWorld = System.currentTimeMillis();
        this.currentlyOpenChestName = "";
        this.lastOpenChestName = "";
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.unloadedWorld = System.currentTimeMillis();
    }

    public void onSendChatMessage(String msg) {
        if (msg.trim().startsWith("/locraw") || msg.trim().startsWith("/locraw ")) {
            this.lastManualLocRaw = System.currentTimeMillis();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void onChatMessage(ClientChatReceivedEvent event) {
        Matcher matcher = JSON_BRACKET_PATTERN.matcher(event.message.func_150260_c());
        if (matcher.find()) {
            try {
                JsonObject obj = NotEnoughUpdates.INSTANCE.manager.gson.fromJson(matcher.group(), JsonObject.class);
                if (obj.has("server")) {
                    if (System.currentTimeMillis() - this.lastManualLocRaw > 5000L) {
                        event.setCanceled(true);
                    }
                    if (obj.has("gametype") && obj.has("mode") && obj.has("map")) {
                        this.locraw = obj;
                        this.setLocation(this.locraw.get("mode").getAsString());
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    @Nullable
    public String getLocation() {
        return this.mode;
    }

    public void setLocation(String location) {
        String string = location = location == null ? location : location.intern();
        if (!Objects.equals(this.mode, location)) {
            MinecraftForge.EVENT_BUS.post((Event)new LocationChangeEvent(location, this.mode));
        }
        this.mode = location;
    }

    @NotNull
    public String getScoreboardLocation() {
        return this.location;
    }

    public void resetScoreboardLocation() {
        this.location = "";
    }

    @NotNull
    public String getLastScoreboardLocation() {
        return this.lastLocation;
    }

    public void tick() {
        List<String> profileData;
        long currentTime = System.currentTimeMillis();
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71441_e != null && this.locraw == null && currentTime - this.joinedWorld > 1000L && currentTime - this.lastLocRaw > 15000L) {
            this.lastLocRaw = System.currentTimeMillis();
            NotEnoughUpdates.INSTANCE.sendChatMessage("/locraw");
        }
        if (currentTime - this.lastMayorUpdate > 300000L) {
            this.updateMayor();
            this.lastMayorUpdate = currentTime;
        }
        if (!(profileData = TablistAPI.getWidgetLines(TablistAPI.WidgetNames.PROFILE)).isEmpty()) {
            Object newProfile = Utils.cleanColour(profileData.get(0)).split(" ")[1];
            if (Character.isLowerCase(((String)newProfile).charAt(0))) {
                newProfile = new StringBuilder((String)newProfile).reverse().toString();
            }
            this.setCurrentProfile((String)newProfile);
        }
        for (String s : TabListUtils.getTabList()) {
            if (!s.matches(completedFactionQuests) || !"crimson_isle".equals(this.mode)) continue;
            if (this.completedQuests.isEmpty()) {
                this.completedQuests.add(s);
                continue;
            }
            if (this.completedQuests.contains(s)) continue;
            this.completedQuests.add(s);
        }
        try {
            List<String> lines = SidebarUtil.readSidebarLines(true, false);
            if (lines.equals(lastLines)) {
                return;
            }
            new SidebarChangeEvent(lines, lastLines).post();
            lastLines = lines;
            boolean tempIsInDungeon = false;
            for (String line : lines) {
                if (!line.contains("Cleared:") || !line.contains("%")) continue;
                tempIsInDungeon = true;
                break;
            }
            this.isInDungeon = tempIsInDungeon;
            boolean containsStranded = false;
            boolean containsBingo = false;
            for (String line : lines) {
                if ((line = SidebarUtil.cleanTeamName(line)).contains("Tarantula Broodfather")) {
                    this.slayer = "Tarantula";
                } else if (line.contains("Revenant Horror")) {
                    this.slayer = "Revenant";
                } else if (line.contains("Sven Packmaster")) {
                    this.slayer = "Sven";
                } else if (line.contains("Voidgloom Seraph")) {
                    this.slayer = "Enderman";
                } else if (line.contains("Inferno Demonlord")) {
                    this.slayer = "Blaze";
                }
                if (line.contains("Slayer Quest") && SlayerOverlay.unloadOverlayTimer == -1L || line.contains("Slayer Quest") && System.currentTimeMillis() - SlayerOverlay.unloadOverlayTimer > 500L) {
                    SlayerOverlay.slayerQuest = true;
                }
                if (SlayerOverlay.slayerQuest) {
                    if (line.contains(" I")) {
                        SlayerOverlay.slayerTier = 1;
                    }
                    if (line.contains(" II")) {
                        SlayerOverlay.slayerTier = 2;
                    }
                    if (line.contains(" III")) {
                        SlayerOverlay.slayerTier = 3;
                    }
                    if (line.contains(" IV")) {
                        SlayerOverlay.slayerTier = 4;
                    }
                    if (line.contains(" V")) {
                        SlayerOverlay.slayerTier = 5;
                    }
                }
                if (line.contains("Stranded")) {
                    containsStranded = true;
                }
                if (!line.contains("Bingo")) continue;
                containsBingo = true;
            }
            this.stranded = containsStranded;
            this.bingo = containsBingo;
            if (lines.size() >= 5) {
                this.date = Utils.cleanColour(lines.get(1)).trim();
                Matcher matcher = timePattern.matcher(lines.get(2));
                if (matcher.find()) {
                    this.time = Utils.cleanColour(matcher.group()).trim();
                    try {
                        String timeSpace = this.time.replace("am", " am").replace("pm", " pm");
                        SimpleDateFormat parseFormat = new SimpleDateFormat("hh:mm a");
                        this.currentTimeDate = parseFormat.parse(timeSpace);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                for (String line : lines) {
                    if (!line.contains("\u23e3")) continue;
                    String l = Utils.cleanColour(line).replaceAll("[^A-Za-z0-9() ]", "").trim();
                    if (l.equals(this.location)) break;
                    this.lastLocation = this.location;
                    this.location = l;
                    break;
                }
            }
            this.objective = null;
            boolean objTextLast = false;
            for (String line : lines) {
                if (objTextLast) {
                    this.objective = line;
                }
                objTextLast = line.equals("Objective");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void updateMayor() {
        NotEnoughUpdates.INSTANCE.manager.apiUtils.newAnonymousHypixelApiRequest("resources/skyblock/election").requestJson().thenAccept(newJson -> {
            this.mayorJson = newJson;
        });
    }

    public JsonObject getMayorJson() {
        return this.mayorJson;
    }

    public void setCurrentProfile(String newProfile) {
        if (!newProfile.equals(this.currentProfile)) {
            this.currentProfile = newProfile;
            MinionHelperManager.getInstance().onProfileSwitch();
            CookieWarning.onProfileSwitch();
            if (NotEnoughUpdates.INSTANCE.config != null && NotEnoughUpdates.INSTANCE.config.mining.powderGrindingTrackerResetMode == 2) {
                OverlayManager.powderGrindingOverlay.load();
            }
        }
    }

    public static enum Gamemode {
        NORMAL("", ""),
        IRONMAN("Ironman", "\u2672"),
        STRANDED("Stranded", "\u2600");

        private final String name;
        private final String emoji;

        private Gamemode(String name, String emoji) {
            this.name = name;
            this.emoji = emoji;
        }

        public static Gamemode find(String type2) {
            for (Gamemode gamemode : Gamemode.values()) {
                if (!type2.contains(gamemode.name)) continue;
                return gamemode;
            }
            return null;
        }
    }
}

