/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public abstract class FMLMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class EntitySpawnMessage
    extends EntityMessage {
        String modId;
        int modEntityTypeId;
        int rawX;
        int rawY;
        int rawZ;
        double scaledX;
        double scaledY;
        double scaledZ;
        float scaledYaw;
        float scaledPitch;
        float scaledHeadYaw;
        int throwerId;
        double speedScaledX;
        double speedScaledY;
        double speedScaledZ;
        List<pz.a> dataWatcherList;
        ByteBuf dataStream;

        public EntitySpawnMessage() {
        }

        public EntitySpawnMessage(EntityRegistry.EntityRegistration er2, pk entity, ModContainer modContainer) {
            super(entity);
            this.modId = modContainer.getModId();
            this.modEntityTypeId = er2.getModEntityId();
        }

        @Override
        void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            ByteBufUtils.writeUTF8String(buf, this.modId);
            buf.writeInt(this.modEntityTypeId);
            buf.writeInt(ns.c((double)(this.entity.s * 32.0)));
            buf.writeInt(ns.c((double)(this.entity.t * 32.0)));
            buf.writeInt(ns.c((double)(this.entity.u * 32.0)));
            buf.writeByte((int)((byte)(this.entity.y * 256.0f / 360.0f)));
            buf.writeByte((int)((byte)(this.entity.z * 256.0f / 360.0f)));
            if (this.entity instanceof pr) {
                buf.writeByte((int)((byte)(((pr)this.entity).aK * 256.0f / 360.0f)));
            } else {
                buf.writeByte(0);
            }
            ByteBuf tmpBuf = Unpooled.buffer();
            em pb = new em(tmpBuf);
            try {
                this.entity.H().a(pb);
            }
            catch (IOException e2) {
                FMLLog.log(Level.FATAL, e2, "Encountered fatal exception trying to send entity spawn data watchers", new Object[0]);
                throw Throwables.propagate((Throwable)e2);
            }
            buf.writeBytes(tmpBuf);
            if (this.entity instanceof IThrowableEntity) {
                pk owner = ((IThrowableEntity)this.entity).getThrower();
                buf.writeInt(owner == null ? this.entity.F() : owner.F());
                double maxVel = 3.9;
                double mX = this.entity.v;
                double mY = this.entity.w;
                double mZ = this.entity.x;
                if (mX < -maxVel) {
                    mX = -maxVel;
                }
                if (mY < -maxVel) {
                    mY = -maxVel;
                }
                if (mZ < -maxVel) {
                    mZ = -maxVel;
                }
                if (mX > maxVel) {
                    mX = maxVel;
                }
                if (mY > maxVel) {
                    mY = maxVel;
                }
                if (mZ > maxVel) {
                    mZ = maxVel;
                }
                buf.writeInt((int)(mX * 8000.0));
                buf.writeInt((int)(mY * 8000.0));
                buf.writeInt((int)(mZ * 8000.0));
            } else {
                buf.writeInt(0);
            }
            if (this.entity instanceof IEntityAdditionalSpawnData) {
                tmpBuf = Unpooled.buffer();
                ((IEntityAdditionalSpawnData)this.entity).writeSpawnData(tmpBuf);
                buf.writeBytes(tmpBuf);
            }
        }

        @Override
        void fromBytes(ByteBuf dat) {
            super.fromBytes(dat);
            this.modId = ByteBufUtils.readUTF8String(dat);
            this.modEntityTypeId = dat.readInt();
            this.rawX = dat.readInt();
            this.rawY = dat.readInt();
            this.rawZ = dat.readInt();
            this.scaledX = (double)this.rawX / 32.0;
            this.scaledY = (double)this.rawY / 32.0;
            this.scaledZ = (double)this.rawZ / 32.0;
            this.scaledYaw = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledPitch = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledHeadYaw = (float)dat.readByte() * 360.0f / 256.0f;
            try {
                this.dataWatcherList = pz.b((em)new em(dat));
            }
            catch (IOException e2) {
                FMLLog.log(Level.FATAL, e2, "There was a critical error decoding the datawatcher stream for a mod entity.", new Object[0]);
                throw Throwables.propagate((Throwable)e2);
            }
            this.throwerId = dat.readInt();
            if (this.throwerId != 0) {
                this.speedScaledX = (double)dat.readInt() / 8000.0;
                this.speedScaledY = (double)dat.readInt() / 8000.0;
                this.speedScaledZ = (double)dat.readInt() / 8000.0;
            }
            this.dataStream = dat;
        }
    }

    public static class EntityAdjustMessage
    extends EntityMessage {
        int serverX;
        int serverY;
        int serverZ;

        public EntityAdjustMessage() {
        }

        public EntityAdjustMessage(pk entity, int serverX, int serverY, int serverZ) {
            super(entity);
            this.serverX = serverX;
            this.serverY = serverY;
            this.serverZ = serverZ;
        }

        @Override
        void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            buf.writeInt(this.serverX);
            buf.writeInt(this.serverY);
            buf.writeInt(this.serverZ);
        }

        @Override
        void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.serverX = buf.readInt();
            this.serverY = buf.readInt();
            this.serverZ = buf.readInt();
        }
    }

    public static abstract class EntityMessage
    extends FMLMessage {
        pk entity;
        int entityId;

        public EntityMessage() {
        }

        EntityMessage(pk entity) {
            this.entity = entity;
        }

        @Override
        void toBytes(ByteBuf buf) {
            buf.writeInt(this.entity.F());
        }

        @Override
        void fromBytes(ByteBuf buf) {
            this.entityId = buf.readInt();
        }
    }

    public static class OpenGui
    extends FMLMessage {
        int windowId;
        String modId;
        int modGuiId;
        int x;
        int y;
        int z;

        public OpenGui() {
        }

        OpenGui(int windowId, String modId, int modGuiId, int x, int y, int z) {
            this.windowId = windowId;
            this.modId = modId;
            this.modGuiId = modGuiId;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        void toBytes(ByteBuf buf) {
            buf.writeInt(this.windowId);
            ByteBufUtils.writeUTF8String(buf, this.modId);
            buf.writeInt(this.modGuiId);
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
        }

        @Override
        void fromBytes(ByteBuf buf) {
            this.windowId = buf.readInt();
            this.modId = ByteBufUtils.readUTF8String(buf);
            this.modGuiId = buf.readInt();
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }
    }

    public static class CompleteHandshake
    extends FMLMessage {
        Side target;

        public CompleteHandshake() {
        }

        public CompleteHandshake(Side target) {
            this.target = target;
        }

        @Override
        void fromBytes(ByteBuf buf) {
            this.target = Side.values()[buf.readByte()];
        }

        @Override
        void toBytes(ByteBuf buf) {
            buf.writeByte(this.target.ordinal());
        }
    }
}

