/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark.elements;

import dev.dediamondpro.minemark.LayoutData;
import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.style.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class BasicElement<S extends Style, R>
extends Element<S, R> {
    protected LayoutData.MarkDownElementPosition position;

    public BasicElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes2) {
        super(style, layoutStyle, parent, qName, attributes2);
    }

    @Override
    public void drawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        this.drawElement(this.position.getX() + xOffset, this.position.getY() + yOffset, this.position.getWidth(), this.position.getHeight(), renderData);
    }

    @Override
    public void generateLayout(LayoutData layoutData, R renderData) {
        float width = this.getWidth(layoutData, renderData);
        float height = this.getHeight(layoutData, renderData);
        float padding = this.getPadding(layoutData, renderData);
        if (layoutData.getX() + width > layoutData.getMaxWidth()) {
            layoutData.nextLine();
        }
        layoutData.updatePadding(padding);
        this.position = layoutData.addElement(this.layoutStyle.getAlignment(), width, height);
    }

    protected abstract void drawElement(float var1, float var2, float var3, float var4, R var5);

    protected abstract float getWidth(LayoutData var1, R var2);

    protected abstract float getHeight(LayoutData var1, R var2);

    protected float getPadding(LayoutData layoutData, R renderData) {
        return 0.0f;
    }
}

