/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark.elements.impl;

import dev.dediamondpro.minemark.LayoutData;
import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.ChildBasedElement;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.elements.Inline;
import dev.dediamondpro.minemark.style.Style;
import dev.dediamondpro.minemark.utils.MouseButton;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class LinkElement<S extends Style, R>
extends ChildBasedElement<S, R>
implements Inline {
    protected final ArrayList<LayoutData.MarkDownElementPosition> positions = new ArrayList();
    protected final String link;

    public LinkElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes2) {
        super(style, layoutStyle, parent, qName, attributes2);
        String string = this.link = attributes2 != null ? attributes2.getValue("href") : null;
        if (this.link != null) {
            this.layoutStyle = this.layoutStyle.clone();
            this.layoutStyle.setPartOfLink(true);
            if (style.getTextStyle().getDefaultTextColor().equals(this.layoutStyle.getTextColor())) {
                this.layoutStyle.setTextColor(style.getLinkStyle().getTextColor());
            }
        }
    }

    @Override
    @ApiStatus.Internal
    public void onMouseClickedInternal(MouseButton button, float mouseX, float mouseY) {
        if ((button == MouseButton.LEFT || button == MouseButton.MIDDLE) && this.isAnyInside(mouseX, mouseY) && this.link != null) {
            this.style.getLinkStyle().getBrowserProvider().browse(this.link);
        } else {
            super.onMouseClickedInternal(button, mouseX, mouseY);
        }
    }

    @Override
    @ApiStatus.Internal
    public void generateLayout(LayoutData layoutData, R renderData) {
        this.positions.clear();
        layoutData.addElementListener(this::onElementAdded);
        super.generateLayout(layoutData, renderData);
        layoutData.removeElementListener();
    }

    protected boolean isAnyInside(float x, float y) {
        for (LayoutData.MarkDownElementPosition position : this.positions) {
            if (!position.isInside(x, y)) continue;
            return true;
        }
        return false;
    }

    protected void onElementAdded(LayoutData.MarkDownElementPosition position) {
        this.positions.add(position);
    }

    public String toString() {
        return "LinkElement {" + this.link + "}";
    }
}

