/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.websocket;

import gg.skytils.ktor.websocket.FrameType;
import gg.skytils.ktor.websocket.ProtocolViolationException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00016B\u0007\u00a2\u0006\u0004\b5\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001cR$\u0010#\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b#\u0010\u0014\u001a\u0004\b$\u0010\u0010R(\u0010%\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001a8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010\u001cR$\u0010*\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010\u0014\u001a\u0004\b+\u0010\u0010R$\u0010,\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b,\u0010\u0014\u001a\u0004\b-\u0010\u0010R$\u0010.\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b.\u0010\u0014\u001a\u0004\b/\u0010\u0010R\"\u00103\u001a\u0010\u0012\f\u0012\n 2*\u0004\u0018\u00010101008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00067"}, d2={"Lgg/skytils/ktor/websocket/FrameParser;", "", "", "bodyComplete", "()V", "Ljava/nio/ByteBuffer;", "bb", "frame", "(Ljava/nio/ByteBuffer;)V", "", "handleStep", "(Ljava/nio/ByteBuffer;)Z", "parseHeader1", "parseLength", "parseMaskKey", "getBodyReady", "()Z", "bodyReady", "<set-?>", "fin", "Z", "getFin", "Lgg/skytils/ktor/websocket/FrameType;", "getFrameType", "()Lio/ktor/websocket/FrameType;", "frameType", "", "lastOpcode", "I", "", "length", "J", "getLength", "()J", "lengthLength", "mask", "getMask", "maskKey", "Ljava/lang/Integer;", "getMaskKey", "()Ljava/lang/Integer;", "opcode", "rsv1", "getRsv1", "rsv2", "getRsv2", "rsv3", "getRsv3", "Ljava/util/concurrent/atomic/AtomicReference;", "Lgg/skytils/ktor/websocket/FrameParser$State;", "kotlin.jvm.PlatformType", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "<init>", "State", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nFrameParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameParser.kt\nio/ktor/websocket/FrameParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class FrameParser {
    @NotNull
    private final AtomicReference<State> state = new AtomicReference<State>(State.HEADER0);
    private boolean fin;
    private boolean rsv1;
    private boolean rsv2;
    private boolean rsv3;
    private boolean mask;
    private int opcode;
    private int lastOpcode;
    private int lengthLength;
    private long length;
    @Nullable
    private Integer maskKey;

    public final boolean getFin() {
        return this.fin;
    }

    public final boolean getRsv1() {
        return this.rsv1;
    }

    public final boolean getRsv2() {
        return this.rsv2;
    }

    public final boolean getRsv3() {
        return this.rsv3;
    }

    public final boolean getMask() {
        return this.mask;
    }

    public final long getLength() {
        return this.length;
    }

    @Nullable
    public final Integer getMaskKey() {
        return this.maskKey;
    }

    @NotNull
    public final FrameType getFrameType() {
        FrameType frameType = FrameType.Companion.get(this.opcode);
        if (frameType == null) {
            throw new IllegalStateException("Unsupported opcode " + Integer.toHexString(this.opcode));
        }
        return frameType;
    }

    public final boolean getBodyReady() {
        return this.state.get() == State.BODY;
    }

    public final void bodyComplete() {
        if (!this.state.compareAndSet(State.BODY, State.HEADER0)) {
            throw new IllegalStateException("It should be state BODY but it is " + (Object)((Object)this.state.get()));
        }
        this.opcode = 0;
        this.length = 0L;
        this.lengthLength = 0;
        this.maskKey = null;
    }

    public final void frame(@NotNull ByteBuffer bb) {
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        if (!Intrinsics.areEqual((Object)bb.order(), (Object)ByteOrder.BIG_ENDIAN)) {
            boolean bl = false;
            String string = "Buffer order should be BIG_ENDIAN but it is " + bb.order();
            throw new IllegalArgumentException(string.toString());
        }
        while (this.handleStep(bb)) {
        }
    }

    private final boolean handleStep(ByteBuffer bb) {
        boolean bl;
        State state = this.state.get();
        Intrinsics.checkNotNull((Object)((Object)state));
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                bl = this.parseHeader1(bb);
                break;
            }
            case 2: {
                bl = this.parseLength(bb);
                break;
            }
            case 3: {
                bl = this.parseMaskKey(bb);
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean parseHeader1(ByteBuffer bb) {
        int n;
        if (bb.remaining() < 2) {
            return false;
        }
        byte flagsAndOpcode = bb.get();
        byte maskAndLength1 = bb.get();
        this.fin = (flagsAndOpcode & 0x80) != 0;
        this.rsv1 = (flagsAndOpcode & 0x40) != 0;
        this.rsv2 = (flagsAndOpcode & 0x20) != 0;
        this.rsv3 = (flagsAndOpcode & 0x10) != 0;
        this.opcode = flagsAndOpcode & 0xF;
        if (this.opcode == 0 && this.lastOpcode == 0) {
            throw new ProtocolViolationException("Can't continue finished frames");
        }
        if (this.opcode == 0) {
            this.opcode = this.lastOpcode;
        } else if (this.lastOpcode != 0 && !this.getFrameType().getControlFrame()) {
            throw new ProtocolViolationException("Can't start new data frame before finishing previous one");
        }
        if (!this.getFrameType().getControlFrame()) {
            this.lastOpcode = this.fin ? 0 : this.opcode;
        } else if (!this.fin) {
            throw new ProtocolViolationException("control frames can't be fragmented");
        }
        this.mask = (maskAndLength1 & 0x80) != 0;
        int length1 = maskAndLength1 & 0x7F;
        if (this.getFrameType().getControlFrame() && length1 > 125) {
            throw new ProtocolViolationException("control frames can't be larger than 125 bytes");
        }
        switch (length1) {
            case 126: {
                n = 2;
                break;
            }
            case 127: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.lengthLength = n;
        this.length = this.lengthLength == 0 ? (long)length1 : 0L;
        if (this.lengthLength > 0) {
            this.state.set(State.LENGTH);
        } else if (this.mask) {
            this.state.set(State.MASK_KEY);
        } else {
            this.state.set(State.BODY);
        }
        return true;
    }

    private final boolean parseLength(ByteBuffer bb) {
        long l;
        if (bb.remaining() < this.lengthLength) {
            return false;
        }
        switch (this.lengthLength) {
            case 2: {
                l = (long)bb.getShort() & 0xFFFFL;
                break;
            }
            case 8: {
                l = bb.getLong();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.length = l;
        State mask = this.mask ? State.MASK_KEY : State.BODY;
        this.state.set(mask);
        return true;
    }

    private final boolean parseMaskKey(ByteBuffer bb) {
        if (bb.remaining() < 4) {
            return false;
        }
        this.maskKey = bb.getInt();
        this.state.set(State.BODY);
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lgg/skytils/ktor/websocket/FrameParser$State;", "", "<init>", "(Ljava/lang/String;I)V", "HEADER0", "LENGTH", "MASK_KEY", "BODY", "ktor-websockets"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State HEADER0 = new State();
        public static final /* enum */ State LENGTH = new State();
        public static final /* enum */ State MASK_KEY = new State();
        public static final /* enum */ State BODY = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.HEADER0, State.LENGTH, State.MASK_KEY, State.BODY};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.HEADER0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.LENGTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MASK_KEY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.BODY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

