/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.config;

import gg.skytils.mixinextras.lib.gson.annotations.SerializedName;
import gg.skytils.mixinextras.lib.semver.Version;
import gg.skytils.mixinextras.service.MixinExtrasVersion;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;

public class MixinExtrasConfig {
    @SerializedName(value="minVersion")
    private final String minVersionString;
    private final transient String configName;
    public final transient MixinExtrasVersion minVersion;

    public MixinExtrasConfig(IMixinConfig config2, String minVersion) {
        this.configName = config2.getName();
        this.minVersionString = minVersion;
        this.minVersion = this.determineMinVersion();
    }

    private MixinExtrasVersion determineMinVersion() {
        if (this.minVersionString == null) {
            return null;
        }
        Version min2 = Version.tryParse(this.minVersionString).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not valid SemVer!", this.minVersionString)));
        MixinExtrasVersion[] versions = MixinExtrasVersion.values();
        if (min2.isHigherThan(MixinExtrasVersion.LATEST.getSemver())) {
            throw new IllegalArgumentException(String.format("Mixin Config %s requires MixinExtras >=%s but %s is present!", new Object[]{this.configName, min2, MixinExtrasVersion.LATEST}));
        }
        MixinExtrasVersion result2 = versions[0];
        for (MixinExtrasVersion version2 : versions) {
            if (version2.getSemver().isHigherThan(min2)) break;
            result2 = version2;
        }
        return result2;
    }
}

