/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.lib.apache.commons;

import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?: |\\u00A0|\\s|[\\s&&[^ ]])\\s*");

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String substringBefore(String str2, String separator) {
        if (StringUtils.isEmpty(str2) || separator == null) {
            return str2;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str2.indexOf(separator);
        if (pos == -1) {
            return str2;
        }
        return str2.substring(0, pos);
    }

    public static String substringAfter(String str2, String separator) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        if (separator == null) {
            return "";
        }
        int pos = str2.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str2.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str2, String separator) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(separator)) {
            return str2;
        }
        int pos = str2.lastIndexOf(separator);
        if (pos == -1) {
            return str2;
        }
        return str2.substring(0, pos);
    }

    public static String substringAfterLast(String str2, String separator) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        if (StringUtils.isEmpty(separator)) {
            return "";
        }
        int pos = str2.lastIndexOf(separator);
        if (pos == -1 || pos == str2.length() - separator.length()) {
            return "";
        }
        return str2.substring(pos + separator.length());
    }

    public static String removeStart(String str2, String remove2) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(remove2)) {
            return str2;
        }
        if (str2.startsWith(remove2)) {
            return str2.substring(remove2.length());
        }
        return str2;
    }

    public static String removeEnd(String str2, String remove2) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(remove2)) {
            return str2;
        }
        if (str2.endsWith(remove2)) {
            return str2.substring(0, str2.length() - remove2.length());
        }
        return str2;
    }

    public static String replaceOnce(String text2, String searchString, String replacement) {
        return StringUtils.replace(text2, searchString, replacement, 1);
    }

    public static String replace(String text2, String searchString, String replacement, int max) {
        if (StringUtils.isEmpty(text2) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text2;
        }
        int start2 = 0;
        int end2 = text2.indexOf(searchString, start2);
        if (end2 == -1) {
            return text2;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text2.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end2 != -1) {
            buf.append(text2.substring(start2, end2)).append(replacement);
            start2 = end2 + replLength;
            if (--max == 0) break;
            end2 = text2.indexOf(searchString, start2);
        }
        buf.append(text2.substring(start2));
        return buf.toString();
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i2 = repeat - 1; i2 >= 0; --i2) {
            buf[i2] = ch;
        }
        return new String(buf);
    }
}

