/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.commands.impl;

import gg.essential.universal.UChat;
import gg.skytils.skytilsmod.Skytils;
import gg.skytils.skytilsmod.core.PersistentSave;
import gg.skytils.skytilsmod.features.impl.handlers.ArmorColor;
import gg.skytils.skytilsmod.utils.ItemUtil;
import gg.skytils.skytilsmod.utils.Utils;
import gg.skytils.skytilsmod.utils.graphics.colors.CustomColor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.incendo.cloud.annotation.specifier.Greedy;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Commands;
import org.jetbrains.annotations.NotNull;

@Commands(value={})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u001b\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\f\u001a\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lgg/skytils/skytilsmod/commands/impl/ArmorColorCommand;", "", "", "clearAll", "()V", "clearCurrent", "Lkotlin/Pair;", "Lnet/minecraft/item/ItemStack;", "", "getCurrentArmor", "()Lkotlin/Pair;", "color", "setCurrent", "(Ljava/lang/String;)V", "<init>", "SkytilsMod"})
@SourceDebugExtension(value={"SMAP\nArmorColorCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArmorColorCommand.kt\ngg/skytils/skytilsmod/commands/impl/ArmorColorCommand\n+ 2 PersistentSave.kt\ngg/skytils/skytilsmod/core/PersistentSave$Companion\n*L\n1#1,85:1\n92#2,2:86\n92#2,2:88\n92#2,2:90\n*S KotlinDebug\n*F\n+ 1 ArmorColorCommand.kt\ngg/skytils/skytilsmod/commands/impl/ArmorColorCommand\n*L\n43#1:86,2\n53#1:88,2\n71#1:90,2\n*E\n"})
public final class ArmorColorCommand {
    @NotNull
    public static final ArmorColorCommand INSTANCE = new ArmorColorCommand();

    private ArmorColorCommand() {
    }

    @Command(value="armorcolor clearall")
    public final void clearAll() {
        ArmorColor.INSTANCE.getArmorColors().clear();
        PersistentSave.Companion this_$iv = PersistentSave.Companion;
        boolean $i$f$markDirty = false;
        this_$iv.markDirty((KClass<? extends PersistentSave>)Reflection.getOrCreateKotlinClass(ArmorColor.class));
        UChat.chat((Object)"\u00a7a\u00a7lSkytils \u00a78\u00bb \u00a7aCleared all your custom armor colors!");
    }

    @Command(value="armorcolor clear")
    public final void clearCurrent() {
        Pair<ItemStack, String> pair = this.getCurrentArmor();
        ItemStack item = (ItemStack)pair.component1();
        String uuid2 = (String)pair.component2();
        if (ArmorColor.INSTANCE.getArmorColors().containsKey(uuid2)) {
            ArmorColor.INSTANCE.getArmorColors().remove(uuid2);
            PersistentSave.Companion this_$iv = PersistentSave.Companion;
            boolean $i$f$markDirty = false;
            this_$iv.markDirty((KClass<? extends PersistentSave>)Reflection.getOrCreateKotlinClass(ArmorColor.class));
            UChat.chat((Object)("\u00a7a\u00a7lSkytils \u00a78\u00bb \u00a7aCleared the custom color for your " + item.func_82833_r() + "\u00a7a!"));
        } else {
            UChat.chat((Object)"\u00a7cThat item doesn't have a custom color!");
        }
    }

    @Command(value="armorcolor set <color>")
    public final void setCurrent(@Greedy @Argument(value="color", description="The color to set the armor to") @NotNull String color) {
        CustomColor customColor;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Pair<ItemStack, String> pair = this.getCurrentArmor();
        ItemStack item = (ItemStack)pair.component1();
        String uuid2 = (String)pair.component2();
        try {
            customColor = Utils.INSTANCE.customColorFromString(color);
        }
        catch (IllegalArgumentException e) {
            throw new SyntaxErrorException("\u00a7c\u00a7lSkytils (1.11.0) \u00a78\u00bb \u00a7cUnable to get a color from inputted string.", new Object[0]);
        }
        CustomColor customColor2 = customColor;
        ((Map)ArmorColor.INSTANCE.getArmorColors()).put(uuid2, customColor2);
        PersistentSave.Companion this_$iv = PersistentSave.Companion;
        boolean $i$f$markDirty = false;
        this_$iv.markDirty((KClass<? extends PersistentSave>)Reflection.getOrCreateKotlinClass(ArmorColor.class));
        UChat.chat((Object)("\u00a7a\u00a7lSkytils \u00a78\u00bb \u00a7aSet the color of your " + item.func_82833_r() + "\u00a7a to " + color + '!'));
    }

    private final Pair<ItemStack, String> getCurrentArmor() {
        if (!Utils.INSTANCE.getInSkyblock()) {
            throw new WrongUsageException("You must be in Skyblock to use this command!", new Object[0]);
        }
        EntityPlayerSP entityPlayerSP = Skytils.Companion.getMc().field_71439_g;
        Object object = entityPlayerSP != null ? entityPlayerSP.func_70694_bm() : null;
        if (object == null) {
            throw new WrongUsageException("You must hold a leather armor piece to use this command", new Object[0]);
        }
        ItemStack item = object;
        Item item2 = item.func_77973_b();
        ItemArmor itemArmor = item2 instanceof ItemArmor ? (ItemArmor)item2 : null;
        if ((itemArmor != null ? itemArmor.func_82812_d() : null) != ItemArmor.ArmorMaterial.LEATHER) {
            throw new WrongUsageException("You must hold a leather armor piece to use this command", new Object[0]);
        }
        NBTTagCompound extraAttributes = ItemUtil.getExtraAttributes(item);
        if (extraAttributes == null || !extraAttributes.func_74764_b("uuid")) {
            throw new WrongUsageException("This item does not have a UUID!", new Object[0]);
        }
        String uuid2 = extraAttributes.func_74779_i("uuid");
        return TuplesKt.to((Object)item, (Object)uuid2);
    }
}

