/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.features.impl.dungeons.catlas.handlers;

import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.Door;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.DoorType;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.Room;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.RoomData;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.RoomState;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.RoomType;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.Tile;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.Unknown;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.storage.MapData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b0\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001e\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\"\u0010&\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u001e\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u0016\u0010)\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010\u001cR\"\u0010*\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010\u001e\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R\"\u0010-\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010\u001e\u001a\u0004\b.\u0010 \"\u0004\b/\u0010\"\u00a8\u00061"}, d2={"Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/handlers/DungeonMapColorParser;", "", "", "calibrate", "()V", "", "arrayX", "arrayY", "", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/Room;", "getConnected", "(II)Ljava/util/List;", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/Tile;", "getTile", "(II)Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/Tile;", "worldX", "worldZ", "scanTile", "(IIII)Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/Tile;", "Lnet/minecraft/world/storage/MapData;", "mapData", "updateMap", "(Lnet/minecraft/world/storage/MapData;)V", "", "cachedTiles", "[Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/Tile;", "", "centerColors", "[B", "halfRoom", "I", "getHalfRoom", "()I", "setHalfRoom", "(I)V", "halfTile", "getHalfTile", "setHalfTile", "quarterRoom", "getQuarterRoom", "setQuarterRoom", "sideColors", "startX", "getStartX", "setStartX", "startY", "getStartY", "setStartY", "<init>", "SkytilsMod"})
@SourceDebugExtension(value={"SMAP\nDungeonMapColorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonMapColorParser.kt\ngg/skytils/skytilsmod/features/impl/dungeons/catlas/handlers/DungeonMapColorParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,150:1\n1#2:151\n1#2:162\n11383#3,9:152\n13309#3:161\n13310#3:163\n11392#3:164\n*S KotlinDebug\n*F\n+ 1 DungeonMapColorParser.kt\ngg/skytils/skytilsmod/features/impl/dungeons/catlas/handlers/DungeonMapColorParser\n*L\n99#1:162\n99#1:152,9\n99#1:161\n99#1:163\n99#1:164\n*E\n"})
public final class DungeonMapColorParser {
    @NotNull
    public static final DungeonMapColorParser INSTANCE = new DungeonMapColorParser();
    @NotNull
    private static byte[] centerColors = new byte[121];
    @NotNull
    private static byte[] sideColors = new byte[121];
    @NotNull
    private static Tile[] cachedTiles;
    private static int halfRoom;
    private static int halfTile;
    private static int quarterRoom;
    private static int startX;
    private static int startY;

    private DungeonMapColorParser() {
    }

    public final int getHalfRoom() {
        return halfRoom;
    }

    public final void setHalfRoom(int n) {
        halfRoom = n;
    }

    public final int getHalfTile() {
        return halfTile;
    }

    public final void setHalfTile(int n) {
        halfTile = n;
    }

    public final int getQuarterRoom() {
        return quarterRoom;
    }

    public final void setQuarterRoom(int n) {
        quarterRoom = n;
    }

    public final int getStartX() {
        return startX;
    }

    public final void setStartX(int n) {
        startX = n;
    }

    public final int getStartY() {
        return startY;
    }

    public final void setStartY(int n) {
        startY = n;
    }

    public final void calibrate() {
        halfRoom = MapUtils.INSTANCE.getMapRoomSize() / 2;
        halfTile = halfRoom + 2;
        quarterRoom = halfRoom / 2;
        startX = ((Number)MapUtils.INSTANCE.getStartCorner().getFirst()).intValue() + halfRoom;
        startY = ((Number)MapUtils.INSTANCE.getStartCorner().getSecond()).intValue() + halfRoom;
        centerColors = new byte[121];
        sideColors = new byte[121];
        int n = 0;
        Tile[] tileArray = new Tile[121];
        while (n < 121) {
            int n2 = n++;
            tileArray[n2] = null;
        }
        cachedTiles = tileArray;
    }

    public final void updateMap(@NotNull MapData mapData) {
        Intrinsics.checkNotNullParameter((Object)mapData, (String)"mapData");
        int n = 0;
        Tile[] tileArray = new Tile[121];
        while (n < 121) {
            int n2 = n++;
            tileArray[n2] = null;
        }
        cachedTiles = tileArray;
        for (int y = 0; y < 11; ++y) {
            for (int x = 0; x < 11; ++x) {
                int n3;
                int mapX = startX + x * halfTile;
                int mapY = startY + y * halfTile;
                if (mapX >= 128 || mapY >= 128) continue;
                DungeonMapColorParser.centerColors[y * 11 + x] = mapData.field_76198_e[mapY * 128 + mapX];
                if (x % 2 == 0 && y % 2 == 0) {
                    int topX = mapX - halfRoom;
                    int topY = mapY - halfRoom;
                    n3 = topY * 128 + topX;
                } else {
                    boolean horizontal = y % 2 == 1;
                    n3 = horizontal ? mapY * 128 + mapX - 4 : (mapY - 4) * 128 + mapX;
                }
                int sideIndex = n3;
                DungeonMapColorParser.sideColors[y * 11 + x] = mapData.field_76198_e[sideIndex];
            }
        }
    }

    @NotNull
    public final Tile getTile(int arrayX, int arrayY) {
        Tile tile;
        int index = arrayY * 11 + arrayX;
        Object[] objectArray = cachedTiles;
        if (index < 0 || index > ArraysKt.getLastIndex((Object[])objectArray)) {
            int it = index;
            boolean bl = false;
            return new Unknown(0, 0);
        }
        Object cached = objectArray[index];
        if (cached == null) {
            int xPos = -185 + arrayX * 16;
            int zPos = -185 + arrayY * 16;
            DungeonMapColorParser.cachedTiles[index] = this.scanTile(arrayX, arrayY, xPos, zPos);
        }
        if ((tile = cachedTiles[index]) == null) {
            tile = new Unknown(0, 0);
        }
        return tile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Room> getConnected(int arrayX, int arrayY) {
        Tile tile = this.getTile(arrayX, arrayY);
        Room room = tile instanceof Room ? (Room)tile : null;
        if (room == null) {
            return CollectionsKt.emptyList();
        }
        Room tile2 = room;
        List connected = new ArrayList();
        ArrayDeque queue = new ArrayDeque();
        queue.add((Object)tile2);
        while (!((Collection)queue).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Room current = (Room)queue.removeFirst();
            connected.add(current);
            Intrinsics.checkNotNullExpressionValue((Object)EnumFacing.field_176754_o, (String)"HORIZONTALS");
            Object[] objectArray = EnumFacing.field_176754_o;
            ArrayDeque arrayDeque = queue;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                Room it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                EnumFacing it = (EnumFacing)element$iv$iv;
                boolean bl2 = false;
                Tile tile3 = INSTANCE.getTile(current.getX() + it.func_176730_m().func_177958_n(), current.getZ() + it.func_176730_m().func_177952_p());
                if ((tile3 instanceof Room ? (Room)tile3 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            arrayDeque.addAll((Collection)((List)destination$iv$iv));
        }
        return connected;
    }

    private final Tile scanTile(int arrayX, int arrayY, int worldX, int worldZ) {
        Tile tile;
        byte centerColor = centerColors[arrayY * 11 + arrayX];
        byte sideColor = sideColors[arrayY * 11 + arrayX];
        if (centerColor == 0) {
            return new Unknown(worldX, worldZ);
        }
        if (arrayX % 2 == 0 && arrayY % 2 == 0) {
            RoomState roomState;
            Room room;
            RoomType roomType = RoomType.Companion.fromMapColor(sideColor);
            if (roomType == null) {
                return new Unknown(worldX, worldZ);
            }
            RoomType type = roomType;
            Room $this$scanTile_u24lambda_u242 = room = new Room(worldX, worldZ, RoomData.Companion.createUnknown(type));
            boolean bl = false;
            block0 : switch (centerColor) {
                case 18: {
                    switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            roomState = RoomState.DISCOVERED;
                            break block0;
                        }
                        case 2: {
                            roomState = RoomState.FAILED;
                            break block0;
                        }
                    }
                    roomState = $this$scanTile_u24lambda_u242.getState();
                    break;
                }
                case 30: {
                    if (WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 3) {
                        roomState = RoomState.DISCOVERED;
                        break;
                    }
                    roomState = RoomState.GREEN;
                    break;
                }
                case 34: {
                    roomState = RoomState.CLEARED;
                    break;
                }
                case 85: 
                case 119: {
                    roomState = RoomState.UNOPENED;
                    break;
                }
                default: {
                    roomState = RoomState.DISCOVERED;
                }
            }
            $this$scanTile_u24lambda_u242.setState(roomState);
            tile = room;
        } else if (sideColor == 0) {
            Door door;
            DoorType doorType = DoorType.Companion.fromMapColor(centerColor);
            if (doorType == null) {
                return new Unknown(worldX, worldZ);
            }
            DoorType type = doorType;
            Door $this$scanTile_u24lambda_u243 = door = new Door(worldX, worldZ, type);
            boolean bl = false;
            $this$scanTile_u24lambda_u243.setState(centerColor == 85 ? RoomState.UNOPENED : RoomState.DISCOVERED);
            tile = door;
        } else {
            Room room;
            RoomType roomType = RoomType.Companion.fromMapColor(sideColor);
            if (roomType == null) {
                return new Unknown(worldX, worldZ);
            }
            RoomType type = roomType;
            Room $this$scanTile_u24lambda_u244 = room = new Room(worldX, worldZ, RoomData.Companion.createUnknown(type));
            boolean bl = false;
            $this$scanTile_u24lambda_u244.setState(RoomState.DISCOVERED);
            $this$scanTile_u24lambda_u244.setSeparator(true);
            tile = room;
        }
        return tile;
    }

    static {
        int n = 0;
        Tile[] tileArray = new Tile[121];
        while (n < 121) {
            int n2 = n++;
            tileArray[n2] = null;
        }
        cachedTiles = tileArray;
        halfRoom = -1;
        halfTile = -1;
        quarterRoom = -1;
        startX = -1;
        startY = -1;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoomType.values().length];
            try {
                nArray[RoomType.BLOOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.PUZZLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.ENTRANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

