/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.Arrays;

public class UserAttributeSubpacket {
    int type;
    private boolean forceLongLength;
    protected byte[] data;

    protected UserAttributeSubpacket(int n, byte[] byArray) {
        this(n, false, byArray);
    }

    protected UserAttributeSubpacket(int n, boolean bl, byte[] byArray) {
        this.type = n;
        this.forceLongLength = bl;
        this.data = byArray;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void encode(OutputStream outputStream2) throws IOException {
        int n = this.data.length + 1;
        if (n < 192 && !this.forceLongLength) {
            outputStream2.write((byte)n);
        } else if (n <= 8383 && !this.forceLongLength) {
            outputStream2.write((byte)(((n -= 192) >> 8 & 0xFF) + 192));
            outputStream2.write((byte)n);
        } else {
            outputStream2.write(255);
            StreamUtil.writeBodyLen(outputStream2, n);
        }
        outputStream2.write(this.type);
        outputStream2.write(this.data);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UserAttributeSubpacket)) {
            return false;
        }
        UserAttributeSubpacket userAttributeSubpacket = (UserAttributeSubpacket)object;
        return this.type == userAttributeSubpacket.type && Arrays.areEqual((byte[])this.data, (byte[])userAttributeSubpacket.data);
    }

    public int hashCode() {
        return this.type ^ Arrays.hashCode((byte[])this.data);
    }
}

