/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.util.io.Streams;

class SXprUtils {
    SXprUtils() {
    }

    private static int readLength(InputStream inputStream2, int n) throws IOException {
        int n2 = n - 48;
        while ((n = inputStream2.read()) >= 0 && n != 58) {
            n2 = n2 * 10 + n - 48;
        }
        return n2;
    }

    static String readString(InputStream inputStream2, int n) throws IOException {
        int n2 = SXprUtils.readLength(inputStream2, n);
        char[] cArray = new char[n2];
        for (int j = 0; j != cArray.length; ++j) {
            cArray[j] = (char)inputStream2.read();
        }
        return new String(cArray);
    }

    static byte[] readBytes(InputStream inputStream2, int n) throws IOException {
        int n2 = SXprUtils.readLength(inputStream2, n);
        byte[] byArray = new byte[n2];
        Streams.readFully((InputStream)inputStream2, (byte[])byArray);
        return byArray;
    }

    static S2K parseS2K(InputStream inputStream2) throws IOException {
        SXprUtils.skipOpenParenthesis(inputStream2);
        String string = SXprUtils.readString(inputStream2, inputStream2.read());
        byte[] byArray = SXprUtils.readBytes(inputStream2, inputStream2.read());
        final long l = Long.parseLong(SXprUtils.readString(inputStream2, inputStream2.read()));
        SXprUtils.skipCloseParenthesis(inputStream2);
        S2K s2K = new S2K(2, byArray, (int)l){

            @Override
            public long getIterationCount() {
                return l;
            }
        };
        return s2K;
    }

    static void skipOpenParenthesis(InputStream inputStream2) throws IOException {
        int n = inputStream2.read();
        if (n != 40) {
            throw new IOException("unknown character encountered: " + (char)n);
        }
    }

    static void skipCloseParenthesis(InputStream inputStream2) throws IOException {
        int n = inputStream2.read();
        if (n != 41) {
            throw new IOException("unknown character encountered");
        }
    }
}

