/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;

public class PGPOnePassSignature
extends PGPDefaultSignatureGenerator {
    private OnePassSignaturePacket sigPack;
    private PGPContentVerifier verifier;

    private static OnePassSignaturePacket cast(Packet packet2) throws IOException {
        if (!(packet2 instanceof OnePassSignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet2);
        }
        return (OnePassSignaturePacket)packet2;
    }

    public PGPOnePassSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this(PGPOnePassSignature.cast(bCPGInputStream.readPacket()));
    }

    PGPOnePassSignature(OnePassSignaturePacket onePassSignaturePacket) {
        this.sigPack = onePassSignaturePacket;
        this.sigType = onePassSignaturePacket.getSignatureType();
    }

    public void init(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, PGPPublicKey pGPPublicKey) throws PGPException {
        PGPContentVerifierBuilder pGPContentVerifierBuilder = pGPContentVerifierBuilderProvider.get(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm());
        this.verifier = pGPContentVerifierBuilder.build(pGPPublicKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
    }

    public boolean verify(PGPSignature pGPSignature) throws PGPException {
        try {
            this.sigOut.write(pGPSignature.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException iOException) {
            throw new PGPException("unable to add trailer: " + iOException.getMessage(), iOException);
        }
        return this.verifier.verify(pGPSignature.getSignature());
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public boolean isContaining() {
        return this.sigPack.isContaining();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream2) throws IOException {
        BCPGOutputStream.wrap(outputStream2).writePacket(this.sigPack);
    }
}

