/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

class PGPExampleUtil {
    PGPExampleUtil() {
    }

    static byte[] compressFile(String string, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
        PGPUtil.writeFileToLiteralData(pGPCompressedDataGenerator.open(byteArrayOutputStream), 'b', new File(string));
        pGPCompressedDataGenerator.close();
        return byteArrayOutputStream.toByteArray();
    }

    static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, long l, char[] cArray) throws PGPException, NoSuchProviderException {
        PGPSecretKey pGPSecretKey = pGPSecretKeyRingCollection.getSecretKey(l);
        if (pGPSecretKey == null) {
            return null;
        }
        return pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(cArray));
    }

    static PGPPublicKey readPublicKey(String string) throws IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PGPPublicKey pGPPublicKey = PGPExampleUtil.readPublicKey(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        return pGPPublicKey;
    }

    static PGPPublicKey readPublicKey(InputStream inputStream2) throws IOException, PGPException {
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(inputStream2), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator<PGPPublicKeyRing> iterator2 = pGPPublicKeyRingCollection.getKeyRings();
        while (iterator2.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator2.next();
            Iterator<PGPPublicKey> iterator3 = pGPPublicKeyRing.getPublicKeys();
            while (iterator3.hasNext()) {
                PGPPublicKey pGPPublicKey = iterator3.next();
                if (!pGPPublicKey.isEncryptionKey()) continue;
                return pGPPublicKey;
            }
        }
        throw new IllegalArgumentException("Can't find encryption key in key ring.");
    }

    static PGPSecretKey readSecretKey(String string) throws IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PGPSecretKey pGPSecretKey = PGPExampleUtil.readSecretKey(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        return pGPSecretKey;
    }

    static PGPSecretKey readSecretKey(InputStream inputStream2) throws IOException, PGPException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(inputStream2), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator<PGPSecretKeyRing> iterator2 = pGPSecretKeyRingCollection.getKeyRings();
        while (iterator2.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = iterator2.next();
            Iterator<PGPSecretKey> iterator3 = pGPSecretKeyRing.getSecretKeys();
            while (iterator3.hasNext()) {
                PGPSecretKey pGPSecretKey = iterator3.next();
                if (!pGPSecretKey.isSigningKey()) continue;
                return pGPSecretKey;
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }
}

