/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.key;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.key.MutableCloudKeyContainer;

@API(status=API.Status.INTERNAL)
public final class SimpleMutableCloudKeyContainer
implements MutableCloudKeyContainer {
    private final Map<CloudKey<?>, Object> map;

    public SimpleMutableCloudKeyContainer(Map<CloudKey<?>, Object> map2) {
        this.map = map2;
    }

    @Override
    public <V> @NonNull Optional<V> optional(@NonNull CloudKey<V> key2) {
        return Optional.ofNullable(this.map.get(key2));
    }

    @Override
    public <V> @NonNull Optional<V> optional(@NonNull String key2) {
        return this.optional(CloudKey.of(key2));
    }

    @Override
    public boolean contains(@NonNull CloudKey<?> key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public @NonNull Map<CloudKey<?>, ? extends @NonNull Object> all() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public <V> void store(@NonNull CloudKey<V> key2, @NonNull V value) {
        this.map.put(key2, value);
    }

    @Override
    public <V> void store(@NonNull String key2, @NonNull V value) {
        this.map.put(CloudKey.of(key2), value);
    }

    @Override
    public void remove(@NonNull CloudKey<?> key2) {
        this.map.remove(key2);
    }

    @Override
    public <V> V computeIfAbsent(@NonNull CloudKey<V> key2, @NonNull Function<@NonNull CloudKey<V>, V> defaultFunction) {
        return (V)this.map.computeIfAbsent(key2, (? super K $) -> defaultFunction.apply(key2));
    }

    public <V> @Nullable V getOrNull(CloudKey<V> key2) {
        return (V)this.map.get(key2);
    }
}

