/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Iterator;
import java.util.List;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends zw
implements IFluidContainerItem {
    public final int capacity;
    public final zx empty;
    public final boolean nbtSensitive;

    public UniversalBucket() {
        this(1000, FluidContainerRegistry.EMPTY_BUCKET, false);
    }

    public UniversalBucket(int capacity, zx empty, boolean nbtSensitive) {
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        this.c(1);
        this.a(yz.f);
    }

    @SideOnly(value=Side.CLIENT)
    public void a(zw itemIn, yz tab, List<zx> subItems) {
        Iterator<Fluid> iterator = FluidRegistry.getRegisteredFluids().values().iterator();
        while (iterator.hasNext()) {
            zx stack = new zx((zw)this);
            Fluid fluid = iterator.next();
            FluidStack fs = new FluidStack(fluid, this.capacity);
            if (this.fill(stack, fs, true) != fs.amount) continue;
            subItems.add(stack);
        }
    }

    public String a(zx stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (this.empty != null) {
                return this.empty.q();
            }
            return super.a(stack);
        }
        String unloc = this.k(stack);
        if (di.c((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return di.a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return di.a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public zx a(zx itemstack, adm world, wn player) {
        cj targetPos;
        cj clickPos;
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return itemstack;
        }
        auh mop = this.a(world, player, false);
        if (mop != null && mop.a == auh.a.b && world.a(player, clickPos = mop.a()) && player.a(targetPos = clickPos.a(mop.b), mop.b, itemstack) && this.tryPlaceFluid(fluidStack.getFluid().getBlock(), world, targetPos) && !player.bA.d) {
            zx emptyStack;
            player.b(na.ad[zw.b((zw)this)]);
            --itemstack.b;
            zx zx2 = emptyStack = this.empty != null ? this.empty.k() : new zx((zw)this);
            if (itemstack.b <= 0) {
                return emptyStack;
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return itemstack;
        }
        return itemstack;
    }

    public boolean tryPlaceFluid(afh block, adm worldIn, cj pos) {
        if (block == null) {
            return false;
        }
        arm material = worldIn.p(pos).c().t();
        boolean isSolid = material.a();
        if (!worldIn.d(pos) && isSolid) {
            return false;
        }
        if (worldIn.t.n() && (block == afi.i || block == afi.j)) {
            int i2 = pos.n();
            int j2 = pos.o();
            int k2 = pos.p();
            worldIn.a((double)((float)i2 + 0.5f), (double)((float)j2 + 0.5f), (double)((float)k2 + 0.5f), "random.fizz", 0.5f, 2.6f + (worldIn.s.nextFloat() - worldIn.s.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                worldIn.a(cy.m, (double)i2 + Math.random(), (double)j2 + Math.random(), (double)k2 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!(worldIn.D || isSolid || material.d())) {
                worldIn.b(pos, true);
            }
            worldIn.a(pos, block.Q(), 3);
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        FluidStack drained;
        IFluidBlock fluidBlock;
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (event.current == null || !event.current.a(this.empty) || this.nbtSensitive && zx.a((zx)event.current, (zx)this.empty)) {
            return;
        }
        if (event.target == null || event.target.a != auh.a.b) {
            return;
        }
        adm world = event.world;
        cj pos = event.target.a();
        alz state = world.p(pos);
        if (state.c() instanceof IFluidBlock && (fluidBlock = (IFluidBlock)state.c()).canDrain(world, pos) && (drained = fluidBlock.drain(world, pos, false)) != null && drained.amount == this.capacity) {
            zx filledBucket = new zx((zw)this);
            int filled = this.fill(filledBucket, drained, false);
            if (filled == drained.amount) {
                drained = fluidBlock.drain(world, pos, true);
                this.fill(filledBucket, drained, true);
                event.setResult(Event.Result.ALLOW);
                event.result = filledBucket;
            } else {
                event.setCanceled(true);
            }
        }
    }

    public static zx getFilledBucket(UniversalBucket item, Fluid fluid) {
        zx stack = new zx((zw)item);
        item.fill(stack, new FluidStack(fluid, item.capacity), true);
        return stack;
    }

    @Override
    public FluidStack getFluid(zx container) {
        return FluidStack.loadFluidStackFromNBT(container.o());
    }

    @Override
    public int getCapacity(zx container) {
        return this.capacity;
    }

    @Override
    public int fill(zx container, FluidStack resource, boolean doFill) {
        if (container.b != 1) {
            return 0;
        }
        if (resource == null || resource.amount != this.capacity) {
            return 0;
        }
        if (!FluidRegistry.getBucketFluids().contains(resource.getFluid())) {
            return 0;
        }
        if (doFill) {
            dn tag = container.o();
            if (tag == null) {
                tag = new dn();
            }
            resource.writeToNBT(tag);
            container.d(tag);
        }
        return this.capacity;
    }

    @Override
    public FluidStack drain(zx container, int maxDrain, boolean doDrain) {
        if (maxDrain < this.capacity) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (doDrain && fluidStack != null) {
            if (this.empty != null) {
                container.a(this.empty.b());
                container.d(this.empty.o());
                container.b(this.empty.h());
            } else {
                container.b = 0;
            }
        }
        return fluidStack;
    }
}

