/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;
import org.jetbrains.annotations.Nullable;

public class PeafowlEntity
extends AbstractBirdEntity {
    protected static final EntityDataAccessor<Boolean> DATA_TRAIN_OPEN = SynchedEntityData.m_135353_(PeafowlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/peafowl/peafowl_indian_male.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/peafowl/peafowl_indian_female.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/peafowl/peafowl_indian_white.png"));
    });
    private int trainTimer;

    public PeafowlEntity(EntityType<? extends PeafowlEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.PEAFOWL_EGG.get()), BIRD_TEXTURES.size(), true, true);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.hasChildTextures = true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TRAIN_OPEN, (Object)false);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.85f : size.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Override
    public AbstractBirdEntity.Gender getGender(int variant) {
        return variant == 2 ? AbstractBirdEntity.Gender.NONE : super.getGender(variant);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_PEAFOWL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_PEAFOWL_HURT.get();
    }

    public PeafowlEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        PeafowlEntity peafowl = (PeafowlEntity)((EntityType)ExoticBirdsEntities.PEAFOWL.get()).m_20615_((Level)serverLevel);
        peafowl.setVariant(this.getChildVariant());
        return peafowl;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Override
    public int getChildVariant() {
        if (this.currentVariant() == 2 || this.f_19796_.nextInt(80) == 0) {
            return 2;
        }
        return super.getChildVariant();
    }

    @Override
    public int getRandomVariant() {
        if (this.f_19796_.nextInt(80) == 0) {
            return 2;
        }
        return this.f_19796_.nextInt(2);
    }

    public boolean getTrain() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TRAIN_OPEN);
    }

    public void setTrain(boolean trainOpen) {
        this.f_19804_.m_135381_(DATA_TRAIN_OPEN, (Object)trainOpen);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("TrainOpen", this.getTrain());
        tag.m_128405_("TrainTime", this.trainTimer);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.trainTimer = tag.m_128451_("TrainTime");
        this.setTrain(tag.m_128471_("TrainOpen"));
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.trainTimer > 0) {
            --this.trainTimer;
            if (this.trainTimer <= 0 && this.getTrain()) {
                this.setTrain(false);
                this.m_5496_(SoundEvents.f_12623_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            }
        }
        super.m_8107_();
    }

    private void openTrain() {
        if (!this.getTrain() && this.getGender(this.currentVariant()) != AbstractBirdEntity.Gender.FEMALE) {
            this.setTrain(true);
            this.m_5496_(SoundEvents.f_12623_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            this.trainTimer = 500 + this.f_19796_.nextInt(100);
        }
    }

    public void m_27595_(@Nullable Player player) {
        super.m_27595_(player);
        this.openTrain();
    }

    public void m_27601_(int ticks) {
        super.m_27601_(ticks);
        this.openTrain();
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return (List)ExoticBirdsCommonConfig.blacklistedDimensionsPeafowl.get();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }
}

