/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.blockentities;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.feature.blocks.BarrelStorageType;
import net.dark_roleplay.projectbrazier.feature.containers.GeneralContainer;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelBlockEntity
extends BlockEntity
implements MenuProvider {
    private BarrelStorageType storageType = BarrelStorageType.NONE;
    private ItemStackHandler itemHandler;
    private FluidTank fluidHandler;
    private LazyOptional<ItemStackHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler == null ? (this.itemHandler = this.createInventory()) : this.itemHandler);
    private LazyOptional<FluidTank> lazyFluidHandler = LazyOptional.of(() -> this.fluidHandler == null ? (this.fluidHandler = this.createFluidTank()) : this.fluidHandler);

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BrazierBlockEntities.BARREL_BLOCK_ENTITY.get(), pos, state);
    }

    public BarrelStorageType getStorageType() {
        return this.storageType;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("fluids")) {
            if (this.fluidHandler == null) {
                this.fluidHandler = this.createFluidTank();
            }
            this.fluidHandler.readFromNBT(compound.m_128469_("fluids"));
        } else if (compound.m_128441_("items")) {
            if (this.itemHandler == null) {
                this.itemHandler = this.createInventory();
            }
            this.itemHandler.deserializeNBT(compound.m_128469_("items"));
        }
        this.storageType = compound.m_128441_("storage_type") ? BarrelStorageType.valueOf(compound.m_128461_("storage_type").toUpperCase(Locale.ROOT)) : BarrelStorageType.NONE;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        switch (this.storageType) {
            case FLUID: {
                if (this.fluidHandler == null) break;
                compound.m_128365_("fluids", (Tag)this.fluidHandler.writeToNBT(new CompoundTag()));
                break;
            }
            case ITEMS: {
                if (this.itemHandler == null) break;
                compound.m_128365_("items", (Tag)this.itemHandler.serializeNBT());
                break;
            }
        }
        compound.m_128359_("storage_type", this.storageType.name().toLowerCase(Locale.ROOT));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if ((this.storageType == BarrelStorageType.NONE || this.storageType == BarrelStorageType.ITEMS) && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.lazyItemHandler != null) {
            return this.lazyItemHandler;
        }
        if ((this.storageType == BarrelStorageType.NONE || this.storageType == BarrelStorageType.FLUID) && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.lazyFluidHandler != null) {
            return this.lazyFluidHandler;
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createInventory() {
        return new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                BarrelBlockEntity.this.storageType = BarrelStorageType.NONE;
                for (int currentSlot = 0; currentSlot < this.getSlots(); ++currentSlot) {
                    if (this.getStackInSlot(currentSlot).m_41619_()) continue;
                    BarrelBlockEntity.this.storageType = BarrelStorageType.ITEMS;
                    break;
                }
                BarrelBlockEntity.this.m_6596_();
            }
        };
    }

    private FluidTank createFluidTank() {
        return new FluidTank(16000){

            protected void onContentsChanged() {
                if (this.getFluidAmount() == 0) {
                    BarrelBlockEntity.this.storageType = BarrelStorageType.NONE;
                } else if (BarrelBlockEntity.this.storageType != BarrelStorageType.FLUID) {
                    BarrelBlockEntity.this.storageType = BarrelStorageType.FLUID;
                }
                BarrelBlockEntity.this.m_6596_();
                BlockState state = BarrelBlockEntity.this.f_58857_.m_8055_(BarrelBlockEntity.this.m_58899_());
                BarrelBlockEntity.this.f_58857_.m_7260_(BarrelBlockEntity.this.m_58899_(), state, state, 3);
            }
        };
    }

    public void handleEntity(BlockState state, BlockPos pos, Entity entity) {
        if (this.storageType == BarrelStorageType.FLUID) {
            float fluidHeight = 0.083333336f * (float)this.fluidHandler.getFluidAmount() + 0.125f;
            if (entity.m_20186_() < (double)pos.m_123342_() + (double)fluidHeight) {
                FluidStack stack = this.fluidHandler.getFluid();
                if (stack.getFluid() == Fluids.f_76193_) {
                    entity.m_20095_();
                } else if (stack.getFluid().getAttributes().getTemperature(stack) >= 470) {
                    entity.m_20093_();
                }
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.lazyItemHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.projectbrazier.gui.container.barrel");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new GeneralContainer(id, playerInventory, this.f_58857_, this.f_58858_);
    }
}

