/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.blockentityrenderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.dark_roleplay.projectbrazier.feature.blockentities.ZiplineBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;

public class ZiplineBlockEntityRenderer
implements BlockEntityRenderer<ZiplineBlockEntity> {
    public ZiplineBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ZiplineBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Vector3f[] vertices = blockEntity.getVertices();
        if (vertices == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)(-blockEntity.m_58899_().m_123341_()), (double)(-blockEntity.m_58899_().m_123342_()), (double)(-blockEntity.m_58899_().m_123343_()));
        this.drawTube((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, bufferSource.m_6299_(RenderType.m_110451_()), poseStack, vertices, vertices.length / 4, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(ZiplineBlockEntity entity) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }

    private void drawTube(BlockAndTintGetter level, VertexConsumer builder, PoseStack poseStack, Vector3f[] vertices, int length, float r, float g, float b) {
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(new ResourceLocation("projectbrazier", "block/rope/rope"));
        BlockPos.MutableBlockPos lightPos = new BlockPos.MutableBlockPos();
        int[] lightCoords = new int[length];
        int i = 0;
        int j = 0;
        while (i < length) {
            lightPos.m_122169_((double)vertices[j].m_122239_(), (double)vertices[j].m_122260_(), (double)vertices[j].m_122269_());
            int blockLight = level.m_45517_(LightLayer.BLOCK, (BlockPos)lightPos);
            int skyLight = level.m_45517_(LightLayer.SKY, (BlockPos)lightPos);
            lightCoords[i] = LightTexture.m_109885_((int)blockLight, (int)skyLight);
            ++i;
            j += 4;
        }
        float uMin = sprite.m_118409_();
        float vMin = sprite.m_118411_();
        float uMax = sprite.m_118410_();
        float vMax = sprite.m_118412_();
        float u2 = uMin + (uMax - uMin) / 8.0f;
        float u3 = uMin + (uMax - uMin) / 16.0f * 4.0f;
        float u4 = uMin + (uMax - uMin) / 16.0f * 6.0f;
        float u5 = uMin + (uMax - uMin) / 16.0f * 8.0f;
        float v2 = vMin + (vMax - vMin) / 8.0f;
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        int i2 = 0;
        int j2 = 1;
        while (i2 < length - 1) {
            Vector3f[] verts = Arrays.copyOfRange(vertices, i2 * 4, j2 * 4 + 4);
            this.putVertex(builder, matrix, verts[1].m_122239_(), verts[1].m_122260_(), verts[1].m_122269_(), u2, vMin, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[5].m_122239_(), verts[5].m_122260_(), verts[5].m_122269_(), u2, vMax, lightCoords[j2]);
            this.putVertex(builder, matrix, verts[4].m_122239_(), verts[4].m_122260_(), verts[4].m_122269_(), u3, vMax, lightCoords[j2]);
            this.putVertex(builder, matrix, verts[0].m_122239_(), verts[0].m_122260_(), verts[0].m_122269_(), u3, vMin, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[5].m_122239_(), verts[5].m_122260_(), verts[5].m_122269_(), u3, vMin, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[1].m_122239_(), verts[1].m_122260_(), verts[1].m_122269_(), u3, vMax, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[2].m_122239_(), verts[2].m_122260_(), verts[2].m_122269_(), u4, vMax, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[6].m_122239_(), verts[6].m_122260_(), verts[6].m_122269_(), u4, vMin, lightCoords[j2]);
            this.putVertex(builder, matrix, verts[3].m_122239_(), verts[3].m_122260_(), verts[3].m_122269_(), u4, vMin, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[7].m_122239_(), verts[7].m_122260_(), verts[7].m_122269_(), u4, vMax, lightCoords[j2]);
            this.putVertex(builder, matrix, verts[6].m_122239_(), verts[6].m_122260_(), verts[6].m_122269_(), u5, vMax, lightCoords[j2]);
            this.putVertex(builder, matrix, verts[2].m_122239_(), verts[2].m_122260_(), verts[2].m_122269_(), u5, vMin, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[0].m_122239_(), verts[0].m_122260_(), verts[0].m_122269_(), uMin, vMin, lightCoords[i2]);
            this.putVertex(builder, matrix, verts[4].m_122239_(), verts[4].m_122260_(), verts[4].m_122269_(), uMin, vMax, lightCoords[j2]);
            this.putVertex(builder, matrix, verts[7].m_122239_(), verts[7].m_122260_(), verts[7].m_122269_(), u2, vMax, lightCoords[j2]);
            this.putVertex(builder, matrix, verts[3].m_122239_(), verts[3].m_122260_(), verts[3].m_122269_(), u2, vMin, lightCoords[i2]);
            j2 = ++i2 + 1;
        }
    }

    private void putVertex(VertexConsumer builder, Matrix4f matrix, float x, float y, float z, float u, float v, int light) {
        builder.m_85982_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_85969_(light).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
    }
}

