/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.textures.generator.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.dark_roleplay.marg.client.generators.textures.generator.processors.TextureProcessorData;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureHolder;
import net.dark_roleplay.marg.client.generators.textures.util.TextureCache;

public class TextureInputData
extends TextureProcessorData {
    public static final Codec<TextureInputData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("cachedTexture", (Object)"").forGetter(TextureInputData::getCachedTextureName), (App)Codec.STRING.optionalFieldOf("texture", (Object)"").forGetter(TextureInputData::getTextureName)).apply((Applicative)i, TextureInputData::new));
    private String cachedTextureName;
    private String textureName;
    private TextureHolder texture;

    public TextureInputData(String cachedTextureName, String textureName) {
        this.cachedTextureName = cachedTextureName;
        this.textureName = textureName;
    }

    @Override
    public void setTexture(Map<String, TextureHolder> textures, TextureCache cache) {
        if (!this.getCachedTextureName().isEmpty()) {
            this.texture = cache.getCachedTexture(this.cachedTextureName);
        }
        if (!this.getTextureName().isEmpty()) {
            this.texture = textures.get(this.textureName);
        }
    }

    @Override
    public TextureHolder getTexture() {
        return this.texture;
    }

    public String getCachedTextureName() {
        return this.cachedTextureName;
    }

    public String getTextureName() {
        return this.textureName;
    }
}

