/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.textures.util;

import java.util.HashMap;
import java.util.Map;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureHolder;
import net.dark_roleplay.marg.common.material.MargMaterial;

public class TextureCache {
    private static Map<MargMaterial, TextureCache> GLOBAL_CACHE = new HashMap<MargMaterial, TextureCache>();
    private TextureCache parent = null;
    private Map<String, TextureHolder> textureCache = new HashMap<String, TextureHolder>();

    public static TextureCache getGlobalCacheFor(MargMaterial material) {
        return GLOBAL_CACHE.computeIfAbsent(material, mat -> new TextureCache());
    }

    public static void clearGlobalCache() {
        GLOBAL_CACHE.values().forEach(val -> val.clear());
        GLOBAL_CACHE.clear();
    }

    public TextureCache() {
    }

    public TextureCache(TextureCache parent) {
        this();
        this.parent = parent;
    }

    public TextureHolder getCachedTexture(String key) {
        TextureHolder texture = this.textureCache.get(key);
        if (texture == null && this.parent != null) {
            texture = this.parent.getCachedTexture(key);
        }
        return texture;
    }

    public void addTexture(String key, TextureHolder texture) {
        this.textureCache.put(key, texture);
    }

    public void clear() {
        this.textureCache.clear();
    }
}

