/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core;

import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.INBTSavable;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.ISyncableEntityCapability;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.ItemStackCapability;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;

public abstract class CapabilityAttacher {
    private static final List<Class<?>> capClasses;
    private static final List<BiConsumer<AttachCapabilitiesEvent<Entity>, Entity>> entityCapAttachers;
    private static final List<Function<Entity, LazyOptional<? extends ISyncableEntityCapability>>> entityCapRetrievers;
    private static final List<BiConsumer<AttachCapabilitiesEvent<ItemStack>, ItemStack>> itemStackCapAttachers;
    private static final List<Function<ItemStack, LazyOptional<? extends ItemStackCapability>>> itemStackCapRetrievers;
    private static final List<BiConsumer<Player, Player>> playerCapCloners;

    @NotNull
    protected static <T> Capability<T> getCapability(CapabilityToken<T> type) {
        return CapabilityManager.get(type);
    }

    protected static <T> void registerCapability(Class<T> capClass) {
        capClasses.add(capClass);
    }

    protected static <C extends ISyncableEntityCapability> void registerPlayerAttacher(BiConsumer<AttachCapabilitiesEvent<Entity>, Player> attacher, Function<Player, LazyOptional<C>> capRetriever, boolean copyOnDeath) {
        CapabilityAttacher.registerEntityAttacher(Player.class, attacher, capRetriever);
        if (copyOnDeath) {
            playerCapCloners.add((oldPlayer, newPlayer) -> ((LazyOptional)capRetriever.apply((Player)oldPlayer)).ifPresent(oldCap -> ((LazyOptional)capRetriever.apply((Player)newPlayer)).ifPresent(newCap -> newCap.deserializeNBT((CompoundTag)oldCap.serializeNBT(false), false))));
        }
    }

    protected static <E extends Entity, C extends ISyncableEntityCapability> void registerEntityAttacher(Class<E> entityClass, BiConsumer<AttachCapabilitiesEvent<Entity>, E> attacher, Function<E, LazyOptional<C>> capRetriever) {
        entityCapAttachers.add((event, entity) -> {
            if (entityClass.isInstance(entity)) {
                attacher.accept((AttachCapabilitiesEvent<Entity>)event, (Object)entity);
            }
        });
        entityCapRetrievers.add(entity -> entityClass.isInstance(entity) ? (LazyOptional)capRetriever.apply(entity) : LazyOptional.empty());
    }

    protected static <C extends ItemStackCapability> void registerItemStackAttacher(BiConsumer<AttachCapabilitiesEvent<ItemStack>, ItemStack> attacher, Function<ItemStack, LazyOptional<C>> capRetriever) {
        itemStackCapAttachers.add(attacher);
        itemStackCapRetrievers.add(capRetriever::apply);
    }

    protected static <I extends INBTSerializable<T>, T extends Tag> void genericAttachCapability(AttachCapabilitiesEvent<?> event, I impl, Capability<I> capability, ResourceLocation location) {
        CapabilityAttacher.genericAttachCapability(event, impl, capability, location, true);
    }

    protected static <I extends INBTSerializable<T>, T extends Tag> void genericAttachCapability(AttachCapabilitiesEvent<?> event, I impl, Capability<I> capability, ResourceLocation location, boolean save) {
        LazyOptional storage = LazyOptional.of(() -> impl);
        ICapabilityProvider provider = CapabilityAttacher.getProvider(impl, storage, capability, save);
        event.addCapability(location, provider);
    }

    protected static <I extends INBTSerializable<T>, T extends Tag> ICapabilityProvider getProvider(final I impl, final LazyOptional<I> storage, final Capability<I> capability, boolean save) {
        if (capability == null) {
            throw new NullPointerException();
        }
        return save ? new ICapabilitySerializable<T>(){

            @Nonnull
            public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
                return cap == capability ? storage.cast() : LazyOptional.empty();
            }

            public T serializeNBT() {
                return impl instanceof INBTSavable ? ((INBTSavable)impl).serializeNBT(true) : impl.serializeNBT();
            }

            public void deserializeNBT(T nbt) {
                if (impl instanceof INBTSavable) {
                    ((INBTSavable)impl).deserializeNBT(nbt, true);
                } else {
                    impl.deserializeNBT(nbt);
                }
            }
        } : new ICapabilityProvider(){

            @Nonnull
            public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
                return cap == capability ? storage.cast() : LazyOptional.empty();
            }
        };
    }

    private static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        capClasses.forEach(arg_0 -> ((RegisterCapabilitiesEvent)event).register(arg_0));
    }

    private static void onAttachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        entityCapAttachers.forEach(attacher -> attacher.accept(event, (Entity)event.getObject()));
    }

    private static void onAttachItemStackCapability(AttachCapabilitiesEvent<ItemStack> event) {
        itemStackCapAttachers.forEach(attacher -> attacher.accept(event, (ItemStack)event.getObject()));
    }

    private static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            entityCapRetrievers.forEach(capRetriever -> ((LazyOptional)capRetriever.apply(player)).ifPresent(cap -> cap.sendUpdatePacketToPlayer(player)));
        }
    }

    private static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        ServerPlayer currentPlayer = (ServerPlayer)event.getPlayer();
        entityCapRetrievers.forEach(capRetriever -> ((LazyOptional)capRetriever.apply(event.getTarget())).ifPresent(cap -> cap.sendUpdatePacketToPlayer(currentPlayer)));
    }

    private static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getPlayer();
        oldPlayer.revive();
        playerCapCloners.forEach(capCloner -> capCloner.accept(oldPlayer, newPlayer));
    }

    static {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityAttacher::onAttachEntityCapability);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, CapabilityAttacher::onAttachItemStackCapability);
        MinecraftForge.EVENT_BUS.addListener(CapabilityAttacher::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(CapabilityAttacher::onPlayerStartTracking);
        MinecraftForge.EVENT_BUS.addListener(CapabilityAttacher::onPlayerClone);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(CapabilityAttacher::onRegisterCapabilities);
        capClasses = new ArrayList();
        entityCapAttachers = new ArrayList<BiConsumer<AttachCapabilitiesEvent<Entity>, Entity>>();
        entityCapRetrievers = new ArrayList<Function<Entity, LazyOptional<? extends ISyncableEntityCapability>>>();
        itemStackCapAttachers = new ArrayList<BiConsumer<AttachCapabilitiesEvent<ItemStack>, ItemStack>>();
        itemStackCapRetrievers = new ArrayList<Function<ItemStack, LazyOptional<? extends ItemStackCapability>>>();
        playerCapCloners = new ArrayList<BiConsumer<Player, Player>>();
    }
}

