/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetSpeakerBlockPacket {
    private final BlockPos pos;
    private final Component str;
    private final boolean narrator;
    private final double volume;

    public ServerBoundSetSpeakerBlockPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.str = buf.m_130238_();
        this.narrator = buf.readBoolean();
        this.volume = buf.readDouble();
    }

    public ServerBoundSetSpeakerBlockPacket(BlockPos pos, String str, boolean narrator, double volume) {
        this.pos = pos;
        this.str = new TextComponent(str);
        this.narrator = narrator;
        this.volume = volume;
    }

    public static void buffer(ServerBoundSetSpeakerBlockPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130083_(message.str);
        buf.writeBoolean(message.narrator);
        buf.writeDouble(message.volume);
    }

    public static void handler(ServerBoundSetSpeakerBlockPacket message, Supplier<NetworkEvent.Context> ctx) {
        Level world = Objects.requireNonNull(ctx.get().getSender()).f_19853_;
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            BlockEntity patt1834$temp = world.m_7702_(pos);
            if (patt1834$temp instanceof SpeakerBlockTile) {
                SpeakerBlockTile speaker = (SpeakerBlockTile)patt1834$temp;
                speaker.message = message.str.getString();
                speaker.narrator = message.narrator;
                speaker.volume = message.volume;
                BlockState state = world.m_8055_(pos);
                world.m_7260_(pos, state, state, 3);
                speaker.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

