/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.common.tools.Ease;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;

public class EmoteDataPacket
extends AbstractNetworkPacket {
    protected boolean valid = true;
    private int version;
    public int tick = 0;
    byte keyframeSize = (byte)9;

    @Override
    public void write(ByteBuffer buf, NetData config) {
        this.version = Math.min(config.versions.get(this.getVer()).byteValue(), 8);
        EmoteData emote = config.emoteData;
        buf.putInt(config.tick);
        buf.putInt(emote.beginTick);
        buf.putInt(emote.endTick);
        buf.putInt(emote.stopTick);
        this.putBoolean(buf, emote.isInfinite);
        buf.putInt(emote.returnToTick);
        this.putBoolean(buf, emote.isEasingBefore);
        this.putBoolean(buf, emote.nsfw);
        buf.put(this.keyframeSize);
        this.writeBodyPartInfo(buf, emote.head);
        this.writeBodyPartInfo(buf, emote.body);
        this.writeBodyPartInfo(buf, emote.rightArm);
        this.writeBodyPartInfo(buf, emote.leftArm);
        this.writeBodyPartInfo(buf, emote.rightLeg);
        this.writeBodyPartInfo(buf, emote.leftLeg);
        buf.putLong(config.emoteData.getUuid().getMostSignificantBits());
        buf.putLong(config.emoteData.getUuid().getLeastSignificantBits());
    }

    private void writeBodyPartInfo(ByteBuffer buf, EmoteData.StateCollection part) {
        this.writePartInfo(buf, part.x);
        this.writePartInfo(buf, part.y);
        this.writePartInfo(buf, part.z);
        this.writePartInfo(buf, part.pitch);
        this.writePartInfo(buf, part.yaw);
        this.writePartInfo(buf, part.roll);
        if (part.isBendable) {
            this.writePartInfo(buf, part.bendDirection);
            this.writePartInfo(buf, part.bend);
        }
    }

    private void writePartInfo(ByteBuffer buf, EmoteData.StateCollection.State part) {
        List<EmoteData.KeyFrame> list = part.keyFrames;
        buf.putInt(part.isEnabled ? list.size() : -1);
        if (part.isEnabled) {
            for (EmoteData.KeyFrame move : list) {
                buf.putInt(move.tick);
                buf.putFloat(move.value);
                buf.put(move.ease.getId());
            }
        }
    }

    @Override
    public boolean read(ByteBuffer buf, NetData config, int version) throws IOException {
        this.version = version;
        EmoteData.EmoteBuilder builder = config.getEmoteBuilder();
        config.tick = buf.getInt();
        builder.beginTick = buf.getInt();
        builder.endTick = buf.getInt();
        builder.stopTick = buf.getInt();
        builder.isLooped = this.getBoolean(buf);
        builder.returnTick = buf.getInt();
        builder.isEasingBefore = this.getBoolean(buf);
        builder.nsfw = this.getBoolean(buf);
        this.keyframeSize = buf.get();
        if (this.keyframeSize <= 0) {
            throw new IOException("keyframe size must be greater than 0, current: " + this.keyframeSize);
        }
        this.getBodyPartInfo(buf, builder.head, false);
        this.getBodyPartInfo(buf, builder.body, true);
        this.getBodyPartInfo(buf, builder.rightArm, true);
        this.getBodyPartInfo(buf, builder.leftArm, true);
        this.getBodyPartInfo(buf, builder.rightLeg, true);
        this.getBodyPartInfo(buf, builder.leftLeg, true);
        if (version >= 1) {
            long msb = buf.getLong();
            long lsb = buf.getLong();
            builder.uuid = new UUID(msb, lsb);
        }
        boolean correct = builder.beginTick >= 0 && builder.beginTick < builder.endTick && (!builder.isLooped || builder.returnTick <= builder.endTick && builder.returnTick >= 0);
        config.valid = this.valid = this.valid && correct;
        config.wasEmoteData = true;
        return correct;
    }

    private void getBodyPartInfo(ByteBuffer buf, EmoteData.StateCollection part, boolean bending) {
        this.getPartInfo(buf, part.x);
        this.getPartInfo(buf, part.y);
        this.getPartInfo(buf, part.z);
        this.getPartInfo(buf, part.pitch);
        this.getPartInfo(buf, part.yaw);
        this.getPartInfo(buf, part.roll);
        if (bending) {
            this.getPartInfo(buf, part.bendDirection);
            this.getPartInfo(buf, part.bend);
        }
    }

    private void getPartInfo(ByteBuffer buf, EmoteData.StateCollection.State part) {
        int len = buf.getInt();
        part.isEnabled = len != -1;
        for (int i = 0; i < len; ++i) {
            int currentPos = buf.position();
            if (!part.addKeyFrame(buf.getInt(), buf.getFloat(), Ease.getEase(buf.get()))) {
                this.valid = false;
            }
            ((Buffer)buf).position(currentPos + this.keyframeSize);
        }
    }

    @Override
    public byte getID() {
        return 0;
    }

    @Override
    public byte getVer() {
        return 1;
    }

    @Override
    public boolean doWrite(NetData data) {
        return data.emoteData != null && data.stopEmoteID == null;
    }

    @Override
    public int calculateSize(NetData config) {
        if (config.emoteData == null) {
            return 0;
        }
        int size = 40;
        size += this.partSize(config.emoteData.head);
        size += this.partSize(config.emoteData.body);
        size += this.partSize(config.emoteData.rightArm);
        size += this.partSize(config.emoteData.leftArm);
        size += this.partSize(config.emoteData.rightLeg);
        return size += this.partSize(config.emoteData.leftLeg);
    }

    int partSize(EmoteData.StateCollection part) {
        int size = 0;
        size += this.axisSize(part.x);
        size += this.axisSize(part.y);
        size += this.axisSize(part.z);
        size += this.axisSize(part.pitch);
        size += this.axisSize(part.yaw);
        size += this.axisSize(part.roll);
        if (part.isBendable) {
            size += this.axisSize(part.bend);
            size += this.axisSize(part.bendDirection);
        }
        return size;
    }

    int axisSize(EmoteData.StateCollection.State axis) {
        return axis.keyFrames.size() * this.keyframeSize + 4;
    }
}

